/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.control;

import com.baselet.control.basics.geom.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class SharedUtils {
    private static final Logger log = Logger.getLogger(SharedUtils.class);

    public static int realignToGrid(double d) {
        return SharedUtils.realignTo(true, d, false, 10);
    }

    public static Rectangle realignToGrid(Rectangle rectangle, boolean bl) {
        int n = SharedUtils.realignToGrid(false, rectangle.getX(), false);
        int n2 = SharedUtils.realignToGrid(false, rectangle.getY(), false);
        if (bl) {
            int n3 = SharedUtils.realignToGrid(false, rectangle.getX() - n + rectangle.getWidth(), true);
            int n4 = SharedUtils.realignToGrid(false, rectangle.getY() - n2 + rectangle.getHeight(), true);
            return new Rectangle(n, n2, n3, n4);
        }
        return new Rectangle(n, n2, rectangle.getWidth(), rectangle.getHeight());
    }

    public static int realignToGridRoundToNearest(boolean bl, double d) {
        boolean bl2 = Math.abs(d % 10.0) < 5.0 ? d < 0.0 : d >= 0.0;
        return SharedUtils.realignTo(bl, d, bl2, 10);
    }

    public static int realignToGrid(boolean bl, double d, boolean bl2) {
        return SharedUtils.realignTo(bl, d, bl2, 10);
    }

    public static int realignTo(boolean bl, double d, boolean bl2, int n) {
        double d2 = d;
        double d3 = d % (double)n;
        if (d3 != 0.0) {
            d2 -= d3;
            if (d > 0.0 && bl2) {
                d2 += (double)n;
            }
            if (d < 0.0 && !bl2) {
                d2 -= (double)n;
            }
            if (bl) {
                log.error((Object)("realignToGrid from " + d + " to " + d2));
            }
        }
        return (int)d2;
    }

    public static String listToString(String string, Collection<?> collection) {
        return SharedUtils.listToStringHelper(new StringBuilder(), string, collection).toString();
    }

    private static StringBuilder listToStringHelper(StringBuilder stringBuilder, String string, Collection<?> collection) {
        for (Object obj : collection) {
            stringBuilder.append(obj).append(string);
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.setLength(stringBuilder.length() - string.length());
        }
        return stringBuilder;
    }

    public static String mapToString(Map<?, ?> map) {
        return SharedUtils.mapToString("\n", ",", map);
    }

    public static String mapToString(String string, String string2, Map<?, ?> map) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            stringBuilder.append(entry.getKey()).append(": ");
            if (entry.getValue() instanceof Collection) {
                SharedUtils.listToStringHelper(stringBuilder, string2, (Collection)entry.getValue());
            } else {
                stringBuilder.append(entry.getValue().toString());
            }
            stringBuilder.append(string);
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.setLength(stringBuilder.length() - string.length());
        }
        return stringBuilder.toString();
    }

    public static <T> List<T> mergeLists(List<T> list, List<T> list2, List<T> list3) {
        ArrayList<T> arrayList = new ArrayList<T>(list);
        arrayList.addAll(list2);
        arrayList.addAll(list3);
        return Collections.unmodifiableList(arrayList);
    }

    public static Double[][] cloneArray(Double[][] doubleArray) {
        int n = doubleArray.length;
        Double[][] doubleArray2 = new Double[n][doubleArray[0].length];
        for (int i = 0; i < n; ++i) {
            System.arraycopy(doubleArray[i], 0, doubleArray2[i], 0, doubleArray[i].length);
        }
        return doubleArray2;
    }

    public static String[] cloneArray(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        return stringArray2;
    }

    public static int[] cloneArray(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        return nArray2;
    }
}

