/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element;

import com.baselet.control.Main;
import com.baselet.control.basics.Converter;
import com.baselet.control.basics.geom.Point;
import com.baselet.diagram.DrawPanel;
import com.baselet.diagram.SelectorOld;
import com.baselet.element.interfaces.GridElement;
import com.baselet.element.old.element.Relation;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.JComponent;

public class ElementUtils {
    public static boolean checkForOverlap(GridElement gridElement, Point p) {
        JComponent component = (JComponent)((Object)gridElement.getComponent());
        Rectangle rectangle = component.getVisibleRect();
        Point absolute = new Point(gridElement.getRectangle().getX() + p.getX(), gridElement.getRectangle().getY() + p.getY());
        if (!rectangle.contains(p.x, p.y)) {
            return false;
        }
        DrawPanel drawPanel = Main.getHandlerForElement(gridElement).getDrawPanel();
        List<GridElement> elements = drawPanel.getGridElements();
        SelectorOld selector = drawPanel.getSelector();
        for (GridElement other : elements) {
            Point other_p;
            if (other == gridElement || other.getLayer() < gridElement.getLayer() || !other.isSelectableOn(absolute)) continue;
            if (gridElement instanceof com.baselet.element.relation.Relation && other instanceof com.baselet.element.relation.Relation) {
                if (selector.isSelectedOnly(gridElement)) {
                    return true;
                }
                if (selector.isSelectedOnly(other)) {
                    return false;
                }
            }
            JComponent otherComponent = (JComponent)((Object)other.getComponent());
            if (other.getLayer() > gridElement.getLayer() && otherComponent.contains(Converter.convert(other_p = new Point(p.x + gridElement.getRectangle().x - other.getRectangle().x, p.y + gridElement.getRectangle().y - other.getRectangle().y)))) {
                return false;
            }
            Rectangle other_rectangle = otherComponent.getVisibleRect();
            other_rectangle.x += other.getRectangle().x - gridElement.getRectangle().x;
            other_rectangle.y += other.getRectangle().y - gridElement.getRectangle().y;
            if (other instanceof Relation || !rectangle.intersects(other_rectangle) || !ElementUtils.firstSmallerThanSecond(other_rectangle, rectangle)) continue;
            return false;
        }
        return true;
    }

    private static boolean firstSmallerThanSecond(Rectangle first, Rectangle second) {
        int areaFirst = first.getSize().height * first.getSize().width;
        int areaSecond = second.getSize().height * second.getSize().width;
        return areaFirst < areaSecond;
    }
}

