/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.elementnew.plot.drawer;

import com.baselet.control.SharedUtils;
import com.baselet.control.basics.geom.Dimension;
import com.baselet.control.basics.geom.Point;
import com.baselet.control.enums.AlignHorizontal;
import com.baselet.diagram.draw.DrawHandler;
import com.baselet.diagram.draw.helper.ColorOwn;
import com.baselet.element.elementnew.plot.drawer.AxisConfig;
import com.baselet.element.elementnew.plot.drawer.Canvas;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;

public class PlotDrawHandler {
    private String[] title;
    private String[] desc;
    private Double[][] values;
    private TreeSet<Double> valuesSorted;
    private TreeSet<Double> valuesShownOnAxisSorted;
    protected DrawHandler base;
    private Double minVal = null;
    private Double maxVal = null;
    private List<String> colors;
    private final Canvas canvas;
    private final AxisConfig axisConfig;

    public PlotDrawHandler(DrawHandler drawHandler, Dimension dimension) {
        this.base = drawHandler;
        this.axisConfig = new AxisConfig();
        this.canvas = new Canvas(dimension);
    }

    public final void drawPlotAndDescValueAxis(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.axisConfig.setxIsDescription(bl);
        this.setupAxis();
        this.calculateAdditionalSpaceForYAxisTextWidth();
        if (bl2) {
            this.drawBars(bl, this.values, this.axisConfig.getDescAxisPos(), this.axisConfig.getValueAxisPos(), this.axisConfig.getValueSegment(), this.axisConfig.getDescSegment(), this.colors);
        }
        if (bl3) {
            this.drawLineOrPoints(bl, this.values, this.axisConfig.getDescAxisPos(), this.axisConfig.getValueAxisPos(), this.axisConfig.getValueSegment(), this.axisConfig.getDescSegment(), this.colors, true);
        }
        if (bl4) {
            this.drawLineOrPoints(bl, this.values, this.axisConfig.getDescAxisPos(), this.axisConfig.getValueAxisPos(), this.axisConfig.getValueSegment(), this.axisConfig.getDescSegment(), this.colors, false);
        }
        if (this.axisConfig.showAxis()) {
            this.drawAxis(bl, this.axisConfig.getDescAxisPos(), this.axisConfig.getValueAxisPos(), this.axisConfig.getValueSegment(), this.axisConfig.getDescSegment());
        }
    }

    private void setupAxis() {
        Double d = Math.max(1.0, this.maxVal - this.minVal);
        Double d2 = 0.0;
        if (this.minVal > 0.0) {
            d2 = 0.0;
        }
        if (this.minVal < 0.0) {
            d2 = this.maxVal < 0.0 ? d : Double.valueOf(-this.minVal.doubleValue());
        }
        int n = this.desc.length;
        for (Double[] doubleArray : this.values) {
            if (doubleArray.length <= n) continue;
            n = doubleArray.length;
        }
        if (this.axisConfig.isxDescription()) {
            this.axisConfig.setDescSegment(this.canvas.getInnerHorizontalDrawspace() / n);
            this.axisConfig.setValueSegment((double)this.canvas.getInnerVerticalDrawspace() / d);
            this.axisConfig.setDescAxisPos((int)((double)this.canvas.getInnerDownPos() - this.axisConfig.getValueSegment() * d2));
            this.axisConfig.setValueAxisPos(this.canvas.getInnerLeftPos());
        } else {
            this.axisConfig.setDescSegment(this.canvas.getInnerVerticalDrawspace() / n);
            this.axisConfig.setValueSegment((double)this.canvas.getInnerHorizontalDrawspace() / d);
            this.axisConfig.setDescAxisPos((int)((double)this.canvas.getInnerLeftPos() + this.axisConfig.getValueSegment() * d2));
            this.axisConfig.setValueAxisPos(this.canvas.getInnerUpPos());
        }
    }

    private final void drawAxis(boolean bl, int n, int n2, Double d, int n3) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        ArrayList<String> arrayList4 = new ArrayList<String>();
        int n4 = n2 + n3 / 2;
        for (String string : this.desc) {
            if (bl) {
                arrayList.add(n4);
                arrayList2.add(string);
            } else {
                arrayList3.add(n4);
                arrayList4.add(string);
            }
            n4 += n3;
        }
        for (Double d2 : this.valuesShownOnAxisSorted) {
            int n5 = (int)this.calculateValuePos(d2, d);
            if (bl) {
                arrayList3.add(n - n5);
                arrayList4.add(String.valueOf(d2));
                continue;
            }
            arrayList.add(n + n5);
            arrayList2.add(String.valueOf(d2));
        }
        this.drawGraylines(arrayList, arrayList3);
        this.base.setForegroundColor(ColorOwn.BLACK.transparency(ColorOwn.Transparency.FOREGROUND));
        this.drawAxisLine();
        this.drawMarkers(arrayList, arrayList3);
        this.drawMarkerTexts(arrayList, arrayList2, arrayList3, arrayList4);
    }

    private void drawAxisLine() {
        int n;
        int n2;
        int n3;
        if (this.axisConfig.drawXAxis()) {
            n3 = this.canvas.getInnerLeftPos();
            n2 = this.canvas.getInnerRightPos();
            n = this.axisConfig.getxAxisPos();
            this.base.drawLine(n3, n, n2, n);
        }
        if (this.axisConfig.drawYAxis()) {
            n3 = this.axisConfig.getyAxisPos();
            n2 = this.canvas.getInnerUpPos();
            n = this.canvas.getInnerDownPos();
            this.base.drawLine(n3, n2, n3, n);
        }
    }

    private void drawGraylines(List<Integer> list, List<Integer> list2) {
        boolean bl;
        this.base.setForegroundColor(ColorOwn.BLACK.transparency(ColorOwn.Transparency.SELECTION_BACKGROUND));
        boolean bl2 = this.axisConfig.isxDescription() && this.axisConfig.drawDescriptionAxisMarkerGrayline() || !this.axisConfig.isxDescription() && this.axisConfig.drawValueAxisMarkerGrayline();
        boolean bl3 = bl = !this.axisConfig.isxDescription() && this.axisConfig.drawDescriptionAxisMarkerGrayline() || this.axisConfig.isxDescription() && this.axisConfig.drawValueAxisMarkerGrayline();
        if (bl2) {
            for (Integer n : list) {
                this.base.drawLine(n.intValue(), this.canvas.getInnerUpPos(), n.intValue(), this.canvas.getInnerDownPos());
            }
        }
        if (bl) {
            for (Integer n : list2) {
                this.base.drawLine(this.canvas.getInnerLeftPos(), n.intValue(), this.canvas.getInnerRightPos(), n.intValue());
            }
        }
    }

    private void drawMarkers(List<Integer> list, List<Integer> list2) {
        boolean bl;
        boolean bl2 = this.axisConfig.isxDescription() && this.axisConfig.drawDescriptionAxisMarkers() || !this.axisConfig.isxDescription() && this.axisConfig.drawValueAxisMarkers();
        boolean bl3 = bl = !this.axisConfig.isxDescription() && this.axisConfig.drawDescriptionAxisMarkers() || this.axisConfig.isxDescription() && this.axisConfig.drawValueAxisMarkers();
        if (bl2) {
            for (Integer n : list) {
                this.base.drawLine(n.intValue(), this.axisConfig.getxAxisPos(), n.intValue(), this.axisConfig.getxAxisPos() + 5);
            }
        }
        if (bl) {
            for (Integer n : list2) {
                this.base.drawLine(this.axisConfig.getyAxisPos() - 5, n.intValue(), this.axisConfig.getyAxisPos(), n.intValue());
            }
        }
    }

    private void drawMarkerTexts(List<Integer> list, List<String> list2, List<Integer> list3, List<String> list4) {
        int n;
        boolean bl;
        boolean bl2 = this.axisConfig.isxDescription() && this.axisConfig.drawDescriptionAxisMarkerText() || !this.axisConfig.isxDescription() && this.axisConfig.drawValueAxisMarkerText();
        boolean bl3 = bl = !this.axisConfig.isxDescription() && this.axisConfig.drawDescriptionAxisMarkerText() || this.axisConfig.isxDescription() && this.axisConfig.drawValueAxisMarkerText();
        if (bl2) {
            for (n = 0; n < list.size(); ++n) {
                this.base.print(list2.get(n), list.get(n).intValue(), this.axisConfig.getxAxisPos() + 15, AlignHorizontal.CENTER);
            }
        }
        if (bl) {
            for (n = 0; n < list3.size(); ++n) {
                this.base.print(list4.get(n), this.axisConfig.getyAxisPos() - 8, (int)((double)list3.get(n).intValue() + this.base.textHeightMax() / 2.0), AlignHorizontal.RIGHT);
            }
        }
    }

    private final void drawLineOrPoints(boolean bl, Double[][] doubleArray, int n, int n2, Double d, int n3, List<String> list, boolean bl2) {
        int n4 = 0;
        for (int i = 0; i < doubleArray.length; ++i) {
            int n5;
            Double[] doubleArray2 = doubleArray[i];
            int n6 = n2 + n3 / 2;
            ArrayList<Point> arrayList = new ArrayList<Point>();
            for (Double d2 : doubleArray2) {
                int n7 = (int)this.calculateValuePos(d2, d);
                if (bl) {
                    arrayList.add(new Point(n6, n - n7));
                } else {
                    arrayList.add(new Point(n + n7, n6));
                }
                n6 += n3;
            }
            if (n4 >= list.size()) {
                n4 = 0;
            }
            this.base.setForegroundColor(ColorOwn.forStringOrNull(list.get(n4), ColorOwn.Transparency.FOREGROUND));
            this.base.setBackgroundColor(ColorOwn.forStringOrNull(list.get(n4), ColorOwn.Transparency.FOREGROUND));
            if (bl2) {
                for (n5 = 0; n5 < arrayList.size() - 1; ++n5) {
                    Point point = (Point)arrayList.get(n5);
                    Point point2 = (Point)arrayList.get(n5 + 1);
                    this.base.drawLine(point.x, point.y, point2.x, point2.y);
                }
            } else {
                for (n5 = 0; n5 < arrayList.size(); ++n5) {
                    Point point = (Point)arrayList.get(n5);
                    this.base.drawCircle(point.x, point.y, 2.0);
                }
            }
            this.base.setForegroundColor(ColorOwn.forStringOrNull(list.get(n4), ColorOwn.Transparency.FOREGROUND).darken(75));
            this.base.print(this.title[i], ((Point)arrayList.get((int)(arrayList.size() - 1))).x, ((Point)arrayList.get((int)(arrayList.size() - 1))).y, AlignHorizontal.CENTER);
            ++n4;
        }
        this.base.resetColorSettings();
    }

    private final void drawBars(boolean bl, Double[][] doubleArray, int n, int n2, Double d, int n3, List<String> list) {
        int n4 = doubleArray.length;
        for (int i = 0; i < n4; ++i) {
            int n5 = 0;
            int n6 = n2;
            for (Double d2 : doubleArray[i]) {
                if (n5 >= list.size()) {
                    n5 = 0;
                }
                this.base.setForegroundColor(ColorOwn.TRANSPARENT);
                this.base.setBackgroundColor(list.get(n5));
                int n7 = (int)this.calculateValuePos(d2, d);
                int n8 = 0;
                int n9 = i * (int)Math.round((double)n3 / (double)n4);
                n8 = i == n4 - 1 ? n6 + n3 - (n6 + n9) : (int)Math.round((double)n3 / (double)n4);
                if (bl) {
                    if (n7 > 0) {
                        this.base.drawRectangle(n6 + n9, n - n7, n8, n7);
                    } else {
                        this.base.drawRectangle(n6 + n9, n, n8, -n7);
                    }
                } else if (n7 > 0) {
                    this.base.drawRectangle(n, n6 + n9, n7, n8);
                } else {
                    this.base.drawRectangle(n + n7, n6 + n9, -n7, n8);
                }
                n6 += n3;
                ++n5;
            }
        }
        this.base.resetColorSettings();
    }

    public final void drawPiePlot() {
        int n;
        Double d = 0.0;
        for (Double n2 : this.values[0]) {
            d = d + Math.abs(n2);
        }
        int n3 = this.canvas.getInnerVerticalDrawspace();
        int n4 = n3 > (n = this.canvas.getInnerHorizontalDrawspace()) ? n : n3;
        Point point = new Point(this.canvas.getInnerLeftPos(), this.canvas.getInnerUpPos());
        this.drawPieArcs(this.values[0], this.desc, point, n4, d, this.colors);
    }

    private final void drawPieArcs(Double[] doubleArray, String[] stringArray, Point point, int n, Double d, List<String> list) {
        int n2 = 0;
        Double d2 = 0.0;
        Double d3 = 0.0;
        for (int i = 0; i < doubleArray.length; ++i) {
            if (n2 >= list.size()) {
                n2 = 0;
            }
            ColorOwn colorOwn = this.base.getForegroundColor();
            this.base.setForegroundColor(ColorOwn.TRANSPARENT);
            this.base.setBackgroundColor(list.get(n2));
            d2 = i < doubleArray.length - 1 ? (double)Math.round(360.0 / d * Math.abs(doubleArray[i])) : 360.0 - d3;
            int n3 = this.canvas.getInnerVerticalDrawspace();
            int n4 = this.canvas.getInnerHorizontalDrawspace();
            this.base.drawArc((double)point.x + (double)n4 / 2.0 - (double)n / 2.0, (double)point.y + (double)n3 / 2.0 - (double)n / 2.0, n, n, d3.floatValue(), d2.floatValue(), false);
            this.base.setForegroundColor(colorOwn);
            double d4 = (360.0 - d3 + (360.0 - d2 / 2.0)) * Math.PI / 180.0;
            int n5 = (int)((double)n / 2.0 * Math.cos(d4) + (double)point.x + (double)n / 2.0 + (double)n4 / 2.0 - (double)n / 2.0);
            int n6 = (int)((double)n / 2.0 * Math.sin(d4) + (double)point.y + (double)n / 2.0 + (double)n3 / 2.0 - (double)n / 2.0);
            this.base.setForegroundColor(ColorOwn.forStringOrNull(list.get(n2), ColorOwn.Transparency.FOREGROUND).darken(75));
            this.base.print(stringArray[i], n5, n6, AlignHorizontal.CENTER);
            d3 = d3 + d2;
            ++n2;
        }
        this.base.resetColorSettings();
    }

    private void calculateAdditionalSpaceForYAxisTextWidth() {
        double d;
        double d2 = 0.0;
        if (this.axisConfig.isxDescription()) {
            if (this.axisConfig.drawValueAxisMarkerText()) {
                for (Double d3 : this.valuesShownOnAxisSorted) {
                    double d4 = this.base.textWidth(String.valueOf(d3));
                    if (!(d4 > d2)) continue;
                    d2 = d4;
                }
            }
        } else if (this.axisConfig.drawDescriptionAxisMarkerText()) {
            for (String string : this.desc) {
                double d5 = this.base.textWidth(string);
                if (!(d5 > d2)) continue;
                d2 = d5;
            }
        }
        if ((d = d2 + (double)this.canvas.getOuterLeftPos() - (double)(this.axisConfig.getyAxisPos() - this.canvas.getInnerLeftPos()) - 5.0) > (double)this.canvas.getOuterLeftPos()) {
            this.canvas.setBorderX((int)d);
            this.setupAxis();
            if (this.axisConfig.getyAxisPos() - this.canvas.getInnerLeftPos() != 0 && (d = d2 + (double)this.canvas.getOuterLeftPos() - (double)(this.axisConfig.getyAxisPos() - this.canvas.getInnerLeftPos()) - 5.0) > (double)this.canvas.getOuterLeftPos()) {
                this.canvas.setBorderX((int)d);
                this.setupAxis();
            }
        }
    }

    public double calculateValuePos(double d, double d2) {
        if (d > 0.0 && this.minVal > 0.0) {
            d -= this.minVal.doubleValue();
        } else if (d < 0.0 && this.maxVal < 0.0) {
            d -= this.maxVal.doubleValue();
        }
        return d * d2;
    }

    public void setValues(String[] stringArray, String[] stringArray2, Double[][] doubleArray, List<String> list) {
        this.desc = SharedUtils.cloneArray(stringArray);
        this.title = SharedUtils.cloneArray(stringArray2);
        this.colors = new ArrayList<String>(list);
        this.values = SharedUtils.cloneArray(doubleArray);
        this.valuesSorted = new TreeSet();
        Double[][] doubleArray2 = doubleArray;
        int n = doubleArray2.length;
        for (int i = 0; i < n; ++i) {
            Double[] doubleArray3;
            for (Double d : doubleArray3 = doubleArray2[i]) {
                this.valuesSorted.add(d);
            }
        }
        this.valuesShownOnAxisSorted = this.axisConfig.setValueAxisList(this.valuesSorted);
        this.minVal = this.minRealOrShownValue();
        this.maxVal = this.maxRealOrShownValue();
    }

    public void setMinValue(Double d) throws IOException {
        Double d2 = Math.min(this.minRealOrShownValue(), this.maxVal);
        if (d > d2) {
            throw new IOException("minValue must be <= " + d2);
        }
        this.minVal = d;
    }

    public void setMaxValue(Double d) throws IOException {
        Double d2 = Math.max(this.maxRealOrShownValue(), this.minVal);
        if (d < d2) {
            throw new IOException("maxValue must be >= " + d2);
        }
        this.maxVal = d;
    }

    private double minRealOrShownValue() {
        if (this.valuesShownOnAxisSorted.isEmpty()) {
            return this.valuesSorted.first();
        }
        return Math.min(this.valuesSorted.first(), this.valuesShownOnAxisSorted.first());
    }

    private double maxRealOrShownValue() {
        if (this.valuesShownOnAxisSorted.isEmpty()) {
            return this.valuesSorted.last();
        }
        return Math.max(this.valuesSorted.last(), this.valuesShownOnAxisSorted.last());
    }

    public Canvas getCanvas() {
        return this.canvas;
    }

    public AxisConfig getAxisConfig() {
        return this.axisConfig;
    }

    public static enum Position {
        LEFT,
        UP,
        DOWN,
        RIGHT;

    }
}

