/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.relation.facet;

import com.baselet.control.basics.geom.Line;
import com.baselet.control.basics.geom.PointDouble;
import com.baselet.control.enums.Direction;
import com.baselet.diagram.draw.DrawHandler;
import com.baselet.element.relation.helper.LineDescriptionEnum;
import com.baselet.element.relation.helper.RelationPointHandler;

public class LineDescriptionUtils {
    static PointDouble calcPosOfEndText(DrawHandler drawHandler, String string, RelationPointHandler relationPointHandler, LineDescriptionEnum lineDescriptionEnum) {
        Boolean bl = lineDescriptionEnum.isStart();
        Line line = bl != false ? relationPointHandler.getFirstLine() : relationPointHandler.getLastLine();
        PointDouble pointDouble = line.getPointOnLineWithDistanceFrom(bl, 15.0);
        Direction direction = line.getDirectionOfLine(bl);
        if (direction == Direction.RIGHT) {
            pointDouble = new PointDouble(pointDouble.getX() - drawHandler.textWidth(string) - drawHandler.getDistanceBorderToText(), pointDouble.getY() + drawHandler.textHeightMax() + 1.0);
        } else if (direction == Direction.LEFT) {
            pointDouble = new PointDouble(pointDouble.getX() + 4.0, pointDouble.getY() + drawHandler.textHeightMax() + 1.0);
        } else if (direction == Direction.UP) {
            pointDouble = new PointDouble(pointDouble.getX() + 4.0, pointDouble.getY() + drawHandler.textHeightMax() + 1.0);
        } else if (direction == Direction.DOWN) {
            pointDouble = new PointDouble(pointDouble.getX() + 4.0, pointDouble.getY() - 1.0);
        }
        if (lineDescriptionEnum.isRoleStartOrEnd()) {
            pointDouble = direction == Direction.UP ? new PointDouble(pointDouble.getX(), pointDouble.getY() + drawHandler.textHeightMaxWithSpace()) : (direction == Direction.DOWN ? new PointDouble(pointDouble.getX(), pointDouble.getY() - drawHandler.textHeightMaxWithSpace()) : new PointDouble(pointDouble.getX(), pointDouble.getY() - drawHandler.textHeightMax() - 5.0));
        }
        return pointDouble;
    }

    static String replaceArrowsWithUtf8Characters(String string) {
        if (string.startsWith("< ")) {
            string = "\u25c4" + string.substring(1);
        }
        if (string.endsWith(" >")) {
            string = string.substring(0, string.length() - 1) + "\u25ba";
        } else if (string.endsWith(" ^")) {
            string = string.substring(0, string.length() - 1) + "\u25b2";
        } else if (string.endsWith(" v")) {
            string = string.substring(0, string.length() - 1) + "\u25bc";
        }
        return string;
    }

    static PointDouble calcPosOfMiddleText(DrawHandler drawHandler, String string, Line line, int n, double d) {
        double d2;
        double d3;
        double d4 = drawHandler.textWidth(string);
        boolean bl = line.getDirectionOfLine(true).isHorizontal();
        PointDouble pointDouble = line.getCenter();
        double d5 = (double)n * drawHandler.textHeightMaxWithSpace();
        if (bl) {
            d3 = pointDouble.getX() - d4 / 2.0;
            d2 = pointDouble.getY() + d5 - 4.0;
        } else {
            d3 = pointDouble.getX() + 4.0;
            d2 = pointDouble.getY() + d5 - d + drawHandler.textHeightMaxWithSpace();
        }
        return new PointDouble(d3, d2);
    }
}

