/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.autocomplete;

import java.util.ArrayList;
import java.util.List;
import org.fife.ui.autocomplete.CompletionProvider;
import org.fife.ui.autocomplete.ParameterizedCompletion;
import org.fife.ui.autocomplete.VariableCompletion;

public class FunctionCompletion
extends VariableCompletion
implements ParameterizedCompletion {
    private List params;
    private String returnValDesc;

    public FunctionCompletion(CompletionProvider completionProvider, String string, String string2) {
        super(completionProvider, string, string2);
    }

    protected void addDefinitionString(StringBuffer stringBuffer) {
        stringBuffer.append("<html><b>");
        stringBuffer.append(this.getDefinitionString());
        stringBuffer.append("</b>");
    }

    protected void addParameters(StringBuffer stringBuffer) {
        int n = this.getParamCount();
        if (n > 0) {
            stringBuffer.append("<b>Parameters:</b><br>");
            stringBuffer.append("<center><table width='90%'><tr><td>");
            for (int i = 0; i < n; ++i) {
                ParameterizedCompletion.Parameter parameter = this.getParam(i);
                stringBuffer.append("<b>");
                stringBuffer.append(parameter.getName() != null ? parameter.getName() : parameter.getType());
                stringBuffer.append("</b>&nbsp;");
                String string = parameter.getDescription();
                if (string != null) {
                    stringBuffer.append(string);
                }
                stringBuffer.append("<br>");
            }
            stringBuffer.append("</td></tr></table></center><br><br>");
        }
        if (this.returnValDesc != null) {
            stringBuffer.append("<b>Returns:</b><br><center><table width='90%'><tr><td>");
            stringBuffer.append(this.returnValDesc);
            stringBuffer.append("</td></tr></table></center><br><br>");
        }
    }

    public String getDefinitionString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.getType();
        if (string != null) {
            stringBuffer.append(string).append(' ');
        }
        stringBuffer.append(this.getName());
        CompletionProvider completionProvider = this.getProvider();
        char c = completionProvider.getParameterListStart();
        if (c != '\u0000') {
            stringBuffer.append(c);
        }
        for (n = 0; n < this.getParamCount(); ++n) {
            ParameterizedCompletion.Parameter parameter = this.getParam(n);
            string = parameter.getType();
            String string2 = parameter.getName();
            if (string != null) {
                stringBuffer.append(string);
                if (string2 != null) {
                    stringBuffer.append(' ');
                }
            }
            if (string2 != null) {
                stringBuffer.append(string2);
            }
            if (n >= this.params.size() - 1) continue;
            stringBuffer.append(completionProvider.getParameterListSeparator());
        }
        n = completionProvider.getParameterListEnd();
        if (n != 0) {
            stringBuffer.append((char)n);
        }
        return stringBuffer.toString();
    }

    public ParameterizedCompletion.Parameter getParam(int n) {
        return (ParameterizedCompletion.Parameter)this.params.get(n);
    }

    public int getParamCount() {
        return this.params == null ? 0 : this.params.size();
    }

    public String getReturnValueDescription() {
        return this.returnValDesc;
    }

    public String getSummary() {
        StringBuffer stringBuffer = new StringBuffer();
        this.addDefinitionString(stringBuffer);
        if (!this.possiblyAddDescription(stringBuffer)) {
            stringBuffer.append("<br><br><br>");
        }
        this.addParameters(stringBuffer);
        this.possiblyAddDefinedIn(stringBuffer);
        return stringBuffer.toString();
    }

    public String getToolTipText() {
        String string = this.getSummary();
        if (string == null) {
            string = this.getDefinitionString();
        }
        return string;
    }

    public void setParams(List list) {
        if (list != null) {
            this.params = new ArrayList(list);
        }
    }

    public void setReturnValueDescription(String string) {
        this.returnValDesc = string;
    }
}

