/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.jetty.internal;

import java.io.IOException;
import org.gradle.api.plugins.jetty.AbstractJettyRunTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsoleScanner
extends Thread {
    private static Logger logger = LoggerFactory.getLogger(ConsoleScanner.class);
    private final AbstractJettyRunTask task;

    public ConsoleScanner(AbstractJettyRunTask task) {
        this.task = task;
        this.setName("Console scanner");
        this.setDaemon(true);
    }

    public void run() {
        try {
            while (true) {
                this.checkSystemInput();
                this.getSomeSleep();
            }
        }
        catch (IOException e) {
            logger.warn("Error when checking console input.", (Throwable)e);
            return;
        }
    }

    private void getSomeSleep() {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            logger.debug("Error while sleeping.", (Throwable)e);
        }
    }

    private void checkSystemInput() throws IOException {
        while (System.in.available() > 0) {
            char c;
            int inputByte = System.in.read();
            if (inputByte < 0 || (c = (char)inputByte) != '\n') continue;
            this.restartWebApp();
        }
    }

    private void clearInputBuffer() {
        try {
            while (System.in.available() > 0) {
                long available = System.in.available();
                int i = 0;
                while ((long)i < available && System.in.read() != -1) {
                    ++i;
                }
            }
        }
        catch (IOException e) {
            logger.warn("Error discarding console input buffer", (Throwable)e);
        }
    }

    private void restartWebApp() {
        try {
            this.task.restartWebApp(false);
            this.clearInputBuffer();
        }
        catch (Exception e) {
            logger.error("Error reconfiguring/restarting webapp after a new line on the console", (Throwable)e);
        }
    }
}

