/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.initialization.loadercache;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.zip.Adler32;
import org.gradle.api.internal.changedetection.state.FileSnapshotter;
import org.gradle.api.internal.initialization.loadercache.ClassPathSnapshot;
import org.gradle.api.internal.initialization.loadercache.ClassPathSnapshotter;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.util.GFileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HashClassPathSnapshotter
implements ClassPathSnapshotter {
    private final FileSnapshotter fileSnapshotter;

    public HashClassPathSnapshotter(FileSnapshotter fileSnapshotter) {
        this.fileSnapshotter = fileSnapshotter;
    }

    @Override
    public ClassPathSnapshot snapshot(ClassPath classPath) {
        LinkedList visitedFilePaths = Lists.newLinkedList();
        LinkedHashSet visitedDirs = Sets.newLinkedHashSet();
        List cpFiles = classPath.getAsFiles();
        Adler32 checksum = new Adler32();
        this.hash(checksum, visitedFilePaths, visitedDirs, cpFiles.iterator());
        return new ClassPathSnapshotImpl(visitedFilePaths, checksum.getValue());
    }

    private void hash(Adler32 combinedHash, List<String> visitedFilePaths, Set<File> visitedDirs, Iterator<File> toHash) {
        while (toHash.hasNext()) {
            File file = toHash.next();
            if ((file = GFileUtils.canonicalise(file)).isDirectory()) {
                if (!visitedDirs.add(file)) continue;
                this.hash(combinedHash, visitedFilePaths, visitedDirs, (Iterator<File>)Iterators.forArray((Object[])file.listFiles()));
                continue;
            }
            if (!file.isFile()) continue;
            visitedFilePaths.add(file.getAbsolutePath());
            combinedHash.update(this.fileSnapshotter.snapshot(file).getHash());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ClassPathSnapshotImpl
    implements ClassPathSnapshot {
        private final List<String> files;
        private final long hash;

        public ClassPathSnapshotImpl(List<String> files, long hash) {
            assert (files != null);
            this.files = files;
            this.hash = hash;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClassPathSnapshotImpl that = (ClassPathSnapshotImpl)o;
            return this.hash == that.hash && this.files.equals(that.files);
        }

        @Override
        public int hashCode() {
            int result = this.files.hashCode();
            result = 31 * result + (int)(this.hash ^ this.hash >>> 32);
            return result;
        }
    }
}

