/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.internal.prebuilt;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.nativeplatform.BuildType;
import org.gradle.nativeplatform.Flavor;
import org.gradle.nativeplatform.NativeLibraryBinary;
import org.gradle.nativeplatform.PrebuiltLibrary;
import org.gradle.nativeplatform.internal.prebuilt.DefaultPrebuiltSharedLibraryBinary;
import org.gradle.nativeplatform.internal.prebuilt.DefaultPrebuiltStaticLibraryBinary;
import org.gradle.nativeplatform.platform.NativePlatform;
import org.gradle.nativeplatform.platform.internal.NativePlatforms;
import org.gradle.platform.base.internal.BinaryNamingSchemeBuilder;
import org.gradle.platform.base.internal.DefaultBinaryNamingSchemeBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrebuiltLibraryInitializer
implements Action<PrebuiltLibrary> {
    private final Instantiator instantiator;
    private final Set<NativePlatform> allPlatforms = new LinkedHashSet<NativePlatform>();
    private final Set<BuildType> allBuildTypes = new LinkedHashSet<BuildType>();
    private final Set<Flavor> allFlavors = new LinkedHashSet<Flavor>();

    public PrebuiltLibraryInitializer(Instantiator instantiator, NativePlatforms nativePlatforms, Collection<? extends NativePlatform> allPlatforms, Collection<? extends BuildType> allBuildTypes, Collection<? extends Flavor> allFlavors) {
        this.instantiator = instantiator;
        this.allPlatforms.addAll(allPlatforms);
        this.allPlatforms.addAll(nativePlatforms.defaultPlatformDefinitions());
        this.allBuildTypes.addAll(allBuildTypes);
        this.allFlavors.addAll(allFlavors);
    }

    public void execute(PrebuiltLibrary prebuiltLibrary) {
        for (NativePlatform platform : this.allPlatforms) {
            for (BuildType buildType : this.allBuildTypes) {
                for (Flavor flavor : this.allFlavors) {
                    this.createNativeBinaries(prebuiltLibrary, platform, buildType, flavor);
                }
            }
        }
    }

    public void createNativeBinaries(PrebuiltLibrary library, NativePlatform platform, BuildType buildType, Flavor flavor) {
        this.createNativeBinary(DefaultPrebuiltSharedLibraryBinary.class, library, platform, buildType, flavor);
        this.createNativeBinary(DefaultPrebuiltStaticLibraryBinary.class, library, platform, buildType, flavor);
    }

    public <T extends NativeLibraryBinary> void createNativeBinary(Class<T> type, PrebuiltLibrary library, NativePlatform platform, BuildType buildType, Flavor flavor) {
        String name = this.getName(type, library, platform, buildType, flavor);
        NativeLibraryBinary nativeBinary = (NativeLibraryBinary)this.instantiator.newInstance(type, new Object[]{name, library, buildType, platform, flavor});
        library.getBinaries().add((Object)nativeBinary);
    }

    private <T extends NativeLibraryBinary> String getName(Class<T> type, PrebuiltLibrary library, NativePlatform platform, BuildType buildType, Flavor flavor) {
        BinaryNamingSchemeBuilder namingScheme = new DefaultBinaryNamingSchemeBuilder().withComponentName(library.getName()).withTypeString(type.getSimpleName()).withVariantDimension(platform.getName()).withVariantDimension(buildType.getName()).withVariantDimension(flavor.getName());
        return namingScheme.build().getLifecycleTaskName();
    }
}

