/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.javascript.jshint.internal;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.plugins.javascript.jshint.internal.JsHintResult;
import org.gradle.plugins.javascript.jshint.internal.JsHintSpec;
import org.gradle.plugins.javascript.rhino.worker.RhinoWorker;
import org.gradle.plugins.javascript.rhino.worker.RhinoWorkerUtils;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Scriptable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsHintWorker
implements RhinoWorker<JsHintResult, JsHintSpec> {
    private static final Logger LOGGER = Logging.getLogger(JsHintWorker.class);

    @Override
    public JsHintResult process(JsHintSpec spec) {
        Scriptable jsHintScope = RhinoWorkerUtils.parse(spec.getJsHint(), "UTF-8");
        String encoding = spec.getEncoding();
        LinkedHashMap<File, Map<String, Object>> results = new LinkedHashMap<File, Map<String, Object>>();
        for (File target : spec.getSource()) {
            LOGGER.info("Reading file: {}", (Object)target.getAbsolutePath());
            String source = RhinoWorkerUtils.readFile(target, encoding);
            Map<String, Object> result = this.jsHint(jsHintScope, source, target.getName());
            results.put(target, result);
        }
        return new JsHintResult(results);
    }

    private Map<String, Object> jsHint(Scriptable jsHintScope, final String source, final String sourceName) {
        return RhinoWorkerUtils.childScope(jsHintScope, new RhinoWorkerUtils.DefaultScopeOperation<Map<String, Object>>(){

            @Override
            public Map<String, Object> action(Scriptable scope, Context context) {
                scope.put("jsHintSource", scope, (Object)source);
                Object data = context.evaluateString(scope, "JSHINT(jsHintSource); JSHINT.data();", sourceName, 0, null);
                return RhinoWorkerUtils.toMap((Scriptable)data);
            }
        });
    }

    @Override
    public Exception convertException(RhinoException rhinoException) {
        return rhinoException;
    }
}

