/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.base.internal.model;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.gradle.api.Nullable;
import org.gradle.api.internal.project.ProjectIdentifier;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.language.base.FunctionalSourceSet;
import org.gradle.language.base.internal.DefaultFunctionalSourceSet;
import org.gradle.language.base.internal.registry.LanguageRegistry;
import org.gradle.model.internal.core.ModelAction;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelProjection;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.ModelView;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.NodeInitializer;
import org.gradle.model.internal.core.UnmanagedModelProjection;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionalSourceSetNodeInitializer
implements NodeInitializer {
    private final Instantiator instantiator;

    public FunctionalSourceSetNodeInitializer(Instantiator instantiator) {
        this.instantiator = instantiator;
    }

    public List<? extends ModelReference<?>> getInputs() {
        return Lists.newArrayList((Object[])new ModelReference[]{ModelReference.of(LanguageRegistry.class), ModelReference.of(ProjectIdentifier.class)});
    }

    public void execute(MutableModelNode modelNode, List<ModelView<?>> inputs) {
        LanguageRegistry languageRegistry = (LanguageRegistry)inputs.get(0).getInstance();
        File baseDir = ((ProjectIdentifier)inputs.get(1).getInstance()).getProjectDir();
        DefaultFunctionalSourceSet defaultFunctionalSourceSet = new DefaultFunctionalSourceSet(modelNode.getPath().getName(), this.instantiator, languageRegistry, baseDir);
        modelNode.setPrivateData(DefaultFunctionalSourceSet.class, (Object)defaultFunctionalSourceSet);
    }

    public List<? extends ModelProjection> getProjections() {
        return Collections.singletonList(new UnmanagedModelProjection(ModelType.of(FunctionalSourceSet.class)));
    }

    @Nullable
    public ModelAction getProjector(ModelPath path, ModelRuleDescriptor descriptor) {
        return null;
    }
}

