/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.base.internal.tasks.apigen;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import org.gradle.internal.Factory;
import org.gradle.language.base.internal.tasks.apigen.StubClassWriter;
import org.gradle.language.base.internal.tasks.apigen.abi.AlwaysMemberOfApiChecker;
import org.gradle.language.base.internal.tasks.apigen.abi.AnnotationAnnotationValue;
import org.gradle.language.base.internal.tasks.apigen.abi.AnnotationSig;
import org.gradle.language.base.internal.tasks.apigen.abi.AnnotationValue;
import org.gradle.language.base.internal.tasks.apigen.abi.ApiValidator;
import org.gradle.language.base.internal.tasks.apigen.abi.ArrayAnnotationValue;
import org.gradle.language.base.internal.tasks.apigen.abi.ClassSig;
import org.gradle.language.base.internal.tasks.apigen.abi.DefaultApiValidator;
import org.gradle.language.base.internal.tasks.apigen.abi.DefaultMemberOfApiChecker;
import org.gradle.language.base.internal.tasks.apigen.abi.EnumAnnotationValue;
import org.gradle.language.base.internal.tasks.apigen.abi.FieldSig;
import org.gradle.language.base.internal.tasks.apigen.abi.InnerClassSig;
import org.gradle.language.base.internal.tasks.apigen.abi.MemberOfApiChecker;
import org.gradle.language.base.internal.tasks.apigen.abi.MethodSig;
import org.gradle.language.base.internal.tasks.apigen.abi.NoOpValidator;
import org.gradle.language.base.internal.tasks.apigen.abi.ParameterAnnotationSig;
import org.gradle.language.base.internal.tasks.apigen.abi.SimpleAnnotationValue;
import org.gradle.language.base.internal.tasks.apigen.abi.SortingAnnotationVisitor;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApiStubGenerator {
    private static final Pattern AIC_LOCAL_CLASS_PATTERN = Pattern.compile(".+\\$[0-9]+(?:[\\p{Alnum}_$]+)?$");
    private final boolean hasDeclaredAPI;
    private final MemberOfApiChecker memberOfApiChecker;
    private final ApiValidator apiValidator;

    public ApiStubGenerator(List<String> allowedPackages) {
        this(allowedPackages, false);
    }

    public ApiStubGenerator(List<String> allowedPackages, boolean validateExposedTypes) {
        this.hasDeclaredAPI = !allowedPackages.isEmpty();
        this.memberOfApiChecker = this.hasDeclaredAPI ? new DefaultMemberOfApiChecker(allowedPackages) : new AlwaysMemberOfApiChecker();
        this.apiValidator = validateExposedTypes ? new DefaultApiValidator(this.memberOfApiChecker) : new NoOpValidator();
    }

    public boolean belongsToAPI(byte[] clazz) {
        ClassReader cr = new ClassReader(clazz);
        return this.belongsToApi(cr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean belongsToAPI(InputStream inputStream) throws IOException {
        ClassReader cr = new ClassReader(inputStream);
        try {
            boolean bl = this.belongsToApi(cr);
            return bl;
        }
        finally {
            inputStream.close();
        }
    }

    private boolean belongsToApi(ClassReader cr) {
        final AtomicBoolean isAPI = new AtomicBoolean();
        cr.accept(new ClassVisitor(327680){

            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                String className = ApiStubGenerator.toClassName(name);
                isAPI.set(ApiStubGenerator.this.memberOfApiChecker.belongsToApi(className) && ApiStubGenerator.this.isPublicAPI(access) && !AIC_LOCAL_CLASS_PATTERN.matcher(name).matches());
            }
        }, 7);
        return isAPI.get();
    }

    public byte[] convertToApi(byte[] clazz) {
        ClassReader cr = new ClassReader(clazz);
        return this.convertToApi(cr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] convertToApi(InputStream inputStream) throws IOException {
        try {
            ClassReader cr = new ClassReader(inputStream);
            byte[] byArray = this.convertToApi(cr);
            return byArray;
        }
        finally {
            inputStream.close();
        }
    }

    private byte[] convertToApi(ClassReader cr) {
        ClassWriter cw = new ClassWriter(1);
        cr.accept((ClassVisitor)new PublicAPIExtractor(new StubClassWriter(cw)), 6);
        return cw.toByteArray();
    }

    public static String toClassName(String cn) {
        return cn.replace('/', '.');
    }

    private boolean isProtected(int access) {
        return (access & 4) == 4;
    }

    private boolean isPublic(int access) {
        return (access & 1) == 1;
    }

    private boolean isPublicAPI(int access) {
        return this.isPackagePrivate(access) && !this.hasDeclaredAPI || this.isPublic(access) || this.isProtected(access);
    }

    private boolean isPackagePrivate(int access) {
        return access == 0 || access == 8 || access == 32 || access == 40;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class PublicAPIExtractor
    extends ClassVisitor
    implements Opcodes {
        private final List<MethodSig> methods;
        private final List<FieldSig> fields;
        private final List<InnerClassSig> innerClasses;
        private final StubClassWriter adapter;
        private String internalClassName;
        private boolean isInnerClass;
        private ClassSig classSig;

        public PublicAPIExtractor(StubClassWriter cv) {
            super(327680);
            this.methods = Lists.newLinkedList();
            this.fields = Lists.newLinkedList();
            this.innerClasses = Lists.newLinkedList();
            this.adapter = cv;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            super.visit(version, access, name, signature, superName, interfaces);
            this.classSig = new ClassSig(version, access, name, signature, superName, interfaces);
            this.internalClassName = name;
            this.isInnerClass = (access & 0x20) == 32;
            ApiStubGenerator.this.apiValidator.validateSuperTypes(name, signature, superName, interfaces);
        }

        public void visitEnd() {
            super.visitEnd();
            this.adapter.visit(this.classSig.getVersion(), this.classSig.getAccess(), this.classSig.getName(), this.classSig.getSignature(), this.classSig.getSuperName(), this.classSig.getInterfaces());
            this.visitAnnotationSigs(Sets.newTreeSet(this.classSig.getAnnotations()));
            for (MethodSig method : Sets.newTreeSet(this.methods)) {
                MethodVisitor mv = this.adapter.visitMethod(method.getAccess(), method.getName(), method.getDesc(), method.getSignature(), method.getExceptions().toArray(new String[method.getExceptions().size()]));
                this.visitAnnotationSigs(mv, (Set<AnnotationSig>)Sets.newTreeSet(method.getAnnotations()));
                this.visitAnnotationSigs(mv, (Set<AnnotationSig>)Sets.newTreeSet(method.getParameterAnnotations()));
                mv.visitEnd();
            }
            for (FieldSig field : Sets.newTreeSet(this.fields)) {
                FieldVisitor fieldVisitor = this.adapter.visitField(field.getAccess(), field.getName(), field.getDesc(), field.getSignature(), null);
                this.visitAnnotationSigs(fieldVisitor, (Set<AnnotationSig>)Sets.newTreeSet(field.getAnnotations()));
                fieldVisitor.visitEnd();
            }
            for (InnerClassSig innerClass : Sets.newTreeSet(this.innerClasses)) {
                this.adapter.visitInnerClass(innerClass.getName(), innerClass.getOuterName(), innerClass.getInnerName(), innerClass.getAccess());
            }
            this.adapter.visitEnd();
        }

        private void visitAnnotationSigs(Set<AnnotationSig> annotationSigs) {
            for (AnnotationSig annotation : annotationSigs) {
                AnnotationVisitor annotationVisitor = this.adapter.visitAnnotation(annotation.getName(), annotation.isVisible());
                this.visitAnnotationValues(annotation, annotationVisitor);
            }
        }

        private void visitAnnotationSigs(MethodVisitor mv, Set<AnnotationSig> annotationSigs) {
            for (AnnotationSig annotation : annotationSigs) {
                AnnotationVisitor annotationVisitor = annotation instanceof ParameterAnnotationSig ? mv.visitParameterAnnotation(((ParameterAnnotationSig)annotation).getParameter(), annotation.getName(), annotation.isVisible()) : mv.visitAnnotation(annotation.getName(), annotation.isVisible());
                this.visitAnnotationValues(annotation, annotationVisitor);
            }
        }

        private void visitAnnotationSigs(FieldVisitor fv, Set<AnnotationSig> annotationSigs) {
            for (AnnotationSig annotation : annotationSigs) {
                AnnotationVisitor annotationVisitor = fv.visitAnnotation(annotation.getName(), annotation.isVisible());
                this.visitAnnotationValues(annotation, annotationVisitor);
            }
        }

        private void visitAnnotationValues(AnnotationSig annotation, AnnotationVisitor annotationVisitor) {
            TreeSet values = Sets.newTreeSet(annotation.getValues());
            for (AnnotationValue value : values) {
                this.visitAnnotationValue(annotationVisitor, value);
            }
            annotationVisitor.visitEnd();
        }

        private void visitAnnotationValue(AnnotationVisitor annotationVisitor, AnnotationValue value) {
            String name = value.getName();
            if (value instanceof EnumAnnotationValue) {
                annotationVisitor.visitEnum(name, ((EnumAnnotationValue)value).getDesc(), (String)((EnumAnnotationValue)value).getValue());
            } else if (value instanceof SimpleAnnotationValue) {
                annotationVisitor.visit(name, ((SimpleAnnotationValue)value).getValue());
            } else if (value instanceof ArrayAnnotationValue) {
                AnnotationValue[] values;
                AnnotationVisitor arrayVisitor = annotationVisitor.visitArray(name);
                for (AnnotationValue annotationValue : values = ((ArrayAnnotationValue)value).getValue()) {
                    this.visitAnnotationValue(arrayVisitor, annotationValue);
                }
                arrayVisitor.visitEnd();
            } else if (value instanceof AnnotationAnnotationValue) {
                AnnotationSig annotation = ((AnnotationAnnotationValue)value).getAnnotation();
                AnnotationVisitor annVisitor = annotationVisitor.visitAnnotation(name, annotation.getName());
                this.visitAnnotationValues(annotation, annVisitor);
            }
        }

        public AnnotationVisitor visitAnnotation(final String desc, final boolean visible) {
            return ApiStubGenerator.this.apiValidator.validateAnnotation(ApiStubGenerator.toClassName(this.internalClassName), desc, new Factory<AnnotationVisitor>(){

                public AnnotationVisitor create() {
                    AnnotationSig sig = PublicAPIExtractor.this.classSig.addAnnotation(desc, visible);
                    return new SortingAnnotationVisitor(sig, PublicAPIExtractor.super.visitAnnotation(desc, visible));
                }
            });
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if ("<clinit>".equals(name)) {
                return null;
            }
            if (ApiStubGenerator.this.isPublicAPI(access) || "<init>".equals(name) && this.isInnerClass) {
                final MethodSig methodSig = new MethodSig(access, name, desc, signature, exceptions);
                return ApiStubGenerator.this.apiValidator.validateMethod(methodSig, new Factory<MethodVisitor>(){

                    public MethodVisitor create() {
                        PublicAPIExtractor.this.methods.add(methodSig);
                        return PublicAPIExtractor.this.createMethodAnnotationChecker(methodSig);
                    }
                });
            }
            return null;
        }

        private MethodVisitor createMethodAnnotationChecker(final MethodSig methodSig) {
            return new MethodVisitor(327680){

                private AnnotationVisitor superVisitParameterAnnotation(int parameter, String annDesc, boolean visible) {
                    return super.visitParameterAnnotation(parameter, annDesc, visible);
                }

                public AnnotationVisitor visitAnnotation(final String annDesc, final boolean visible) {
                    return ApiStubGenerator.this.apiValidator.validateAnnotation(methodSig.toString(), annDesc, new Factory<AnnotationVisitor>(){

                        public AnnotationVisitor create() {
                            AnnotationSig sig = methodSig.addAnnotation(annDesc, visible);
                            return new SortingAnnotationVisitor(sig, PublicAPIExtractor.super.visitAnnotation(annDesc, visible));
                        }
                    });
                }

                public AnnotationVisitor visitParameterAnnotation(final int parameter, final String annDesc, final boolean visible) {
                    return ApiStubGenerator.this.apiValidator.validateAnnotation(methodSig.toString(), annDesc, new Factory<AnnotationVisitor>(){

                        public AnnotationVisitor create() {
                            ParameterAnnotationSig pSig = methodSig.addParameterAnnotation(parameter, annDesc, visible);
                            return new SortingAnnotationVisitor(pSig, this.superVisitParameterAnnotation(parameter, annDesc, visible));
                        }
                    });
                }
            };
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            if (ApiStubGenerator.this.isPublicAPI(access)) {
                final FieldSig fieldSig = new FieldSig(access, name, desc, signature);
                return ApiStubGenerator.this.apiValidator.validateField(fieldSig, new Factory<FieldVisitor>(){

                    public FieldVisitor create() {
                        PublicAPIExtractor.this.fields.add(fieldSig);
                        return new FieldVisitor(327680){

                            private AnnotationVisitor superVisitAnnotation(String desc, boolean visible) {
                                return super.visitAnnotation(desc, visible);
                            }

                            public AnnotationVisitor visitAnnotation(final String annotationDesc, final boolean visible) {
                                return ApiStubGenerator.this.apiValidator.validateAnnotation(fieldSig.toString(), annotationDesc, new Factory<AnnotationVisitor>(){

                                    public AnnotationVisitor create() {
                                        AnnotationSig sig = fieldSig.addAnnotation(annotationDesc, visible);
                                        return new SortingAnnotationVisitor(sig, this.superVisitAnnotation(annotationDesc, visible));
                                    }
                                });
                            }
                        };
                    }
                });
            }
            return null;
        }

        public void visitInnerClass(String name, String outerName, String innerName, int access) {
            if (innerName == null) {
                return;
            }
            if (ApiStubGenerator.this.isPackagePrivate(access) && ApiStubGenerator.this.hasDeclaredAPI) {
                return;
            }
            this.innerClasses.add(new InnerClassSig(name, outerName, innerName, access));
            super.visitInnerClass(name, outerName, innerName, access);
        }
    }
}

