/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.base.internal.tasks.apigen.abi;

import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Lists;
import java.lang.reflect.Modifier;
import java.util.List;
import org.gradle.language.base.internal.tasks.apigen.abi.AnnotationSig;
import org.objectweb.asm.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldSig
implements Comparable<FieldSig> {
    private final int access;
    private final String name;
    private final String desc;
    private final String signature;
    private final List<AnnotationSig> annotations = Lists.newArrayList();

    public FieldSig(int access, String name, String desc, String signature) {
        this.access = access;
        this.name = name;
        this.desc = desc;
        this.signature = signature;
    }

    public int getAccess() {
        return this.access;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getName() {
        return this.name;
    }

    public String getSignature() {
        return this.signature;
    }

    public List<AnnotationSig> getAnnotations() {
        return this.annotations;
    }

    public AnnotationSig addAnnotation(String desc, boolean visible) {
        AnnotationSig sig = new AnnotationSig(desc, visible);
        this.annotations.add(sig);
        return sig;
    }

    @Override
    public int compareTo(FieldSig o) {
        return ComparisonChain.start().compare(this.access, o.access).compare((Comparable)((Object)this.name), (Comparable)((Object)o.name)).compare((Comparable)((Object)(this.desc == null ? "" : this.desc)), (Comparable)((Object)(o.desc == null ? "" : o.desc))).compare((Comparable)((Object)(this.signature == null ? "" : this.signature)), (Comparable)((Object)(o.signature == null ? "" : o.signature))).result();
    }

    public String toString() {
        return String.format("%s %s %s", Modifier.toString(this.access), Type.getType((String)this.desc).getClassName(), this.name);
    }
}

