/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.platform.base.internal.registry;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.gradle.internal.TriAction;
import org.gradle.language.base.plugins.ComponentModelBasePlugin;
import org.gradle.model.InvalidModelRuleDeclarationException;
import org.gradle.model.internal.core.DirectNodeInputUsingModelAction;
import org.gradle.model.internal.core.ExtractedModelAction;
import org.gradle.model.internal.core.ExtractedModelRule;
import org.gradle.model.internal.core.ModelAction;
import org.gradle.model.internal.core.ModelActionRole;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.ModelView;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.inspect.MethodRuleDefinition;
import org.gradle.model.internal.type.ModelType;
import org.gradle.platform.base.BinarySpec;
import org.gradle.platform.base.ComponentBinaries;
import org.gradle.platform.base.ComponentSpec;
import org.gradle.platform.base.ComponentSpecContainer;
import org.gradle.platform.base.InvalidModelException;
import org.gradle.platform.base.internal.registry.AbstractAnnotationDrivenComponentModelRuleExtractor;
import org.gradle.platform.base.internal.registry.ModelMapBasedRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentBinariesModelRuleExtractor
extends AbstractAnnotationDrivenComponentModelRuleExtractor<ComponentBinaries> {
    public <R, S> ExtractedModelRule registration(MethodRuleDefinition<R, S> ruleDefinition) {
        return this.createRegistration(ruleDefinition);
    }

    private <R, S extends BinarySpec, C extends ComponentSpec> ExtractedModelRule createRegistration(MethodRuleDefinition<R, ?> ruleDefinition) {
        try {
            AbstractAnnotationDrivenComponentModelRuleExtractor.RuleMethodDataCollector dataCollector = new AbstractAnnotationDrivenComponentModelRuleExtractor.RuleMethodDataCollector(this);
            this.visitAndVerifyMethodSignature(dataCollector, ruleDefinition);
            Class binaryType = dataCollector.getParameterType(BinarySpec.class);
            Class componentType = dataCollector.getParameterType(ComponentSpec.class);
            ModelReference subject = ModelReference.of((ModelPath)ModelPath.path((String)"components"), (ModelType)ModelType.of(ComponentSpecContainer.class));
            ComponentBinariesRule componentBinariesRule = new ComponentBinariesRule((ModelReference<ComponentSpecContainer>)subject, componentType, binaryType, ruleDefinition);
            return new ExtractedModelAction(ModelActionRole.Finalize, (List)ImmutableList.of(ComponentModelBasePlugin.class), componentBinariesRule);
        }
        catch (InvalidModelException e) {
            throw this.invalidModelRule(ruleDefinition, e);
        }
    }

    private void visitAndVerifyMethodSignature(AbstractAnnotationDrivenComponentModelRuleExtractor.RuleMethodDataCollector dataCollector, MethodRuleDefinition<?, ?> ruleDefinition) {
        this.assertIsVoidMethod(ruleDefinition);
        this.visitSubject(dataCollector, ruleDefinition, BinarySpec.class);
        this.visitDependency(dataCollector, ruleDefinition, ModelType.of(ComponentSpec.class));
    }

    protected InvalidModelRuleDeclarationException invalidModelRule(MethodRuleDefinition<?, ?> ruleDefinition, InvalidModelException e) {
        StringBuilder sb = new StringBuilder();
        ruleDefinition.getDescriptor().describeTo((Appendable)sb);
        sb.append(" is not a valid ComponentBinaries model rule method.");
        return new InvalidModelRuleDeclarationException(sb.toString(), (Throwable)((Object)e));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ComponentBinariesRule<R, S extends BinarySpec, C extends ComponentSpec>
    extends ModelMapBasedRule<R, S, ComponentSpec, ComponentSpecContainer> {
        private final Class<C> componentType;
        private final Class<S> binaryType;

        public ComponentBinariesRule(ModelReference<ComponentSpecContainer> subject, Class<C> componentType, Class<S> binaryType, MethodRuleDefinition<R, ?> ruleDefinition) {
            super(subject, componentType, ruleDefinition, new ModelReference[0]);
            this.componentType = componentType;
            this.binaryType = binaryType;
        }

        protected void execute(MutableModelNode modelNode, ComponentSpecContainer componentSpecs, List<ModelView<?>> modelMapRuleInputs) {
            modelNode.applyToAllLinks(ModelActionRole.Mutate, (ModelAction)DirectNodeInputUsingModelAction.of((ModelReference)ModelReference.of((ModelType)ModelType.of(this.componentType)), (ModelRuleDescriptor)this.getDescriptor(), (List)this.getInputs(), (TriAction)new TriAction<MutableModelNode, C, List<ModelView<?>>>(){

                public void execute(MutableModelNode componentModelNode, C component, List<ModelView<?>> componentRuleInputs) {
                    ComponentBinariesRule.this.invoke(componentRuleInputs, component.getBinaries().withType(ComponentBinariesRule.this.binaryType), component, new Object[0]);
                }
            }));
        }
    }
}

