/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.manage.schema.extract;

import com.google.common.collect.ImmutableSet;
import org.gradle.api.Action;
import org.gradle.internal.BiAction;
import org.gradle.internal.Cast;
import org.gradle.model.internal.core.FactoryBasedManagedNodeInitializer;
import org.gradle.model.internal.core.FactoryBasedNodeInitializer;
import org.gradle.model.internal.core.InstanceFactory;
import org.gradle.model.internal.core.NodeInitializer;
import org.gradle.model.internal.manage.instance.ManagedProxyFactory;
import org.gradle.model.internal.manage.schema.ModelManagedImplStructSchema;
import org.gradle.model.internal.manage.schema.ModelSchema;
import org.gradle.model.internal.manage.schema.ModelSchemaStore;
import org.gradle.model.internal.manage.schema.extract.NodeInitializerExtractionStrategy;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FactoryBasedNodeInitializerExtractionStrategy<T>
implements NodeInitializerExtractionStrategy {
    private final InstanceFactory<T> instanceFactory;
    private final ModelSchemaStore schemaStore;
    private final ManagedProxyFactory proxyFactory;
    private final BiAction<? super T, ? super ModelSchema<? extends T>> configAction;

    public FactoryBasedNodeInitializerExtractionStrategy(InstanceFactory<T> instanceFactory, ModelSchemaStore schemaStore, ManagedProxyFactory proxyFactory, BiAction<? super T, ? super ModelSchema<? extends T>> configAction) {
        this.instanceFactory = instanceFactory;
        this.schemaStore = schemaStore;
        this.proxyFactory = proxyFactory;
        this.configAction = configAction;
    }

    public <S> NodeInitializer extractNodeInitializer(ModelSchema<S> schema) {
        if (!this.instanceFactory.getBaseInterface().isAssignableFrom(schema.getType())) {
            return null;
        }
        return this.getNodeInitializer((ModelSchema)Cast.uncheckedCast(schema));
    }

    private <S extends T> NodeInitializer getNodeInitializer(final ModelSchema<S> schema) {
        if (schema instanceof ModelManagedImplStructSchema) {
            ModelManagedImplStructSchema managedSchema = (ModelManagedImplStructSchema)Cast.uncheckedCast(schema);
            return new FactoryBasedManagedNodeInitializer(this.instanceFactory, managedSchema, this.schemaStore, this.proxyFactory, new Action<T>(){

                public void execute(T instance) {
                    FactoryBasedNodeInitializerExtractionStrategy.this.configAction.execute(instance, (Object)schema);
                }
            });
        }
        return new FactoryBasedNodeInitializer<T, S>(this.instanceFactory, schema.getType());
    }

    @Override
    public Iterable<ModelType<?>> supportedTypes() {
        return ImmutableSet.copyOf(this.instanceFactory.getSupportedTypes());
    }
}

