/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testkit.runner.internal;

import java.io.File;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.internal.classpath.DefaultGradleDistributionLocator;
import org.gradle.internal.SystemProperties;
import org.gradle.internal.classloader.ClasspathUtil;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.testkit.runner.BuildResult;
import org.gradle.testkit.runner.GradleRunner;
import org.gradle.testkit.runner.InvalidRunnerConfigurationException;
import org.gradle.testkit.runner.UnexpectedBuildFailure;
import org.gradle.testkit.runner.UnexpectedBuildSuccess;
import org.gradle.testkit.runner.internal.ConstantTestKitDirProvider;
import org.gradle.testkit.runner.internal.DefaultBuildResult;
import org.gradle.testkit.runner.internal.GradleExecutionParameters;
import org.gradle.testkit.runner.internal.GradleExecutionResult;
import org.gradle.testkit.runner.internal.GradleExecutor;
import org.gradle.testkit.runner.internal.TempTestKitDirProvider;
import org.gradle.testkit.runner.internal.TestKitDirProvider;
import org.gradle.testkit.runner.internal.ToolingApiGradleExecutor;
import org.gradle.testkit.runner.internal.dist.GradleDistribution;
import org.gradle.testkit.runner.internal.dist.InstalledGradleDistribution;
import org.gradle.testkit.runner.internal.dist.URILocatedGradleDistribution;
import org.gradle.testkit.runner.internal.dist.VersionBasedGradleDistribution;
import org.gradle.testkit.runner.internal.io.SynchronizedOutputStream;
import org.gradle.testkit.runner.internal.io.WriterOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultGradleRunner
extends GradleRunner {
    public static final String DEBUG_SYS_PROP = "org.gradle.testkit.debug";
    private final GradleExecutor gradleExecutor;
    private GradleDistribution distribution;
    private TestKitDirProvider testKitDirProvider;
    private File projectDirectory;
    private List<String> arguments = Collections.emptyList();
    private List<String> jvmArguments = Collections.emptyList();
    private ClassPath classpath = ClassPath.EMPTY;
    private boolean debug;
    private OutputStream standardOutput;
    private OutputStream standardError;
    private boolean forwardingSystemStreams;

    public DefaultGradleRunner() {
        this(new ToolingApiGradleExecutor(), new TempTestKitDirProvider());
    }

    DefaultGradleRunner(GradleExecutor gradleExecutor, TestKitDirProvider testKitDirProvider) {
        this.gradleExecutor = gradleExecutor;
        this.testKitDirProvider = testKitDirProvider;
        this.debug = Boolean.getBoolean(DEBUG_SYS_PROP);
    }

    public TestKitDirProvider getTestKitDirProvider() {
        return this.testKitDirProvider;
    }

    @Override
    public GradleRunner withGradleVersion(String versionNumber) {
        this.distribution = new VersionBasedGradleDistribution(versionNumber);
        return this;
    }

    @Override
    public GradleRunner withGradleInstallation(File installation) {
        this.distribution = new InstalledGradleDistribution(installation);
        return this;
    }

    @Override
    public GradleRunner withGradleDistribution(URI distribution) {
        this.distribution = new URILocatedGradleDistribution(distribution);
        return this;
    }

    @Override
    public DefaultGradleRunner withTestKitDir(File testKitDir) {
        this.validateArgumentNotNull(testKitDir, "testKitDir");
        this.testKitDirProvider = new ConstantTestKitDirProvider(testKitDir);
        return this;
    }

    public DefaultGradleRunner withJvmArguments(List<String> jvmArguments) {
        this.jvmArguments = Collections.unmodifiableList(new ArrayList<String>(jvmArguments));
        return this;
    }

    public DefaultGradleRunner withJvmArguments(String ... jvmArguments) {
        return this.withJvmArguments(Arrays.asList(jvmArguments));
    }

    @Override
    public File getProjectDir() {
        return this.projectDirectory;
    }

    @Override
    public DefaultGradleRunner withProjectDir(File projectDir) {
        this.projectDirectory = projectDir;
        return this;
    }

    @Override
    public List<String> getArguments() {
        return this.arguments;
    }

    @Override
    public DefaultGradleRunner withArguments(List<String> arguments) {
        this.arguments = Collections.unmodifiableList(new ArrayList<String>(arguments));
        return this;
    }

    @Override
    public DefaultGradleRunner withArguments(String ... arguments) {
        return this.withArguments((List)Arrays.asList(arguments));
    }

    @Override
    public List<? extends File> getPluginClasspath() {
        return this.classpath.getAsFiles();
    }

    @Override
    public GradleRunner withPluginClasspath(Iterable<? extends File> classpath) {
        ArrayList<File> f = new ArrayList<File>();
        for (File file : classpath) {
            f.add(new File(file.getAbsolutePath()));
        }
        if (!f.isEmpty()) {
            this.classpath = new DefaultClassPath(f);
        }
        return this;
    }

    @Override
    public boolean isDebug() {
        return this.debug;
    }

    @Override
    public GradleRunner withDebug(boolean flag) {
        this.debug = flag;
        return this;
    }

    @Override
    public GradleRunner forwardStdOutput(Writer writer) {
        if (this.forwardingSystemStreams) {
            this.forwardingSystemStreams = false;
            this.standardError = null;
        }
        this.validateArgumentNotNull(writer, "standardOutput");
        this.standardOutput = DefaultGradleRunner.toOutputStream(writer);
        return this;
    }

    @Override
    public GradleRunner forwardStdError(Writer writer) {
        if (this.forwardingSystemStreams) {
            this.forwardingSystemStreams = false;
            this.standardOutput = null;
        }
        this.validateArgumentNotNull(writer, "standardError");
        this.standardError = DefaultGradleRunner.toOutputStream(writer);
        return this;
    }

    @Override
    public GradleRunner forwardOutput() {
        this.forwardingSystemStreams = true;
        SynchronizedOutputStream systemOut = new SynchronizedOutputStream(System.out);
        this.standardOutput = systemOut;
        this.standardError = systemOut;
        return this;
    }

    private static OutputStream toOutputStream(Writer standardOutput) {
        return new WriterOutputStream(standardOutput, Charset.defaultCharset());
    }

    private void validateArgumentNotNull(Object argument, String argumentName) {
        if (argument == null) {
            throw new IllegalArgumentException(String.format("%s argument cannot be null", argumentName));
        }
    }

    @Override
    public BuildResult build() {
        return this.run(new Action<GradleExecutionResult>(){

            public void execute(GradleExecutionResult gradleExecutionResult) {
                if (!gradleExecutionResult.isSuccessful()) {
                    throw new UnexpectedBuildFailure(DefaultGradleRunner.this.createDiagnosticsMessage("Unexpected build execution failure", gradleExecutionResult), DefaultGradleRunner.this.createBuildResult(gradleExecutionResult));
                }
            }
        });
    }

    @Override
    public BuildResult buildAndFail() {
        return this.run(new Action<GradleExecutionResult>(){

            public void execute(GradleExecutionResult gradleExecutionResult) {
                if (gradleExecutionResult.isSuccessful()) {
                    throw new UnexpectedBuildSuccess(DefaultGradleRunner.this.createDiagnosticsMessage("Unexpected build execution success", gradleExecutionResult), DefaultGradleRunner.this.createBuildResult(gradleExecutionResult));
                }
            }
        });
    }

    String createDiagnosticsMessage(String trailingMessage, GradleExecutionResult gradleExecutionResult) {
        String lineBreak = SystemProperties.getInstance().getLineSeparator();
        StringBuilder message = new StringBuilder();
        message.append(trailingMessage);
        message.append(" in ");
        message.append(this.getProjectDir().getAbsolutePath());
        message.append(" with arguments ");
        message.append(this.getArguments());
        String output = gradleExecutionResult.getOutput();
        if (output != null && !output.isEmpty()) {
            message.append(lineBreak);
            message.append(lineBreak);
            message.append("Output:");
            message.append(lineBreak);
            message.append(output);
        }
        return message.toString();
    }

    private BuildResult run(Action<GradleExecutionResult> resultVerification) {
        if (this.projectDirectory == null) {
            throw new InvalidRunnerConfigurationException("Please specify a project directory before executing the build");
        }
        File testKitDir = this.createTestKitDir(this.testKitDirProvider);
        GradleDistribution effectiveDistribution = this.distribution == null ? DefaultGradleRunner.findGradleInstallFromGradleRunner() : this.distribution;
        GradleExecutionResult execResult = this.gradleExecutor.run(new GradleExecutionParameters(effectiveDistribution, testKitDir, this.projectDirectory, this.arguments, this.jvmArguments, this.classpath, this.debug, this.standardOutput, this.standardError));
        resultVerification.execute((Object)execResult);
        return this.createBuildResult(execResult);
    }

    private BuildResult createBuildResult(GradleExecutionResult execResult) {
        return new DefaultBuildResult(execResult.getOutput(), execResult.getTasks());
    }

    private File createTestKitDir(TestKitDirProvider testKitDirProvider) {
        File dir = testKitDirProvider.getDir();
        if (dir.isDirectory()) {
            if (!dir.canWrite()) {
                throw new InvalidRunnerConfigurationException("Unable to write to test kit directory: " + dir.getAbsolutePath());
            }
            return dir;
        }
        if (dir.exists()) {
            throw new InvalidRunnerConfigurationException("Unable to use non-directory as test kit directory: " + dir.getAbsolutePath());
        }
        if (dir.mkdirs() || dir.isDirectory()) {
            return dir;
        }
        throw new InvalidRunnerConfigurationException("Unable to create test kit directory: " + dir.getAbsolutePath());
    }

    private static GradleDistribution findGradleInstallFromGradleRunner() {
        DefaultGradleDistributionLocator gradleDistributionLocator = new DefaultGradleDistributionLocator(GradleRunner.class);
        File gradleHome = gradleDistributionLocator.getGradleHome();
        if (gradleHome == null) {
            String messagePrefix = "Could not find a Gradle runtime to use based on the location of the GradleRunner class";
            try {
                File classpathForClass = ClasspathUtil.getClasspathForClass(GradleRunner.class);
                messagePrefix = messagePrefix + ": " + classpathForClass.getAbsolutePath();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new InvalidRunnerConfigurationException(messagePrefix + ". Please specify a Gradle runtime to use via GradleRunner.withGradleVersion() or similar.");
        }
        return new InstalledGradleDistribution(gradleHome);
    }
}

