/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.plugins;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.tasks.Copy;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.jvm.JarBinarySpec;
import org.gradle.jvm.JvmLibrarySpec;
import org.gradle.jvm.internal.DefaultJarBinarySpec;
import org.gradle.jvm.internal.DefaultJvmLibrarySpec;
import org.gradle.jvm.internal.JarBinaryRules;
import org.gradle.jvm.internal.JarBinarySpecInternal;
import org.gradle.jvm.internal.JavaPlatformResolver;
import org.gradle.jvm.internal.JvmLibrarySpecInternal;
import org.gradle.jvm.internal.StubbedJar;
import org.gradle.jvm.internal.toolchain.JavaToolChainInternal;
import org.gradle.jvm.platform.JavaPlatform;
import org.gradle.jvm.platform.internal.DefaultJavaPlatform;
import org.gradle.jvm.tasks.Jar;
import org.gradle.jvm.toolchain.JavaToolChainRegistry;
import org.gradle.jvm.toolchain.internal.DefaultJavaToolChainRegistry;
import org.gradle.language.base.internal.BuildDirHolder;
import org.gradle.language.base.internal.tasks.apigen.ApiStubGenerator;
import org.gradle.model.Model;
import org.gradle.model.ModelMap;
import org.gradle.model.Mutate;
import org.gradle.model.Path;
import org.gradle.model.RuleSource;
import org.gradle.model.internal.registry.ModelRegistry;
import org.gradle.model.internal.type.ModelType;
import org.gradle.platform.base.BinaryTasks;
import org.gradle.platform.base.BinaryType;
import org.gradle.platform.base.BinaryTypeBuilder;
import org.gradle.platform.base.ComponentBinaries;
import org.gradle.platform.base.ComponentSpec;
import org.gradle.platform.base.ComponentType;
import org.gradle.platform.base.ComponentTypeBuilder;
import org.gradle.platform.base.DependencySpec;
import org.gradle.platform.base.internal.BinaryNamingSchemeBuilder;
import org.gradle.platform.base.internal.DefaultBinaryNamingSchemeBuilder;
import org.gradle.platform.base.internal.DefaultPlatformRequirement;
import org.gradle.platform.base.internal.PlatformRequirement;
import org.gradle.platform.base.internal.PlatformResolver;
import org.gradle.platform.base.internal.PlatformResolvers;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
public class JvmComponentPlugin
implements Plugin<Project> {
    private final ModelRegistry modelRegistry;

    @Inject
    public JvmComponentPlugin(ModelRegistry modelRegistry) {
        this.modelRegistry = modelRegistry;
    }

    public void apply(Project project) {
        this.modelRegistry.getRoot().applyToAllLinksTransitive(ModelType.of(ComponentSpec.class), JarBinaryRules.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Rules
    extends RuleSource {
        Rules() {
        }

        @ComponentType
        public void register(ComponentTypeBuilder<JvmLibrarySpec> builder) {
            builder.defaultImplementation(DefaultJvmLibrarySpec.class);
            builder.internalView(JvmLibrarySpecInternal.class);
        }

        @BinaryType
        public void registerJar(BinaryTypeBuilder<JarBinarySpec> builder) {
            builder.defaultImplementation(DefaultJarBinarySpec.class);
            builder.internalView(JarBinarySpecInternal.class);
        }

        @Model
        public BinaryNamingSchemeBuilder binaryNamingSchemeBuilder() {
            return new DefaultBinaryNamingSchemeBuilder();
        }

        @Model
        public JavaToolChainRegistry javaToolChain(ServiceRegistry serviceRegistry) {
            JavaToolChainInternal toolChain = (JavaToolChainInternal)serviceRegistry.get(JavaToolChainInternal.class);
            return new DefaultJavaToolChainRegistry(toolChain);
        }

        @Model
        public BuildDirHolder buildDirHolder(@Path(value="buildDir") File buildDir) {
            return new BuildDirHolder(buildDir);
        }

        @Mutate
        public void registerPlatformResolver(PlatformResolvers platformResolvers) {
            platformResolvers.register((PlatformResolver)new JavaPlatformResolver());
        }

        @ComponentBinaries
        public void createBinaries(ModelMap<JarBinarySpec> binaries, BinaryNamingSchemeBuilder namingSchemeBuilder, PlatformResolvers platforms, JvmLibrarySpec jvmLibrary) {
            List<JavaPlatform> selectedPlatforms = this.resolvePlatforms(platforms, jvmLibrary);
            final Set<String> exportedPackages = jvmLibrary.getExportedPackages();
            final Collection<DependencySpec> apiDependencies = jvmLibrary.getApiDependencies();
            for (final JavaPlatform platform : selectedPlatforms) {
                String binaryName = this.buildBinaryName(jvmLibrary, namingSchemeBuilder, selectedPlatforms, platform);
                binaries.create(binaryName, (Action)new Action<JarBinarySpec>(){

                    public void execute(JarBinarySpec jarBinary) {
                        jarBinary.setTargetPlatform(platform);
                        jarBinary.setExportedPackages(exportedPackages);
                        jarBinary.setApiDependencies(apiDependencies);
                    }
                });
            }
        }

        private List<JavaPlatform> resolvePlatforms(final PlatformResolvers platformResolver, JvmLibrarySpec jvmLibrarySpec) {
            List<PlatformRequirement> targetPlatforms = ((JvmLibrarySpecInternal)jvmLibrarySpec).getTargetPlatforms();
            if (targetPlatforms.isEmpty()) {
                targetPlatforms = Collections.singletonList(DefaultPlatformRequirement.create((String)DefaultJavaPlatform.current().getName()));
            }
            return CollectionUtils.collect(targetPlatforms, (Transformer)new Transformer<JavaPlatform, PlatformRequirement>(){

                public JavaPlatform transform(PlatformRequirement platformRequirement) {
                    return (JavaPlatform)platformResolver.resolve(JavaPlatform.class, platformRequirement);
                }
            });
        }

        private String buildBinaryName(JvmLibrarySpec jvmLibrary, BinaryNamingSchemeBuilder namingSchemeBuilder, List<JavaPlatform> selectedPlatforms, JavaPlatform platform) {
            BinaryNamingSchemeBuilder componentBuilder = namingSchemeBuilder.withComponentName(jvmLibrary.getName()).withTypeString("jar");
            if (selectedPlatforms.size() > 1) {
                componentBuilder = componentBuilder.withVariantDimension(platform.getName());
            }
            return componentBuilder.build().getLifecycleTaskName();
        }

        @BinaryTasks
        public void createTasks(ModelMap<Task> tasks, final JarBinarySpec binary, final @Path(value="buildDir") File buildDir) {
            final File runtimeClassesDir = binary.getClassesDir();
            final File runtimeJarDestDir = binary.getJarFile().getParentFile();
            final String runtimeJarArchiveName = binary.getJarFile().getName();
            final String createRuntimeJar = "create" + StringUtils.capitalize((String)binary.getName());
            tasks.create(createRuntimeJar, Jar.class, (Action)new Action<Jar>(){

                public void execute(Jar jar) {
                    jar.setDescription(String.format("Creates the binary file for %s.", binary));
                    jar.from(new Object[]{runtimeClassesDir});
                    jar.from(new Object[]{binary.getResourcesDir()});
                    jar.setDestinationDir(runtimeJarDestDir);
                    jar.setArchiveName(runtimeJarArchiveName);
                }
            });
            String binaryName = binary.getName();
            if (!binaryName.endsWith("Jar")) {
                return;
            }
            String libName = binaryName.substring(0, binaryName.lastIndexOf("Jar"));
            String createApiJar = "create" + StringUtils.capitalize((String)(libName + "ApiJar"));
            final ImmutableList allowedPackages = ImmutableList.copyOf(binary.getExportedPackages());
            if (allowedPackages.isEmpty()) {
                tasks.create(createApiJar, Copy.class, (Action)new Action<Copy>(){

                    public void execute(Copy copy) {
                        copy.setDescription(String.format("Creates the API binary file for %s.", binary));
                        copy.from(new Object[]{new File(runtimeJarDestDir, runtimeJarArchiveName)});
                        copy.setDestinationDir(binary.getApiJarFile().getParentFile());
                        copy.dependsOn(new Object[]{createRuntimeJar});
                    }
                });
            } else {
                ApiStubGenerator stubGenerator = new ApiStubGenerator((List)allowedPackages);
                tasks.create(createApiJar, StubbedJar.class, (Action)new Action<StubbedJar>(){

                    public void execute(StubbedJar jar) {
                        File apiClassesDir = new File(new File(buildDir, "apiClasses"), runtimeClassesDir.getName());
                        jar.setDescription(String.format("Creates the API binary file for %s.", binary));
                        jar.setRuntimeClassesDir(runtimeClassesDir);
                        jar.setExportedPackages((Collection<String>)allowedPackages);
                        jar.setApiClassesDir(apiClassesDir);
                        jar.setDestinationDir(binary.getApiJarFile().getParentFile());
                        jar.setArchiveName(binary.getApiJarFile().getName());
                        jar.dependsOn(new Object[]{createRuntimeJar});
                    }
                });
            }
        }
    }
}

