/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.dsl.internal;

import com.google.common.collect.Lists;
import groovy.lang.Closure;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import net.jcip.annotations.ThreadSafe;
import org.gradle.api.Action;
import org.gradle.api.Transformer;
import org.gradle.api.internal.ClosureBackedAction;
import org.gradle.internal.BiAction;
import org.gradle.internal.file.RelativeFilePathResolver;
import org.gradle.model.InvalidModelRuleDeclarationException;
import org.gradle.model.dsl.internal.inputs.PotentialInput;
import org.gradle.model.dsl.internal.inputs.PotentialInputs;
import org.gradle.model.dsl.internal.transform.InputReferences;
import org.gradle.model.dsl.internal.transform.RuleMetadata;
import org.gradle.model.dsl.internal.transform.RulesBlock;
import org.gradle.model.dsl.internal.transform.SourceLocation;
import org.gradle.model.dsl.internal.transform.TransformedClosure;
import org.gradle.model.internal.core.DefaultNodeInitializerRegistry;
import org.gradle.model.internal.core.DirectNodeNoInputsModelAction;
import org.gradle.model.internal.core.InputUsingModelAction;
import org.gradle.model.internal.core.ModelAction;
import org.gradle.model.internal.core.ModelActionRole;
import org.gradle.model.internal.core.ModelCreators;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.ModelTypeInitializationException;
import org.gradle.model.internal.core.ModelView;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.NodeInitializer;
import org.gradle.model.internal.core.NodeInitializerContext;
import org.gradle.model.internal.core.NodeInitializerRegistry;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.registry.ModelRegistry;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class TransformedModelDslBacking {
    private static final Transformer<InputReferences, Closure<?>> INPUT_PATHS_EXTRACTOR = new Transformer<InputReferences, Closure<?>>(){

        public InputReferences transform(Closure<?> closure) {
            InputReferences inputs = new InputReferences();
            RuleMetadata ruleMetadata = TransformedModelDslBacking.getRuleMetadata(closure);
            inputs.absolutePaths(ruleMetadata.absoluteInputPaths(), ruleMetadata.absoluteInputLineNumbers());
            return inputs;
        }
    };
    private final ModelRegistry modelRegistry;
    private final Transformer<? extends InputReferences, ? super Closure<?>> inputPathsExtractor;
    private final Transformer<SourceLocation, ? super Closure<?>> ruleLocationExtractor;

    public TransformedModelDslBacking(ModelRegistry modelRegistry, RelativeFilePathResolver relativeFilePathResolver) {
        this(modelRegistry, INPUT_PATHS_EXTRACTOR, new RelativePathSourceLocationTransformer(relativeFilePathResolver));
    }

    TransformedModelDslBacking(ModelRegistry modelRegistry, Transformer<? extends InputReferences, ? super Closure<?>> inputPathsExtractor, Transformer<SourceLocation, ? super Closure<?>> ruleLocationExtractor) {
        this.modelRegistry = modelRegistry;
        this.inputPathsExtractor = inputPathsExtractor;
        this.ruleLocationExtractor = ruleLocationExtractor;
    }

    public void configure(String modelPathString, Closure<?> closure) {
        SourceLocation sourceLocation = (SourceLocation)this.ruleLocationExtractor.transform(closure);
        ModelPath modelPath = ModelPath.path((String)modelPathString);
        ModelRuleDescriptor descriptor = this.toDescriptor(sourceLocation, modelPath);
        this.registerAction(modelPath, Object.class, descriptor, ModelActionRole.Mutate, closure);
    }

    public <T> void create(String modelPathString, Class<T> type, Closure<?> closure) {
        SourceLocation sourceLocation = (SourceLocation)this.ruleLocationExtractor.transform(closure);
        ModelPath modelPath = ModelPath.path((String)modelPathString);
        ModelRuleDescriptor descriptor = this.toDescriptor(sourceLocation, modelPath);
        try {
            NodeInitializerRegistry nodeInitializerRegistry = (NodeInitializerRegistry)this.modelRegistry.realize(DefaultNodeInitializerRegistry.DEFAULT_REFERENCE.getPath(), DefaultNodeInitializerRegistry.DEFAULT_REFERENCE.getType());
            NodeInitializer nodeInitializer = nodeInitializerRegistry.getNodeInitializer(NodeInitializerContext.forType((ModelType)ModelType.of(type)));
            this.modelRegistry.create(ModelCreators.of((ModelPath)modelPath, (NodeInitializer)nodeInitializer).descriptor(descriptor).build());
        }
        catch (ModelTypeInitializationException e) {
            throw new InvalidModelRuleDeclarationException(descriptor, (Throwable)e);
        }
        this.registerAction(modelPath, type, descriptor, ModelActionRole.Initialize, closure);
    }

    private <T> void registerAction(ModelPath modelPath, Class<T> viewType, final ModelRuleDescriptor descriptor, final ModelActionRole role, final Closure<?> closure) {
        final ModelReference reference = ModelReference.of((ModelPath)modelPath, viewType);
        this.modelRegistry.configure(ModelActionRole.DefineRules, DirectNodeNoInputsModelAction.of((ModelReference)reference, (ModelRuleDescriptor)descriptor, (Action)new Action<MutableModelNode>(){

            public void execute(MutableModelNode mutableModelNode) {
                InputReferences inputs = (InputReferences)TransformedModelDslBacking.this.inputPathsExtractor.transform((Object)closure);
                List<String> absolutePaths = inputs.getAbsolutePaths();
                List<Integer> absolutePathLineNumbers = inputs.getAbsolutePathLineNumbers();
                final ArrayList potentialInputs = Lists.newArrayListWithCapacity((int)absolutePaths.size());
                ArrayList actualInputs = Lists.newArrayListWithCapacity((int)potentialInputs.size());
                for (int i = 0; i < absolutePaths.size(); ++i) {
                    String description = String.format("@ line %d", absolutePathLineNumbers.get(i));
                    String path = absolutePaths.get(i);
                    potentialInputs.add(PotentialInput.absoluteInput(path, actualInputs.size()));
                    actualInputs.add(ModelReference.untyped((ModelPath)ModelPath.path((String)path), (String)description));
                }
                mutableModelNode.applyToSelf(role, (ModelAction)InputUsingModelAction.of((ModelReference)reference, (ModelRuleDescriptor)descriptor, (List)actualInputs, (BiAction)new BiAction<T, List<ModelView<?>>>(){

                    public void execute(T t, List<ModelView<?>> modelViews) {
                        ((TransformedClosure)closure).applyRuleInputs(new PotentialInputs(modelViews, potentialInputs));
                        ClosureBackedAction.execute(t, (Closure)closure.rehydrate(null, closure.getThisObject(), closure.getThisObject()));
                    }
                }));
            }
        }));
    }

    public ModelRuleDescriptor toDescriptor(SourceLocation sourceLocation, ModelPath modelPath) {
        return sourceLocation.asDescriptor("model." + modelPath);
    }

    private static RuleMetadata getRuleMetadata(Closure<?> closure) {
        RuleMetadata ruleMetadata = closure.getClass().getAnnotation(RuleMetadata.class);
        if (ruleMetadata == null) {
            throw new IllegalStateException(String.format("Expected %s annotation to be used on the argument closure.", RuleMetadata.class.getName()));
        }
        return ruleMetadata;
    }

    public static boolean isTransformedBlock(Closure<?> closure) {
        Class<?> closureClass = closure.getClass();
        RulesBlock annotation = closureClass.getAnnotation(RulesBlock.class);
        return annotation != null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RelativePathSourceLocationTransformer
    implements Transformer<SourceLocation, Closure<?>> {
        private final RelativeFilePathResolver relativeFilePathResolver;

        public RelativePathSourceLocationTransformer(RelativeFilePathResolver relativeFilePathResolver) {
            this.relativeFilePathResolver = relativeFilePathResolver;
        }

        public SourceLocation transform(Closure<?> closure) {
            RuleMetadata ruleMetadata = TransformedModelDslBacking.getRuleMetadata(closure);
            URI uri = URI.create(ruleMetadata.absoluteScriptSourceLocation());
            String scheme = uri.getScheme();
            String description = "file".equalsIgnoreCase(scheme) ? this.relativeFilePathResolver.resolveAsRelativePath((Object)ruleMetadata.absoluteScriptSourceLocation()) : uri.toString();
            return new SourceLocation(uri.toString(), description, ruleMetadata.lineNumber(), ruleMetadata.columnNumber());
        }
    }
}

