/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.svg;

import java.awt.Graphics2D;
import java.io.IOException;
import java.text.AttributedCharacterIterator;
import java.util.List;
import org.apache.batik.gvt.renderer.StrokingTextPainter;
import org.apache.batik.gvt.text.TextSpanLayout;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.fonts.Font;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.svg.ACIUtils;
import org.apache.fop.util.CharUtilities;

public abstract class NativeTextPainter
extends StrokingTextPainter {
    protected Log log = LogFactory.getLog(NativeTextPainter.class);
    protected final FontInfo fontInfo;

    public NativeTextPainter(FontInfo fontInfo) {
        this.fontInfo = fontInfo;
    }

    protected abstract boolean isSupported(Graphics2D var1);

    protected abstract void paintTextRun(StrokingTextPainter.TextRun var1, Graphics2D var2) throws IOException;

    protected void paintTextRuns(List textRuns, Graphics2D g2d) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("paintTextRuns: count = " + textRuns.size());
        }
        if (!this.isSupported(g2d)) {
            super.paintTextRuns(textRuns, g2d);
            return;
        }
        for (int i = 0; i < textRuns.size(); ++i) {
            StrokingTextPainter.TextRun textRun = (StrokingTextPainter.TextRun)textRuns.get(i);
            try {
                this.paintTextRun(textRun, g2d);
                continue;
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
    }

    protected Font[] findFonts(AttributedCharacterIterator aci) {
        Font[] fonts = ACIUtils.findFontsForBatikACI(aci, this.fontInfo);
        return fonts;
    }

    protected CharSequence collectCharacters(AttributedCharacterIterator runaci) {
        StringBuffer chars = new StringBuffer();
        runaci.first();
        while (runaci.getIndex() < runaci.getEndIndex()) {
            chars.append(runaci.current());
            runaci.next();
        }
        return chars;
    }

    protected final void logTextRun(AttributedCharacterIterator runaci, TextSpanLayout layout) {
        if (this.log.isTraceEnabled()) {
            int charCount = runaci.getEndIndex() - runaci.getBeginIndex();
            this.log.trace("================================================");
            this.log.trace("New text run:");
            this.log.trace("char count: " + charCount);
            this.log.trace("range: " + runaci.getBeginIndex() + " - " + runaci.getEndIndex());
            this.log.trace("glyph count: " + layout.getGlyphCount());
        }
    }

    protected final void logCharacter(char ch, TextSpanLayout layout, int index, boolean visibleChar) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("glyph " + index + " -> " + layout.getGlyphIndex(index) + " => " + ch);
            if (CharUtilities.isAnySpace(ch) && ch != ' ') {
                this.log.trace("Space found: " + Integer.toHexString(ch));
            } else if (ch == '\u200d') {
                this.log.trace("ZWJ found: " + Integer.toHexString(ch));
            } else if (ch == '\u00ad') {
                this.log.trace("Soft hyphen found: " + Integer.toHexString(ch));
            }
            if (!visibleChar) {
                this.log.trace("Invisible glyph found: " + Integer.toHexString(ch));
            }
        }
    }
}

