/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.scriptext;

import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javajs.util.AU;
import javajs.util.CU;
import javajs.util.Lst;
import javajs.util.M3;
import javajs.util.M4;
import javajs.util.Measure;
import javajs.util.P3;
import javajs.util.P4;
import javajs.util.PT;
import javajs.util.Quat;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.api.Interface;
import org.jmol.api.JmolNMRInterface;
import org.jmol.api.JmolPatternMatcher;
import org.jmol.api.SymmetryInterface;
import org.jmol.atomdata.RadiusData;
import org.jmol.bspt.Bspt;
import org.jmol.bspt.CubeIterator;
import org.jmol.c.VDW;
import org.jmol.i18n.GT;
import org.jmol.java.BS;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.BondSet;
import org.jmol.modelset.ModelSet;
import org.jmol.script.SV;
import org.jmol.script.ScriptEval;
import org.jmol.script.ScriptException;
import org.jmol.script.ScriptMathProcessor;
import org.jmol.script.ScriptParam;
import org.jmol.script.T;
import org.jmol.util.BSUtil;
import org.jmol.util.ColorEncoder;
import org.jmol.util.Escape;
import org.jmol.util.JmolMolecule;
import org.jmol.util.Logger;
import org.jmol.util.Parser;
import org.jmol.util.Point3fi;
import org.jmol.util.SimpleUnitCell;
import org.jmol.viewer.Viewer;

public class MathExt {
    private Viewer vwr;
    private ScriptEval e;
    private Random rand;
    private JmolPatternMatcher pm;

    public MathExt init(Object object) {
        this.e = (ScriptEval)object;
        this.vwr = this.e.vwr;
        return this;
    }

    public boolean evaluate(ScriptMathProcessor scriptMathProcessor, T t, SV[] sVArray, int n) throws ScriptException {
        switch (n) {
            case 134217749: 
            case 0x8000202: 
            case 134218244: 
            case 134218245: 
            case 134218246: 
            case 134218250: {
                return this.evaluateMath(scriptMathProcessor, sVArray, n);
            }
            case 1275068928: 
            case 1275068929: 
            case 1275068930: 
            case 1275068931: 
            case 1275069441: 
            case 1275334681: 
            case 1275335685: {
                return this.evaluateList(scriptMathProcessor, t.intValue, sVArray);
            }
            case 0x10000040: {
                if (sVArray.length == 0) {
                    scriptMathProcessor.wasX = false;
                }
            }
            case 1275068418: {
                return this.evaluateArray(scriptMathProcessor, sVArray, n == 1275068418 && t.tok == 0x100000D1);
            }
            case 0x8000003: 
            case 134221850: {
                return this.evaluateQuaternion(scriptMathProcessor, sVArray, n);
            }
            case 0x4C000004: {
                return this.evaluateBin(scriptMathProcessor, sVArray);
            }
            case 134221829: {
                return this.evaluateCache(scriptMathProcessor, sVArray);
            }
            case 1275068934: 
            case 1275068935: {
                return this.evaluateRowCol(scriptMathProcessor, sVArray, n);
            }
            case 1765808134: {
                return this.evaluateColor(scriptMathProcessor, sVArray);
            }
            case 134221831: {
                return this.evaluateCompare(scriptMathProcessor, sVArray);
            }
            case 0x8000008: 
            case 1228931587: 
            case 1275203608: {
                return this.evaluateConnected(scriptMathProcessor, sVArray, n);
            }
            case 1747587102: {
                return this.evaluateUnitCell(scriptMathProcessor, sVArray);
            }
            case 134353926: {
                return this.evaluateContact(scriptMathProcessor, sVArray);
            }
            case 134221834: {
                return this.evaluateData(scriptMathProcessor, sVArray);
            }
            case 1275069442: 
            case 0x4C000404: {
                return this.evaluateDotDist(scriptMathProcessor, sVArray, n, t.intValue);
            }
            case 1275069443: {
                if (t.tok == 0x100000D1) {
                    return this.evaluateDotDist(scriptMathProcessor, sVArray, n, t.intValue);
                }
            }
            case 0x8000001: 
            case 1745489939: {
                return this.evaluateMeasure(scriptMathProcessor, sVArray, t.tok);
            }
            case 134222849: 
            case 1228935687: {
                return this.evaluateLoad(scriptMathProcessor, sVArray, n == 1228935687);
            }
            case 1275068427: {
                return this.evaluateFind(scriptMathProcessor, sVArray);
            }
            case 1287653388: 
            case 1825200146: {
                return this.evaluateFormat(scriptMathProcessor, t.intValue, sVArray, n == 1825200146);
            }
            case 134320141: {
                return this.evaluateUserFunction(scriptMathProcessor, (String)t.value, sVArray, t.intValue, t.tok == 0x100000D1);
            }
            case 1275068449: 
            case 1275072526: 
            case 1275082245: {
                return this.evaluateGetProperty(scriptMathProcessor, sVArray, n, t.tok == 0x100000D1);
            }
            case 136314895: {
                return this.evaluateHelix(scriptMathProcessor, sVArray);
            }
            case 134217750: 
            case 134219265: 
            case 134219266: {
                return this.evaluatePlane(scriptMathProcessor, sVArray, n);
            }
            case 134218253: 
            case 134222350: 
            case 134222850: 
            case 134238732: {
                return this.evaluateScript(scriptMathProcessor, sVArray, n);
            }
            case 1275068932: 
            case 1275069446: 
            case 1275069447: {
                return this.evaluateString(scriptMathProcessor, t.intValue, sVArray);
            }
            case 134217751: {
                return this.evaluatePoint(scriptMathProcessor, sVArray);
            }
            case 134256131: {
                return this.evaluatePrompt(scriptMathProcessor, sVArray);
            }
            case 134219268: {
                return this.evaluateRandom(scriptMathProcessor, sVArray);
            }
            case 1275068432: {
                return this.evaluateIn(scriptMathProcessor, sVArray);
            }
            case 1275072532: {
                return this.evaluateModulation(scriptMathProcessor, sVArray);
            }
            case 1275068443: {
                return this.evaluateReplace(scriptMathProcessor, sVArray);
            }
            case 0x8000404: 
            case 134218757: 
            case 1237320707: {
                return this.evaluateSubstructure(scriptMathProcessor, sVArray, n, t.tok == 0x100000D1);
            }
            case 1275068425: 
            case 1275068444: {
                return this.evaluateSort(scriptMathProcessor, sVArray, n);
            }
            case 1296041474: {
                return this.evaluateSymop(scriptMathProcessor, sVArray, t.tok == 0x100000D1);
            }
            case 1275068445: {
                return this.evaluateTensor(scriptMathProcessor, sVArray);
            }
            case 134217759: {
                return this.evaluateWithin(scriptMathProcessor, sVArray);
            }
            case 134221856: {
                return this.evaluateWrite(scriptMathProcessor, sVArray);
            }
        }
        return false;
    }

    private boolean evaluateUnitCell(ScriptMathProcessor scriptMathProcessor, SV[] sVArray) {
        String string;
        int n;
        boolean bl;
        int n2 = sVArray.length - 1;
        float f = 1.0f;
        switch (n2 < 0 ? 0 : sVArray[n2].tok) {
            case 2: 
            case 3: {
                f = sVArray[n2].asFloat();
                --n2;
            }
        }
        int n3 = n2 < 0 ? 0 : sVArray[0].tok;
        Lst<SV> lst = n3 == 7 ? sVArray[0].getList() : null;
        SymmetryInterface symmetryInterface = null;
        boolean bl2 = bl = lst != null;
        if (bl && lst.size() < 4) {
            return false;
        }
        int n4 = bl ? 1 : 0;
        T3[] t3Array = null;
        if (!bl && n3 != 8) {
            T3[] t3Array2;
            symmetryInterface = this.vwr.getCurrentUnitCell();
            if (symmetryInterface == null) {
                P3[] p3Array = new P3[4];
                p3Array[0] = P3.new3(0.0f, 0.0f, 0.0f);
                p3Array[1] = P3.new3(1.0f, 0.0f, 0.0f);
                p3Array[2] = P3.new3(0.0f, 1.0f, 0.0f);
                t3Array2 = p3Array;
                p3Array[3] = P3.new3(0.0f, 0.0f, 1.0f);
            } else {
                t3Array2 = t3Array = symmetryInterface.getUnitCellVectors();
            }
        }
        if (t3Array == null) {
            t3Array = new P3[4];
            if (bl) {
                t3Array[0] = P3.newP(SV.ptValue((SV)lst.get(0)));
                for (int i = 1; i < 4; ++i) {
                    t3Array[i] = P3.newP(SV.ptValue((SV)lst.get(i)));
                }
            } else {
                t3Array[0] = SV.ptValue(sVArray[0]);
                switch (n2) {
                    case 3: {
                        for (int i = 1; i < 4; ++i) {
                            t3Array[i] = P3.newP(SV.ptValue(sVArray[i]));
                            t3Array[i].sub(t3Array[0]);
                        }
                        break;
                    }
                    case 1: {
                        Lst<SV> lst2 = sVArray[1].getList();
                        if (lst2 != null && lst2.size() == 3) {
                            for (n = 0; n < 3; ++n) {
                                t3Array[n + 1] = SV.ptValue((SV)lst2.get(n));
                            }
                            break;
                        }
                    }
                    default: {
                        return false;
                    }
                }
            }
        }
        if ((n = "primitive".equalsIgnoreCase(string = n4 <= n2 ? sVArray[n4].asString() : null)) != 0 || "conventional".equalsIgnoreCase(string)) {
            if (!SimpleUnitCell.transformCubic(n != 0, sVArray[++n4].asString(), t3Array)) {
                return false;
            }
        } else if ("reciprocal".equalsIgnoreCase(string)) {
            t3Array = SimpleUnitCell.getReciprocal(t3Array);
        }
        if (f != 1.0f) {
            for (int i = 1; i < 4; ++i) {
                t3Array[i].scale(f);
            }
        }
        return scriptMathProcessor.addXObj(t3Array);
    }

    private boolean evaluateArray(ScriptMathProcessor scriptMathProcessor, SV[] sVArray, boolean bl) throws ScriptException {
        if (bl) {
            SV sV = scriptMathProcessor.getX();
            switch (sVArray.length == 1 ? sV.tok : 0) {
                case 6: {
                    int n;
                    Lst<SV> lst = new Lst<SV>();
                    String string = sVArray[0].asString();
                    Map<String, SV> map = sV.getMap();
                    String[] stringArray = sV.getKeys(false);
                    int n2 = stringArray.length;
                    for (n = 0; n < n2; ++n) {
                        if (map.get(stringArray[n]).getMap() != null) continue;
                        return false;
                    }
                    n2 = stringArray.length;
                    for (n = 0; n < n2; ++n) {
                        SV sV2 = map.get(stringArray[n]);
                        Map<String, SV> map2 = sV2.getMap();
                        Map map3 = (Map)SV.deepCopy(map2, true, false);
                        map3.put(string, SV.newS(stringArray[n]));
                        lst.addLast(SV.newV(6, map3));
                    }
                    return scriptMathProcessor.addXList(lst);
                }
                case 7: {
                    Map<String, SV> map;
                    int n;
                    Hashtable<String, SV> hashtable = new Hashtable<String, SV>();
                    Lst<SV> lst = sV.getList();
                    String string = sVArray[0].asString();
                    int n3 = lst.size();
                    for (n = 0; n < n3; ++n) {
                        map = ((SV)lst.get(n)).getMap();
                        if (map != null && map.get(string) != null) continue;
                        return false;
                    }
                    n3 = lst.size();
                    for (n = 0; n < n3; ++n) {
                        map = (SV)lst.get(n);
                        Map map4 = (Map)SV.deepCopy(((SV)((Object)map)).getMap(), true, false);
                        SV sV3 = (SV)map4.remove(string);
                        hashtable.put(sV3.asString(), SV.newV(6, map4));
                    }
                    return scriptMathProcessor.addXObj(hashtable);
                }
            }
            return false;
        }
        SV[] sVArray2 = new SV[sVArray.length];
        int n = sVArray2.length;
        while (--n >= 0) {
            sVArray2[n] = SV.newT(sVArray[n]);
        }
        return scriptMathProcessor.addXAV(sVArray2);
    }

    private boolean evaluateBin(ScriptMathProcessor scriptMathProcessor, SV[] sVArray) throws ScriptException {
        float[] fArray;
        boolean bl;
        if (sVArray.length != 3 && sVArray.length != 4) {
            return false;
        }
        SV sV = scriptMathProcessor.getX();
        boolean bl2 = bl = sV.tok == 13;
        if (!bl && sV.tok != 7) {
            return scriptMathProcessor.addX(sV);
        }
        float f = SV.fValue(sVArray[0]);
        float f2 = SV.fValue(sVArray[1]);
        float f3 = SV.fValue(sVArray[2]);
        String string = sVArray.length == 4 ? SV.sValue(sVArray[3]) : null;
        Map<K, V>[] mapArray = null;
        if (bl) {
            fArray = (float[])sV.value;
        } else {
            Lst<SV> lst = sV.getList();
            fArray = new float[lst.size()];
            if (string != null) {
                mapArray = AU.createArrayOfHashtable(lst.size());
            }
            try {
                int n = lst.size();
                while (--n >= 0) {
                    SV sV2;
                    if (string == null) {
                        sV2 = (SV)lst.get(n);
                    } else {
                        mapArray[n] = ((SV)lst.get(n)).getMap();
                        sV2 = mapArray[n].get(string);
                    }
                    fArray[n] = SV.fValue(sV2);
                }
            }
            catch (Exception exception) {
                return false;
            }
        }
        int n = Math.max((int)Math.floor((f2 - f) / f3 + 0.01f), 1);
        int[] nArray = new int[n];
        int n2 = fArray.length;
        for (int i = 0; i < n2; ++i) {
            Map<String, SV> map;
            float f4 = fArray[i];
            int n3 = (int)Math.floor((f4 - f) / f3);
            if (n3 < 0) {
                n3 = 0;
            } else if (n3 >= n) {
                n3 = n - 1;
            }
            int n4 = n3;
            nArray[n4] = nArray[n4] + 1;
            if (string == null || (map = mapArray[i]) == null) continue;
            map.put("_bin", SV.newI(n3));
            float f5 = f + f3 * (float)n3;
            float f6 = f5 + f3;
            map.put("_binMin", SV.newV(3, Float.valueOf(n3 == 0 ? -3.4028235E38f : f5)));
            map.put("_binMax", SV.newV(3, Float.valueOf(n3 == n - 1 ? Float.MAX_VALUE : f6)));
        }
        return scriptMathProcessor.addXAI(nArray);
    }

    private boolean evaluateCache(ScriptMathProcessor scriptMathProcessor, SV[] sVArray) {
        if (sVArray.length > 0) {
            return false;
        }
        return scriptMathProcessor.addXMap(this.vwr.fm.cacheList());
    }

    private boolean evaluateColor(ScriptMathProcessor scriptMathProcessor, SV[] sVArray) {
        Object object;
        boolean bl;
        ColorEncoder colorEncoder;
        String string = sVArray.length > 0 ? SV.sValue(sVArray[0]) : "";
        boolean bl2 = string.startsWith("$");
        if (sVArray.length == 2 && string.equalsIgnoreCase("TOHSL")) {
            return scriptMathProcessor.addXPt(CU.rgbToHSL(P3.newP(sVArray[1].tok == 8 ? SV.ptValue(sVArray[1]) : CU.colorPtFromString(sVArray[1].asString())), true));
        }
        if (sVArray.length == 2 && string.equalsIgnoreCase("TORGB")) {
            P3 p3 = P3.newP(sVArray[1].tok == 8 ? SV.ptValue(sVArray[1]) : CU.colorPtFromString(sVArray[1].asString()));
            return scriptMathProcessor.addXPt(sVArray[1].tok == 8 ? CU.hslToRGB(p3) : p3);
        }
        if (sVArray.length == 4 && (sVArray[3].tok == 1073742335 || sVArray[3].tok == 1073742334)) {
            boolean bl3;
            P3 p3 = P3.newP(sVArray[0].tok == 8 ? SV.ptValue(sVArray[0]) : CU.colorPtFromString(sVArray[0].asString()));
            P3 p32 = P3.newP(sVArray[1].tok == 8 ? SV.ptValue(sVArray[1]) : CU.colorPtFromString(sVArray[1].asString()));
            boolean bl4 = bl3 = sVArray[3].tok == 1073742335;
            if (bl3) {
                p3 = CU.rgbToHSL(p3, false);
                p32 = CU.rgbToHSL(p32, false);
            }
            SB sB = new SB();
            V3 v3 = V3.newVsub(p32, p3);
            int n = sVArray[2].asInt();
            if (n < 2) {
                n = 20;
            }
            v3.scale(1.0f / (float)(n - 1));
            for (int i = 0; i < n; ++i) {
                sB.append(Escape.escapeColor(CU.colorPtToFFRGB(bl3 ? CU.hslToRGB(p3) : p3)));
                p3.add(v3);
            }
            return scriptMathProcessor.addXStr(sB.toString());
        }
        ColorEncoder colorEncoder2 = colorEncoder = bl2 ? null : this.vwr.cm.getColorEncoder(string);
        if (!bl2 && colorEncoder == null) {
            return scriptMathProcessor.addXStr("");
        }
        float f = sVArray.length > 1 ? SV.fValue(sVArray[1]) : Float.MAX_VALUE;
        Object object2 = sVArray.length > 2 ? SV.fValue(sVArray[2]) : Float.MAX_VALUE;
        float f2 = sVArray.length > 3 ? SV.fValue(sVArray[3]) : Float.MAX_VALUE;
        boolean bl5 = f2 != Float.MAX_VALUE || f != Float.MAX_VALUE && object2 == Float.MAX_VALUE;
        boolean bl6 = bl = object2 != Float.MAX_VALUE;
        if (!bl && string.length() == 0) {
            f2 = f;
            object = this.vwr.getCurrentColorRange();
            f = (float)object[0];
            object2 = object[1];
        }
        if (bl2) {
            object = string.substring(1);
            Object[] objectArray = new Object[]{object, null};
            if (!this.vwr.shm.getShapePropertyData(24, "colorEncoder", objectArray)) {
                return scriptMathProcessor.addXStr("");
            }
            colorEncoder = (ColorEncoder)objectArray[1];
        } else {
            colorEncoder.setRange(f, (float)object2, f > object2);
        }
        object = colorEncoder.getColorKey();
        if (bl5) {
            return scriptMathProcessor.addXPt(CU.colorPtFromInt(colorEncoder.getArgb(object2 == Float.MAX_VALUE ? f : f2), null));
        }
        return scriptMathProcessor.addX(SV.getVariableMap(object));
    }

    private boolean evaluateCompare(ScriptMathProcessor scriptMathProcessor, SV[] sVArray) throws ScriptException {
        if (sVArray.length < 2 || sVArray.length > 5) {
            return false;
        }
        String string = SV.sValue(sVArray[sVArray.length - 1]);
        boolean bl = string.equalsIgnoreCase("stddev");
        boolean bl2 = string.equalsIgnoreCase("ISOMER");
        boolean bl3 = string.equalsIgnoreCase("BONDS");
        boolean bl4 = !bl2 && sVArray.length > (bl ? 3 : 2);
        BS bS = sVArray[0].tok == 10 ? (BS)sVArray[0].value : null;
        BS bS2 = sVArray[1].tok == 10 ? (BS)sVArray[1].value : null;
        String string2 = bS == null ? SV.sValue(sVArray[0]) : "";
        String string3 = bS2 == null ? SV.sValue(sVArray[1]) : "";
        M4 m4 = new M4();
        float f = Float.NaN;
        try {
            if (bl4 && (bS == null || bS2 == null)) {
                return false;
            }
            if (bl3) {
                if (sVArray.length != 4) {
                    return false;
                }
                string2 = SV.sValue(sVArray[2]);
                bl4 = string2.equalsIgnoreCase("SMILES");
                try {
                    if (bl4) {
                        string2 = this.vwr.getSmiles(bS);
                    }
                }
                catch (Exception exception) {
                    this.e.evalError(exception.getMessage(), null);
                }
                float[] fArray = this.e.getSmilesExt().getFlexFitList(bS, bS2, string2, !bl4);
                return fArray == null ? scriptMathProcessor.addXStr("") : scriptMathProcessor.addXAF(fArray);
            }
            if (bl2) {
                boolean bl5;
                String string4;
                if (sVArray.length != 3) {
                    return false;
                }
                if (bS == null && bS2 == null) {
                    return scriptMathProcessor.addXStr(this.vwr.getSmilesMatcher().getRelationship(string2, string3).toUpperCase());
                }
                String string5 = bS == null ? this.vwr.getSmilesMatcher().getMolecularFormula(string2, false) : JmolMolecule.getMolecularFormula(this.vwr.ms.at, bS, false, null, false);
                String string6 = string4 = bS2 == null ? this.vwr.getSmilesMatcher().getMolecularFormula(string3, false) : JmolMolecule.getMolecularFormula(this.vwr.ms.at, bS2, false, null, false);
                if (!string5.equals(string4)) {
                    return scriptMathProcessor.addXStr("NONE");
                }
                if (bS != null) {
                    string2 = (String)this.e.getSmilesExt().getSmilesMatches("", null, bS, null, 1, true, false);
                }
                if (bS2 == null) {
                    bl5 = this.vwr.getSmilesMatcher().areEqual(string3, string2) > 0;
                } else {
                    boolean bl6 = bl5 = ((BS)this.e.getSmilesExt().getSmilesMatches(string2, null, bS2, null, 1, true, false)).nextSetBit(0) >= 0;
                }
                if (!bl5) {
                    String string7 = string2 + string3;
                    if (string7.indexOf("/") >= 0 || string7.indexOf("\\") >= 0 || string7.indexOf("@") >= 0) {
                        if (string2.indexOf("@") >= 0 && (bS2 != null || string3.indexOf("@") >= 0)) {
                            string2 = "/invertstereo/" + string2;
                            if (bS2 == null) {
                                bl5 = this.vwr.getSmilesMatcher().areEqual(string2, string3) > 0;
                            } else {
                                boolean bl7 = bl5 = ((BS)this.e.getSmilesExt().getSmilesMatches(string2, null, bS2, null, 1, true, false)).nextSetBit(0) >= 0;
                            }
                            if (bl5) {
                                return scriptMathProcessor.addXStr("ENANTIOMERS");
                            }
                        }
                        if (bS2 == null) {
                            bl5 = this.vwr.getSmilesMatcher().areEqual("/nostereo/" + string3, string2) > 0;
                        } else {
                            Object object = this.e.getSmilesExt().getSmilesMatches("/nostereo/" + string2, null, bS2, null, 1, true, false);
                            boolean bl8 = bl5 = ((BS)object).nextSetBit(0) >= 0;
                        }
                        if (bl5) {
                            return scriptMathProcessor.addXStr("DIASTERIOMERS");
                        }
                    }
                    return scriptMathProcessor.addXStr("CONSTITUTIONAL ISOMERS");
                }
                if (bS == null || bS2 == null) {
                    return scriptMathProcessor.addXStr("IDENTICAL");
                }
                f = this.e.getSmilesExt().getSmilesCorrelation(bS, bS2, string2, null, null, null, null, false, null, null, false, 1);
                return scriptMathProcessor.addXStr(f < 0.2f ? "IDENTICAL" : "IDENTICAL or CONFORMATIONAL ISOMERS (RMSD=" + f + ")");
            }
            if (bl4) {
                boolean bl9;
                boolean bl10;
                Lst<P3> lst = new Lst<P3>();
                Lst<P3> lst2 = new Lst<P3>();
                string = SV.sValue(sVArray[2]);
                boolean bl11 = string.equalsIgnoreCase("MAP");
                bl4 = string.equalsIgnoreCase("SMILES");
                boolean bl12 = bl10 = bl11 || string.equalsIgnoreCase("SMARTS");
                if (bl4 || bl10) {
                    string = sVArray.length > (bl ? 4 : 3) ? SV.sValue(sVArray[3]) : null;
                }
                boolean bl13 = "H".equalsIgnoreCase(string) || "allH".equalsIgnoreCase(string) || "bestH".equalsIgnoreCase(string);
                boolean bl14 = "polyhedra".equalsIgnoreCase(string);
                if (bl14) {
                    string = sVArray.length > (bl ? 5 : 4) ? SV.sValue(sVArray[4]) : null;
                }
                boolean bl15 = "all".equalsIgnoreCase(string) || "allH".equalsIgnoreCase(string);
                boolean bl16 = bl9 = "best".equalsIgnoreCase(string) || "bestH".equalsIgnoreCase(string);
                if ("stddev".equals(string)) {
                    string = null;
                }
                String string8 = string;
                if (string == null || bl13 || bl15 || bl9) {
                    if (!bl11 && !bl4 || bl13 && bl14) {
                        return false;
                    }
                    string8 = "/noaromatic" + (bl15 || bl9 ? "/" : " nostereo/") + this.e.getSmilesExt().getSmilesMatches(bl13 ? "H" : "", null, bS, null, 1, true, false);
                } else {
                    bl15 = true;
                }
                f = this.e.getSmilesExt().getSmilesCorrelation(bS, bS2, string8, lst, lst2, m4, null, bl11, null, null, bl9, (bl4 ? 1 : 2) | (!bl15 && !bl9 ? 64 : 0));
                if (bl11) {
                    int n = lst.size();
                    if (n == 0) {
                        return scriptMathProcessor.addXStr("");
                    }
                    int n2 = lst2.size() / n;
                    Lst<int[][]> lst3 = new Lst<int[][]>();
                    int n3 = 0;
                    for (int i = 0; i < n2; ++i) {
                        int[][] nArray = AU.newInt2(n);
                        lst3.addLast(nArray);
                        int n4 = 0;
                        while (n4 < n) {
                            nArray[n4] = new int[]{((Atom)lst.get((int)n4)).i, ((Atom)lst2.get((int)n3)).i};
                            ++n4;
                            ++n3;
                        }
                    }
                    return bl15 ? scriptMathProcessor.addXList(lst3) : (lst3.size() > 0 ? scriptMathProcessor.addXAII((int[][])lst3.get(0)) : scriptMathProcessor.addXStr(""));
                }
            } else {
                switch (sVArray.length) {
                    case 2: {
                        break;
                    }
                    case 3: {
                        if (bl) break;
                    }
                    default: {
                        return false;
                    }
                }
                Lst<P3> lst = this.e.getPointVector(sVArray[0], 0);
                Lst<P3> lst4 = this.e.getPointVector(sVArray[1], 0);
                if (lst != null && lst4 != null) {
                    Interface.getInterface("javajs.util.Eigen", this.vwr, "script");
                    f = Measure.getTransformMatrix4(lst, lst4, m4, null);
                }
            }
            return bl || Float.isNaN(f) ? scriptMathProcessor.addXFloat(f) : scriptMathProcessor.addXM4(m4.round(1.0E-7f));
        }
        catch (Exception exception) {
            this.e.evalError(exception.getMessage() == null ? exception.toString() : exception.getMessage(), null);
            return false;
        }
    }

    private boolean evaluateConnected(ScriptMathProcessor scriptMathProcessor, SV[] sVArray, int n) throws ScriptException {
        boolean bl;
        boolean bl2 = bl = n == 1228931587;
        if (sVArray.length > 5 || bl && sVArray.length != 1) {
            return false;
        }
        float f = -2.1474836E9f;
        float f2 = 2.1474836E9f;
        float f3 = 0.0f;
        float f4 = Float.MAX_VALUE;
        int n2 = 65535;
        BS bS = null;
        BS bS2 = null;
        boolean bl3 = false;
        boolean bl4 = false;
        switch (n) {
            case 1275203608: {
                int n3 = Integer.MIN_VALUE;
                String string = null;
                if (sVArray.length > 0) {
                    switch (sVArray[0].tok) {
                        case 2: {
                            n3 = sVArray[0].intValue;
                            break;
                        }
                        case 4: {
                            string = SV.sValue(sVArray[0]);
                        }
                    }
                }
                Object[] objectArray = new Object[]{n3, string, null};
                this.vwr.shm.getShapePropertyData(21, "centers", objectArray);
                return scriptMathProcessor.addXBs(objectArray[2] == null ? new BS() : (BS)objectArray[2]);
            }
            case 1228931587: {
                SV sV = scriptMathProcessor.getX();
                if (sV.tok != 10) {
                    return false;
                }
                bS = SV.bsSelectVar(sV);
                bS2 = SV.bsSelectVar(sVArray[0]);
                Lst<Integer> lst = new Lst<Integer>();
                Atom[] atomArray = this.vwr.ms.at;
                int n4 = bS.nextSetBit(0);
                while (n4 >= 0) {
                    int n5 = 0;
                    Bond[] bondArray = atomArray[n4].bonds;
                    int n6 = bondArray.length;
                    while (--n6 >= 0) {
                        if (!bS2.get(bondArray[n6].getOtherAtom((Atom)atomArray[n4]).i)) continue;
                        ++n5;
                    }
                    lst.addLast(n5);
                    n4 = bS.nextSetBit(n4 + 1);
                }
                return scriptMathProcessor.addXList(lst);
            }
        }
        block15: for (int i = 0; i < sVArray.length; ++i) {
            SV sV = sVArray[i];
            switch (sV.tok) {
                case 10: {
                    bl4 = sV.value instanceof BondSet;
                    if (bl4 && bS != null) {
                        return false;
                    }
                    if (bS == null) {
                        bS = SV.bsSelectVar(sV);
                        continue block15;
                    }
                    if (bS2 == null) {
                        bS2 = SV.bsSelectVar(sV);
                        continue block15;
                    }
                    return false;
                }
                case 4: {
                    String string = SV.sValue(sV);
                    n2 = string.equalsIgnoreCase("hbond") ? 30720 : ScriptParam.getBondOrderFromString(string);
                    if (n2 != 131071) continue block15;
                    return false;
                }
                case 3: {
                    bl3 = true;
                }
                default: {
                    int n7 = sV.asInt();
                    float f5 = sV.asFloat();
                    if (f2 != 2.1474836E9f) {
                        return false;
                    }
                    if (f == -2.1474836E9f) {
                        f = Math.max(n7, 0);
                        f3 = f5;
                        continue block15;
                    }
                    f2 = n7;
                    f4 = f5;
                }
            }
        }
        if (f == -2.1474836E9f) {
            f = 1.0f;
            f2 = 100.0f;
            f3 = 0.1f;
            f4 = 1.0E8f;
        } else if (f2 == 2.1474836E9f) {
            f2 = f;
            f4 = f3;
            f3 = 0.1f;
        }
        if (bS == null) {
            bS = this.vwr.getAllAtoms();
        }
        if (bl3 && bS2 == null) {
            bS2 = bS;
        }
        if (bS2 != null) {
            BS bS3 = new BS();
            this.vwr.makeConnections(f3, f4, n2, 1086324745, bS, bS2, bS3, bl4, false, 0.0f);
            return scriptMathProcessor.addX(SV.newV(10, BondSet.newBS(bS3, this.vwr.ms.getAtomIndices(this.vwr.ms.getAtoms(1677721602, bS3)))));
        }
        return scriptMathProcessor.addXBs(this.vwr.ms.getAtomsConnected(f, f2, n2, bS));
    }

    private boolean evaluateContact(ScriptMathProcessor scriptMathProcessor, SV[] sVArray) {
        if (sVArray.length < 1 || sVArray.length > 3) {
            return false;
        }
        int n = 0;
        float f = 100.0f;
        int n2 = sVArray[0].tok;
        switch (n2) {
            case 2: 
            case 3: {
                f = SV.fValue(sVArray[n++]);
                break;
            }
            case 10: {
                break;
            }
            default: {
                return false;
            }
        }
        if (n == sVArray.length || !(sVArray[n].value instanceof BS)) {
            return false;
        }
        BS bS = BSUtil.copy(SV.bsSelectVar(sVArray[n++]));
        BS bS2 = n < sVArray.length ? BSUtil.copy(SV.bsSelectVar(sVArray[n])) : null;
        RadiusData radiusData = new RadiusData(null, f > 10.0f ? f / 100.0f : f, f > 10.0f ? RadiusData.EnumType.FACTOR : RadiusData.EnumType.OFFSET, VDW.AUTO);
        bS2 = this.setContactBitSets(bS, bS2, true, Float.NaN, radiusData, false);
        bS2.or(bS);
        return scriptMathProcessor.addXBs(bS2);
    }

    private boolean evaluateData(ScriptMathProcessor scriptMathProcessor, SV[] sVArray) {
        String string = SV.sValue(sVArray[0]);
        String string2 = "";
        switch (sVArray.length) {
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                if (sVArray[0].tok != 10) break;
                return scriptMathProcessor.addXStr(this.vwr.getModelFileData(string, SV.sValue(sVArray[1]), sVArray.length == 3 && SV.bValue(sVArray[2])));
            }
            case 4: {
                int n = sVArray[1].asInt();
                int n2 = sVArray[2].asInt();
                int n3 = sVArray[3].asInt();
                float[] fArray = Parser.parseFloatArrayFromMatchAndField(SV.sValue(sVArray[0]), null, 0, 0, null, n, n2, null, n3);
                return scriptMathProcessor.addXStr(Escape.escapeFloatA(fArray, false));
            }
            default: {
                return false;
            }
        }
        if (string.indexOf("data2d_") == 0) {
            float[][] fArray = (float[][])this.vwr.getDataObj(string, null, 2);
            if (fArray == null) {
                return scriptMathProcessor.addXStr("");
            }
            if (sVArray.length == 2 && sVArray[1].tok == 2) {
                int n = sVArray[1].intValue;
                if (n < 0) {
                    n += fArray.length;
                }
                if (n >= 0 && n < fArray.length) {
                    return scriptMathProcessor.addXStr(Escape.escapeFloatA(fArray[n], false));
                }
                return scriptMathProcessor.addXStr("");
            }
            return scriptMathProcessor.addXStr(Escape.escapeFloatAA(fArray, false));
        }
        if (string.indexOf("property_") == 0) {
            float[] fArray;
            float[] fArray2 = (float[])this.vwr.getDataObj(string, null, 1);
            if (fArray2 == null) {
                return scriptMathProcessor.addXStr("");
            }
            float[] fArray3 = fArray = string2.indexOf("property_") == 0 ? (float[])this.vwr.getDataObj(string, null, 1) : null;
            if (fArray != null) {
                fArray2 = AU.arrayCopyF(fArray2, -1);
                int n = Math.min(fArray2.length, fArray.length);
                while (--n >= 0) {
                    int n4 = n;
                    fArray2[n4] = fArray2[n4] + fArray[n];
                }
            }
            return scriptMathProcessor.addXStr(Escape.escapeFloatA(fArray2, false));
        }
        Object[] objectArray = (Object[])this.vwr.getDataObj(string, null, -1);
        return scriptMathProcessor.addXStr(objectArray == null ? "" : "" + objectArray[1]);
    }

    private boolean evaluateDotDist(ScriptMathProcessor scriptMathProcessor, SV[] sVArray, int n, int n2) throws ScriptException {
        float f;
        block33: {
            SV sV;
            SV sV2;
            boolean bl = n == 1275069443;
            SV sV3 = null;
            switch (sVArray.length) {
                case 2: {
                    if (n2 == Integer.MAX_VALUE) {
                        sV2 = sVArray[0];
                        sV = sVArray[1];
                        break;
                    }
                    sV3 = sVArray[1];
                }
                case 1: {
                    sV2 = scriptMathProcessor.getX();
                    sV = sVArray[0];
                    break;
                }
                default: {
                    return false;
                }
            }
            if (n == 1275069442) {
                P3 p3 = P3.newP(scriptMathProcessor.ptValue(sV2));
                p3.cross(p3, scriptMathProcessor.ptValue(sV));
                return scriptMathProcessor.addXPt(p3);
            }
            P3 p3 = sV.tok == 7 ? null : scriptMathProcessor.ptValue(sV);
            P4 p4 = scriptMathProcessor.planeValue(sV);
            if (bl) {
                int n3 = n2 == Integer.MIN_VALUE ? 0 : n2 & 0x1E0;
                boolean bl2 = n3 == 32 || n3 == 64;
                boolean bl3 = n3 == 480;
                switch (sV2.tok) {
                    case 10: {
                        BS bS = SV.bsSelectVar(sV2);
                        BS bS2 = null;
                        boolean bl4 = bl2 && sV3 != null && sV3.asBoolean();
                        switch (sV.tok) {
                            case 10: {
                                bS2 = sV.tok == 10 ? SV.bsSelectVar(sV) : null;
                            }
                            case 8: {
                                Atom[] atomArray = this.vwr.ms.at;
                                if (bl4) {
                                    float f2 = Float.NaN;
                                    int n4 = Integer.MAX_VALUE;
                                    int n5 = bS.nextSetBit(0);
                                    while (n5 >= 0) {
                                        float f3;
                                        float f4 = f3 = bS2 == null ? atomArray[n5].distanceSquared(p3) : ((Float)this.e.getBitsetProperty(bS2, n2, atomArray[n5], p4, sV2.value, null, false, sV2.index, false)).floatValue();
                                        if (!(n3 == 32 ? f3 >= f2 : f3 <= f2)) {
                                            f2 = f3;
                                            n4 = n5;
                                        }
                                        n5 = bS.nextSetBit(n5 + 1);
                                    }
                                    return scriptMathProcessor.addXBs(n4 == Integer.MAX_VALUE ? new BS() : BSUtil.newAndSetBit(n4));
                                }
                                if (bl3) {
                                    if (bS2 == null) {
                                        float[] fArray = new float[bS.cardinality()];
                                        int n6 = 0;
                                        int n7 = bS.nextSetBit(0);
                                        while (n7 >= 0) {
                                            fArray[n6] = atomArray[n7].distance(p3);
                                            n7 = bS.nextSetBit(n7 + 1);
                                            ++n6;
                                        }
                                        return scriptMathProcessor.addXAF(fArray);
                                    }
                                    float[][] fArray = new float[bS.cardinality()][bS2.cardinality()];
                                    int n8 = 0;
                                    int n9 = bS.nextSetBit(0);
                                    while (n9 >= 0) {
                                        int n10 = 0;
                                        int n11 = bS2.nextSetBit(0);
                                        while (n11 >= 0) {
                                            fArray[n8][n10] = atomArray[n9].distance(atomArray[n11]);
                                            n11 = bS2.nextSetBit(n11 + 1);
                                            ++n10;
                                        }
                                        n9 = bS.nextSetBit(n9 + 1);
                                        ++n8;
                                    }
                                    return scriptMathProcessor.addXAFF(fArray);
                                }
                                if (bl2) {
                                    float[] fArray = new float[bS.cardinality()];
                                    int n12 = bS.nextSetBit(0);
                                    int n13 = 0;
                                    while (n12 >= 0) {
                                        fArray[n13++] = ((Float)this.e.getBitsetProperty(bS2, n2, atomArray[n12], p4, sV2.value, null, false, sV2.index, false)).floatValue();
                                        n12 = bS.nextSetBit(n12 + 1);
                                    }
                                    return scriptMathProcessor.addXAF(fArray);
                                }
                                return scriptMathProcessor.addXObj(this.e.getBitsetProperty(bS, n2, p3, p4, sV2.value, null, false, sV2.index, false));
                            }
                        }
                    }
                }
            }
            P3 p32 = scriptMathProcessor.ptValue(sV2);
            P4 p42 = scriptMathProcessor.planeValue(sV2);
            f = Float.NaN;
            try {
                if (bl) {
                    if (p4 != null && sV3 != null) {
                        f = Measure.directedDistanceToPlane(p32, p4, SV.ptValue(sV3));
                        break block33;
                    }
                    f = p42 == null ? (p4 == null ? p3.distance(p32) : Measure.distanceToPlane(p4, p32)) : Measure.distanceToPlane(p42, p3);
                    break block33;
                }
                if (p42 != null && p4 != null) {
                    f = p42.x * p4.x + p42.y * p4.y + p42.z * p4.z + p42.w * p4.w;
                } else {
                    if (p42 != null) {
                        p32 = P3.new3(p42.x, p42.y, p42.z);
                    } else if (p4 != null) {
                        p3 = P3.new3(p4.x, p4.y, p4.z);
                    }
                    f = p32.dot(p3);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return scriptMathProcessor.addXFloat(f);
    }

    private boolean evaluateHelix(ScriptMathProcessor scriptMathProcessor, SV[] sVArray) throws ScriptException {
        if (sVArray.length < 1 || sVArray.length > 5) {
            return false;
        }
        int n = sVArray.length > 2 ? 3 : 1;
        String string = n >= sVArray.length ? "array" : SV.sValue(sVArray[n]);
        int n2 = T.getTokFromName(string);
        if (sVArray.length > 2) {
            P3 p3 = scriptMathProcessor.ptValue(sVArray[0]);
            P3 p32 = scriptMathProcessor.ptValue(sVArray[1]);
            if (n2 == 0 || sVArray[2].tok != 9 || p3 == null || p32 == null) {
                return false;
            }
            Quat quat = Quat.newP4((P4)sVArray[2].value);
            T3[] t3Array = Measure.computeHelicalAxis(p3, p32, quat);
            return t3Array == null ? false : scriptMathProcessor.addXObj(Escape.escapeHelical(string, n2, p3, p32, t3Array));
        }
        BS bS = sVArray[0].value instanceof BS ? (BS)sVArray[0].value : this.vwr.ms.getAtoms(1094715412, new Integer(sVArray[0].asInt()));
        switch (n2) {
            case 134217751: {
                return scriptMathProcessor.addXObj(this.getHelixData(bS, 134217751));
            }
            case 1073741854: {
                return scriptMathProcessor.addXObj(this.getHelixData(bS, 1073741854));
            }
            case 1665140738: {
                return scriptMathProcessor.addXObj(this.getHelixData(bS, 1665140738));
            }
            case 0x8000001: {
                return scriptMathProcessor.addXFloat(((Float)this.getHelixData(bS, 0x8000001)).floatValue());
            }
            case 135176: 
            case 1745489939: {
                return scriptMathProcessor.addXObj(this.getHelixData(bS, n2));
            }
            case 1275068418: {
                String[] stringArray = (String[])this.getHelixData(bS, 1073742001);
                if (stringArray == null) {
                    return false;
                }
                return scriptMathProcessor.addXAS(stringArray);
            }
        }
        return false;
    }

    private Object getHelixData(BS bS, int n) {
        int n2 = bS.nextSetBit(0);
        return n2 < 0 ? "null" : this.vwr.ms.at[n2].group.getHelixData(n, this.vwr.getQuaternionFrame(), this.vwr.getInt(0x21000012));
    }

    private boolean evaluateFind(ScriptMathProcessor scriptMathProcessor, SV[] sVArray) throws ScriptException {
        boolean bl;
        boolean bl2;
        String string;
        String string2;
        boolean bl3;
        boolean bl4;
        SV sV;
        block42: {
            sV = scriptMathProcessor.getX();
            bl4 = sV.tok == 7;
            bl3 = sVArray.length == 0;
            string2 = bl3 ? "" : SV.sValue(sVArray[0]);
            string = sVArray.length > 1 && sVArray[1].tok != 1073742335 && sVArray[1].tok != 1073742334 ? SV.sValue(sVArray[1]) : "";
            bl2 = !bl4 && string2.equalsIgnoreCase("SEQUENCE");
            boolean bl5 = !bl4 && string2.equalsIgnoreCase("SEQ");
            boolean bl6 = !bl4 && string2.equalsIgnoreCase("SMILES");
            boolean bl7 = !bl4 && string2.equalsIgnoreCase("SMARTS");
            boolean bl8 = !bl4 && string2.equalsIgnoreCase("CHEMICAL");
            boolean bl9 = !bl4 && string2.equalsIgnoreCase("MF");
            boolean bl10 = !bl4 && string2.equalsIgnoreCase("CELLFORMULA");
            SV sV2 = sVArray.length > 0 ? sVArray[sVArray.length - 1] : SV.vF;
            boolean bl11 = !bl4 && sV2.tok == 1073742335;
            try {
                if (bl8) {
                    String string3;
                    String string4 = string3 = sV.tok == 10 ? this.vwr.getSmiles(SV.getBitSet(sV, false)) : SV.sValue(sV);
                    String string5 = string3.length() == 0 ? "" : (string3 = this.vwr.getChemicalInfo(string3, sVArray.length > 1 ? T.getTokenFromName(string.toLowerCase()) : null));
                    if (string3.endsWith("\n")) {
                        string3 = string3.substring(0, string3.length() - 1);
                    }
                    if (string3.startsWith("InChI")) {
                        string3 = PT.rep(PT.rep(string3, "InChI=", ""), "InChIKey=", "");
                    }
                    return scriptMathProcessor.addXStr(string3);
                }
                if (!bl6 && !bl7 && sV.tok != 10) break block42;
                int n = bl6 || bl7 ? 2 : 1;
                BS bS = n < sVArray.length && sVArray[n].tok == 10 ? (BS)sVArray[n++].value : null;
                boolean bl12 = "bonds".equalsIgnoreCase(SV.sValue(sVArray[sVArray.length - 1]));
                boolean bl13 = bl12 || bl11;
                Object object = null;
                switch (sV.tok) {
                    case 4: {
                        String string6 = SV.sValue(sV);
                        if (bS != null || bl6 && sVArray.length == 1) {
                            return false;
                        }
                        if (string.equalsIgnoreCase("mf")) {
                            object = this.vwr.getSmilesMatcher().getMolecularFormula(string6, bl7);
                            break;
                        }
                        String string7 = string;
                        boolean bl14 = true;
                        boolean bl15 = false;
                        switch (sVArray.length) {
                            case 4: {
                                bl14 = SV.bValue(sVArray[3]);
                            }
                            case 3: {
                                bl15 = SV.bValue(sVArray[2]);
                            }
                        }
                        try {
                            object = this.e.getSmilesExt().getSmilesMatches(string7, string6, null, null, bl7 ? 2 : 1, !bl15, !bl14);
                        }
                        catch (Exception exception) {
                            return scriptMathProcessor.addXInt(-1);
                        }
                        if (bl15 || bl14 && bl7) break;
                        int n2 = ((int[])object).length;
                        return scriptMathProcessor.addXInt(!bl14 && n2 > 0 ? 1 : n2);
                    }
                    case 10: {
                        if (bl9 && string.length() != 0) {
                            return scriptMathProcessor.addXBs(JmolMolecule.getBitSetForMF(this.vwr.ms.at, (BS)sV.value, string));
                        }
                        if (bl9 || bl10) {
                            return scriptMathProcessor.addXStr(JmolMolecule.getMolecularFormula(this.vwr.ms.at, (BS)sV.value, false, bl9 ? null : this.vwr.ms.getCellWeights((BS)sV.value), bl11));
                        }
                        if (bl2 || bl5) {
                            boolean bl16 = sV2.asString().equalsIgnoreCase("H");
                            return scriptMathProcessor.addXStr(this.vwr.getSmilesOpt((BS)sV.value, -1, -1, ((bl13 |= bl16) ? 0x13000 | (bl16 ? 90112 : 0) : 0) | (bl5 ? 327680 : 65536)));
                        }
                        if (bl6 || bl7) {
                            string2 = sVArray.length > 1 && sVArray[1].tok == 10 ? this.vwr.getSmilesOpt((BS)sVArray[1].value, 0, 0, 0) : string;
                        }
                        BS bS2 = bS;
                        if (bl12) {
                            int[][] nArray = this.vwr.getSmilesMatcher().getCorrelationMaps(string2, this.vwr.ms.at, this.vwr.ms.ac, (BS)sV.value, (bl6 ? 1 : 2) | 0x40);
                            object = nArray.length > 0 ? (Object)this.vwr.ms.getDihedralMap(nArray[0]) : new int[]{};
                            break;
                        }
                        int n3 = (bl6 ? 1 : 2) | (bl11 && string2.length() == 0 ? 204800 : 0);
                        object = this.e.getSmilesExt().getSmilesMatches(string2, null, (BS)sV.value, bS2, n3, !bl11, false);
                    }
                }
                if (object == null) {
                    this.e.invArg();
                }
                return scriptMathProcessor.addXObj(object);
            }
            catch (Exception exception) {
                this.e.evalError(exception.getMessage(), null);
            }
        }
        boolean bl17 = string.indexOf("v") >= 0;
        boolean bl18 = string.indexOf("i") >= 0;
        boolean bl19 = string.indexOf("m") >= 0;
        boolean bl20 = bl = sVArray.length == 2;
        if (bl4 || bl) {
            int n;
            int n4;
            Lst<SV> lst;
            JmolPatternMatcher jmolPatternMatcher = this.getPatternMatcher();
            Pattern pattern = null;
            String[] stringArray = null;
            Lst<SV> lst2 = lst = bl4 ? sV.getList() : null;
            if (string2.length() > 0) {
                try {
                    pattern = string2.length() == 0 ? null : jmolPatternMatcher.compile(string2, bl18);
                    stringArray = SV.strListValue(sV);
                }
                catch (Exception exception) {
                    this.e.evalError(exception.toString(), null);
                }
            }
            int n5 = n4 = stringArray == null ? lst.size() : stringArray.length;
            if (Logger.debugging) {
                Logger.debug("finding " + string2);
            }
            BS bS = new BS();
            int n6 = 0;
            Matcher matcher = null;
            Lst<String> lst3 = bl19 ? new Lst<String>() : null;
            String string8 = "";
            for (int i = 0; i < n4; ++i) {
                if (pattern == null) {
                    SV sV3 = (SV)lst.get(i);
                    switch (sV3.tok) {
                        case 6: {
                            n = sV3.getMap().isEmpty() != bl3 ? 1 : 0;
                            break;
                        }
                        case 7: {
                            n = sV3.getList().size() == 0 != bl3 ? 1 : 0;
                            break;
                        }
                        case 4: {
                            n = sV3.asString().length() == 0 != bl3 ? 1 : 0;
                            break;
                        }
                        default: {
                            n = 1;
                            break;
                        }
                    }
                } else {
                    string8 = stringArray[i];
                    matcher = pattern.matcher(string8);
                    n = matcher.find() ? 1 : 0;
                }
                if ((!bl19 || n == 0) && (bl19 || n != (!bl17 ? 1 : 0))) continue;
                ++n6;
                bS.set(i);
                if (!bl19) continue;
                lst3.addLast(bl17 ? string8.substring(0, matcher.start()) + string8.substring(matcher.end()) : matcher.group());
            }
            if (!bl4) {
                return bl19 ? scriptMathProcessor.addXStr(lst3.size() == 1 ? (String)lst3.get(0) : "") : (bl17 ? scriptMathProcessor.addXBool(n6 == 1) : (bl19 ? scriptMathProcessor.addXStr(n6 == 0 ? "" : matcher.group()) : scriptMathProcessor.addXInt(n6 == 0 ? 0 : matcher.start() + 1)));
            }
            if (bl19) {
                String[] stringArray2 = new String[n6];
                if (n6 > 0) {
                    n = stringArray.length;
                    while (--n >= 0) {
                        if (!bS.get(n)) continue;
                        String string9 = bl19 ? (String)lst3.get(--n6) : stringArray[n];
                        stringArray2[n6] = string9;
                    }
                }
                return scriptMathProcessor.addXAS(stringArray2);
            }
            Lst lst4 = new Lst();
            n = bS.nextSetBit(0);
            while (n >= 0) {
                lst4.addLast(lst.get(n));
                n = bS.nextSetBit(n + 1);
            }
            return scriptMathProcessor.addXList(lst4);
        }
        if (bl2) {
            return scriptMathProcessor.addXStr(this.vwr.getJBR().toStdAmino3(SV.sValue(sV)));
        }
        return scriptMathProcessor.addXInt(SV.sValue(sV).indexOf(string2) + 1);
    }

    private boolean evaluateGetProperty(ScriptMathProcessor scriptMathProcessor, SV[] sVArray, int n, boolean bl) throws ScriptException {
        int n2;
        Object object;
        int n3;
        boolean bl2 = bl && n == 1275082245;
        boolean bl3 = n == 1275068449;
        int n4 = 0;
        int n5 = n3 = sVArray.length == 0 ? 0 : sVArray[0].tok;
        if (sVArray.length == 2 && (n3 == 7 || n3 == 6 || n3 == 14)) {
            return scriptMathProcessor.addXObj(this.vwr.extractProperty(sVArray[0].value, sVArray[1].value.toString(), -1));
        }
        String string = sVArray.length > 0 ? SV.sValue(sVArray[n4++]) : "";
        String string2 = string.toLowerCase();
        if (!bl2 && string2.indexOf("[select ") < 0) {
            string = string2;
        }
        boolean bl4 = false;
        if (string.equals("json") && sVArray.length > n4) {
            bl4 = true;
            string = SV.sValue(sVArray[n4++]);
        }
        SV sV = null;
        if (bl) {
            sV = scriptMathProcessor.getX();
            if (sV.tok != 10) {
                if (bl2) {
                    string = "[SELECT " + string + "]";
                }
                return scriptMathProcessor.addXObj(this.vwr.extractProperty(sV, string, -1));
            }
        }
        if (bl && !string2.startsWith("bondinfo") && !string2.startsWith("atominfo")) {
            string = "atomInfo." + string;
        }
        BS[] bSArray = "";
        if (string.equalsIgnoreCase("fileContents") && sVArray.length > 2) {
            object = SV.sValue(sVArray[1]);
            for (n2 = 2; n2 < sVArray.length; ++n2) {
                object = (String)object + "|" + SV.sValue(sVArray[n2]);
            }
            bSArray = object;
            n4 = sVArray.length;
        } else if (sVArray.length > n4) {
            switch (sVArray[n4].tok) {
                case 10: {
                    bSArray = SV.bsSelectVar(sVArray[n4++]);
                    if (!string.equalsIgnoreCase("bondInfo") || sVArray.length <= n4 || sVArray[n4].tok != 10) break;
                    bSArray = new BS[]{(BS)bSArray, SV.bsSelectVar(sVArray[n4])};
                    break;
                }
                case 4: 
                case 6: {
                    if (!this.vwr.checkPropertyParameter(string)) break;
                    bSArray = sVArray[n4++].value;
                }
            }
        }
        if (bl) {
            object = SV.bsSelectVar(sV);
            n2 = ((BS)object).nextSetBit(0);
            if (n2 < 0) {
                return scriptMathProcessor.addXStr("");
            }
            bSArray = object;
        }
        if (bl3 && !bl) {
            string = "auxiliaryInfo.models." + string;
        }
        string = PT.rep(string, ".[", "[");
        object = this.vwr.getProperty(null, string, bSArray);
        if (n4 < sVArray.length) {
            object = this.vwr.extractProperty(object, sVArray, n4);
        }
        return scriptMathProcessor.addXObj(bl4 ? "{" + PT.toJSON("value", object) + "}" : (SV.isVariableType(object) ? object : Escape.toReadable(string, object)));
    }

    private boolean evaluateFormat(ScriptMathProcessor scriptMathProcessor, int n, SV[] sVArray, boolean bl) throws ScriptException {
        Lst<SV> lst;
        Cloneable cloneable;
        String string;
        SV sV;
        SV sV2 = sV = sVArray.length < 2 || n == 1287653388 ? scriptMathProcessor.getX() : null;
        String string2 = sVArray.length == 0 ? "%U" : (string = sVArray[0].tok == 7 ? null : SV.sValue(sVArray[0]));
        if (!bl && sVArray.length > 0 && sV != null && sV.tok != 10 && string != null) {
            if (sVArray.length == 2) {
                cloneable = sV.getList();
                lst = sVArray[1].getList();
                if (cloneable == null || lst == null) {
                    return false;
                }
                sV = SV.getVariableList(this.getSublist((Lst<SV>)cloneable, lst));
            }
            sVArray = new SV[]{sVArray[0], sV};
            sV = null;
        }
        if (sV == null) {
            int n2;
            int n3 = n2 = bl ? -1 : SV.getFormatType(string);
            if (n2 >= 0 && sVArray.length != 2) {
                return false;
            }
            if (n2 >= 0 || sVArray.length < 2 || sVArray[1].tok != 7) {
                lst = SV.format(sVArray, n2, false);
                return string.equalsIgnoreCase("json") ? scriptMathProcessor.addXStr((String)((Object)lst)) : scriptMathProcessor.addXObj(lst);
            }
            lst = sVArray[1].getList();
            SV[] sVArray2 = new SV[]{sVArray[0], null};
            String[] stringArray = new String[lst.size()];
            int n4 = stringArray.length;
            while (--n4 >= 0) {
                sVArray2[1] = (SV)lst.get(n4);
                stringArray[n4] = SV.format(sVArray2, n2, true).toString();
            }
            return scriptMathProcessor.addXAS(stringArray);
        }
        if (sV.tok == 7 && string == null) {
            cloneable = sV.getList();
            lst = sVArray[0].getList();
            Lst<SV> lst2 = this.getSublist((Lst<SV>)cloneable, lst);
            return scriptMathProcessor.addXList(lst2);
        }
        cloneable = SV.getBitSet(sV, true);
        boolean bl2 = T.tokAttr(n, 480);
        return scriptMathProcessor.addXObj(string == null ? "" : (cloneable == null ? SV.sprintf(PT.formatCheck(string), sV) : this.e.getCmdExt().getBitsetIdent((BS)cloneable, string, sV.value, true, sV.index, bl2)));
    }

    private Lst<SV> getSublist(Lst<SV> lst, Lst<SV> lst2) {
        Lst<SV> lst3 = new Lst<SV>();
        int n = lst.size();
        block4: for (int i = 0; i < n; ++i) {
            SV sV = (SV)lst.get(i);
            switch (sV.tok) {
                case 6: {
                    int n2;
                    Map<String, SV> map = sV.getMap();
                    Lst<Object> lst4 = new Lst();
                    int n3 = lst2.size();
                    for (n2 = 0; n2 < n3; ++n2) {
                        SV sV2 = map.get(SV.sValue((T)lst2.get(n2)));
                        lst4.addLast(sV2 == null ? SV.newS("") : sV2);
                    }
                    lst3.addLast(SV.getVariableList(lst4));
                    continue block4;
                }
                case 7: {
                    int n2;
                    Map<String, SV> map = new Hashtable<String, SV>();
                    Lst<Object> lst4 = sV.getList();
                    int n3 = Math.min(lst4.size(), lst2.size());
                    for (n2 = 0; n2 < n3; ++n2) {
                        map.put(SV.sValue((T)lst2.get(n2)), (SV)lst4.get(n2));
                    }
                    lst3.addLast(SV.getVariable(map));
                }
            }
        }
        return lst3;
    }

    private boolean evaluateList(ScriptMathProcessor scriptMathProcessor, int n, SV[] sVArray) throws ScriptException {
        boolean bl;
        int n2 = sVArray.length;
        SV sV = scriptMathProcessor.getX();
        boolean bl2 = sV.tok == 7;
        switch (n) {
            case 1275335685: {
                return n2 == 2 && scriptMathProcessor.addX(sV.pushPop(sVArray[1], sVArray[0])) || n2 == 1 && scriptMathProcessor.addX(sV.pushPop(sVArray[0], null));
            }
            case 1275334681: {
                return n2 == 1 && scriptMathProcessor.addX(sV.pushPop(null, sVArray[0])) || n2 == 0 && scriptMathProcessor.addX(sV.pushPop(null, null));
            }
            case 1275069441: {
                if (n2 == 1 || n2 == 2) break;
                return false;
            }
            case 1275069446: 
            case 1275069447: {
                break;
            }
            default: {
                if (n2 == 1) break;
                return false;
            }
        }
        String[] stringArray = null;
        String[] stringArray2 = null;
        String[] stringArray3 = null;
        if (n2 == 2) {
            boolean bl3;
            String string = SV.sValue(sVArray[0]);
            SV sV2 = sVArray[1];
            if (n == 1275069441) {
                stringArray = bl2 ? SV.strListValue(sV) : PT.split(SV.sValue(sV), "\n");
                stringArray2 = sV2.tok == 7 ? SV.strListValue(sV2) : PT.split(SV.sValue(sV2), "\n");
                n2 = Math.max(stringArray.length, stringArray2.length);
                stringArray3 = new String[n2];
                for (int i = 0; i < n2; ++i) {
                    stringArray3[i] = (i >= stringArray.length ? "" : stringArray[i]) + string + (i >= stringArray2.length ? "" : stringArray2[i]);
                }
                return scriptMathProcessor.addXAS(stringArray3);
            }
            if (sV2.tok != 1073742335) {
                return false;
            }
            Lst<SV> lst = sV.getList();
            boolean bl4 = bl3 = string.length() == 0;
            if (bl3) {
                string = ",";
            }
            if (n == 1275069446) {
                SV[] sVArray2 = new SV[lst.size()];
                int n3 = lst.size();
                while (--n3 >= 0) {
                    Lst<SV> lst2 = ((SV)lst.get(n3)).getList();
                    if (lst2 == null) {
                        sVArray2[n3] = (SV)lst.get(n3);
                        continue;
                    }
                    SB sB = new SB();
                    int n4 = lst2.size();
                    for (int i = 0; i < n4; ++i) {
                        if (i > 0) {
                            sB.append(string);
                        }
                        SV sV3 = (SV)lst2.get(i);
                        sB.append(bl3 && sV3.tok == 4 ? "\"" + PT.rep((String)sV3.value, "\"", "\"\"") + "\"" : "" + sV3.asString());
                    }
                    sVArray2[n3] = SV.newS(sB.toString());
                }
                return scriptMathProcessor.addXAV(sVArray2);
            }
            Lst<SV> lst3 = new Lst<SV>();
            if (bl3) {
                string = "\u0000";
            }
            int[] nArray = new int[2];
            int n5 = lst.size();
            for (int i = 0; i < n5; ++i) {
                Object object;
                String string2 = ((SV)lst.get(i)).asString();
                if (bl3) {
                    nArray[1] = 0;
                    nArray[0] = 0;
                    int n6 = 0;
                    while (true) {
                        if ((object = PT.getCSVString(string2, nArray)) == null) {
                            if (nArray[1] == -1) {
                                string2 = string2 + (++i < n5 ? "\n" + ((SV)lst.get(i)).asString() : "\"");
                                nArray[1] = n6;
                                continue;
                            }
                            string2 = string2.substring(0, n6) + string2.substring(n6).replace(',', '\u0000');
                            break;
                        }
                        string2 = string2.substring(0, n6) + string2.substring(n6, nArray[0]).replace(',', '\u0000') + (String)object + string2.substring(nArray[1]);
                        nArray[1] = n6 = nArray[0] + ((String)object).length();
                    }
                }
                String[] stringArray4 = string2.split(string);
                object = new Lst();
                for (String string3 : stringArray4) {
                    if (string3.indexOf(".") < 0) {
                        try {
                            ((Lst)object).addLast(SV.newI(Integer.parseInt(string3)));
                            continue;
                        }
                        catch (Exception exception) {
                        }
                    } else {
                        try {
                            ((Lst)object).addLast(SV.getVariable(Float.valueOf(Float.parseFloat(string3))));
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    ((Lst)object).addLast(SV.newS(string3));
                }
                lst3.addLast(SV.getVariableList(object));
            }
            return scriptMathProcessor.addXObj(SV.getVariableList(lst3));
        }
        SV sV4 = n2 == 0 ? SV.newV(1073742327, "all") : sVArray[0];
        boolean bl5 = bl = sV4.tok == 1073742327;
        if (!bl2 && sV.tok != 4) {
            return scriptMathProcessor.binaryOp(this.opTokenFor(n), sV, sV4);
        }
        boolean bl6 = SV.isScalar(sV);
        boolean bl7 = SV.isScalar(sV4);
        float[] fArray = null;
        float[] fArray2 = null;
        Lst<SV> lst = sV.getList();
        Lst<SV> lst4 = sV4.getList();
        if (bl2) {
            n2 = lst.size();
        } else if (bl6) {
            n2 = Integer.MAX_VALUE;
        } else {
            stringArray = PT.split(SV.sValue(sV), "\n");
            n2 = stringArray.length;
            fArray = new float[n2];
            PT.parseFloatArrayData(stringArray, fArray);
        }
        if (bl && n != 1275069446) {
            float f = 0.0f;
            if (bl2) {
                int n7 = n2;
                while (--n7 >= 0) {
                    f += SV.fValue((T)lst.get(n7));
                }
            } else if (!bl6) {
                int n8 = n2;
                while (--n8 >= 0) {
                    f += fArray[n8];
                }
            }
            return scriptMathProcessor.addXFloat(f);
        }
        if (n == 1275069446 && sV4.tok == 4) {
            SB sB = new SB();
            if (bl6) {
                sB.append(SV.sValue(sV));
            } else {
                String string = bl ? "" : sV4.value.toString();
                for (int i = 0; i < n2; ++i) {
                    sB.append(i > 0 ? string : "").append(SV.sValue((T)lst.get(i)));
                }
            }
            return scriptMathProcessor.addXStr(sB.toString());
        }
        SV sV5 = null;
        if (bl7) {
            sV5 = sV4;
        } else if (sV4.tok == 7) {
            n2 = Math.min(n2, lst4.size());
        } else {
            stringArray2 = PT.split(SV.sValue(sV4), "\n");
            fArray2 = new float[stringArray2.length];
            PT.parseFloatArrayData(stringArray2, fArray2);
            n2 = Math.min(n2, fArray2.length);
        }
        T t = this.opTokenFor(n);
        SV[] sVArray3 = new SV[n2];
        if (bl2 && bl) {
            Lst<SV> lst5 = new Lst<SV>();
            return scriptMathProcessor.addXList(this.addAllLists(sV.getList(), lst5));
        }
        SV sV6 = bl6 ? sV : null;
        for (int i = 0; i < n2; ++i) {
            SV sV7 = bl7 ? sV5 : (sV4.tok == 7 ? (SV)lst4.get(i) : (Float.isNaN(fArray2[i]) ? SV.getVariable(SV.unescapePointOrBitsetAsVariable(stringArray2[i])) : SV.newV(3, Float.valueOf(fArray2[i]))));
            if (!bl6) {
                sV6 = bl2 ? (SV)lst.get(i) : (Float.isNaN(fArray[i]) ? SV.getVariable(SV.unescapePointOrBitsetAsVariable(stringArray[i])) : SV.newV(3, Float.valueOf(fArray[i])));
            }
            if (n == 1275069446 && sV6.tok != 7) {
                Lst<SV> lst6 = new Lst<SV>();
                lst6.addLast(sV6);
                sV6 = SV.getVariableList(lst6);
            }
            if (!scriptMathProcessor.binaryOp(t, sV6, sV7)) {
                return false;
            }
            sVArray3[i] = scriptMathProcessor.getX();
        }
        return scriptMathProcessor.addXAV(sVArray3);
    }

    private Lst<SV> addAllLists(Lst<SV> lst, Lst<SV> lst2) {
        int n = lst.size();
        for (int i = 0; i < n; ++i) {
            SV sV = (SV)lst.get(i);
            if (sV.tok == 7) {
                this.addAllLists(sV.getList(), lst2);
                continue;
            }
            lst2.addLast(sV);
        }
        return lst2;
    }

    private boolean evaluateLoad(ScriptMathProcessor scriptMathProcessor, SV[] sVArray, boolean bl) throws ScriptException {
        String string;
        int n = -1;
        boolean bl2 = false;
        boolean bl3 = this.vwr.async;
        switch (sVArray.length) {
            case 3: {
                bl3 = SV.bValue(sVArray[2]);
            }
            case 2: {
                n = sVArray[1].tok == 2 ? sVArray[1].asInt() : -1;
                bl2 = sVArray[1].tok == 1073742335;
            }
            case 1: {
                string = SV.sValue(sVArray[0]);
                string = string.replace('\\', '/');
                break;
            }
            default: {
                return false;
            }
        }
        if (bl2) {
            return scriptMathProcessor.addXMap(this.vwr.fm.getFileAsMap(string));
        }
        boolean bl4 = string.startsWith("?");
        if (this.vwr.isJS && (bl4 || bl3)) {
            if (bl && bl4) {
                return scriptMathProcessor.addXStr("");
            }
            string = this.e.loadFileAsync("load()_", string, scriptMathProcessor.oPt, true);
        }
        return scriptMathProcessor.addXStr(bl ? this.vwr.fm.getFilePath(string, false, false) : this.vwr.getFileAsString4(string, n, false, false, true, "script"));
    }

    private boolean evaluateMath(ScriptMathProcessor scriptMathProcessor, SV[] sVArray, int n) {
        if (n == 134217749) {
            if (sVArray.length == 1 && sVArray[0].tok == 4) {
                return scriptMathProcessor.addXStr(new Date() + "\t" + SV.sValue(sVArray[0]));
            }
            return scriptMathProcessor.addXInt(((int)System.currentTimeMillis() & Integer.MAX_VALUE) - (sVArray.length == 0 ? 0 : sVArray[0].asInt()));
        }
        if (sVArray.length != 1) {
            return false;
        }
        if (n == 134218250) {
            if (sVArray[0].tok == 2) {
                return scriptMathProcessor.addXInt(Math.abs(sVArray[0].asInt()));
            }
            return scriptMathProcessor.addXFloat(Math.abs(sVArray[0].asFloat()));
        }
        double d = SV.fValue(sVArray[0]);
        switch (n) {
            case 0x8000202: {
                return scriptMathProcessor.addXFloat((float)(Math.acos(d) * 180.0 / Math.PI));
            }
            case 134218245: {
                return scriptMathProcessor.addXFloat((float)Math.cos(d * Math.PI / 180.0));
            }
            case 134218244: {
                return scriptMathProcessor.addXFloat((float)Math.sin(d * Math.PI / 180.0));
            }
            case 134218246: {
                return scriptMathProcessor.addXFloat((float)Math.sqrt(d));
            }
        }
        return false;
    }

    private boolean evaluateMeasure(ScriptMathProcessor scriptMathProcessor, SV[] sVArray, int n) throws ScriptException {
        int n2 = 0;
        switch (n) {
            case 1745489939: {
                Lst<Object> lst = new Lst<Object>();
                float[] fArray = new float[]{Float.MAX_VALUE, Float.MAX_VALUE};
                String string = null;
                String string2 = null;
                boolean bl = false;
                boolean bl2 = false;
                int n3 = 0;
                boolean bl3 = false;
                RadiusData radiusData = null;
                int n4 = 0;
                float f = Float.MAX_VALUE;
                boolean bl4 = false;
                boolean bl5 = false;
                block15: for (int i = 0; i < sVArray.length; ++i) {
                    switch (sVArray[i].tok) {
                        case 10: {
                            BS bS = (BS)sVArray[i].value;
                            if (bS.length() == 0) {
                                bl3 = true;
                            }
                            lst.addLast(bS);
                            ++n2;
                            ++n4;
                            continue block15;
                        }
                        case 8: {
                            Point3fi point3fi = new Point3fi();
                            point3fi.setT((P3)sVArray[i].value);
                            lst.addLast(point3fi);
                            ++n2;
                            continue block15;
                        }
                        case 2: 
                        case 3: {
                            fArray[n3++ % 2] = SV.fValue(sVArray[i]);
                            continue block15;
                        }
                        case 4: {
                            String string3 = SV.sValue(sVArray[i]);
                            if (string3.equalsIgnoreCase("vdw") || string3.equalsIgnoreCase("vanderwaals")) {
                                f = (float)(i + 1 < sVArray.length && sVArray[i + 1].tok == 2 ? sVArray[++i].asInt() : 100) / 100.0f;
                                continue block15;
                            }
                            if (string3.equalsIgnoreCase("notConnected")) {
                                bl2 = true;
                                continue block15;
                            }
                            if (string3.equalsIgnoreCase("connected")) {
                                bl = true;
                                continue block15;
                            }
                            if (string3.equalsIgnoreCase("minArray")) {
                                bl4 = n4 >= 1;
                                continue block15;
                            }
                            if (string3.equalsIgnoreCase("asArray")) {
                                bl5 = n4 >= 1;
                                continue block15;
                            }
                            if (PT.isOneOf(string3.toLowerCase(), ";nm;nanometers;pm;picometers;angstroms;ang;au;") || string3.endsWith("hz")) {
                                string2 = string3.toLowerCase();
                                continue block15;
                            }
                            string = n2 + ":" + string3;
                            continue block15;
                        }
                        default: {
                            return false;
                        }
                    }
                }
                if (n2 < 2 || n2 > 4 || n3 > 2 || bl2 && bl) {
                    return false;
                }
                if (bl3) {
                    return scriptMathProcessor.addXStr("");
                }
                if (f != Float.MAX_VALUE && (n4 != 2 || n2 != 2)) {
                    return scriptMathProcessor.addXStr("");
                }
                radiusData = f == Float.MAX_VALUE ? new RadiusData(fArray, 0.0f, null, null) : new RadiusData(null, f, RadiusData.EnumType.FACTOR, VDW.AUTO);
                return scriptMathProcessor.addXObj(this.vwr.newMeasurementData(null, lst).set(0, null, radiusData, string, string2, null, bl, bl2, null, true, 0, (short)0, null).getMeasurements(bl5, bl4));
            }
            case 0x8000001: {
                n2 = sVArray.length;
                if (n2 == 3 || n2 == 4) break;
                return false;
            }
            default: {
                n2 = sVArray.length;
                if (n2 == 2) break;
                return false;
            }
        }
        P3[] p3Array = new P3[n2];
        for (int i = 0; i < n2; ++i) {
            p3Array[i] = scriptMathProcessor.ptValue(sVArray[i]);
            if (p3Array[i] != null) continue;
            return false;
        }
        switch (n2) {
            case 2: {
                return scriptMathProcessor.addXFloat(p3Array[0].distance(p3Array[1]));
            }
            case 3: {
                return scriptMathProcessor.addXFloat(Measure.computeAngleABC(p3Array[0], p3Array[1], p3Array[2], true));
            }
            case 4: {
                return scriptMathProcessor.addXFloat(Measure.computeTorsion(p3Array[0], p3Array[1], p3Array[2], p3Array[3], true));
            }
        }
        return false;
    }

    private boolean evaluateModulation(ScriptMathProcessor scriptMathProcessor, SV[] sVArray) throws ScriptException {
        String string = "";
        float f = Float.NaN;
        P3 p3 = null;
        block0 : switch (sVArray.length) {
            case 0: {
                break;
            }
            case 1: {
                switch (sVArray[0].tok) {
                    case 8: {
                        p3 = (P3)sVArray[0].value;
                        break block0;
                    }
                    case 4: {
                        string = sVArray[0].asString();
                        break block0;
                    }
                }
                f = SV.fValue(sVArray[0]);
                break;
            }
            case 2: {
                string = SV.sValue(sVArray[0]);
                f = SV.fValue(sVArray[1]);
                break;
            }
            default: {
                return false;
            }
        }
        if (p3 == null && (double)f < 1000000.0) {
            p3 = P3.new3(f, f, f);
        }
        BS bS = SV.getBitSet(scriptMathProcessor.getX(), false);
        return scriptMathProcessor.addXList(this.vwr.ms.getModulationList(bS, (string + "D").toUpperCase().charAt(0), p3));
    }

    private boolean evaluatePlane(ScriptMathProcessor scriptMathProcessor, SV[] sVArray, int n) throws ScriptException {
        block33: {
            if (n == 134219265 && sVArray.length != 3 || n == 134219266 && sVArray.length != 2 && sVArray.length != 3 || sVArray.length == 0 || sVArray.length > 4) {
                return false;
            }
            switch (sVArray.length) {
                case 1: {
                    Object object;
                    if (sVArray[0].tok == 10 && ((BS)(object = SV.getBitSet(sVArray[0], false))).cardinality() == 3) {
                        Lst<P3> lst = this.vwr.ms.getAtomPointVector((BS)object);
                        return scriptMathProcessor.addXPt4(Measure.getPlaneThroughPoints((T3)lst.get(0), (T3)lst.get(1), (T3)lst.get(2), new V3(), new V3(), new P4()));
                    }
                    object = Escape.uP(SV.sValue(sVArray[0]));
                    if (object instanceof P4) {
                        return scriptMathProcessor.addXPt4((P4)object);
                    }
                    return scriptMathProcessor.addXStr("" + object);
                }
                case 2: {
                    if (n == 134219266) {
                        if (sVArray[1].tok != 9) {
                            return false;
                        }
                        P3 p3 = new P3();
                        V3 v3 = new V3();
                        V3 v32 = new V3();
                        P4 p4 = (P4)sVArray[1].value;
                        if (sVArray[0].tok == 9) {
                            Lst<Object> lst = Measure.getIntersectionPP((P4)sVArray[0].value, p4);
                            if (lst == null) {
                                return scriptMathProcessor.addXStr("");
                            }
                            return scriptMathProcessor.addXList(lst);
                        }
                        P3 p32 = scriptMathProcessor.ptValue(sVArray[0]);
                        if (p32 == null) {
                            return scriptMathProcessor.addXStr("");
                        }
                        return scriptMathProcessor.addXPt(Measure.getIntersection(p32, null, p4, p3, v3, v32));
                    }
                }
                case 3: 
                case 4: {
                    switch (n) {
                        case 134219265: {
                            return scriptMathProcessor.addXPt4(this.e.getHklPlane(P3.new3(SV.fValue(sVArray[0]), SV.fValue(sVArray[1]), SV.fValue(sVArray[2]))));
                        }
                        case 134219266: {
                            P3 p3 = scriptMathProcessor.ptValue(sVArray[0]);
                            P3 p33 = scriptMathProcessor.ptValue(sVArray[1]);
                            if (p3 == null || p33 == null) {
                                return scriptMathProcessor.addXStr("");
                            }
                            V3 v3 = V3.newV(p33);
                            v3.normalize();
                            if (sVArray[2].tok == 9) {
                                P3 p34 = new P3();
                                V3 v33 = new V3();
                                V3 v34 = new V3();
                                if ((p3 = Measure.getIntersection(p3, v3, (P4)sVArray[2].value, p34, v33, v34)) == null) {
                                    return scriptMathProcessor.addXStr("");
                                }
                                return scriptMathProcessor.addXPt(p3);
                            }
                            P3 p35 = scriptMathProcessor.ptValue(sVArray[2]);
                            if (p35 == null) {
                                return scriptMathProcessor.addXStr("");
                            }
                            V3 v35 = new V3();
                            Measure.projectOntoAxis(p35, p3, v3, v35);
                            return scriptMathProcessor.addXPt(p35);
                        }
                    }
                    switch (sVArray[0].tok) {
                        case 2: 
                        case 3: {
                            if (sVArray.length == 3) {
                                float f = SV.fValue(sVArray[0]);
                                float f2 = SV.fValue(sVArray[1]);
                                float f3 = SV.fValue(sVArray[2]);
                                V3 v3 = V3.new3(0.0f, 0.0f, 1.0f);
                                P3 p3 = P3.new3(0.0f, 1.0f, 0.0f);
                                Quat quat = Quat.newVA(p3, f3);
                                quat.getMatrix().rotate(v3);
                                p3.set(0.0f, 0.0f, 1.0f);
                                quat = Quat.newVA(p3, f2);
                                quat.getMatrix().rotate(v3);
                                p3.setT(v3);
                                p3.scale(f);
                                P4 p4 = new P4();
                                Measure.getPlaneThroughPoint(p3, v3, p4);
                                return scriptMathProcessor.addXPt4(p4);
                            }
                            break block33;
                        }
                        case 8: 
                        case 10: {
                            P3 p3 = scriptMathProcessor.ptValue(sVArray[0]);
                            P3 p36 = scriptMathProcessor.ptValue(sVArray[1]);
                            if (p36 == null) {
                                return false;
                            }
                            P3 p37 = sVArray.length > 2 && (sVArray[2].tok == 10 || sVArray[2].tok == 8) ? scriptMathProcessor.ptValue(sVArray[2]) : null;
                            V3 v3 = V3.newV(p36);
                            if (p37 == null) {
                                P4 p4 = new P4();
                                if (sVArray.length == 2 || sVArray[2].tok != 2 && sVArray[2].tok != 3 && !sVArray[2].asBoolean()) {
                                    p37 = P3.newP(p3);
                                    p37.add(p36);
                                    p37.scale(0.5f);
                                    v3.sub(p3);
                                    v3.normalize();
                                } else if (sVArray[2].tok == 1073742335) {
                                    p37 = p3;
                                } else {
                                    v3.sub(p3);
                                    p37 = new P3();
                                    p37.scaleAdd2(sVArray[2].asFloat(), v3, p3);
                                }
                                Measure.getPlaneThroughPoint(p37, v3, p4);
                                return scriptMathProcessor.addXPt4(p4);
                            }
                            V3 v36 = new V3();
                            P3 p38 = sVArray.length == 4 ? scriptMathProcessor.ptValue(sVArray[3]) : null;
                            float f = Measure.getDirectedNormalThroughPoints(p3, p36, p37, p38, v3, v36);
                            return scriptMathProcessor.addXPt4(P4.new4(v3.x, v3.y, v3.z, f));
                        }
                    }
                }
            }
        }
        if (sVArray.length != 4) {
            return false;
        }
        float f = SV.fValue(sVArray[0]);
        float f4 = SV.fValue(sVArray[1]);
        float f5 = SV.fValue(sVArray[2]);
        float f6 = SV.fValue(sVArray[3]);
        return scriptMathProcessor.addXPt4(P4.new4(f, f4, f5, f6));
    }

    private boolean evaluatePoint(ScriptMathProcessor scriptMathProcessor, SV[] sVArray) {
        switch (sVArray.length) {
            default: {
                return false;
            }
            case 1: {
                Object object;
                if (sVArray[0].tok == 3 || sVArray[0].tok == 2) {
                    return scriptMathProcessor.addXInt(sVArray[0].asInt());
                }
                String string = SV.sValue(sVArray[0]);
                if (sVArray[0].tok == 7) {
                    string = "{" + string + "}";
                }
                return (object = Escape.uP(string)) instanceof P3 ? scriptMathProcessor.addXPt((P3)object) : scriptMathProcessor.addXStr("" + object);
            }
            case 2: {
                P3 p3;
                switch (sVArray[1].tok) {
                    case 1073742334: {
                        p3 = SV.ptValue(sVArray[0]);
                        if (p3 == null) {
                            return false;
                        }
                        this.vwr.tm.unTransformPoint(p3, p3);
                        break;
                    }
                    case 1073742335: {
                        p3 = SV.ptValue(sVArray[0]);
                        if (p3 == null) {
                            return false;
                        }
                        this.vwr.tm.transformPt3f(p3, p3);
                        break;
                    }
                    case 8: {
                        Lst<SV> lst = sVArray[0].getList();
                        if (lst == null || lst.size() != 4) {
                            return false;
                        }
                        P3 p32 = SV.ptValue(sVArray[1]);
                        p3 = P3.newP(SV.ptValue((SV)lst.get(0)));
                        p3.scaleAdd2(p32.x, SV.ptValue((SV)lst.get(1)), p3);
                        p3.scaleAdd2(p32.y, SV.ptValue((SV)lst.get(2)), p3);
                        p3.scaleAdd2(p32.z, SV.ptValue((SV)lst.get(3)), p3);
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                return scriptMathProcessor.addXPt(p3);
            }
            case 3: {
                return scriptMathProcessor.addXPt(P3.new3(sVArray[0].asFloat(), sVArray[1].asFloat(), sVArray[2].asFloat()));
            }
            case 4: 
        }
        return scriptMathProcessor.addXPt4(P4.new4(sVArray[0].asFloat(), sVArray[1].asFloat(), sVArray[2].asFloat(), sVArray[3].asFloat()));
    }

    private boolean evaluatePrompt(ScriptMathProcessor scriptMathProcessor, SV[] sVArray) {
        boolean bl;
        if (sVArray.length != 1 && sVArray.length != 2 && sVArray.length != 3) {
            return false;
        }
        String string = SV.sValue(sVArray[0]);
        String[] stringArray = sVArray.length > 1 && sVArray[1].tok == 7 ? SV.strListValue(sVArray[1]) : null;
        boolean bl2 = bl = stringArray != null || sVArray.length == 1 || sVArray.length == 3 && sVArray[2].asBoolean();
        String string2 = stringArray != null ? null : (sVArray.length >= 2 ? SV.sValue(sVArray[1]) : "OK");
        String string3 = "" + this.vwr.prompt(string, string2, stringArray, bl);
        return bl && stringArray != null ? scriptMathProcessor.addXInt(Integer.parseInt(string3) + 1) : scriptMathProcessor.addXStr(string3);
    }

    private boolean evaluateQuaternion(ScriptMathProcessor scriptMathProcessor, SV[] sVArray, int n) throws ScriptException {
        Object object;
        P3 p3 = null;
        int n2 = sVArray.length;
        int n3 = Integer.MAX_VALUE;
        boolean bl = false;
        if (n == 134221850) {
            if (n2 > 1 && sVArray[n2 - 1].tok == 4 && ((String)sVArray[n2 - 1].value).equalsIgnoreCase("relative")) {
                --n2;
                bl = true;
            }
            if (n2 > 1 && sVArray[n2 - 1].tok == 2 && sVArray[0].tok == 10) {
                n3 = sVArray[n2 - 1].asInt();
                if (n3 <= 0) {
                    n3 = 0x7FFFFFFE;
                }
                --n2;
            }
        }
        switch (n2) {
            case 0: 
            case 1: 
            case 4: {
                break;
            }
            case 2: {
                if (n == 134221850 && (sVArray[0].tok == 7 && (sVArray[1].tok == 7 || sVArray[1].tok == 1073742335) || sVArray[0].tok == 10 && (sVArray[1].tok == 2 || sVArray[1].tok == 10)) || (p3 = scriptMathProcessor.ptValue(sVArray[0])) != null && (n == 134221850 || sVArray[1].tok != 8)) break;
                return false;
            }
            case 3: {
                if (n != 134221850) {
                    return false;
                }
                if (sVArray[0].tok == 9) {
                    if (sVArray[2].tok == 8 || sVArray[2].tok == 10) break;
                    return false;
                }
                for (int i = 0; i < 3; ++i) {
                    if (sVArray[i].tok == 8 || sVArray[i].tok == 10) continue;
                    return false;
                }
                break;
            }
            default: {
                return false;
            }
        }
        Quat quat = null;
        Quat[] quatArray = null;
        P4 p4 = null;
        switch (n2) {
            case 0: {
                return scriptMathProcessor.addXPt4(this.vwr.tm.getRotationQ().toPoint4f());
            }
            default: {
                Object object2;
                if (n == 134221850 && sVArray[0].tok == 7) {
                    object = this.e.getQuaternionArray(sVArray[0].getList(), 1073742001);
                    object2 = Quat.sphereMean((Quat[])object, null, 1.0E-4f);
                    quat = object2 instanceof Quat ? (Quat)object2 : null;
                    break;
                }
                if (n == 134221850 && sVArray[0].tok == 10) {
                    quatArray = this.vwr.getAtomGroupQuaternions((BS)sVArray[0].value, n3);
                } else if (sVArray[0].tok == 11) {
                    quat = Quat.newM((M3)sVArray[0].value);
                } else if (sVArray[0].tok == 9) {
                    p4 = (P4)sVArray[0].value;
                } else {
                    object = SV.sValue(sVArray[0]);
                    object2 = Escape.uP((String)(((String)object).equalsIgnoreCase("best") ? this.vwr.getOrientationText(1073741863, null) : object));
                    if (!(object2 instanceof P4)) {
                        return false;
                    }
                    p4 = (P4)object2;
                }
                if (n != 0x8000003) break;
                quat = Quat.newVA(P3.new3(p4.x, p4.y, p4.z), p4.w);
                break;
            }
            case 2: {
                Object object2;
                if (n == 134221850) {
                    if (sVArray[0].tok == 7 && sVArray[1].tok == 7) {
                        object = this.e.getQuaternionArray(sVArray[0].getList(), 1073742001);
                        object2 = this.e.getQuaternionArray(sVArray[1].getList(), 1073742001);
                        quatArray = Quat.div((Quat[])object2, (Quat[])object, n3, bl);
                        break;
                    }
                    if (sVArray[0].tok == 7 && sVArray[1].tok == 1073742335) {
                        Quat[] quatArray2 = this.e.getQuaternionArray(sVArray[0].getList(), 1073742001);
                        float[] fArray = new float[1];
                        Quat.sphereMean(quatArray2, fArray, 1.0E-4f);
                        return scriptMathProcessor.addXFloat(fArray[0]);
                    }
                    if (sVArray[0].tok == 10 && sVArray[1].tok == 10) {
                        object = this.vwr.getAtomGroupQuaternions((BS)sVArray[0].value, Integer.MAX_VALUE);
                        object2 = this.vwr.getAtomGroupQuaternions((BS)sVArray[1].value, Integer.MAX_VALUE);
                        quatArray = Quat.div((Quat[])object2, (Quat[])object, n3, bl);
                        break;
                    }
                }
                object = scriptMathProcessor.ptValue(sVArray[1]);
                p4 = scriptMathProcessor.planeValue(sVArray[0]);
                if (object != null) {
                    quat = Quat.getQuaternionFrame(P3.new3(0.0f, 0.0f, 0.0f), p3, (T3)object);
                    break;
                }
                quat = Quat.newVA(p3, SV.fValue(sVArray[1]));
                break;
            }
            case 3: {
                if (sVArray[0].tok == 9) {
                    P3 p32 = sVArray[2].tok == 8 ? (P3)sVArray[2].value : this.vwr.ms.getAtomSetCenter((BS)sVArray[2].value);
                    return scriptMathProcessor.addXStr(Escape.drawQuat(Quat.newP4((P4)sVArray[0].value), "q", SV.sValue(sVArray[1]), p32, 1.0f));
                }
                Object object2 = new P3[3];
                for (int i = 0; i < 3; ++i) {
                    object2[i] = sVArray[i].tok == 8 ? (P3)sVArray[i].value : this.vwr.ms.getAtomSetCenter((BS)sVArray[i].value);
                }
                quat = Quat.getQuaternionFrame(object2[0], object2[1], object2[2]);
                break;
            }
            case 4: {
                if (n == 134221850) {
                    p4 = P4.new4(SV.fValue(sVArray[1]), SV.fValue(sVArray[2]), SV.fValue(sVArray[3]), SV.fValue(sVArray[0]));
                    break;
                }
                quat = Quat.newVA(P3.new3(SV.fValue(sVArray[0]), SV.fValue(sVArray[1]), SV.fValue(sVArray[2])), SV.fValue(sVArray[3]));
            }
        }
        if (quatArray != null) {
            if (n3 != Integer.MAX_VALUE) {
                object = new Lst();
                for (int i = 0; i < quatArray.length; ++i) {
                    ((Lst)object).addLast(quatArray[i].toPoint4f());
                }
                return scriptMathProcessor.addXList((Lst<?>)object);
            }
            quat = quatArray.length > 0 ? quatArray[0] : null;
        }
        return scriptMathProcessor.addXPt4((quat == null ? Quat.newP4(p4) : quat).toPoint4f());
    }

    private boolean evaluateRandom(ScriptMathProcessor scriptMathProcessor, SV[] sVArray) {
        if (sVArray.length > 3) {
            return false;
        }
        if (this.rand == null) {
            this.rand = new Random();
        }
        float f = 0.0f;
        float f2 = 1.0f;
        switch (sVArray.length) {
            case 3: {
                this.rand.setSeed((int)SV.fValue(sVArray[2]));
            }
            case 2: {
                f2 = SV.fValue(sVArray[1]);
            }
            case 1: {
                f = SV.fValue(sVArray[0]);
            }
            case 0: {
                break;
            }
            default: {
                return false;
            }
        }
        return scriptMathProcessor.addXFloat(this.rand.nextFloat() * (f2 - f) + f);
    }

    private boolean evaluateRowCol(ScriptMathProcessor scriptMathProcessor, SV[] sVArray, int n) throws ScriptException {
        if (sVArray.length != 1) {
            return false;
        }
        int n2 = sVArray[0].asInt() - 1;
        SV sV = scriptMathProcessor.getX();
        switch (sV.tok) {
            case 11: {
                if (n2 < 0 || n2 > 2) {
                    return false;
                }
                M3 m3 = (M3)sV.value;
                switch (n) {
                    case 1275068935: {
                        float[] fArray = new float[3];
                        m3.getRow(n2, fArray);
                        return scriptMathProcessor.addXAF(fArray);
                    }
                }
                float[] fArray = new float[3];
                m3.getColumn(n2, fArray);
                return scriptMathProcessor.addXAF(fArray);
            }
            case 12: {
                if (n2 < 0 || n2 > 2) {
                    return false;
                }
                M4 m4 = (M4)sV.value;
                switch (n) {
                    case 1275068935: {
                        float[] fArray = new float[4];
                        m4.getRow(n2, fArray);
                        return scriptMathProcessor.addXAF(fArray);
                    }
                }
                float[] fArray = new float[4];
                m4.getColumn(n2, fArray);
                return scriptMathProcessor.addXAF(fArray);
            }
            case 7: {
                Lst<SV> lst = sV.getList();
                Lst<SV> lst2 = new Lst<SV>();
                int n3 = lst.size();
                for (int i = 0; i < n3; ++i) {
                    Lst<SV> lst3 = ((SV)lst.get(i)).getList();
                    if (lst3 == null) {
                        return scriptMathProcessor.addXStr("");
                    }
                    lst2.addLast(n2 < lst3.size() ? (SV)lst3.get(n2) : SV.newS(""));
                }
                return scriptMathProcessor.addXList(lst2);
            }
        }
        return false;
    }

    private boolean evaluateIn(ScriptMathProcessor scriptMathProcessor, SV[] sVArray) throws ScriptException {
        SV sV = scriptMathProcessor.getX();
        switch (sVArray.length) {
            case 1: {
                Lst<SV> lst = sVArray[0].getList();
                if (lst == null) break;
                int n = lst.size();
                for (int i = 0; i < n; ++i) {
                    if (!SV.areEqual(sV, (SV)lst.get(i))) continue;
                    return scriptMathProcessor.addXInt(i + 1);
                }
                break;
            }
            default: {
                for (int i = 0; i < sVArray.length; ++i) {
                    if (!SV.areEqual(sV, sVArray[i])) continue;
                    return scriptMathProcessor.addXInt(i + 1);
                }
            }
        }
        return scriptMathProcessor.addXInt(0);
    }

    private boolean evaluateReplace(ScriptMathProcessor scriptMathProcessor, SV[] sVArray) throws ScriptException {
        String string;
        String string2;
        boolean bl = false;
        switch (sVArray.length) {
            case 0: {
                bl = true;
                string2 = null;
                string = null;
                break;
            }
            case 3: {
                bl = SV.bValue(sVArray[2]);
            }
            case 2: {
                string = SV.sValue(sVArray[0]);
                string2 = SV.sValue(sVArray[1]);
                break;
            }
            default: {
                return false;
            }
        }
        SV sV = scriptMathProcessor.getX();
        if (sV.tok == 7) {
            String[] stringArray = SV.strListValue(sV);
            String[] stringArray2 = new String[stringArray.length];
            int n = stringArray.length;
            while (--n >= 0) {
                stringArray2[n] = string == null ? PT.clean(stringArray[n]) : (bl ? PT.replaceAllCharacters(stringArray[n], string, string2) : PT.rep(stringArray[n], string, string2));
            }
            return scriptMathProcessor.addXAS(stringArray2);
        }
        String string3 = SV.sValue(sV);
        return scriptMathProcessor.addXStr(string == null ? PT.clean(string3) : (bl ? PT.replaceAllCharacters(string3, string, string2) : PT.rep(string3, string, string2)));
    }

    private boolean evaluateScript(ScriptMathProcessor scriptMathProcessor, SV[] sVArray, int n) throws ScriptException {
        if ((n == 134218253 || n == 134222350 || n == 134238732) && sVArray.length != 1 || sVArray.length == 0 || sVArray.length > 2) {
            return false;
        }
        String string = SV.sValue(sVArray[0]);
        SB sB = new SB();
        switch (n) {
            case 134218253: {
                return scriptMathProcessor.addXObj(this.vwr.evaluateExpressionAsVariable(string));
            }
            case 134222850: {
                String string2;
                String string3 = string2 = sVArray.length == 2 ? SV.sValue(sVArray[1]) : ".";
                if (!string2.equals(".")) {
                    sB.append(this.vwr.jsEval(string2 + "\u0001" + string));
                }
                if (!string2.equals(".") && !string2.equals("*")) break;
                this.e.runScriptBuffer(string, sB);
                break;
            }
            case 134222350: {
                this.e.runScriptBuffer("show " + string, sB);
                break;
            }
            case 134238732: {
                sB.append(this.vwr.jsEval(string));
            }
        }
        string = sB.toString();
        float f = PT.parseFloatStrict(string);
        return Float.isNaN(f) ? scriptMathProcessor.addXStr(string) : (string.indexOf(".") >= 0 ? scriptMathProcessor.addXFloat(f) : scriptMathProcessor.addXInt(PT.parseInt(string)));
    }

    private boolean evaluateSort(ScriptMathProcessor scriptMathProcessor, SV[] sVArray, int n) throws ScriptException {
        SV sV;
        if (sVArray.length > 1) {
            return false;
        }
        if (n == 1275068444) {
            if (sVArray.length == 1 && sVArray[0].tok == 4) {
                return scriptMathProcessor.addX(scriptMathProcessor.getX().sortMapArray(sVArray[0].asString()));
            }
            int n2 = sVArray.length == 0 ? 0 : sVArray[0].asInt();
            return scriptMathProcessor.addX(scriptMathProcessor.getX().sortOrReverse(n2));
        }
        SV sV2 = scriptMathProcessor.getX();
        SV sV3 = sV = sVArray.length == 0 ? null : sVArray[0];
        if (sV2.tok == 4) {
            int n3;
            int n4 = 0;
            String string = SV.sValue(sV2);
            if (sV == null) {
                return scriptMathProcessor.addXInt(0);
            }
            String string2 = SV.sValue(sV);
            for (int i = 0; i < string.length() && (n3 = string.indexOf(string2, i)) >= 0; ++i) {
                ++n4;
                i = n3;
            }
            return scriptMathProcessor.addXInt(n4);
        }
        Lst<SV> lst = new Lst<SV>();
        SV sV4 = null;
        SV sV5 = null;
        Lst<SV> lst2 = SV.getVariable(sV2.value).sortOrReverse(0).getList();
        if (lst2 == null) {
            return sV == null ? scriptMathProcessor.addXStr("") : scriptMathProcessor.addXInt(0);
        }
        int n5 = lst2.size();
        for (int i = 0; i <= n5; ++i) {
            SV sV6;
            SV sV7 = sV6 = i == n5 ? null : (SV)lst2.get(i);
            if (sV != null && sV6 != null && !SV.areEqual(sV6, sV)) continue;
            if (SV.areEqual(sV6, sV4)) {
                ++sV5.intValue;
                continue;
            }
            if (sV4 != null) {
                Lst<SV> lst3 = new Lst<SV>();
                lst3.addLast(sV4);
                lst3.addLast(sV5);
                lst.addLast(SV.getVariableList(lst3));
            }
            sV5 = SV.newI(1);
            sV4 = sV6;
        }
        if (sV == null) {
            return scriptMathProcessor.addX(SV.getVariableList(lst));
        }
        if (lst.isEmpty()) {
            return scriptMathProcessor.addXInt(0);
        }
        return scriptMathProcessor.addX((SV)((SV)lst.get(0)).getList().get(1));
    }

    private boolean evaluateString(ScriptMathProcessor scriptMathProcessor, int n, SV[] sVArray) throws ScriptException {
        SV sV = scriptMathProcessor.getX();
        String string = sVArray.length > 0 ? SV.sValue(sVArray[0]) : (n == 1275068932 ? "" : "\n");
        switch (sVArray.length) {
            case 0: 
            case 1: {
                break;
            }
            case 2: {
                if (sV.tok == 7) break;
                if (n == 1275069447) {
                    sV = SV.getVariable(PT.split(PT.rep((String)sV.value, "\n\r", "\n").replace('\r', '\n'), "\n"));
                    break;
                }
            }
            default: {
                return false;
            }
        }
        if (sV.tok == 7 && n != 1275068932 && (n != 1275069447 || sVArray.length == 2)) {
            scriptMathProcessor.addX(sV);
            return this.evaluateList(scriptMathProcessor, n, sVArray);
        }
        String string2 = n == 1275069447 && sV.tok == 10 || n == 1275068932 && sV.tok == 7 ? null : SV.sValue(sV);
        switch (n) {
            case 1275069447: {
                if (sV.tok == 10) {
                    BS bS = SV.bsSelectVar(sV);
                    string = "\n";
                    int n2 = this.vwr.ms.mc;
                    string2 = "";
                    for (int i = 0; i < n2; ++i) {
                        string2 = string2 + (i == 0 ? "" : "\n");
                        BS bS2 = this.vwr.getModelUndeletedAtomsBitSet(i);
                        bS2.and(bS);
                        string2 = string2 + Escape.eBS(bS2);
                    }
                }
                return scriptMathProcessor.addXAS(PT.split(string2, string));
            }
            case 1275069446: {
                if (string2.length() > 0 && string2.charAt(string2.length() - 1) == '\n') {
                    string2 = string2.substring(0, string2.length() - 1);
                }
                return scriptMathProcessor.addXStr(PT.rep(string2, "\n", string));
            }
            case 1275068932: {
                if (string2 != null) {
                    return scriptMathProcessor.addXStr(PT.trim(string2, string));
                }
                String[] stringArray = SV.strListValue(sV);
                int n3 = stringArray.length;
                while (--n3 >= 0) {
                    stringArray[n3] = PT.trim(stringArray[n3], string);
                }
                return scriptMathProcessor.addXAS(stringArray);
            }
        }
        return scriptMathProcessor.addXStr("");
    }

    private boolean evaluateSubstructure(ScriptMathProcessor scriptMathProcessor, SV[] sVArray, int n, boolean bl) throws ScriptException {
        if (sVArray.length == 0 || bl && sVArray.length != 1) {
            return false;
        }
        BS bS = new BS();
        String string = SV.sValue(sVArray[0]);
        if (string.length() > 0) {
            try {
                BS bS2 = bl ? SV.bsSelectVar(scriptMathProcessor.getX()) : (sVArray.length == 2 && sVArray[1].tok == 10 ? SV.bsSelectVar(sVArray[1]) : null);
                bS = this.vwr.getSmilesMatcher().getSubstructureSet(string, this.vwr.ms.at, this.vwr.ms.ac, bS2, n == 134218757 ? 1 : 2);
            }
            catch (Exception exception) {
                this.e.evalError(exception.getMessage(), null);
            }
        }
        return scriptMathProcessor.addXBs(bS);
    }

    private boolean evaluateSymop(ScriptMathProcessor scriptMathProcessor, SV[] sVArray, boolean bl) throws ScriptException {
        P3 p3;
        String string;
        SV sV;
        if (sVArray.length == 0) {
            return false;
        }
        SV sV2 = sV = bl ? scriptMathProcessor.getX() : null;
        if (sV != null && sV.tok != 10) {
            return false;
        }
        BS bS = sV != null ? (BS)sV.value : (sVArray.length > 2 && sVArray[1].tok == 10 ? (BS)sVArray[1].value : this.vwr.getAllAtoms());
        switch (sVArray[0].tok) {
            case 4: {
                string = SV.sValue(sVArray[0]);
                break;
            }
            case 12: {
                string = sVArray[0].escape();
                break;
            }
            default: {
                string = null;
            }
        }
        int n = string == null ? sVArray[0].asInt() : 0;
        P3 p32 = p3 = sVArray.length > 1 ? scriptMathProcessor.ptValue(sVArray[1]) : null;
        if (sVArray.length == 2 && p3 != null) {
            return scriptMathProcessor.addXObj(this.vwr.ms.getSymTemp(false).getSymmetryInfoAtom(this.vwr.ms, bS, string, n, p3, null, null, 134217751));
        }
        String string2 = (sVArray.length == 1 ? "matrix" : SV.sValue(sVArray[sVArray.length - 1])).toLowerCase();
        int n2 = 135176;
        if (string2.equalsIgnoreCase("matrix")) {
            n2 = 12;
        } else if (string2.equalsIgnoreCase("array") || string2.equalsIgnoreCase("list")) {
            n2 = 1073742001;
        } else if (string2.equalsIgnoreCase("description")) {
            n2 = 1825200146;
        } else if (string2.equalsIgnoreCase("xyz")) {
            n2 = 1073741982;
        } else if (string2.equalsIgnoreCase("translation")) {
            n2 = 1073742178;
        } else if (string2.equalsIgnoreCase("axis")) {
            n2 = 1073741854;
        } else if (string2.equalsIgnoreCase("plane")) {
            n2 = 134217750;
        } else if (string2.equalsIgnoreCase("angle")) {
            n2 = 0x8000001;
        } else if (string2.equalsIgnoreCase("axispoint")) {
            n2 = 134217751;
        } else if (string2.equalsIgnoreCase("center")) {
            n2 = 12289;
        }
        return scriptMathProcessor.addXObj(this.vwr.ms.getSymTemp(false).getSymmetryInfoAtom(this.vwr.ms, bS, string, n, p3, null, string2, n2));
    }

    private boolean evaluateTensor(ScriptMathProcessor scriptMathProcessor, SV[] sVArray) throws ScriptException {
        if (sVArray.length > 2) {
            return false;
        }
        BS bS = SV.getBitSet(scriptMathProcessor.getX(), false);
        String string = sVArray.length == 0 ? null : SV.sValue(sVArray[0]).toLowerCase();
        JmolNMRInterface jmolNMRInterface = this.vwr.getNMRCalculation();
        if ("unique".equals(string)) {
            return scriptMathProcessor.addXBs(jmolNMRInterface.getUniqueTensorSet(bS));
        }
        String string2 = sVArray.length < 2 ? null : SV.sValue(sVArray[1]).toLowerCase();
        return scriptMathProcessor.addXList(jmolNMRInterface.getTensorInfo(string, string2, bS));
    }

    private boolean evaluateUserFunction(ScriptMathProcessor scriptMathProcessor, String string, SV[] sVArray, int n, boolean bl) throws ScriptException {
        SV sV = null;
        if (bl) {
            sV = scriptMathProcessor.getX();
            switch (sV.tok) {
                case 10: {
                    break;
                }
                case 6: {
                    if (sVArray.length > 0) {
                        return false;
                    }
                    return (sV = sV.getMap().get(string)) == null ? scriptMathProcessor.addXStr("") : scriptMathProcessor.addX(sV);
                }
                default: {
                    return false;
                }
            }
        }
        string = string.toLowerCase();
        scriptMathProcessor.wasX = false;
        Lst<SV> lst = new Lst<SV>();
        for (int i = 0; i < sVArray.length; ++i) {
            lst.addLast(sVArray[i]);
        }
        if (bl) {
            return scriptMathProcessor.addXObj(this.e.getBitsetProperty(SV.bsSelectVar(sV), n, null, null, sV.value, new Object[]{string, lst}, false, sV.index, false));
        }
        SV sV2 = this.e.getUserFunctionResult(string, lst, null);
        return sV2 == null ? false : scriptMathProcessor.addX(sV2);
    }

    private boolean evaluateWithin(ScriptMathProcessor scriptMathProcessor, SV[] sVArray) throws ScriptException {
        BS bS;
        Object object;
        boolean bl;
        if (sVArray.length < 1 || sVArray.length > 5) {
            return false;
        }
        int n = sVArray.length;
        if (n == 1 && sVArray[0].tok == 10) {
            return scriptMathProcessor.addX(sVArray[0]);
        }
        float f = 0.0f;
        Object object2 = sVArray[0].value;
        String string = "" + object2;
        int n2 = sVArray[0].tok;
        if (n2 == 4) {
            n2 = T.getTokFromName(string);
        }
        boolean bl2 = bl = n2 == 1648363544;
        if (bl) {
            f = 100.0f;
            object2 = null;
        }
        ModelSet modelSet = this.vwr.ms;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = bl || n2 == 3 || n2 == 2;
        RadiusData radiusData = null;
        switch (n2) {
            case 7: {
                if (n != 1) break;
                object2 = sVArray[0].asString();
                n2 = 0;
                break;
            }
            case 1073742328: {
                return n == 3 && sVArray[1].value instanceof BS && sVArray[2].value instanceof BS && scriptMathProcessor.addXBs(this.vwr.getBranchBitSet(((BS)sVArray[2].value).nextSetBit(0), ((BS)sVArray[1].value).nextSetBit(0), true));
            }
            case 0x8000404: 
            case 134218757: 
            case 1237320707: {
                BS bS2 = null;
                boolean bl6 = true;
                switch (n) {
                    case 2: {
                        break;
                    }
                    case 3: {
                        boolean bl7 = bl6 = sVArray[2].tok == 10;
                        if (!bl6) break;
                        bS2 = (BS)sVArray[2].value;
                        break;
                    }
                    default: {
                        bl6 = false;
                    }
                }
                if (!bl6) {
                    this.e.invArg();
                }
                return scriptMathProcessor.addXObj(this.e.getSmilesExt().getSmilesMatches(SV.sValue(sVArray[1]), null, bS2, null, n2 == 0x8000404 ? 2 : 1, scriptMathProcessor.asBitSet, false));
            }
        }
        if (object2 instanceof String) {
            if (n2 == 0) {
                n2 = 1073742362;
                if (n > 2) {
                    return false;
                }
                n = 2;
            }
        } else if (bl5) {
            if (!bl) {
                f = SV.fValue(sVArray[0]);
            }
            if (n < 2) {
                return false;
            }
            n2 = sVArray[1].tok;
            switch (n2) {
                case 1073742334: 
                case 1073742335: {
                    bl3 = sVArray[1].asBoolean();
                    n = 0;
                    if (sVArray.length <= 2 || !SV.sValue(sVArray[2]).equalsIgnoreCase("unitcell")) break;
                    n2 = 1747587102;
                    break;
                }
                case 4: {
                    object = SV.sValue(sVArray[1]);
                    if (((String)object).startsWith("$")) {
                        return scriptMathProcessor.addXBs(this.getAtomsNearSurface(f, ((String)object).substring(1)));
                    }
                    if (((String)object).equalsIgnoreCase("group")) {
                        bl4 = true;
                        n2 = 1086324742;
                        break;
                    }
                    if (((String)object).equalsIgnoreCase("vanderwaals") || ((String)object).equalsIgnoreCase("vdw")) {
                        object2 = null;
                        bl = true;
                        n2 = 1648363544;
                        break;
                    }
                    if (((String)object).equalsIgnoreCase("unitcell")) {
                        n2 = 1747587102;
                        break;
                    }
                    return false;
                }
            }
        } else {
            return false;
        }
        object = null;
        P4 p4 = null;
        block13 : switch (n) {
            case 1: {
                switch (n2) {
                    case 0x200020: 
                    case 136314895: 
                    case 1678381065: {
                        return scriptMathProcessor.addXBs(modelSet.getAtoms(n2, null));
                    }
                    case 1073741864: {
                        return scriptMathProcessor.addXBs(modelSet.getAtoms(n2, ""));
                    }
                    case 1073742362: {
                        return scriptMathProcessor.addXBs(modelSet.getAtoms(1086324744, string));
                    }
                }
                return false;
            }
            case 2: {
                switch (n2) {
                    case 1073742362: {
                        n2 = 1086324744;
                        break block13;
                    }
                    case 0x40000000: 
                    case 1073741864: 
                    case 1073741916: 
                    case 1073741925: 
                    case 1073742128: 
                    case 1073742189: 
                    case 1086324744: 
                    case 1086326785: 
                    case 1086326786: {
                        return scriptMathProcessor.addXBs(this.vwr.ms.getAtoms(n2, SV.sValue(sVArray[sVArray.length - 1])));
                    }
                }
                break;
            }
            case 3: {
                switch (n2) {
                    case 8: 
                    case 134217750: 
                    case 134219265: 
                    case 1073742329: 
                    case 1073742334: 
                    case 1073742335: 
                    case 1086324742: 
                    case 1648363544: 
                    case 1747587102: {
                        break block13;
                    }
                    case 1086324744: {
                        string = SV.sValue(sVArray[2]);
                        break block13;
                    }
                }
                return false;
            }
        }
        int n3 = sVArray.length - 1;
        switch (sVArray[n3].tok) {
            case 9: {
                p4 = (P4)sVArray[n3].value;
                break;
            }
            case 8: {
                object = (P3)sVArray[n3].value;
                if (!SV.sValue(sVArray[1]).equalsIgnoreCase("hkl")) break;
                p4 = this.e.getHklPlane((P3)object);
                break;
            }
            case 7: {
                if (n3 != 2) {
                    return false;
                }
                object = SV.ptValue(sVArray[1]);
            }
        }
        if (n3 > 0 && p4 == null && object == null && !(sVArray[n3].value instanceof BS)) {
            return false;
        }
        if (p4 != null) {
            return scriptMathProcessor.addXBs(modelSet.getAtomsNearPlane(f, p4));
        }
        BS bS3 = bS = sVArray[n3].tok == 10 ? SV.bsSelectVar(sVArray[n3]) : null;
        if (n2 == 1747587102) {
            boolean bl8 = bl3;
            return scriptMathProcessor.addXObj(this.vwr.ms.getUnitCellPointsWithin(f, bS, (P3)object, bl8));
        }
        if (object != null) {
            if (sVArray[n3].tok == 7) {
                Lst<SV> lst = sVArray[2].getList();
                Lst<T3> lst2 = new Lst<T3>();
                Bspt bspt = new Bspt(3, 0);
                int n4 = lst.size();
                while (--n4 >= 0) {
                    bspt.addTuple(SV.ptValue((SV)lst.get(n4)));
                }
                CubeIterator cubeIterator = bspt.allocateCubeIterator();
                cubeIterator.initialize((T3)object, f, false);
                float f2 = f * f;
                while (cubeIterator.hasMoreElements()) {
                    T3 t3 = cubeIterator.nextElement();
                    if (!(t3.distanceSquared((T3)object) <= f2)) continue;
                    lst2.addLast(t3);
                }
                return scriptMathProcessor.addXList(lst2);
            }
            return scriptMathProcessor.addXBs(this.vwr.getAtomsNearPt(f, (P3)object));
        }
        if (n2 == 1086324744) {
            return scriptMathProcessor.addXBs(this.vwr.ms.getSequenceBits(string, bS, new BS()));
        }
        if (bS == null) {
            bS = new BS();
        }
        if (!bl5) {
            return scriptMathProcessor.addXBs(this.vwr.ms.getAtoms(n2, bS));
        }
        if (bl4) {
            return scriptMathProcessor.addXBs(this.vwr.getGroupsWithin((int)f, bS));
        }
        if (bl) {
            radiusData = new RadiusData(null, f > 10.0f ? f / 100.0f : f, f > 10.0f ? RadiusData.EnumType.FACTOR : RadiusData.EnumType.OFFSET, VDW.AUTO);
            if (f < 0.0f) {
                f = 0.0f;
            }
        }
        return scriptMathProcessor.addXBs(this.vwr.ms.getAtomsWithinRadius(f, bS, bl3, radiusData));
    }

    private boolean evaluateWrite(ScriptMathProcessor scriptMathProcessor, SV[] sVArray) throws ScriptException {
        switch (sVArray.length) {
            case 0: {
                return false;
            }
            case 1: {
                if (!sVArray[0].asString().toUpperCase().equals("PNGJ")) break;
                return scriptMathProcessor.addXMap(this.vwr.fm.getFileAsMap(null));
            }
        }
        return scriptMathProcessor.addXStr(this.e.getCmdExt().dispatch(134221856, true, sVArray));
    }

    private BS getAtomsNearSurface(float f, String string) {
        Object[] objectArray = new Object[]{string, null, null};
        if (this.e.getShapePropertyData(24, "getVertices", objectArray)) {
            return this.getAtomsNearPts(f, (T3[])objectArray[1], (BS)objectArray[2]);
        }
        objectArray[1] = 0;
        objectArray[2] = -1;
        if (this.e.getShapePropertyData(22, "getCenter", objectArray)) {
            return this.vwr.getAtomsNearPt(f, (P3)objectArray[2]);
        }
        return new BS();
    }

    private BS getAtomsNearPts(float f, T3[] t3Array, BS bS) {
        BS bS2 = new BS();
        if (t3Array.length == 0 || bS != null && bS.cardinality() == 0) {
            return bS2;
        }
        if (bS == null) {
            bS = BSUtil.setAll(t3Array.length);
        }
        Atom[] atomArray = this.vwr.ms.at;
        int n = this.vwr.ms.ac;
        block0: while (--n >= 0) {
            Atom atom = atomArray[n];
            int n2 = bS.nextSetBit(0);
            while (n2 >= 0) {
                if (atom.distance(t3Array[n2]) < f) {
                    bS2.set(n);
                    continue block0;
                }
                n2 = bS.nextSetBit(n2 + 1);
            }
        }
        return bS2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getMinMax(Object object, int n) {
        double d;
        int n2;
        float[] fArray = null;
        Lst lst = null;
        int n3 = 0;
        Hashtable<String, Integer> hashtable = null;
        if (AU.isAF(object)) {
            fArray = (float[])object;
            n3 = fArray.length;
            if (n3 == 0) {
                return "NaN";
            }
        } else {
            if (!(object instanceof Lst)) return "NaN";
            lst = (Lst)object;
            n3 = lst.size();
            if (n3 == 0) {
                if (n != 1140850707) {
                    return "NaN";
                }
            } else {
                SV sV = (SV)lst.get(0);
                if (sV.tok == 4 && ((String)sV.value).startsWith("{")) {
                    P3 p3 = SV.ptValue(sV);
                    if (p3 instanceof P3) {
                        return this.getMinMaxPoint(lst, n);
                    }
                    if (!(p3 instanceof P4)) return "NaN";
                    return this.getMinMaxQuaternion(lst, n);
                }
            }
        }
        boolean bl = false;
        switch (n) {
            case 1140850707: {
                hashtable = new Hashtable<String, Integer>();
                n2 = 0;
                d = 0;
                break;
            }
            case 32: {
                bl = true;
                d = 3.4028234663852886E38;
                n2 = Integer.MAX_VALUE;
                break;
            }
            case 64: {
                d = -3.4028234663852886E38;
                n2 = -2147483647;
                break;
            }
            default: {
                n2 = 0;
                d = 0;
            }
        }
        double d2 = 0.0;
        int n4 = 0;
        boolean bl2 = true;
        boolean bl3 = n == 1140850707;
        int n5 = n3;
        while (--n5 >= 0) {
            float f;
            SV sV = (SV)lst.get(n5);
            float f2 = bl3 ? 1.0f : (f = fArray == null ? SV.fValue(sV) : fArray[n5]);
            if (Float.isNaN(f)) continue;
            ++n4;
            switch (n) {
                case 160: 
                case 192: {
                    d2 += (double)f * (double)f;
                }
                case 96: 
                case 128: {
                    d += (double)f;
                    break;
                }
                case 1140850707: {
                    bl2 &= sV.tok == 2;
                    String string = sV.asString();
                    Integer n6 = (Integer)hashtable.get(string);
                    hashtable.put(string, n6 == null ? new Integer(1) : new Integer(n6 + 1));
                    break;
                }
                case 32: 
                case 64: {
                    bl2 &= sV.tok == 2;
                    if (bl != (double)f < d) break;
                    d = f;
                    if (!bl2) break;
                    n2 = sV.intValue;
                }
            }
        }
        if (n == 1140850707) {
            return hashtable;
        }
        if (n4 == 0) return "NaN";
        switch (n) {
            case 96: {
                d /= (double)n4;
                return Float.valueOf((float)d);
            }
            case 192: {
                if (n4 == 1) return Float.valueOf((float)d);
                d = Math.sqrt((d2 - d * d / (double)n4) / (double)(n4 - 1));
                return Float.valueOf((float)d);
            }
            case 32: 
            case 64: {
                if (!bl2) return Float.valueOf((float)d);
                return n2;
            }
            case 128: {
                return Float.valueOf((float)d);
            }
            case 160: {
                d = d2;
            }
        }
        return Float.valueOf((float)d);
    }

    private Object getMinMaxPoint(Object object, int n) {
        P3[] p3Array = null;
        Lst lst = null;
        int n2 = 0;
        if (object instanceof Quat[]) {
            p3Array = (P3[])object;
            n2 = p3Array.length;
        } else if (object instanceof Lst) {
            lst = (Lst)object;
            n2 = lst.size();
        }
        if (lst != null || p3Array != null) {
            P3 p3 = new P3();
            float[] fArray = new float[n2];
            boolean bl = true;
            block10: for (int i = 0; i < 3 && bl; ++i) {
                Object object2;
                block11: for (int j = 0; j < n2; ++j) {
                    P3 p32;
                    P3 p33 = p32 = p3Array == null ? SV.ptValue((SV)lst.get(j)) : p3Array[j];
                    if (p32 == null) {
                        bl = false;
                        break;
                    }
                    switch (i) {
                        case 0: {
                            fArray[j] = p32.x;
                            continue block11;
                        }
                        case 1: {
                            fArray[j] = p32.y;
                            continue block11;
                        }
                        case 2: {
                            fArray[j] = p32.z;
                        }
                    }
                }
                if (!bl || !((object2 = this.getMinMax(fArray, n)) instanceof Number)) break;
                float f = ((Number)object2).floatValue();
                switch (i) {
                    case 0: {
                        p3.x = f;
                        continue block10;
                    }
                    case 1: {
                        p3.y = f;
                        continue block10;
                    }
                    case 2: {
                        p3.z = f;
                    }
                }
            }
            return p3;
        }
        return "NaN";
    }

    private Object getMinMaxQuaternion(Lst<SV> lst, int n) {
        block7: {
            switch (n) {
                case 32: 
                case 64: 
                case 128: 
                case 160: {
                    return "NaN";
                }
            }
            Quat[] quatArray = this.e.getQuaternionArray(lst, 1073742001);
            if (quatArray == null) break block7;
            float[] fArray = new float[1];
            Quat quat = Quat.sphereMean(quatArray, fArray, 1.0E-4f);
            switch (n) {
                case 96: {
                    return quat;
                }
                case 192: {
                    return Float.valueOf(fArray[0]);
                }
            }
        }
        return "NaN";
    }

    private JmolPatternMatcher getPatternMatcher() {
        return this.pm == null ? (this.pm = (JmolPatternMatcher)Interface.getUtil("PatternMatcher", this.e.vwr, "script")) : this.pm;
    }

    private T opTokenFor(int n) {
        switch (n) {
            case 1275069441: 
            case 1275069446: {
                return T.tokenPlus;
            }
            case 1275068931: {
                return T.tokenMinus;
            }
            case 1275068929: {
                return T.tokenTimes;
            }
            case 1275068930: {
                return T.tokenMul3;
            }
            case 1275068928: {
                return T.tokenDivide;
            }
        }
        return null;
    }

    public BS setContactBitSets(BS bS, BS bS2, boolean bl, float f, RadiusData radiusData, boolean bl2) {
        int n;
        BS bS3;
        boolean bl3;
        if (bS2 == null) {
            bS2 = BSUtil.setAll(this.vwr.ms.ac);
            BSUtil.andNot(bS2, this.vwr.slm.bsDeleted);
            bS2.andNot(bS);
            bl3 = false;
        } else {
            bS3 = BSUtil.copy(bS);
            bS3.or(bS2);
            n = this.vwr.ms.getModelBS(bS3, false).cardinality();
            boolean bl4 = bl3 = n > 1;
            if (bl2 && n > 1 && !this.e.tQuiet) {
                this.e.showString(GT._("Note: More than one model is involved in this contact!"));
            }
        }
        if (!bS.equals(bS2)) {
            int n2 = n = !bl || bS.cardinality() < bS2.cardinality() ? 1 : 0;
            if (n != 0) {
                bS3 = this.vwr.ms.getAtomsWithinRadius(f, bS, bl3, Float.isNaN(f) ? radiusData : null);
                bS2.and(bS3);
            }
            if (bl) {
                bS3 = this.vwr.ms.getAtomsWithinRadius(f, bS2, bl3, Float.isNaN(f) ? radiusData : null);
                bS.and(bS3);
                if (n == 0) {
                    bS3 = this.vwr.ms.getAtomsWithinRadius(f, bS, bl3, Float.isNaN(f) ? radiusData : null);
                    bS2.and(bS3);
                }
                bS3 = BSUtil.copy(bS2);
                bS3.and(bS);
                if (bS3.equals(bS)) {
                    bS2.andNot(bS);
                } else if (bS3.equals(bS2)) {
                    bS.andNot(bS2);
                }
            }
        }
        return bS2;
    }
}

