/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.popup;

import java.util.Arrays;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javajs.api.SC;
import javajs.util.Lst;
import javajs.util.PT;
import org.jmol.i18n.GT;
import org.jmol.i18n.Language;
import org.jmol.java.BS;
import org.jmol.modelset.Group;
import org.jmol.popup.GenericSwingPopup;
import org.jmol.popup.MainPopupResourceBundle;
import org.jmol.popup.PopupResource;
import org.jmol.util.Elements;
import org.jmol.viewer.Viewer;

public abstract class JmolGenericPopup
extends GenericSwingPopup {
    protected static final int UPDATE_NEVER = -1;
    private static final int UPDATE_ALL = 0;
    private static final int UPDATE_CONFIG = 1;
    private static final int UPDATE_SHOW = 2;
    protected Viewer vwr;
    protected int updateMode;
    protected Properties menuText = new Properties();
    private SC frankPopup;
    private int nFrankList = 0;
    private int itemMax = 25;
    private int titleWidthMax = 20;
    private String nullModelSetName;
    private String modelSetName;
    private String modelSetFileName;
    private String modelSetRoot;
    private String currentFrankId = null;
    private String configurationSelected = "";
    private String altlocs;
    private Object[][] frankList = new Object[10][];
    private Map<String, Object> modelSetInfo;
    private Map<String, Object> modelInfo;
    private Lst<SC> NotPDB = new Lst();
    private Lst<SC> PDBOnly = new Lst();
    private Lst<SC> FileUnitOnly = new Lst();
    private Lst<SC> FileMolOnly = new Lst();
    private Lst<SC> UnitcellOnly = new Lst();
    private Lst<SC> SingleModelOnly = new Lst();
    private Lst<SC> FramesOnly = new Lst();
    private Lst<SC> VibrationOnly = new Lst();
    private Lst<SC> Special = new Lst();
    private Lst<SC> SymmetryOnly = new Lst();
    private Lst<SC> ChargesOnly = new Lst();
    private Lst<SC> TemperatureOnly = new Lst();
    private boolean fileHasUnitCell;
    private boolean haveBFactors;
    private boolean haveCharges;
    private boolean isLastFrame;
    private boolean isMultiConfiguration;
    private boolean isMultiFrame;
    private boolean isPDB;
    private boolean hasSymmetry;
    private boolean isUnitCell;
    private boolean isVibration;
    private boolean isZapped;
    private int modelIndex;
    private int modelCount;
    private int ac;
    private String group3List;
    private int[] group3Counts;
    private Lst<String> cnmrPeaks;
    private Lst<String> hnmrPeaks;
    private static final int MENUITEM_HEIGHT = 20;
    private final String[] noZapped = new String[]{"surfaceMenu", "measureMenu", "pickingMenu", "computationMenu", "saveMenu", "exportMenu", "SIGNEDJAVAcaptureMenuSPECIAL"};

    protected void initialize(Viewer viewer, PopupResource popupResource, String string) {
        this.vwr = viewer;
        this.initSwing(string, popupResource, viewer.html5Applet, viewer.isJS, viewer.getBooleanProperty("_signedApplet"), viewer.isWebGL);
    }

    public void jpiDispose() {
        this.helper.menuClearListeners(this.popupMenu);
        this.helper.menuClearListeners(this.frankPopup);
        this.thisPopup = null;
        this.frankPopup = null;
        this.popupMenu = null;
    }

    public SC jpiGetMenuAsObject() {
        return this.popupMenu;
    }

    public void jpiShow(int n, int n2) {
        if (!this.vwr.haveDisplay) {
            return;
        }
        this.show(n, n2, false);
        if (n < 0) {
            this.getViewerData();
            this.setFrankMenu(this.currentMenuItemId);
            this.thisx = -n - 50;
            if (this.nFrankList > 1) {
                this.thisy = n2 - this.nFrankList * 20;
                this.menuShowPopup(this.frankPopup, this.thisx, this.thisy);
                return;
            }
        }
        this.appRestorePopupMenu();
        this.menuShowPopup(this.popupMenu, this.thisx, this.thisy);
    }

    public void jpiUpdateComputedMenus() {
        if (this.updateMode == -1) {
            return;
        }
        this.isTainted = true;
        this.updateMode = 0;
        this.getViewerData();
        this.updateSelectMenu();
        this.updateFileMenu();
        this.updateElementsComputedMenu(this.vwr.getElementsPresentBitSet(this.modelIndex));
        this.updateHeteroComputedMenu(this.vwr.ms.getHeteroList(this.modelIndex));
        this.updateSurfMoComputedMenu((Map)this.modelInfo.get("moData"));
        this.updateFileTypeDependentMenus();
        this.updatePDBComputedMenus();
        this.updateMode = 1;
        this.updateConfigurationComputedMenu();
        this.updateSYMMETRYComputedMenus();
        this.updateFRAMESbyModelComputedMenu();
        this.updateModelSetComputedMenu();
        this.updateLanguageSubmenu();
        this.updateAboutSubmenu();
    }

    @Override
    protected void appCheckItem(String string, SC sC) {
        if (string.indexOf("!PDB") >= 0) {
            this.NotPDB.addLast((Object)sC);
        } else if (string.indexOf("PDB") >= 0) {
            this.PDBOnly.addLast((Object)sC);
        }
        if (string.indexOf("CHARGE") >= 0) {
            this.ChargesOnly.addLast((Object)sC);
        } else if (string.indexOf("BFACTORS") >= 0) {
            this.TemperatureOnly.addLast((Object)sC);
        } else if (string.indexOf("UNITCELL") >= 0) {
            this.UnitcellOnly.addLast((Object)sC);
        } else if (string.indexOf("FILEUNIT") >= 0) {
            this.FileUnitOnly.addLast((Object)sC);
        } else if (string.indexOf("FILEMOL") >= 0) {
            this.FileMolOnly.addLast((Object)sC);
        }
        if (string.indexOf("!FRAMES") >= 0) {
            this.SingleModelOnly.addLast((Object)sC);
        } else if (string.indexOf("FRAMES") >= 0) {
            this.FramesOnly.addLast((Object)sC);
        }
        if (string.indexOf("VIBRATION") >= 0) {
            this.VibrationOnly.addLast((Object)sC);
        } else if (string.indexOf("SYMMETRY") >= 0) {
            this.SymmetryOnly.addLast((Object)sC);
        }
        if (string.indexOf("SPECIAL") >= 0) {
            this.Special.addLast((Object)sC);
        }
    }

    @Override
    protected String appFixLabel(String string) {
        return string;
    }

    @Override
    protected String appFixScript(String string, String string2) {
        if (string2 == "" || string.endsWith("Checkbox")) {
            return string2;
        }
        if (string2.indexOf("SELECT") == 0) {
            return "select thisModel and (" + string2.substring(6) + ")";
        }
        int n = string.lastIndexOf("[");
        if (n >= 0) {
            if ((n = (string = string.substring(n + 1)).indexOf("]")) >= 0) {
                string = string.substring(0, n);
            }
            string = string.replace('_', ' ');
            if (string2.indexOf("[]") < 0) {
                string2 = "[] " + string2;
            }
            string2 = string2.replace('_', ' ');
            return PT.rep((String)string2, (String)"[]", (String)string);
        }
        if (string2.indexOf("?FILEROOT?") >= 0) {
            string2 = PT.rep((String)string2, (String)"FILEROOT?", (String)this.modelSetRoot);
        } else if (string2.indexOf("?FILE?") >= 0) {
            string2 = PT.rep((String)string2, (String)"FILE?", (String)this.modelSetFileName);
        } else if (string2.indexOf("?PdbId?") >= 0) {
            string2 = PT.rep((String)string2, (String)"PdbId?", (String)"=xxxx");
        }
        return string2;
    }

    @Override
    protected boolean appGetBooleanProperty(String string) {
        return this.vwr.getBooleanProperty(string);
    }

    @Override
    protected String appGetMenuAsString(String string) {
        return new MainPopupResourceBundle(this.strMenuStructure, null).getMenuAsText(string);
    }

    @Override
    protected boolean appIsSpecialCheckBox(SC sC, String string, String string2, boolean bl) {
        if (this.appGetBooleanProperty(string) == bl) {
            return true;
        }
        if (!string.endsWith("P!")) {
            return false;
        }
        if (string.indexOf("??") >= 0) {
            string2 = this.menuSetCheckBoxOption(sC, string, string2);
        } else {
            if (!bl) {
                return true;
            }
            string2 = "set picking " + string.substring(0, string.length() - 2);
        }
        this.appRunScript(string2);
        return true;
    }

    @Override
    protected void appRestorePopupMenu() {
        this.thisPopup = this.popupMenu;
        if (this.vwr.isJS || this.nFrankList < 2) {
            return;
        }
        int n = this.nFrankList;
        while (--n > 0) {
            Object[] objectArray = this.frankList[n];
            this.helper.menuInsertSubMenu((SC)objectArray[0], (SC)objectArray[1], (Integer)objectArray[2]);
        }
        this.nFrankList = 1;
    }

    @Override
    protected void appRunScript(String string) {
        this.vwr.evalStringQuiet(string);
    }

    @Override
    protected void appUpdateSpecialCheckBoxValue(SC sC, String string, boolean bl) {
        if (string.indexOf("#CONFIG") >= 0) {
            this.configurationSelected = string;
            this.updateConfigurationComputedMenu();
            this.updateModelSetComputedMenu();
        }
    }

    private void setFrankMenu(String string) {
        if (this.currentFrankId != null && this.currentFrankId == string && this.nFrankList > 0) {
            return;
        }
        if (this.frankPopup == null) {
            this.frankPopup = this.helper.menuCreatePopup("Frank", this.vwr.html5Applet);
        }
        this.thisPopup = this.frankPopup;
        this.menuRemoveAll(this.frankPopup, 0);
        this.menuCreateItem(this.frankPopup, this.getMenuText("mainMenuText"), "MAIN", "");
        this.currentFrankId = string;
        this.nFrankList = 0;
        this.frankList[this.nFrankList++] = new Object[]{null, null, null};
        if (string != null) {
            int n;
            int n2 = string.indexOf(".", 2) + 1;
            while ((n = string.indexOf(".", n2)) >= 0) {
                SC sC = (SC)this.htMenus.get(string.substring(n2, n));
                this.frankList[this.nFrankList++] = new Object[]{sC.getParent(), sC, this.vwr.isJS ? 0 : this.menuGetListPosition(sC)};
                this.menuAddSubMenu(this.frankPopup, sC);
                n2 = n + 1;
            }
        }
        this.thisPopup = this.popupMenu;
    }

    private boolean checkBoolean(String string) {
        return this.modelSetInfo != null && this.modelSetInfo.get(string) == Boolean.TRUE;
    }

    private void getViewerData() {
        this.modelSetName = this.vwr.ms.modelSetName;
        this.modelSetFileName = this.vwr.getModelSetFileName();
        int n = this.modelSetFileName.lastIndexOf(".");
        this.isZapped = "zapped".equals(this.modelSetName);
        if (this.isZapped || "string".equals(this.modelSetFileName) || "files".equals(this.modelSetFileName) || "string[]".equals(this.modelSetFileName)) {
            this.modelSetFileName = "";
        }
        this.modelSetRoot = this.modelSetFileName.substring(0, n < 0 ? this.modelSetFileName.length() : n);
        if (this.modelSetRoot.length() == 0) {
            this.modelSetRoot = "Jmol";
        }
        this.modelIndex = this.vwr.am.cmi;
        this.modelCount = this.vwr.ms.mc;
        this.ac = this.vwr.ms.getAtomCountInModel(this.modelIndex);
        this.modelSetInfo = this.vwr.getModelSetAuxiliaryInfo();
        this.modelInfo = this.vwr.ms.getModelAuxiliaryInfo(this.modelIndex);
        if (this.modelInfo == null) {
            this.modelInfo = new Hashtable<String, Object>();
        }
        this.isPDB = this.checkBoolean("isPDB");
        this.isMultiFrame = this.modelCount > 1;
        this.hasSymmetry = this.modelInfo.containsKey("hasSymmetry");
        this.isUnitCell = this.modelInfo.containsKey("unitCellParams");
        this.fileHasUnitCell = this.isPDB && this.isUnitCell || this.checkBoolean("fileHasUnitCell");
        this.isLastFrame = this.modelIndex == this.modelCount - 1;
        this.altlocs = this.vwr.ms.getAltLocListInModel(this.modelIndex);
        this.isMultiConfiguration = this.altlocs.length() > 0;
        this.isVibration = this.vwr.modelHasVibrationVectors(this.modelIndex);
        this.haveCharges = this.vwr.ms.getPartialCharges() != null;
        this.haveBFactors = this.vwr.getBooleanProperty("haveBFactors");
        this.cnmrPeaks = (Lst)this.modelInfo.get("jdxAtomSelect_13CNMR");
        this.hnmrPeaks = (Lst)this.modelInfo.get("jdxAtomSelect_1HNMR");
    }

    @Override
    protected void appCheckSpecialMenu(String string, SC sC, String string2) {
        if ("modelSetMenu".equals(string)) {
            this.nullModelSetName = string2;
            this.menuEnable(sC, false);
        }
    }

    @Override
    protected void appUpdateForShow() {
        if (this.updateMode == -1) {
            return;
        }
        this.isTainted = true;
        this.getViewerData();
        this.updateMode = 2;
        this.updateSelectMenu();
        this.updateSpectraMenu();
        this.updateFRAMESbyModelComputedMenu();
        this.updateSceneComputedMenu();
        this.updateModelSetComputedMenu();
        this.updateAboutSubmenu();
        int n = this.Special.size();
        while (--n >= 0) {
            this.updateSpecialMenuItem((SC)this.Special.get(n));
        }
    }

    private void updateFileMenu() {
        boolean bl;
        SC sC = (SC)this.htMenus.get("fileMenu");
        if (sC == null) {
            return;
        }
        String string = this.getMenuText("writeFileTextVARIABLE");
        sC = (SC)this.htMenus.get("writeFileTextVARIABLE");
        boolean bl2 = bl = this.modelSetFileName.equals("zapped") || this.modelSetFileName.equals("");
        if (bl) {
            this.menuSetLabel(sC, "");
            this.menuEnable(sC, false);
        } else {
            this.menuSetLabel(sC, GT.o((String)GT._((String)string), (Object)this.modelSetFileName));
            this.menuEnable(sC, true);
        }
    }

    private String getMenuText(String string) {
        String string2 = this.menuText.getProperty(string);
        return string2 == null ? string : string2;
    }

    private void updateSelectMenu() {
        SC sC = (SC)this.htMenus.get("selectMenuText");
        if (sC == null) {
            return;
        }
        this.menuEnable(sC, this.ac != 0);
        this.menuSetLabel(sC, this.gti("selectMenuText", this.vwr.slm.getSelectionCount()));
    }

    private void updateElementsComputedMenu(BS bS) {
        String string;
        String string2;
        SC sC = (SC)this.htMenus.get("elementsComputedMenu");
        if (sC == null) {
            return;
        }
        this.menuRemoveAll(sC, 0);
        this.menuEnable(sC, false);
        if (bS == null) {
            return;
        }
        int n = bS.nextSetBit(0);
        while (n >= 0) {
            String string3 = Elements.elementNameFromNumber((int)n);
            string2 = Elements.elementSymbolFromNumber((int)n);
            string = string2 + " - " + string3;
            this.menuCreateItem(sC, string, "SELECT " + string3, null);
            n = bS.nextSetBit(n + 1);
        }
        for (n = 4; n < Elements.altElementMax; ++n) {
            int n2 = Elements.elementNumberMax + n;
            if (!bS.get(n2)) continue;
            n2 = Elements.altElementNumberFromIndex((int)n);
            string2 = Elements.elementNameFromNumber((int)n2);
            string = Elements.elementSymbolFromNumber((int)n2);
            String string4 = string + " - " + string2;
            this.menuCreateItem(sC, string4, "SELECT " + string2, null);
        }
        this.menuEnable(sC, true);
    }

    private void updateSpectraMenu() {
        SC sC;
        SC sC2 = (SC)this.htMenus.get("hnmrMenu");
        SC sC3 = (SC)this.htMenus.get("cnmrMenu");
        if (sC2 != null) {
            this.menuRemoveAll(sC2, 0);
        }
        if (sC3 != null) {
            this.menuRemoveAll(sC3, 0);
        }
        if ((sC = (SC)this.htMenus.get("spectraMenu")) == null) {
            return;
        }
        this.menuRemoveAll(sC, 0);
        boolean bl = this.setSpectraMenu(sC2, this.hnmrPeaks) | this.setSpectraMenu(sC3, this.cnmrPeaks);
        if (bl) {
            if (sC2 != null) {
                this.menuAddSubMenu(sC, sC2);
            }
            if (sC3 != null) {
                this.menuAddSubMenu(sC, sC3);
            }
        }
        this.menuEnable(sC, bl);
    }

    private boolean setSpectraMenu(SC sC, Lst<String> lst) {
        int n;
        if (sC == null) {
            return false;
        }
        this.menuEnable(sC, false);
        int n2 = n = lst == null ? 0 : lst.size();
        if (n == 0) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            String string = (String)lst.get(i);
            String string2 = PT.getQuotedAttribute((String)string, (String)"title");
            String string3 = PT.getQuotedAttribute((String)string, (String)"atoms");
            if (string3 == null) continue;
            this.menuCreateItem(sC, string2, "select visible & (@" + PT.rep((String)string3, (String)",", (String)" or @") + ")", "Focus" + i);
        }
        this.menuEnable(sC, true);
        return true;
    }

    private void updateHeteroComputedMenu(Map<String, String> map) {
        SC sC = (SC)this.htMenus.get("PDBheteroComputedMenu");
        if (sC == null) {
            return;
        }
        this.menuRemoveAll(sC, 0);
        this.menuEnable(sC, false);
        if (map == null) {
            return;
        }
        int n = 0;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = entry.getKey();
            String string2 = entry.getValue();
            if (string2.length() > 20) {
                string2 = string2.substring(0, 20) + "...";
            }
            String string3 = string + " - " + string2;
            this.menuCreateItem(sC, string3, "SELECT [" + string + "]", null);
            ++n;
        }
        this.menuEnable(sC, n > 0);
    }

    private void updateSurfMoComputedMenu(Map<String, Object> map) {
        SC sC = (SC)this.htMenus.get("surfMoComputedMenuText");
        if (sC == null) {
            return;
        }
        this.menuRemoveAll(sC, 0);
        Lst lst = map == null ? null : (Lst)map.get("mos");
        int n = lst == null ? 0 : lst.size();
        String string = this.getMenuText("surfMoComputedMenuText");
        if (n == 0) {
            this.menuSetLabel(sC, GT.o((String)GT._((String)string), (Object)""));
            this.menuEnable(sC, false);
            return;
        }
        this.menuSetLabel(sC, GT.i((String)GT._((String)string), (int)n));
        this.menuEnable(sC, true);
        SC sC2 = sC;
        int n2 = n % this.itemMax;
        if (n2 == 0) {
            n2 = this.itemMax;
        }
        int n3 = n > this.itemMax ? 0 : Integer.MIN_VALUE;
        int n4 = n;
        while (--n4 >= 0) {
            Object object;
            if (n3 >= 0 && n3++ % n2 == 0) {
                if (n3 == n2 + 1) {
                    n2 = this.itemMax;
                }
                object = "mo" + n3 + "Menu";
                sC2 = this.menuNewSubMenu(Math.max(n4 + 2 - n2, 1) + "..." + (n4 + 1), this.menuGetId(sC) + "." + (String)object);
                this.menuAddSubMenu(sC, sC2);
                this.htMenus.put(object, sC2);
                n3 = 1;
            }
            object = (Map)lst.get(n4);
            String string2 = "#" + (n4 + 1) + " " + (object.containsKey("type") ? object.get("type") + " " : "") + (object.containsKey("symmetry") ? object.get("symmetry") + " " : "") + (object.containsKey("occupancy") ? "(" + object.get("occupancy") + ") " : "") + (object.containsKey("energy") ? object.get("energy") : "");
            String string3 = "mo " + (n4 + 1);
            this.menuCreateItem(sC2, string2, string3, null);
        }
    }

    private void updateFileTypeDependentMenus() {
        int n = this.NotPDB.size();
        while (--n >= 0) {
            this.menuEnable((SC)this.NotPDB.get(n), !this.isPDB);
        }
        n = this.PDBOnly.size();
        while (--n >= 0) {
            this.menuEnable((SC)this.PDBOnly.get(n), this.isPDB);
        }
        n = this.UnitcellOnly.size();
        while (--n >= 0) {
            this.menuEnable((SC)this.UnitcellOnly.get(n), this.isUnitCell);
        }
        n = this.FileUnitOnly.size();
        while (--n >= 0) {
            this.menuEnable((SC)this.FileUnitOnly.get(n), this.isUnitCell || this.fileHasUnitCell);
        }
        n = this.FileMolOnly.size();
        while (--n >= 0) {
            this.menuEnable((SC)this.FileMolOnly.get(n), this.isUnitCell || this.fileHasUnitCell);
        }
        n = this.SingleModelOnly.size();
        while (--n >= 0) {
            this.menuEnable((SC)this.SingleModelOnly.get(n), this.isLastFrame);
        }
        n = this.FramesOnly.size();
        while (--n >= 0) {
            this.menuEnable((SC)this.FramesOnly.get(n), this.isMultiFrame);
        }
        n = this.VibrationOnly.size();
        while (--n >= 0) {
            this.menuEnable((SC)this.VibrationOnly.get(n), this.isVibration);
        }
        n = this.SymmetryOnly.size();
        while (--n >= 0) {
            this.menuEnable((SC)this.SymmetryOnly.get(n), this.hasSymmetry && this.isUnitCell);
        }
        n = this.ChargesOnly.size();
        while (--n >= 0) {
            this.menuEnable((SC)this.ChargesOnly.get(n), this.haveCharges);
        }
        n = this.TemperatureOnly.size();
        while (--n >= 0) {
            this.menuEnable((SC)this.TemperatureOnly.get(n), this.haveBFactors);
        }
        this.updateSignedAppletItems();
    }

    private void updateSceneComputedMenu() {
        SC sC = (SC)this.htMenus.get("sceneComputedMenu");
        if (sC == null) {
            return;
        }
        this.menuRemoveAll(sC, 0);
        this.menuEnable(sC, false);
        String[] stringArray = (String[])this.vwr.ms.getInfoM("scenes");
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            this.menuCreateItem(sC, stringArray[i], "restore scene " + PT.esc((String)stringArray[i]) + " 1.0", null);
        }
        this.menuEnable(sC, true);
    }

    private void updatePDBComputedMenus() {
        Map map;
        SC sC = (SC)this.htMenus.get("PDBaaResiduesComputedMenu");
        if (sC == null) {
            return;
        }
        this.menuRemoveAll(sC, 0);
        this.menuEnable(sC, false);
        SC sC2 = (SC)this.htMenus.get("PDBnucleicResiduesComputedMenu");
        if (sC2 == null) {
            return;
        }
        this.menuRemoveAll(sC2, 0);
        this.menuEnable(sC2, false);
        SC sC3 = (SC)this.htMenus.get("PDBcarboResiduesComputedMenu");
        if (sC3 == null) {
            return;
        }
        this.menuRemoveAll(sC3, 0);
        this.menuEnable(sC3, false);
        if (this.modelSetInfo == null) {
            return;
        }
        int n = this.modelIndex < 0 ? 0 : this.modelIndex + 1;
        String[] stringArray = (String[])this.modelSetInfo.get("group3Lists");
        this.group3List = stringArray == null ? null : stringArray[n];
        int[] nArray = this.group3Counts = stringArray == null ? null : ((int[][])this.modelSetInfo.get("group3Counts"))[n];
        if (this.group3List == null) {
            return;
        }
        int n2 = 0;
        String string = Group.standardGroupList;
        for (int i = 1; i < 24; ++i) {
            n2 += this.updateGroup3List(sC, string.substring(i * 6 - 4, i * 6 - 1).trim());
        }
        this.menuEnable(sC, (n2 += this.augmentGroup3List(sC, "p>", true)) > 0);
        this.menuEnable((SC)this.htMenus.get("PDBproteinMenu"), n2 > 0);
        n2 = this.augmentGroup3List(sC2, "n>", false);
        this.menuEnable(sC2, n2 > 0);
        this.menuEnable((SC)this.htMenus.get("PDBnucleicMenu"), n2 > 0);
        Map map2 = map = n2 > 0 && this.modelIndex >= 0 ? (Map)this.vwr.ms.getInfo(this.modelIndex, "dssr") : null;
        if (map != null) {
            this.setSecStrucMenu((SC)this.htMenus.get("aaStructureMenu"), map);
        }
        this.menuEnable(sC3, (n2 = this.augmentGroup3List(sC3, "c>", false)) > 0);
        this.menuEnable((SC)this.htMenus.get("PDBcarboMenu"), n2 > 0);
    }

    private boolean setSecStrucMenu(SC sC, Map<String, Object> map) {
        Map map2 = (Map)map.get("counts");
        if (map2 == null) {
            return false;
        }
        Object[] objectArray = new String[map2.size()];
        map2.keySet().toArray(objectArray);
        Arrays.sort(objectArray);
        if (objectArray.length == 0) {
            return false;
        }
        sC.removeAll();
        for (int i = 0; i < objectArray.length; ++i) {
            this.menuCreateItem(sC, (String)objectArray[i] + " (" + map2.get(objectArray[i]) + ")", "select modelIndex=" + this.modelIndex + " && within('dssr', '" + (String)objectArray[i] + "');", null);
        }
        return true;
    }

    private int updateGroup3List(SC sC, String string) {
        int n = 0;
        int n2 = this.group3Counts[this.group3List.indexOf(string) / 6];
        string = string.trim();
        String string2 = null;
        if (n2 > 0) {
            string2 = "SELECT " + string;
            string = string + "  (" + n2 + ")";
            ++n;
        }
        SC sC2 = this.menuCreateItem(sC, string, string2, this.menuGetId(sC) + "." + string);
        if (n2 == 0) {
            this.menuEnable(sC2, false);
        }
        return n;
    }

    private int augmentGroup3List(SC sC, String string, boolean bl) {
        int n = 138;
        int n2 = 0;
        while ((n = this.group3List.indexOf(string, n)) >= 0) {
            if (n2++ == 0 && bl) {
                this.menuAddSeparator(sC);
            }
            int n3 = this.group3Counts[n / 6];
            String string2 = this.group3List.substring(n + 2, n + 5);
            String string3 = string2 + "  (" + n3 + ")";
            this.menuCreateItem(sC, string3, "SELECT [" + string2 + "]", this.menuGetId(sC) + "." + string3);
            ++n;
        }
        return n2;
    }

    private void updateSYMMETRYComputedMenus() {
        this.updateSYMMETRYSelectComputedMenu();
        this.updateSYMMETRYShowComputedMenu();
    }

    private void updateSYMMETRYShowComputedMenu() {
        SC sC = (SC)this.htMenus.get("SYMMETRYShowComputedMenu");
        if (sC == null) {
            return;
        }
        this.menuRemoveAll(sC, 0);
        this.menuEnable(sC, false);
        if (!this.hasSymmetry || this.modelIndex < 0) {
            return;
        }
        Map map = (Map)this.vwr.getProperty("DATA_API", "spaceGroupInfo", null);
        if (map == null) {
            return;
        }
        Object[][] objectArray = (Object[][])map.get("operations");
        if (objectArray == null) {
            return;
        }
        String string = (String)map.get("spaceGroupName");
        this.menuSetLabel(sC, string == null ? GT._((String)"Space Group") : string);
        SC sC2 = sC;
        int n = this.itemMax;
        int n2 = objectArray.length > this.itemMax ? 0 : Integer.MIN_VALUE;
        for (int i = 0; i < objectArray.length; ++i) {
            String string2;
            if (n2 >= 0 && n2++ % n == 0) {
                string2 = "drawsymop" + n2 + "Menu";
                sC2 = this.menuNewSubMenu(i + 1 + "..." + Math.min(i + this.itemMax, objectArray.length), this.menuGetId(sC) + "." + string2);
                this.menuAddSubMenu(sC, sC2);
                this.htMenus.put(string2, sC2);
                n2 = 1;
            }
            if (i == 0) {
                this.menuEnable(this.menuCreateItem(sC2, GT._((String)"none"), "draw sym_* delete", null), true);
            }
            if ((string2 = (String)objectArray[i][1]).indexOf("x1") < 0) {
                string2 = (String)objectArray[i][0];
            }
            String string3 = i + 1 + " " + objectArray[i][2] + " (" + string2 + ")";
            this.menuEnable(this.menuCreateItem(sC2, string3, "draw SYMOP " + (i + 1), null), true);
        }
        this.menuEnable(sC, true);
    }

    private void updateSYMMETRYSelectComputedMenu() {
        SC sC = (SC)this.htMenus.get("SYMMETRYSelectComputedMenu");
        if (sC == null) {
            return;
        }
        this.menuRemoveAll(sC, 0);
        this.menuEnable(sC, false);
        if (!this.hasSymmetry || this.modelIndex < 0) {
            return;
        }
        String[] stringArray = (String[])this.modelInfo.get("symmetryOperations");
        if (stringArray == null) {
            return;
        }
        int[] nArray = (int[])this.modelInfo.get("unitCellRange");
        boolean bl = nArray != null;
        SC sC2 = sC;
        int n = this.itemMax;
        int n2 = stringArray.length > this.itemMax ? 0 : Integer.MIN_VALUE;
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            if (n2 >= 0 && n2++ % n == 0) {
                string = "symop" + n2 + "Menu";
                sC2 = this.menuNewSubMenu(i + 1 + "..." + Math.min(i + this.itemMax, stringArray.length), this.menuGetId(sC) + "." + string);
                this.menuAddSubMenu(sC, sC2);
                this.htMenus.put(string, sC2);
                n2 = 1;
            }
            string = "symop=" + (i + 1) + " # " + stringArray[i];
            this.menuEnable(this.menuCreateItem(sC2, string, "SELECT symop=" + (i + 1), null), bl);
        }
        this.menuEnable(sC, true);
    }

    private void updateFRAMESbyModelComputedMenu() {
        SC sC = (SC)this.htMenus.get("FRAMESbyModelComputedMenu");
        if (sC == null) {
            return;
        }
        this.menuEnable(sC, this.modelCount > 0);
        this.menuSetLabel(sC, this.modelIndex < 0 ? this.gti("allModelsText", this.modelCount) : this.gto("modelMenuText", this.modelIndex + 1 + "/" + this.modelCount));
        this.menuRemoveAll(sC, 0);
        if (this.modelCount < 1) {
            return;
        }
        if (this.modelCount > 1) {
            this.menuCreateCheckboxItem(sC, GT._((String)"All"), "frame 0 ##", null, this.modelIndex < 0, false);
        }
        SC sC2 = sC;
        int n = this.itemMax;
        int n2 = this.modelCount > this.itemMax ? 0 : Integer.MIN_VALUE;
        for (int i = 0; i < this.modelCount; ++i) {
            String string;
            if (n2 >= 0 && n2++ % n == 0) {
                string = "model" + n2 + "Menu";
                sC2 = this.menuNewSubMenu(i + 1 + "..." + Math.min(i + this.itemMax, this.modelCount), this.menuGetId(sC) + "." + string);
                this.menuAddSubMenu(sC, sC2);
                this.htMenus.put(string, sC2);
                n2 = 1;
            }
            string = "" + this.vwr.getModelNumberDotted(i);
            String string2 = this.vwr.getModelName(i);
            String string3 = (String)this.vwr.ms.getInfo(i, "spectrumTypes");
            if (string3 != null && string2.startsWith(string3)) {
                string3 = null;
            }
            if (!string2.equals(string)) {
                int n3 = string2.indexOf(";PATH");
                if (n3 >= 0) {
                    string2 = string2.substring(0, n3);
                }
                if (string2.indexOf("Model[") == 0 && (n3 = string2.indexOf("]:")) >= 0) {
                    string2 = string2.substring(n3 + 2);
                }
                string2 = string + ": " + string2;
            }
            if (string2.length() > 60) {
                string2 = string2.substring(0, 55) + "...";
            }
            if (string3 != null) {
                string2 = string2 + " (" + string3 + ")";
            }
            this.menuCreateCheckboxItem(sC2, string2, "model " + string + " ##", null, this.modelIndex == i, false);
        }
    }

    private void updateConfigurationComputedMenu() {
        SC sC = (SC)this.htMenus.get("configurationComputedMenu");
        if (sC == null) {
            return;
        }
        this.menuEnable(sC, this.isMultiConfiguration);
        if (!this.isMultiConfiguration) {
            return;
        }
        int n = this.altlocs.length();
        this.menuSetLabel(sC, this.gti("configurationMenuText", n));
        this.menuRemoveAll(sC, 0);
        String string = "hide none ##CONFIG";
        this.menuCreateCheckboxItem(sC, GT._((String)"All"), string, null, this.updateMode == 1 && this.configurationSelected.equals(string), false);
        for (int i = 0; i < n; ++i) {
            string = "configuration " + (i + 1) + "; hide thisModel and not selected ##CONFIG";
            String string2 = "" + (i + 1) + " -- \"" + this.altlocs.charAt(i) + "\"";
            this.menuCreateCheckboxItem(sC, string2, string, null, this.updateMode == 1 && this.configurationSelected.equals(string), false);
        }
    }

    private void updateModelSetComputedMenu() {
        SC sC = (SC)this.htMenus.get("modelSetMenu");
        if (sC == null) {
            return;
        }
        this.menuRemoveAll(sC, 0);
        this.menuSetLabel(sC, this.nullModelSetName);
        this.menuEnable(sC, false);
        int n = this.noZapped.length;
        while (--n >= 0) {
            this.menuEnable((SC)this.htMenus.get(this.noZapped[n]), !this.isZapped);
        }
        if (this.modelSetName == null || this.isZapped) {
            return;
        }
        if (this.isMultiFrame) {
            this.modelSetName = this.gti("modelSetCollectionText", this.modelCount);
            if (this.modelSetName.length() > this.titleWidthMax) {
                this.modelSetName = this.modelSetName.substring(0, this.titleWidthMax) + "...";
            }
        } else if (this.vwr.getBooleanProperty("hideNameInPopup")) {
            this.modelSetName = this.getMenuText("hiddenModelSetText");
        } else if (this.modelSetName.length() > this.titleWidthMax) {
            this.modelSetName = this.modelSetName.substring(0, this.titleWidthMax) + "...";
        }
        this.menuSetLabel(sC, this.modelSetName);
        this.menuEnable(sC, true);
        this.menuEnable((SC)this.htMenus.get("computationMenu"), this.ac <= 100);
        this.addMenuItem(sC, this.gti("atomsText", this.ac));
        this.addMenuItem(sC, this.gti("bondsText", this.vwr.ms.getBondCountInModel(this.modelIndex)));
        if (this.isPDB) {
            Lst lst;
            this.menuAddSeparator(sC);
            this.addMenuItem(sC, this.gti("groupsText", this.vwr.ms.getGroupCountInModel(this.modelIndex)));
            this.addMenuItem(sC, this.gti("chainsText", this.vwr.ms.getChainCountInModelWater(this.modelIndex, false)));
            this.addMenuItem(sC, this.gti("polymersText", this.vwr.ms.getBioPolymerCountInModel(this.modelIndex)));
            SC sC2 = (SC)this.htMenus.get("BiomoleculesMenu");
            if (sC2 == null) {
                sC2 = this.menuNewSubMenu(GT._((String)this.getMenuText("biomoleculesMenuText")), this.menuGetId(sC) + ".biomolecules");
                this.menuAddSubMenu(sC, sC2);
            }
            this.menuRemoveAll(sC2, 0);
            this.menuEnable(sC2, false);
            if (this.modelIndex >= 0 && (lst = (Lst)this.vwr.ms.getInfo(this.modelIndex, "biomolecules")) != null) {
                this.menuEnable(sC2, true);
                int n2 = lst.size();
                for (int i = 0; i < n2; ++i) {
                    String string = this.isMultiFrame ? "" : "save orientation;load \"\" FILTER \"biomolecule " + (i + 1) + "\";restore orientation;";
                    int n3 = (Integer)((Map)lst.get(i)).get("atomCount");
                    String string2 = this.gto(this.isMultiFrame ? "biomoleculeText" : "loadBiomoleculeText", new Object[]{i + 1, n3});
                    this.menuCreateItem(sC2, string2, string, null);
                }
            }
        }
        if (this.isApplet && !this.vwr.getBooleanProperty("hideNameInPopup")) {
            this.menuAddSeparator(sC);
            this.menuCreateItem(sC, this.gto("viewMenuText", this.modelSetFileName), "show url", null);
        }
    }

    private String gti(String string, int n) {
        return GT.i((String)GT._((String)this.getMenuText(string)), (int)n);
    }

    private String gto(String string, Object object) {
        return GT.o((String)GT._((String)this.getMenuText(string)), (Object)object);
    }

    private void updateAboutSubmenu() {
        Runtime runtime;
        int n;
        if (this.isApplet) {
            this.setText("APPLETid", this.vwr.appletName);
        }
        if ((n = (runtime = Runtime.getRuntime()).availableProcessors()) > 0) {
            this.setText("JAVAprocessors", GT.i((String)GT._((String)"{0} processors"), (int)n));
        }
        this.setText("JAVAmemTotal", GT.i((String)GT._((String)"{0} MB total"), (int)JmolGenericPopup.convertToMegabytes(runtime.totalMemory())));
        this.setText("JAVAmemMax", GT.i((String)GT._((String)"{0} MB maximum"), (int)JmolGenericPopup.convertToMegabytes(runtime.maxMemory())));
    }

    private void updateLanguageSubmenu() {
        SC sC = (SC)this.htMenus.get("languageComputedMenu");
        if (sC == null) {
            return;
        }
        this.menuRemoveAll(sC, 0);
        String string = GT.getLanguage();
        String string2 = this.menuGetId(sC);
        Language[] languageArray = GT.getLanguageList(null);
        int n = 0;
        for (int i = 0; i < languageArray.length; ++i) {
            if (string.equals(languageArray[i].code)) {
                languageArray[i].display = true;
            }
            if (!languageArray[i].display) continue;
            String string3 = languageArray[i].code;
            String string4 = languageArray[i].language;
            String string5 = languageArray[i].nativeLanguage;
            String string6 = string3 + " - " + GT._((String)string4);
            if (string5 != null && !string5.equals(GT._((String)string4))) {
                string6 = string6 + " - " + string5;
            }
            if (n++ > 0 && n % 4 == 1) {
                this.menuAddSeparator(sC);
            }
            this.menuCreateCheckboxItem(sC, string6, "language = \"" + string3 + "\" ##" + string4, string2 + "." + string3, string.equals(string3), false);
        }
    }

    private void updateSpecialMenuItem(SC sC) {
        sC.setText(this.getSpecialLabel(sC.getName(), sC.getText()));
    }

    protected String getSpecialLabel(String string, String string2) {
        int n = string2.indexOf(" (");
        if (n < 0) {
            n = string2.length();
        }
        String string3 = null;
        if (string.indexOf("captureLooping") >= 0) {
            string3 = this.vwr.am.animationReplayMode == 1073742070 ? "ONCE" : "LOOP";
        } else if (string.indexOf("captureFps") >= 0) {
            string3 = "" + this.vwr.getInt(553648132);
        } else if (string.indexOf("captureMenu") >= 0) {
            string3 = this.vwr.captureParams == null ? GT._((String)"not capturing") : this.vwr.fm.getFilePath((String)this.vwr.captureParams.get("captureFileName"), false, true) + " " + this.vwr.captureParams.get("captureCount");
        }
        return string3 == null ? string2 : string2.substring(0, n) + " (" + string3 + ")";
    }
}

