/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.minimize.forcefield;

import javajs.util.Lst;
import org.jmol.minimize.MinTorsion;
import org.jmol.minimize.forcefield.Calculation;

class MMFFTorsionCalc
extends Calculation {
    MMFFTorsionCalc() {
    }

    void setData(Lst<Object[]> lst, MinTorsion minTorsion) {
        if (this.calcs.isLinear(minTorsion.data[1]) || this.calcs.isLinear(minTorsion.data[2])) {
            return;
        }
        Object object = this.calcs.getParameterObj(minTorsion);
        if (object == null) {
            return;
        }
        lst.addLast((Object)new Object[]{minTorsion.data, object, minTorsion.key});
    }

    @Override
    double compute(Object[] objectArray) {
        this.key = (Integer)objectArray[2];
        this.getPointers(objectArray);
        double d = this.dData[0];
        double d2 = this.dData[1];
        double d3 = this.dData[2];
        this.calcs.setTorsionVariables(this);
        double d4 = Math.cos(this.theta);
        double d5 = d4 * d4;
        this.energy = 0.5 * (d * (1.0 + d4) + d2 * (2.0 - 2.0 * d5) + d3 * (1.0 + d4 * (4.0 * d5 - 3.0)));
        if (this.calcs.gradients) {
            double d6 = Math.sin(this.theta);
            this.dE = 0.5 * (-d * d6 + 4.0 * d2 * d6 * d4 + 3.0 * d3 * d6 * (1.0 - 4.0 * d5));
            this.calcs.addForces(this, 4);
        }
        if (this.calcs.logging) {
            this.calcs.appendLogData(this.calcs.getDebugLine(3, this));
        }
        return this.energy;
    }
}

