/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.locator;

import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.locator.CommonLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorNameFilter;
import de.intarsys.tools.randomaccess.IRandomAccess;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;

public class ClassResourceLocator
extends CommonLocator {
    private final Class clazz;
    private final String name;
    private final String resolvedName;
    private String encoding;
    private ILocator tempFileLocator;

    public ClassResourceLocator(Class clazz, String string) {
        this.clazz = clazz;
        this.name = string;
        this.resolvedName = this.resolveName(string);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ClassResourceLocator)) {
            return false;
        }
        return this.resolvedName.equals(((ClassResourceLocator)object).resolvedName) && this.clazz.equals(((ClassResourceLocator)object).clazz);
    }

    @Override
    public boolean exists() {
        return this.getClazz().getResource(this.getResolvedName()) != null;
    }

    @Override
    public ILocator getChild(String string) {
        String string2 = String.valueOf(this.getResolvedName()) + "/" + string;
        ClassResourceLocator classResourceLocator = new ClassResourceLocator(this.getClazz(), string2);
        return classResourceLocator;
    }

    public Class getClazz() {
        return this.clazz;
    }

    protected String getEncoding() {
        return this.encoding;
    }

    @Override
    public String getFullName() {
        return this.getResolvedName();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.getClazz().getResourceAsStream(this.getResolvedName());
    }

    @Override
    public String getLocalName() {
        if (this.getName() == null) {
            return "unknown";
        }
        return FileTools.getBaseName(this.getName());
    }

    public String getName() {
        return this.name;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        throw new IOException("locator is read only");
    }

    @Override
    public ILocator getParent() {
        int n = this.getResolvedName().lastIndexOf("/");
        if (n > -1) {
            String string = this.getResolvedName().substring(0, n);
            return new ClassResourceLocator(this.getClazz(), string);
        }
        return null;
    }

    @Override
    public synchronized IRandomAccess getRandomAccess() throws IOException {
        if (this.tempFileLocator == null) {
            this.tempFileLocator = this.createTempFileLocator();
        }
        return this.tempFileLocator.getRandomAccess();
    }

    @Override
    public Reader getReader() throws IOException {
        if (this.getEncoding() == null) {
            return new InputStreamReader(this.getInputStream());
        }
        return new InputStreamReader(this.getInputStream(), this.getEncoding());
    }

    @Override
    public Reader getReader(String string) throws IOException {
        if (string == null || string.equals("")) {
            return this.getReader();
        }
        return new InputStreamReader(this.getInputStream(), string);
    }

    protected String getResolvedName() {
        return this.resolvedName;
    }

    @Override
    public String getType() {
        if (this.getName() == null) {
            return "<unknown>";
        }
        return FileTools.getExtension(new File(this.getName()));
    }

    @Override
    public String getTypedName() {
        if (this.getName() == null) {
            return "<unknown>";
        }
        return new File(this.getName()).getName();
    }

    @Override
    public Writer getWriter() throws IOException {
        throw new IOException("locator is read only");
    }

    @Override
    public Writer getWriter(String string) throws IOException {
        throw new IOException("locator is read only");
    }

    public int hashCode() {
        return this.resolvedName.hashCode();
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public boolean isOutOfSynch() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    public boolean isSynchSynchronous() {
        return false;
    }

    @Override
    public ILocator[] listLocators(ILocatorNameFilter iLocatorNameFilter) throws IOException {
        return new ILocator[0];
    }

    private String resolveName(String string) {
        if (string == null) {
            return string;
        }
        if (!string.startsWith("/")) {
            Class<?> clazz = this.getClazz();
            while (clazz.isArray()) {
                clazz = clazz.getComponentType();
            }
            String string2 = clazz.getName();
            int n = string2.lastIndexOf(46);
            if (n != -1) {
                string = "/" + string2.substring(0, n).replace('.', '/') + "/" + string;
            }
        }
        return string;
    }

    protected void setEncoding(String string) {
        this.encoding = string;
    }

    @Override
    public void synch() {
    }

    public String toString() {
        return this.getResolvedName();
    }

    @Override
    public URL toURL() {
        return null;
    }
}

