/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.crypt;

import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSTrailer;
import de.intarsys.pdf.crypt.COSEncryption;
import de.intarsys.pdf.crypt.COSSecurityException;
import de.intarsys.pdf.crypt.ISecurityHandler;
import de.intarsys.pdf.st.STDocument;

public abstract class AbstractSecurityHandler
implements ISecurityHandler {
    private COSDictionary cosEncryption;
    private COSEncryption encryption;
    private STDocument stDoc;

    protected AbstractSecurityHandler() {
    }

    @Override
    public void attach(STDocument sTDocument) {
        if (sTDocument == null) {
            return;
        }
        this.stDoc = sTDocument;
        this.cosEncryption = sTDocument.cosGetTrailer().get(COSTrailer.DK_Encrypt).asDictionary();
        this.encryption = (COSEncryption)COSEncryption.META.createFromCos(this.cosEncryption);
    }

    public COSDictionary cosGetEncryption() {
        return this.cosEncryption;
    }

    @Override
    public void detach(STDocument sTDocument) throws COSSecurityException {
        this.stDoc = null;
    }

    public COSEncryption getEncryption() {
        return this.encryption;
    }

    @Override
    public void initialize(STDocument sTDocument) {
        this.stDoc = sTDocument;
        this.cosEncryption = sTDocument.cosGetTrailer().get(COSTrailer.DK_Encrypt).asDictionary();
        this.encryption = (COSEncryption)COSEncryption.META.createFromCos(this.cosEncryption);
    }

    @Override
    public STDocument stGetDoc() {
        return this.stDoc;
    }
}

