/*
 * Decompiled with CFR 0.152.
 */
package org.grails.compiler.injection.test;

import grails.compiler.ast.GrailsArtefactClassInjector;
import grails.test.mixin.TestMixin;
import grails.test.mixin.TestMixinTargetAware;
import grails.test.mixin.TestRuntimeAwareMixin;
import grails.test.mixin.integration.IntegrationTestMixin;
import grails.test.mixin.support.MixinInstance;
import grails.test.mixin.support.MixinMethod;
import grails.test.mixin.support.SkipMethod;
import grails.test.runtime.TestRuntimeJunitAdapter;
import grails.util.GrailsNameUtils;
import groovy.lang.GroovyObjectSupport;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.ProcessingUnit;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.messages.Message;
import org.codehaus.groovy.control.messages.SimpleMessage;
import org.codehaus.groovy.transform.ASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;
import org.grails.compiler.injection.GrailsASTUtils;
import org.grails.compiler.injection.test.IntegrationTestMixinTransformation;
import org.grails.compiler.injection.test.TestForTransformation;
import org.grails.io.support.MainClassFinder;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;
import org.spockframework.runtime.model.FieldMetadata;
import spock.lang.Shared;

@GroovyASTTransformation(phase=CompilePhase.CANONICALIZATION)
public class TestMixinTransformation
implements ASTTransformation {
    private static final String RULE_FIELD_NAME_BASE = "$testRuntime";
    private static final String JUNIT_ADAPTER_FIELD_NAME = "$testRuntimeJunitAdapter";
    private static final String JUNIT3_RULE_SETUP_TEARDOWN_APPLIED_KEY = "JUNIT3_RULE_SETUP_TEARDOWN_APPLIED_KEY";
    public static final AnnotationNode MIXIN_METHOD_ANNOTATION = new AnnotationNode(new ClassNode(MixinMethod.class));
    static final ClassNode MY_TYPE = new ClassNode(TestMixin.class);
    private static final String MY_TYPE_NAME = "@" + MY_TYPE.getNameWithoutPackage();
    public static final String SPEC_CLASS = "spock.lang.Specification";
    private static final String JUNIT3_CLASS = "junit.framework.TestCase";
    public static final String SET_UP_METHOD = "setUp";
    public static final String TEAR_DOWN_METHOD = "tearDown";
    public static final ClassNode GROOVY_OBJECT_CLASS_NODE = new ClassNode(GroovyObjectSupport.class);
    public static final AnnotationNode TEST_ANNOTATION = new AnnotationNode(new ClassNode(Test.class));
    public static final String VOID_TYPE = "void";
    private static final String EMC_STATEMENT_ADDED_KEY = "EMC_STATEMENT_ADDED_KEY";
    private static final ClassNode SKIP_METHOD_CLASS_NODE = ClassHelper.make(SkipMethod.class);

    public void visit(ASTNode[] astNodes, SourceUnit source) {
        if (!(astNodes[0] instanceof AnnotationNode) || !(astNodes[1] instanceof AnnotatedNode)) {
            throw new RuntimeException("Internal error: wrong types: " + astNodes[0].getClass() + " / " + astNodes[1].getClass());
        }
        AnnotatedNode parent = (AnnotatedNode)astNodes[1];
        AnnotationNode annotationNode = (AnnotationNode)astNodes[0];
        if (!MY_TYPE.equals((Object)annotationNode.getClassNode()) || !(parent instanceof ClassNode)) {
            return;
        }
        String mainClass = MainClassFinder.searchMainClass((URI)source.getSource().getURI());
        ClassNode applicationClassNode = null;
        if (mainClass != null) {
            applicationClassNode = ClassHelper.make((String)mainClass);
        }
        ClassNode classNode = (ClassNode)parent;
        ListExpression values = this.getListOfClasses(annotationNode);
        this.weaveTestMixins(classNode, values, applicationClassNode);
    }

    public void weaveTestMixins(ClassNode classNode, ListExpression values) {
        this.weaveTestMixins(classNode, values, null);
    }

    public void weaveTestMixins(ClassNode classNode, ListExpression values, ClassNode applicationClassNode) {
        String cName = classNode.getName();
        if (classNode.isInterface()) {
            throw new RuntimeException("Error processing interface '" + cName + "'. " + MY_TYPE_NAME + " not allowed for interfaces.");
        }
        this.autoAnnotateSetupTeardown(classNode);
        this.autoAddTestAnnotation(classNode);
        this.weaveMixinsIntoClass(classNode, values, applicationClassNode);
    }

    private void autoAddTestAnnotation(ClassNode classNode) {
        if (TestMixinTransformation.isSpockTest(classNode)) {
            return;
        }
        Map declaredMethodsMap = classNode.getDeclaredMethodsMap();
        for (String methodName : declaredMethodsMap.keySet()) {
            ClassNode returnType;
            MethodNode methodNode = (MethodNode)declaredMethodsMap.get(methodName);
            ClassNode testAnnotationClassNode = TEST_ANNOTATION.getClassNode();
            List existingTestAnnotations = methodNode.getAnnotations(testAnnotationClassNode);
            if (!this.isCandidateMethod(methodNode) || !methodNode.getName().startsWith("test") && existingTestAnnotations.size() <= 0 || existingTestAnnotations.size() != 0 || !(returnType = methodNode.getReturnType()).getName().equals(VOID_TYPE)) continue;
            methodNode.addAnnotation(TEST_ANNOTATION);
        }
    }

    protected ListExpression getListOfClasses(AnnotationNode node) {
        Expression value = node.getMember("value");
        ListExpression values = null;
        if (value instanceof ListExpression) {
            values = (ListExpression)value;
        } else if (value instanceof ClassExpression) {
            values = new ListExpression();
            values.addExpression(value);
        }
        return values;
    }

    public void weaveMixinsIntoClass(ClassNode classNode, ListExpression values) {
        this.weaveMixinsIntoClass(classNode, values, null);
    }

    public void weaveMixinsIntoClass(ClassNode classNode, ListExpression values, ClassNode applicationClassNode) {
        if (values == null) {
            return;
        }
        Junit3TestFixtureMethodHandler junit3MethodHandler = TestMixinTransformation.isJunit3Test(classNode) ? new Junit3TestFixtureMethodHandler(classNode) : null;
        for (Expression current : values.getExpressions()) {
            if (!(current instanceof ClassExpression)) continue;
            ClassExpression ce = (ClassExpression)current;
            ClassNode mixinClassNode = ce.getType();
            this.weaveMixinIntoClass(classNode, mixinClassNode, junit3MethodHandler, applicationClassNode);
        }
        if (junit3MethodHandler != null) {
            junit3MethodHandler.postProcessClassNode();
        }
    }

    protected void weaveMixinIntoClass(ClassNode classNode, ClassNode mixinClassNode, Junit3TestFixtureMethodHandler junit3MethodHandler, ClassNode applicationClassNode) {
        if (mixinClassNode.getName().equals(IntegrationTestMixin.class.getName())) {
            new IntegrationTestMixinTransformation().weaveIntegrationTestMixin(classNode, applicationClassNode);
            return;
        }
        String fieldName = '$' + GrailsNameUtils.getPropertyName((String)mixinClassNode.getName());
        boolean implementsTestRuntimeAwareMixin = GrailsASTUtils.findInterface((ClassNode)mixinClassNode, (ClassNode)ClassHelper.make(TestRuntimeAwareMixin.class)) != null;
        FieldNode mixinFieldNode = null;
        mixinFieldNode = !implementsTestRuntimeAwareMixin ? TestMixinTransformation.addLegacyMixinFieldIfNonExistent(classNode, mixinClassNode, fieldName) : this.addTestRuntimeAwareMixinFieldIfNonExistent(classNode, mixinClassNode, fieldName);
        if (mixinFieldNode == null) {
            return;
        }
        FieldExpression fieldReference = new FieldExpression(mixinFieldNode);
        ClassNode currentMixinClassNode = mixinClassNode;
        while (!currentMixinClassNode.getName().equals("java.lang.Object")) {
            List mixinMethods = currentMixinClassNode.getMethods();
            for (MethodNode mixinMethod : mixinMethods) {
                if (!this.isCandidateMethod(mixinMethod) || TestMixinTransformation.hasDeclaredMethod(classNode, mixinMethod)) continue;
                MethodNode methodNode = mixinMethod.isStatic() ? GrailsASTUtils.addDelegateStaticMethod((ClassNode)classNode, (MethodNode)mixinMethod) : GrailsASTUtils.addDelegateInstanceMethod((ClassNode)classNode, (Expression)fieldReference, (MethodNode)mixinMethod, (boolean)false);
                if (methodNode != null) {
                    methodNode.addAnnotation(MIXIN_METHOD_ANNOTATION);
                    GrailsASTUtils.addCompileStaticAnnotation((AnnotatedNode)methodNode);
                }
                if (junit3MethodHandler == null) continue;
                junit3MethodHandler.handle(mixinMethod, methodNode);
            }
            currentMixinClassNode = currentMixinClassNode.getSuperClass();
            if (junit3MethodHandler == null) continue;
            junit3MethodHandler.mixinSuperClassChanged();
        }
    }

    protected FieldNode addTestRuntimeAwareMixinFieldIfNonExistent(ClassNode classNode, ClassNode fieldType, String fieldName) {
        if (classNode == null || classNode.getField(fieldName) != null) {
            return null;
        }
        MapExpression constructorArguments = new MapExpression();
        constructorArguments.addMapEntryExpression(new MapEntryExpression((Expression)new ConstantExpression((Object)"testClass"), (Expression)new ClassExpression(classNode)));
        FieldNode mixinInstanceFieldNode = classNode.addField(fieldName, 8, fieldType, (Expression)new ConstructorCallExpression(fieldType, (Expression)constructorArguments));
        mixinInstanceFieldNode.addAnnotation(new AnnotationNode(ClassHelper.make(MixinInstance.class)));
        this.addJunitRuleFields(classNode);
        return mixinInstanceFieldNode;
    }

    protected void addJunitRuleFields(ClassNode classNode) {
        if (classNode.getField(JUNIT_ADAPTER_FIELD_NAME) != null) {
            return;
        }
        ClassNode junitAdapterType = ClassHelper.make(TestRuntimeJunitAdapter.class);
        FieldNode junitAdapterFieldNode = classNode.addField(JUNIT_ADAPTER_FIELD_NAME, 8, junitAdapterType, (Expression)new ConstructorCallExpression(junitAdapterType, MethodCallExpression.NO_ARGUMENTS));
        boolean spockTest = TestMixinTransformation.isSpockTest(classNode);
        FieldNode staticRuleFieldNode = classNode.addField("$testRuntimeStaticClassRule", 10, ClassHelper.make(TestRule.class), (Expression)new MethodCallExpression((Expression)new FieldExpression(junitAdapterFieldNode), "newClassRule", (Expression)new ClassExpression(classNode)));
        AnnotationNode classRuleAnnotation = new AnnotationNode(ClassHelper.make(ClassRule.class));
        if (spockTest) {
            FieldNode spockSharedRuleFieldNode = classNode.addField("$testRuntimeSharedClassRule", 1, ClassHelper.make(TestRule.class), (Expression)new FieldExpression(staticRuleFieldNode));
            spockSharedRuleFieldNode.addAnnotation(classRuleAnnotation);
            spockSharedRuleFieldNode.addAnnotation(new AnnotationNode(ClassHelper.make(Shared.class)));
            if (spockTest) {
                this.addSpockFieldMetadata(spockSharedRuleFieldNode, 0);
            }
        } else {
            staticRuleFieldNode.setModifiers(9);
            staticRuleFieldNode.addAnnotation(classRuleAnnotation);
        }
        FieldNode ruleFieldNode = classNode.addField("$testRuntimeRule", 1, ClassHelper.make(TestRule.class), (Expression)new MethodCallExpression((Expression)new FieldExpression(junitAdapterFieldNode), "newRule", (Expression)new VariableExpression("this")));
        ruleFieldNode.addAnnotation(new AnnotationNode(ClassHelper.make(Rule.class)));
        if (spockTest) {
            this.addSpockFieldMetadata(ruleFieldNode, 0);
        }
    }

    private void addSpockFieldMetadata(FieldNode field, int ordinal) {
        AnnotationNode ann = new AnnotationNode(ClassHelper.make(FieldMetadata.class));
        ann.setMember("name", (Expression)new ConstantExpression((Object)field.getName()));
        ann.setMember("ordinal", (Expression)new ConstantExpression((Object)ordinal));
        ann.setMember("line", (Expression)new ConstantExpression((Object)field.getLineNumber()));
        field.addAnnotation(ann);
    }

    protected static FieldNode addLegacyMixinFieldIfNonExistent(ClassNode classNode, ClassNode fieldType, String fieldName) {
        ClassNode targetAwareInterface = GrailsASTUtils.findInterface((ClassNode)fieldType, (ClassNode)new ClassNode(TestMixinTargetAware.class).getPlainNodeReference());
        if (classNode != null && classNode.getField(fieldName) == null) {
            ArgumentListExpression constructorArgument = new ArgumentListExpression();
            if (targetAwareInterface != null) {
                MapExpression namedArguments = new MapExpression();
                namedArguments.addMapEntryExpression(new MapEntryExpression((Expression)new ConstantExpression((Object)"target"), (Expression)new VariableExpression("this")));
                constructorArgument = namedArguments;
            }
            return classNode.addField(fieldName, 2, fieldType, (Expression)new ConstructorCallExpression(fieldType, (Expression)constructorArgument));
        }
        return null;
    }

    protected static boolean hasDeclaredMethod(ClassNode classNode, MethodNode mixinMethod) {
        return classNode.hasDeclaredMethod(mixinMethod.getName(), mixinMethod.getParameters());
    }

    protected static boolean hasAnnotation(MethodNode mixinMethod, Class<?> beforeClass) {
        return !mixinMethod.getAnnotations(new ClassNode(beforeClass)).isEmpty();
    }

    protected static void addMethodCallsToMethod(ClassNode classNode, String name, List<MethodNode> methods) {
        if (methods != null && !methods.isEmpty()) {
            BlockStatement setupMethodBody = TestMixinTransformation.getOrCreateNoArgsMethodBody(classNode, name);
            for (MethodNode beforeMethod : methods) {
                setupMethodBody.addStatement((Statement)new ExpressionStatement((Expression)new MethodCallExpression((Expression)new VariableExpression("this"), beforeMethod.getName(), (Expression)GrailsArtefactClassInjector.ZERO_ARGS)));
            }
        }
    }

    protected static BlockStatement getOrCreateNoArgsMethodBody(ClassNode classNode, String name) {
        MethodNode setupMethod = classNode.getMethod(name, GrailsArtefactClassInjector.ZERO_PARAMETERS);
        return TestMixinTransformation.getOrCreateMethodBody(classNode, setupMethod, name);
    }

    protected static BlockStatement getOrCreateMethodBody(ClassNode classNode, MethodNode methodNode, String name) {
        BlockStatement methodBody;
        if (!methodNode.getDeclaringClass().equals((Object)classNode)) {
            methodBody = new BlockStatement();
            methodNode = new MethodNode(name, 1, methodNode.getReturnType(), GrailsArtefactClassInjector.ZERO_PARAMETERS, null, (Statement)methodBody);
            classNode.addMethod(methodNode);
        } else {
            Statement setupMethodBody = methodNode.getCode();
            if (!(setupMethodBody instanceof BlockStatement)) {
                methodBody = new BlockStatement();
                if (setupMethodBody != null && !(setupMethodBody instanceof ReturnStatement)) {
                    methodBody.addStatement(setupMethodBody);
                }
                methodNode.setCode((Statement)methodBody);
            } else {
                methodBody = (BlockStatement)setupMethodBody;
            }
        }
        return methodBody;
    }

    public static boolean isJunit3Test(ClassNode classNode) {
        return GrailsASTUtils.isSubclassOf((ClassNode)classNode, (String)JUNIT3_CLASS);
    }

    public static boolean isSpockTest(ClassNode classNode) {
        return GrailsASTUtils.isSubclassOf((ClassNode)classNode, (String)SPEC_CLASS);
    }

    protected boolean isCandidateMethod(MethodNode declaredMethod) {
        return !this.shouldSkipMethod(declaredMethod) && TestMixinTransformation.isAddableMethod(declaredMethod) && !TestMixinTransformation.hasSimilarMethod(declaredMethod, ClassHelper.make(TestRuntimeAwareMixin.class));
    }

    protected boolean shouldSkipMethod(MethodNode declaredMethod) {
        return declaredMethod.getAnnotations(SKIP_METHOD_CLASS_NODE).size() > 0;
    }

    public static boolean isAddableMethod(MethodNode declaredMethod) {
        ClassNode groovyMethods = GROOVY_OBJECT_CLASS_NODE;
        String methodName = declaredMethod.getName();
        return !declaredMethod.isSynthetic() && !methodName.contains("$") && Modifier.isPublic(declaredMethod.getModifiers()) && !Modifier.isAbstract(declaredMethod.getModifiers()) && !TestMixinTransformation.hasSimilarMethod(declaredMethod, groovyMethods);
    }

    protected static boolean hasSimilarMethod(MethodNode declaredMethod, ClassNode groovyMethods) {
        return groovyMethods.hasMethod(declaredMethod.getName(), declaredMethod.getParameters());
    }

    protected void error(SourceUnit source, String me) {
        source.getErrorCollector().addError((Message)new SimpleMessage(me, (ProcessingUnit)source), true);
    }

    protected void autoAnnotateSetupTeardown(ClassNode classNode) {
        MethodNode tearDown;
        MethodNode setupMethod = classNode.getDeclaredMethod(SET_UP_METHOD, GrailsArtefactClassInjector.ZERO_PARAMETERS);
        if (setupMethod != null && setupMethod.getAnnotations(TestForTransformation.BEFORE_CLASS_NODE).size() == 0) {
            setupMethod.addAnnotation(TestForTransformation.BEFORE_ANNOTATION);
        }
        if ((tearDown = classNode.getDeclaredMethod(TEAR_DOWN_METHOD, GrailsArtefactClassInjector.ZERO_PARAMETERS)) != null && tearDown.getAnnotations(TestForTransformation.AFTER_CLASS_NODE).size() == 0) {
            tearDown.addAnnotation(TestForTransformation.AFTER_ANNOTATION);
        }
    }

    private static class Junit3TestFixtureMethodHandler {
        ClassNode classNode;
        List<MethodNode> beforeMethods = new ArrayList<MethodNode>();
        List<MethodNode> afterMethods = new ArrayList<MethodNode>();
        int beforeClassMethodCount = 0;
        int afterClassMethodCount = 0;
        boolean hasExistingSetUp;
        boolean hasExistingTearDown;

        public Junit3TestFixtureMethodHandler(ClassNode classNode) {
            this.classNode = classNode;
            this.hasExistingSetUp = classNode.hasDeclaredMethod(TestMixinTransformation.SET_UP_METHOD, Parameter.EMPTY_ARRAY);
            this.hasExistingTearDown = classNode.hasDeclaredMethod(TestMixinTransformation.TEAR_DOWN_METHOD, Parameter.EMPTY_ARRAY);
        }

        public void mixinSuperClassChanged() {
            this.beforeClassMethodCount = 0;
            this.afterClassMethodCount = 0;
        }

        public void handle(MethodNode mixinMethod, MethodNode weavedMethod) {
            if (TestMixinTransformation.hasAnnotation(mixinMethod, Before.class)) {
                this.beforeMethods.add(mixinMethod);
            }
            if (TestMixinTransformation.hasAnnotation(mixinMethod, BeforeClass.class)) {
                this.beforeMethods.add(this.beforeClassMethodCount++, mixinMethod);
            }
            if (TestMixinTransformation.hasAnnotation(mixinMethod, After.class)) {
                this.afterMethods.add(mixinMethod);
            }
            if (TestMixinTransformation.hasAnnotation(mixinMethod, AfterClass.class)) {
                this.afterMethods.add(this.afterClassMethodCount++, mixinMethod);
            }
        }

        public void postProcessClassNode() {
            TestMixinTransformation.addMethodCallsToMethod(this.classNode, TestMixinTransformation.SET_UP_METHOD, this.beforeMethods);
            TestMixinTransformation.addMethodCallsToMethod(this.classNode, TestMixinTransformation.TEAR_DOWN_METHOD, this.afterMethods);
            this.handleTestRuntimeJunitSetUpAndTearDownCalls();
        }

        private void handleTestRuntimeJunitSetUpAndTearDownCalls() {
            FieldNode junitAdapterFieldNode = this.classNode.getDeclaredField(TestMixinTransformation.JUNIT_ADAPTER_FIELD_NAME);
            if (junitAdapterFieldNode == null) {
                return;
            }
            if (this.classNode.redirect().getNodeMetaData((Object)TestMixinTransformation.JUNIT3_RULE_SETUP_TEARDOWN_APPLIED_KEY) != Boolean.TRUE) {
                BlockStatement setUpMethodBody = TestMixinTransformation.getOrCreateNoArgsMethodBody(this.classNode, TestMixinTransformation.SET_UP_METHOD);
                if (!this.hasExistingSetUp) {
                    setUpMethodBody.getStatements().add(0, new ExpressionStatement((Expression)new MethodCallExpression((Expression)new VariableExpression("super"), TestMixinTransformation.SET_UP_METHOD, (Expression)GrailsArtefactClassInjector.ZERO_ARGS)));
                }
                BlockStatement tearDownMethodBody = TestMixinTransformation.getOrCreateNoArgsMethodBody(this.classNode, TestMixinTransformation.TEAR_DOWN_METHOD);
                setUpMethodBody.getStatements().add(1, new ExpressionStatement((Expression)new MethodCallExpression((Expression)new FieldExpression(junitAdapterFieldNode), TestMixinTransformation.SET_UP_METHOD, (Expression)new VariableExpression("this"))));
                tearDownMethodBody.addStatement((Statement)new ExpressionStatement((Expression)new MethodCallExpression((Expression)new FieldExpression(junitAdapterFieldNode), TestMixinTransformation.TEAR_DOWN_METHOD, (Expression)new VariableExpression("this"))));
                if (!this.hasExistingTearDown) {
                    tearDownMethodBody.addStatement((Statement)new ExpressionStatement((Expression)new MethodCallExpression((Expression)new VariableExpression("super"), TestMixinTransformation.TEAR_DOWN_METHOD, (Expression)GrailsArtefactClassInjector.ZERO_ARGS)));
                }
                this.classNode.redirect().setNodeMetaData((Object)TestMixinTransformation.JUNIT3_RULE_SETUP_TEARDOWN_APPLIED_KEY, (Object)Boolean.TRUE);
            }
        }
    }
}

