/*
 * Decompiled with CFR 0.152.
 */
package reactor.spring.core.task;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import reactor.Environment;
import reactor.core.dispatch.AbstractLifecycleDispatcher;
import reactor.core.dispatch.WorkQueueDispatcher;
import reactor.fn.Consumer;
import reactor.fn.timer.Timer;
import reactor.jarjar.com.lmax.disruptor.BlockingWaitStrategy;
import reactor.jarjar.com.lmax.disruptor.WaitStrategy;
import reactor.jarjar.com.lmax.disruptor.dsl.ProducerType;
import reactor.spring.core.task.AbstractAsyncTaskExecutor;
import reactor.spring.core.task.AsyncTaskExceptionEvent;

public class WorkQueueAsyncTaskExecutor
extends AbstractAsyncTaskExecutor
implements ApplicationEventPublisherAware {
    private final Logger log = LoggerFactory.getLogger(WorkQueueAsyncTaskExecutor.class);
    private ProducerType producerType;
    private WaitStrategy waitStrategy;
    private ApplicationEventPublisher eventPublisher;
    private WorkQueueDispatcher workQueue;

    public WorkQueueAsyncTaskExecutor(Environment env) {
        this(env.getTimer());
    }

    public WorkQueueAsyncTaskExecutor(Timer timer) {
        super(timer);
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public void afterPropertiesSet() throws Exception {
        this.workQueue = new WorkQueueDispatcher(this.getName(), this.getThreads(), this.getBacklog(), (Consumer)new Consumer<Throwable>(){

            public void accept(Throwable throwable) {
                if (null != WorkQueueAsyncTaskExecutor.this.eventPublisher) {
                    WorkQueueAsyncTaskExecutor.this.eventPublisher.publishEvent((ApplicationEvent)new AsyncTaskExceptionEvent(throwable));
                } else {
                    WorkQueueAsyncTaskExecutor.this.log.error(throwable.getMessage(), throwable);
                }
            }
        }, null != this.producerType ? this.producerType : ProducerType.MULTI, (WaitStrategy)(null != this.waitStrategy ? this.waitStrategy : new BlockingWaitStrategy()));
    }

    public ProducerType getProducerType() {
        return this.producerType;
    }

    public void setProducerType(ProducerType producerType) {
        this.producerType = producerType;
    }

    public WaitStrategy getWaitStrategy() {
        return this.waitStrategy;
    }

    public void setWaitStrategy(WaitStrategy waitStrategy) {
        this.waitStrategy = waitStrategy;
    }

    @Override
    protected AbstractLifecycleDispatcher getDispatcher() {
        return this.workQueue;
    }
}

