/*
 * Decompiled with CFR 0.152.
 */
package jspecview.export;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.Lst;
import javajs.util.OC;
import javajs.util.PT;
import jspecview.common.Coordinate;
import org.jmol.util.Logger;

class FormContext {
    String[] tokens;
    Hashtable<String, Object> context = new Hashtable();
    Lst<FormToken> formTokens;
    int commandLevel;
    Lst<Integer> cmds = new Lst();
    String strError;
    static final int VT_DATA = 0;
    static final int VT_IF = 1;
    static final int VT_ELSE = 2;
    static final int VT_ELSEIF = 3;
    static final int VT_END = 4;
    static final int VT_FOREACH = 5;
    static final int VT_SET = 6;
    private static final String[] ops = new String[]{"==", "!=", "="};
    private static final int OP_EEQ = 0;
    private static final int OP_NE = 1;
    private static final int OP_EQ = 2;

    FormContext() {
    }

    void put(String string, Object object) {
        if (object == null) {
            object = "";
        }
        this.context.put(string, object);
    }

    String setTemplate(String string) {
        String string2 = this.getFormTokens(string);
        if (string2 != null) {
            return string2;
        }
        return null;
    }

    private String getFormTokens(String string) {
        this.formTokens = new Lst();
        if (string.indexOf("\r\n") >= 0) {
            string = PT.replaceAllCharacters(string, "\r\n", "\n");
        }
        string = string.replace('\r', '\n');
        String[] stringArray = string.split("\n");
        String string2 = "";
        for (int i = 0; i < stringArray.length && this.strError == null; ++i) {
            char c;
            String string3 = stringArray[i];
            int n = string3.length();
            while (--n >= 0 && ((c = string3.charAt(n)) == ' ' || c == '\t')) {
            }
            if ((string3 = string3.substring(0, n + 1)).length() == 0) continue;
            int n2 = -1;
            int n3 = string3.length();
            while (++n2 < n3 && Character.isWhitespace(string3.charAt(n2))) {
            }
            if (string3.indexOf("#") == n2) {
                if (string2.length() > 0) {
                    new FormToken(string2, 0);
                    string2 = "";
                }
                if (this.strError != null) break;
                new FormToken(string3, n2);
                continue;
            }
            string2 = string2 + string3 + "\n";
        }
        if (string2.length() > 0 && this.strError == null) {
            new FormToken(string2, 0);
        }
        return this.strError;
    }

    public String merge(OC oC) {
        block7: for (int i = 0; i < this.formTokens.size() && this.strError == null; ++i) {
            FormToken formToken = (FormToken)this.formTokens.get(i);
            switch (formToken.cmdType) {
                case 0: {
                    String string = this.fillData(formToken.data);
                    oC.append(string);
                    continue block7;
                }
                case 1: {
                    if (this.evaluate(formToken.data, true)) {
                        formToken.endPtr = -formToken.endPtr;
                        continue block7;
                    }
                    i = formToken.endPtr - 1;
                    continue block7;
                }
                case 2: 
                case 3: {
                    int n = ((FormToken)this.formTokens.get((int)formToken.cmdPtr)).endPtr;
                    if (n < 0) {
                        ((FormToken)this.formTokens.get((int)formToken.cmdPtr)).endPtr = -n;
                        do {
                            formToken = (FormToken)this.formTokens.get(formToken.endPtr);
                        } while (formToken.cmdType != 4);
                        i = formToken.ptr;
                        continue block7;
                    }
                    if (formToken.cmdType != 3) continue block7;
                    if (this.evaluate(formToken.data, true)) {
                        formToken.endPtr = -formToken.endPtr;
                        continue block7;
                    }
                    i = formToken.endPtr - 1;
                    continue block7;
                }
                case 5: {
                    this.foreach(formToken);
                }
                case 4: {
                    formToken = (FormToken)this.formTokens.get(formToken.cmdPtr);
                    if (formToken.cmdType != 5 || formToken.vc == null) continue block7;
                    if (++formToken.pointCount == formToken.vc.size()) {
                        i = formToken.endPtr;
                        continue block7;
                    }
                    Object e = formToken.vc.get(formToken.pointCount);
                    if (e instanceof Coordinate) {
                        Coordinate coordinate = (Coordinate)e;
                        this.context.put("pointCount", new Integer(formToken.pointCount));
                        this.context.put(formToken.var + ".xVal", new Double(coordinate.getXVal()));
                        this.context.put(formToken.var + ".yVal", new Double(coordinate.getYVal()));
                        this.context.put(formToken.var + ".getXString()", coordinate.getXString());
                        this.context.put(formToken.var + ".getYString()", coordinate.getYString());
                    } else if (e instanceof Map) {
                        for (Map.Entry entry : ((Map)e).entrySet()) {
                            this.context.put(formToken.var + "." + (String)entry.getKey(), entry.getValue());
                        }
                    }
                    i = formToken.cmdPtr;
                    continue block7;
                }
            }
        }
        return this.strError != null ? this.strError : (oC != null ? oC.toString() : null);
    }

    private void foreach(FormToken formToken) {
        String string = formToken.data;
        string = string.replace('(', ' ');
        String[] stringArray = PT.getTokens(string = string.replace(')', ' '));
        if (stringArray.length != 4) {
            return;
        }
        formToken.var = stringArray[1].substring(1);
        Object object = this.context.get(stringArray[3].substring(1));
        if (object instanceof Lst) {
            formToken.vc = (Lst)object;
        }
        formToken.cmdPtr = formToken.ptr;
        formToken.pointCount = -1;
    }

    private static int findOp(String string) {
        int n = ops.length;
        while (--n >= 0) {
            if (!ops[n].equals(string)) continue;
            return n;
        }
        return -1;
    }

    private boolean evaluate(String string, boolean bl) {
        int n = string.indexOf("(");
        if (n < 0) {
            this.strError = "missing ( in " + string;
            return false;
        }
        if ((n = (string = string.substring(n + 1)).lastIndexOf(")")) < 0) {
            this.strError = "missing ) in " + string;
            return false;
        }
        string = string.substring(0, n);
        string = PT.rep(string, "=", " = ");
        string = PT.rep(string, "!", " ! ");
        string = PT.rep(string, "<", " < ");
        string = PT.rep(string, ">", " > ");
        string = PT.rep(string, "=  =", "==");
        string = PT.rep(string, "<  =", "<=");
        string = PT.rep(string, ">  =", ">=");
        string = PT.rep(string, "!  =", "!=");
        String[] stringArray = PT.getTokens(string);
        String string2 = stringArray[0].substring(1);
        boolean bl2 = false;
        boolean bl3 = false;
        String string3 = null;
        String string4 = "";
        try {
            switch (stringArray.length) {
                case 1: {
                    string3 = this.getValue(string2);
                    return !string3.equals("") && !string3.equals("false");
                }
                case 2: {
                    if (!string2.equals("!")) break;
                    string2 = PT.trim(stringArray[1], "$ ");
                    string3 = this.getValue(string2);
                    return string3.equals("false") || string3.equals("");
                }
                case 3: {
                    string2 = PT.trim(stringArray[0], "$ ");
                    string3 = this.getValue(string2);
                    string4 = PT.trim(stringArray[2], " \"");
                    switch (FormContext.findOp(stringArray[1])) {
                        case 0: 
                        case 2: {
                            return string3.equals(string4);
                        }
                        case 1: {
                            return !string3.equals(string4);
                        }
                    }
                    Logger.warn("???? " + string2 + " " + string4 + " " + string3);
                }
            }
        }
        catch (Exception exception) {
            Logger.warn(exception.toString() + " in VelocityContext.merge");
        }
        return bl2 ? !bl3 : bl3;
    }

    private String getValue(String string) {
        return this.context.containsKey(string) ? this.context.get(string).toString() : "";
    }

    private String fillData(String string) {
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            String string2;
            char c;
            while (n < n2 && string.charAt(n++) != '$') {
            }
            if (n == n2) break;
            int n3 = n;
            while (++n3 < n2 && (Character.isLetterOrDigit(c = string.charAt(n3)) || c == '.' || c == '_')) {
            }
            if (n3 < n2 && string.charAt(n3) == '(') {
                n3 += 2;
            }
            if (!this.context.containsKey(string2 = string.substring(n, n3))) continue;
            Object object = this.context.get(string2);
            String string3 = object instanceof Coordinate ? object.toString() : object.toString();
            string = string.substring(0, n - 1) + string3 + string.substring(n3);
            n2 = string.length();
            n += string3.length();
        }
        return string;
    }

    class FormToken {
        boolean hasVariable;
        int cmdType;
        int cmdPtr = -1;
        int endPtr = -1;
        int ptr;
        String var;
        Lst<Object> vc;
        int pointCount;
        String data;

        FormToken(String string, int n) {
            this.hasVariable = string.indexOf("$") >= 0;
            this.data = string;
            if (string.indexOf("#") != n) {
                FormContext.this.formTokens.addLast(this);
                return;
            }
            this.ptr = FormContext.this.formTokens.size();
            boolean bl = false;
            if (string.indexOf("#end") == n) {
                this.cmdType = 4;
                this.endPtr = this.ptr;
                --FormContext.this.commandLevel;
                if (FormContext.this.commandLevel < 0) {
                    FormContext.this.strError = "misplaced #end";
                    return;
                }
                this.cmdPtr = (Integer)FormContext.this.cmds.remove(0);
                ((FormToken)FormContext.this.formTokens.get((int)this.cmdPtr)).endPtr = this.ptr;
            } else {
                FormToken formToken;
                ++FormContext.this.commandLevel;
                if (string.indexOf("#if") == n) {
                    this.cmdType = 1;
                    FormContext.this.cmds.add(0, new Integer(this.ptr));
                } else if (string.indexOf("#foreach") == n) {
                    this.cmdType = 5;
                    FormContext.this.cmds.add(0, new Integer(this.ptr));
                    this.cmdPtr = this.ptr;
                    if (string.indexOf("#end") > 0) {
                        int n2 = string.indexOf(")") + 1;
                        this.data = string.substring(0, n2);
                        FormContext.this.formTokens.addLast(this);
                        new FormToken(string.substring(n2, string.indexOf("#end")), 0);
                        new FormToken("#end", 0);
                        return;
                    }
                } else if (string.indexOf("#elseif") == n) {
                    if (FormContext.this.cmds.size() == 0) {
                        FormContext.this.strError = "misplaced #elseif";
                        return;
                    }
                    this.cmdType = 3;
                    this.cmdPtr = (Integer)FormContext.this.cmds.remove(0);
                    formToken = (FormToken)FormContext.this.formTokens.get(this.cmdPtr);
                    bl = true;
                    formToken.endPtr = this.ptr;
                    FormContext.this.cmds.add(0, new Integer(this.ptr));
                } else if (string.indexOf("#else") == n) {
                    if (FormContext.this.cmds.size() == 0) {
                        FormContext.this.strError = "misplaced #else";
                        return;
                    }
                    this.cmdType = 2;
                    bl = true;
                    this.cmdPtr = (Integer)FormContext.this.cmds.remove(0);
                    ((FormToken)FormContext.this.formTokens.get((int)this.cmdPtr)).endPtr = this.ptr;
                    FormContext.this.cmds.add(0, new Integer(this.ptr));
                } else {
                    Logger.warn("??? " + string);
                }
                if (bl) {
                    formToken = (FormToken)FormContext.this.formTokens.get(this.cmdPtr);
                    if (formToken.cmdType != 1 && formToken.cmdType != 3) {
                        FormContext.this.strError = "misplaced " + string.trim();
                        return;
                    }
                }
            }
            FormContext.this.formTokens.addLast(this);
        }
    }
}

