/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import org.jmol.viewer.MotionPoint;
import org.jmol.viewer.Viewer;
import org.jmol.viewer.binding.Binding;

class Gesture {
    private int action;
    MotionPoint[] nodes;
    private int ptNext;
    private long time0;
    private Viewer vwr;

    public Gesture(int n, Viewer viewer) {
        this.vwr = viewer;
        this.nodes = new MotionPoint[n];
        for (int i = 0; i < n; ++i) {
            this.nodes[i] = new MotionPoint();
        }
    }

    void setAction(int n, long l) {
        this.action = n;
        this.ptNext = 0;
        this.time0 = l;
        for (int i = 0; i < this.nodes.length; ++i) {
            this.nodes[i].index = -1;
        }
    }

    int add(int n, int n2, int n3, long l) {
        this.action = n;
        this.getNode(this.ptNext).set(this.ptNext, n2, n3, l - this.time0);
        ++this.ptNext;
        return this.ptNext;
    }

    public long getTimeDifference(int n) {
        if ((n = this.getPointCount2(n, 0)) < 2) {
            return 0L;
        }
        MotionPoint motionPoint = this.getNode(this.ptNext - 1);
        MotionPoint motionPoint2 = this.getNode(this.ptNext - n);
        return motionPoint.time - motionPoint2.time;
    }

    public float getSpeedPixelsPerMillisecond(int n, int n2) {
        if ((n = this.getPointCount2(n, n2)) < 2) {
            return 0.0f;
        }
        MotionPoint motionPoint = this.getNode(this.ptNext - 1 - n2);
        MotionPoint motionPoint2 = this.getNode(this.ptNext - n - n2);
        float f = (float)(motionPoint.x - motionPoint2.x) / (float)this.vwr.getScreenWidth() * 360.0f;
        float f2 = (float)(motionPoint.y - motionPoint2.y) / (float)this.vwr.getScreenHeight() * 360.0f;
        return (float)Math.sqrt(f * f + f2 * f2) / (float)(motionPoint.time - motionPoint2.time);
    }

    int getDX(int n, int n2) {
        if ((n = this.getPointCount2(n, n2)) < 2) {
            return 0;
        }
        MotionPoint motionPoint = this.getNode(this.ptNext - 1 - n2);
        MotionPoint motionPoint2 = this.getNode(this.ptNext - n - n2);
        return motionPoint.x - motionPoint2.x;
    }

    int getDY(int n, int n2) {
        if ((n = this.getPointCount2(n, n2)) < 2) {
            return 0;
        }
        MotionPoint motionPoint = this.getNode(this.ptNext - 1 - n2);
        MotionPoint motionPoint2 = this.getNode(this.ptNext - n - n2);
        return motionPoint.y - motionPoint2.y;
    }

    int getPointCount() {
        return this.ptNext;
    }

    private int getPointCount2(int n, int n2) {
        if (n > this.nodes.length - n2) {
            n = this.nodes.length - n2;
        }
        int n3 = n + 1;
        while (--n3 >= 0 && this.getNode((int)(this.ptNext - n3 - n2)).index < 0) {
        }
        return n3;
    }

    MotionPoint getNode(int n) {
        return this.nodes[(n + this.nodes.length + this.nodes.length) % this.nodes.length];
    }

    public String toString() {
        if (this.nodes.length == 0) {
            return "" + this;
        }
        return Binding.getMouseActionName(this.action, false) + " nPoints = " + this.ptNext + " " + this.nodes[0];
    }
}

