/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.export;

import java.util.Map;
import javajs.awt.Font;
import javajs.util.M3;
import javajs.util.M4;
import javajs.util.P3;
import javajs.util.P3i;
import javajs.util.T3;
import org.jmol.api.Interface;
import org.jmol.api.JmolRendererInterface;
import org.jmol.export.___Exporter;
import org.jmol.g3d.HermiteRenderer;
import org.jmol.modelset.Atom;
import org.jmol.util.GData;
import org.jmol.util.MeshSurface;
import org.jmol.viewer.Viewer;

public class Export3D
implements JmolRendererInterface {
    protected ___Exporter exporter;
    private double privateKey;
    private GData gdata;
    private short colix;
    private HermiteRenderer hermite3d;
    private int width;
    private int height;
    private int slab;
    private int depth;
    String exportName;
    private boolean isWebGL;
    private boolean isCartesian;
    private P3 ptA = new P3();
    private P3 ptB = new P3();
    private P3 ptC = new P3();
    private P3 ptD = new P3();

    @Override
    public Object initializeExporter(Viewer viewer, double d, GData gData, Map<String, Object> map) {
        this.exportName = (String)map.get("type");
        this.isWebGL = this.exportName.equals("JS");
        this.exporter = (___Exporter)Interface.getOption("export." + (this.isWebGL ? "" : "_") + this.exportName + "Exporter", viewer, "export");
        if (this.exporter == null) {
            return null;
        }
        this.exporter.export3D = this;
        this.isCartesian = this.exporter.exportType == 1;
        this.gdata = gData;
        gData.setNewWindowParametersForExport();
        this.slab = gData.slab;
        this.width = gData.width;
        this.height = gData.height;
        this.privateKey = d;
        return this.initializeOutput(viewer, d, map) ? this.exporter : null;
    }

    @Override
    public boolean initializeOutput(Viewer viewer, double d, Map<String, Object> map) {
        return this.exporter.initializeOutput(viewer, d, this.gdata, map);
    }

    @Override
    public int getExportType() {
        return this.exporter.exportType;
    }

    @Override
    public String getExportName() {
        return this.exportName;
    }

    @Override
    public String finalizeOutput() {
        return this.exporter.finalizeOutput();
    }

    @Override
    public void setSlab(int n) {
        this.gdata.setSlab(n);
        this.slab = this.gdata.slab;
    }

    @Override
    public void setSlabAndZShade(int n, int n2, int n3, int n4, int n5) {
        this.gdata.setSlab(n);
        this.slab = this.gdata.slab;
        this.gdata.setDepth(n2);
        this.depth = this.gdata.depth;
    }

    @Override
    public void renderBackground(JmolRendererInterface jmolRendererInterface) {
        if (!this.isCartesian) {
            this.gdata.renderBackground(jmolRendererInterface);
        }
    }

    @Override
    public void drawAtom(Atom atom) {
        this.exporter.drawAtom(atom);
    }

    @Override
    public void drawRect(int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.isWebGL) {
            return;
        }
        if (n4 != 0 && this.gdata.isClippedZ(n4)) {
            return;
        }
        int n7 = n5 - 1;
        int n8 = n6 - 1;
        int n9 = n + n7;
        int n10 = n2 + n8;
        if (n2 >= 0 && n2 < this.height) {
            this.drawHLine(n, n2, n3, n7);
        }
        if (n10 >= 0 && n10 < this.height) {
            this.drawHLine(n, n10, n3, n7);
        }
        if (n >= 0 && n < this.width) {
            this.drawVLine(n, n2, n3, n8);
        }
        if (n9 >= 0 && n9 < this.width) {
            this.drawVLine(n9, n2, n3, n8);
        }
    }

    private void drawHLine(int n, int n2, int n3, int n4) {
        int n5 = this.gdata.getColorArgbOrGray(this.colix);
        if (n4 < 0) {
            n += n4;
            n4 = -n4;
        }
        for (int i = 0; i <= n4; ++i) {
            this.exporter.drawTextPixel(n5, n + i, n2, n3);
        }
    }

    private void drawVLine(int n, int n2, int n3, int n4) {
        int n5 = this.gdata.getColorArgbOrGray(this.colix);
        if (n4 < 0) {
            n2 += n4;
            n4 = -n4;
        }
        for (int i = 0; i <= n4; ++i) {
            this.exporter.drawTextPixel(n5, n, n2 + i, n3);
        }
    }

    @Override
    public void drawFilledCircle(short s, short s2, int n, int n2, int n3, int n4) {
        if (!this.gdata.isClippedZ(n4)) {
            this.exporter.drawFilledCircle(s, s2, n, n2, n3, n4);
        }
    }

    public void drawCircle(short s, int n, int n2, int n3, int n4, boolean bl) {
        if (!this.gdata.isClippedZ(n4)) {
            this.exporter.drawCircle(n2, n3, n4, n, s, bl);
        }
    }

    @Override
    public void fillSphereXYZ(int n, int n2, int n3, int n4) {
        this.ptA.set(n2, n3, n4);
        this.fillSphereBits(n, this.ptA);
    }

    @Override
    public void fillSphereI(int n, P3i p3i) {
        this.ptA.set(p3i.x, p3i.y, p3i.z);
        this.fillSphereBits(n, this.ptA);
    }

    @Override
    public void fillSphereBits(int n, P3 p3) {
        if (n != 0) {
            this.exporter.fillSphere(this.colix, n, p3);
        }
    }

    @Override
    public void fillTextRect(int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.isCartesian || this.gdata.isClippedZ(n4)) {
            return;
        }
        n3 = this.exporter.fixScreenZ(n3);
        this.ptA.set(n, n2, n3);
        this.ptB.set(n + n5, n2, n3);
        this.ptC.set(n + n5, n2 + n6, n3);
        this.ptD.set(n, n2 + n6, n3);
        this.fillQuadrilateral(this.ptA, this.ptB, this.ptC, this.ptD);
    }

    @Override
    public void drawString(String string, Font font, int n, int n2, int n3, int n4, short s) {
        if (string != null && !this.gdata.isClippedZ(n4)) {
            this.drawStringNoSlab(string, font, n, n2, n3, s);
        }
    }

    @Override
    public void drawStringNoSlab(String string, Font font, int n, int n2, int n3, short s) {
        if (string == null) {
            return;
        }
        n3 = Math.max(this.slab, n3);
        if (font == null) {
            font = this.gdata.getFont3DCurrent();
        } else {
            this.gdata.setFont(font);
        }
        this.exporter.plotText(n, n2, n3, this.colix, string, font);
    }

    @Override
    public void drawImage(Object object, int n, int n2, int n3, int n4, short s, int n5, int n6) {
        if (this.isCartesian || object == null || n5 == 0 || n6 == 0 || this.gdata.isClippedZ(n4)) {
            return;
        }
        n3 = Math.max(this.slab, n3);
        this.exporter.plotImage(n, n2, n3, object, s, n5, n6);
    }

    @Override
    public void drawPixel(int n, int n2, int n3) {
        this.plotPixelClipped(n, n2, n3);
    }

    void plotPixelClipped(int n, int n2, int n3) {
        if (this.isClipped(n, n2, n3)) {
            return;
        }
        this.exporter.drawPixel(this.colix, n, n2, n3, 1);
    }

    @Override
    public void plotPixelClippedP3i(P3i p3i) {
        if (this.isClipped(p3i.x, p3i.y, p3i.z)) {
            return;
        }
        this.exporter.drawPixel(this.colix, p3i.x, p3i.y, p3i.z, 1);
    }

    @Override
    public void drawPoints(int n, int[] nArray, int n2) {
        int n3 = n * 3;
        while (n3 > 0) {
            int n4;
            int n5;
            int n6 = nArray[--n3];
            --n3;
            if (this.isClipped(n5 = nArray[--n3], n4 = nArray[n3], n6)) continue;
            this.exporter.drawPixel(this.colix, n5, n4, n6, n2);
        }
    }

    @Override
    public void drawDashedLineBits(int n, int n2, P3 p3, P3 p32) {
        this.exporter.fillCylinderScreenMad(this.colix, (byte)2, this.exporter.lineWidthMad, p3, p32);
    }

    @Override
    public void drawDottedLineBits(P3 p3, P3 p32) {
        this.exporter.fillCylinderScreenMad(this.colix, (byte)2, this.exporter.lineWidthMad, p3, p32);
    }

    @Override
    public void drawLineXYZ(int n, int n2, int n3, int n4, int n5, int n6) {
        this.ptA.set(n, n2, n3);
        this.ptB.set(n4, n5, n6);
        this.exporter.fillCylinderScreenMad(this.colix, (byte)2, this.exporter.lineWidthMad, this.ptA, this.ptB);
    }

    @Override
    public void drawLine(short s, short s2, int n, int n2, int n3, int n4, int n5, int n6) {
        this.fillCylinderXYZ(s, s2, (byte)2, this.exporter.lineWidthMad, n, n2, n3, n4, n5, n6);
    }

    @Override
    public void drawLineBits(short s, short s2, P3 p3, P3 p32) {
        this.fillCylinderBits2(s, s2, (byte)2, this.exporter.lineWidthMad, p3, p32);
    }

    @Override
    public void drawLineAB(P3 p3, P3 p32) {
        this.exporter.fillCylinderScreenMad(this.colix, (byte)2, this.exporter.lineWidthMad, p3, p32);
    }

    @Override
    public void drawBond(P3 p3, P3 p32, short s, short s2, byte by, short s3, int n) {
        if (s3 == 1) {
            s3 = this.exporter.lineWidthMad;
        }
        this.exporter.drawCylinder(p3, p32, s, s2, by, s3, n);
    }

    @Override
    public void fillCylinderXYZ(short s, short s2, byte by, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.ptA.set(n2, n3, n4);
        this.ptB.set(n5, n6, n7);
        this.exporter.drawCylinder(this.ptA, this.ptB, s, s2, by, n, 1);
    }

    @Override
    public void fillCylinderScreen3I(byte by, int n, P3 p3, P3 p32, P3 p33, P3 p34, float f) {
        if (n <= 0) {
            return;
        }
        this.exporter.fillCylinderScreen(this.colix, by, n, p3, p32, p33, p34, f);
    }

    @Override
    public void fillCylinder(byte by, int n, P3i p3i, P3i p3i2) {
        if (n <= 0) {
            return;
        }
        this.ptA.set(p3i.x, p3i.y, p3i.z);
        this.ptB.set(p3i2.x, p3i2.y, p3i2.z);
        this.exporter.fillCylinderScreenMad(this.colix, by, n, this.ptA, this.ptB);
    }

    @Override
    public void fillCylinderBits(byte by, int n, P3 p3, P3 p32) {
        if (n <= 0) {
            return;
        }
        if (this.isCartesian) {
            this.exporter.fillCylinderScreen(this.colix, by, n, p3, p32, null, null, 0.0f);
        } else {
            this.exporter.fillCylinderScreenMad(this.colix, by, n, p3, p32);
        }
    }

    @Override
    public void fillConeScreen3f(byte by, int n, P3 p3, P3 p32, boolean bl) {
        this.exporter.fillConeScreen(this.colix, by, n, p3, p32, bl);
    }

    @Override
    public void drawHermite4(int n, P3 p3, P3 p32, P3 p33, P3 p34) {
        this.hermite3d.renderHermiteRope(false, n, 0, 0, 0, p3, p32, p33, p34);
    }

    @Override
    public void fillHermite(int n, int n2, int n3, int n4, P3 p3, P3 p32, P3 p33, P3 p34) {
        this.hermite3d.renderHermiteRope(true, n, n2, n3, n4, p3, p32, p33, p34);
    }

    @Override
    public void drawTriangle3C(P3i p3i, short s, P3i p3i2, short s2, P3i p3i3, short s3, int n) {
        if ((n & 1) == 1) {
            this.drawLine(s, s2, p3i.x, p3i.y, p3i.z, p3i2.x, p3i2.y, p3i2.z);
        }
        if ((n & 2) == 2) {
            this.drawLine(s2, s3, p3i2.x, p3i2.y, p3i2.z, p3i3.x, p3i3.y, p3i3.z);
        }
        if ((n & 4) == 4) {
            this.drawLine(s, s3, p3i.x, p3i.y, p3i.z, p3i3.x, p3i3.y, p3i3.z);
        }
    }

    public void drawLineBits(P3 p3, P3 p32, short s, short s2) {
        this.exporter.drawCylinder(p3, p32, s, s2, (byte)2, this.exporter.lineWidthMad, 1);
    }

    @Override
    public void fillCylinderBits2(short s, short s2, byte by, int n, P3 p3, P3 p32) {
        this.exporter.drawCylinder(p3, p32, s, s2, by, n, 1);
    }

    @Override
    public void fillTriangle3CNBits(P3 p3, short s, short s2, P3 p32, short s3, short s4, P3 p33, short s5, short s6) {
        if (s != s3 || s3 != s5) {
            return;
        }
        this.exporter.fillTriangle(s, p3, p32, p33, false);
    }

    @Override
    public void fillTriangle3CN(P3i p3i, short s, short s2, P3i p3i2, short s3, short s4, P3i p3i3, short s5, short s6) {
        if (s != s3 || s3 != s5) {
            return;
        }
        this.ptA.set(p3i.x, p3i.y, p3i.z);
        this.ptB.set(p3i2.x, p3i2.y, p3i2.z);
        this.ptC.set(p3i3.x, p3i3.y, p3i3.z);
        this.exporter.fillTriangle(s, this.ptA, this.ptB, this.ptC, false);
    }

    @Override
    public void fillTriangleTwoSided(short s, P3 p3, P3 p32, P3 p33) {
        this.exporter.fillTriangle(this.colix, p3, p32, p33, true);
    }

    @Override
    public void fillTriangle3f(P3 p3, P3 p32, P3 p33, boolean bl) {
        this.exporter.fillTriangle(this.colix, p3, p32, p33, false);
    }

    @Override
    public void fillTriangle3i(P3 p3, P3 p32, P3 p33, T3 t3, T3 t32, T3 t33, boolean bl) {
        this.exporter.fillTriangle(this.colix, p3, p32, p33, true);
    }

    @Override
    public void fillQuadrilateral(P3 p3, P3 p32, P3 p33, P3 p34) {
        this.exporter.fillTriangle(this.colix, p3, p32, p33, false);
        this.exporter.fillTriangle(this.colix, p3, p33, p34, false);
    }

    @Override
    public void drawSurface(MeshSurface meshSurface, short s) {
        this.exporter.drawSurface(meshSurface, s);
    }

    @Override
    public void fillEllipsoid(P3 p3, P3[] p3Array, int n, int n2, int n3, int n4, M3 m3, double[] dArray, M4 m4, int n5, P3[] p3Array2) {
        this.exporter.fillEllipsoid(p3, p3Array, this.colix, n, n2, n3, n4, m3, dArray, m4, p3Array2);
    }

    @Override
    public boolean drawEllipse(P3 p3, P3 p32, P3 p33, boolean bl, boolean bl2) {
        return this.exporter.drawEllipse(p3, p32, p33, this.colix, bl);
    }

    @Override
    public boolean isAntialiased() {
        return false;
    }

    @Override
    public boolean checkTranslucent(boolean bl) {
        return true;
    }

    @Override
    public boolean haveTranslucentObjects() {
        return true;
    }

    @Override
    public boolean setC(short s) {
        this.colix = s;
        this.gdata.setC(s);
        return true;
    }

    @Override
    public boolean isInDisplayRange(int n, int n2) {
        return this.isCartesian || this.gdata.isInDisplayRange(n, n2);
    }

    public int clipCode(int n, int n2, int n3) {
        return this.isCartesian ? this.gdata.clipCode(n3) : this.gdata.clipCode3(n, n2, n3);
    }

    @Override
    public boolean isClippedXY(int n, int n2, int n3) {
        return !this.isCartesian && this.gdata.isClippedXY(n, n2, n3);
    }

    public boolean isClipped(int n, int n2, int n3) {
        return this.gdata.isClippedZ(n3) || this.isClipped(n, n2);
    }

    protected boolean isClipped(int n, int n2) {
        return !this.isCartesian && this.gdata.isClipped(n, n2);
    }

    public double getPrivateKey() {
        return this.privateKey;
    }

    @Override
    public void volumeRender4(int n, int n2, int n3, int n4) {
        this.fillSphereXYZ(n, n2, n3, n4);
    }

    @Override
    public void renderCrossHairs(int[] nArray, int n, int n2, P3 p3, float f) {
    }

    @Override
    public void volumeRender(boolean bl) {
    }

    @Override
    public void addRenderer(int n) {
        if (n == 553648147) {
            this.hermite3d = (HermiteRenderer)new HermiteRenderer().set(this, this.gdata);
        }
    }

    @Override
    public void plotImagePixel(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int[] nArray, Object object, int n9) {
        if (this.isWebGL) {
            return;
        }
        n4 = Math.max(this.slab, n4);
        if (n5 != 0) {
            int n10 = n5 == 8 ? 255 : (8 - n5 << 4) + (8 - n5);
            n = n & 0xFFFFFF | n10 << 24;
        }
        this.exporter.drawTextPixel(n, n2, n3, n4);
    }

    @Override
    public void drawHermite7(boolean bl, boolean bl2, int n, P3 p3, P3 p32, P3 p33, P3 p34, P3 p35, P3 p36, P3 p37, P3 p38, int n2, short s) {
        if (s == 0 || this.isWebGL) {
            this.hermite3d.renderHermiteRibbon(bl, bl2, n, p3, p32, p33, p34, p35, p36, p37, p38, n2, 0);
            return;
        }
        this.hermite3d.renderHermiteRibbon(bl, bl2, n, p3, p32, p33, p34, p35, p36, p37, p38, n2, 1);
        short s2 = this.colix;
        this.setC(s);
        this.hermite3d.renderHermiteRibbon(bl, bl2, n, p3, p32, p33, p34, p35, p36, p37, p38, n2, -1);
        this.setC(s2);
    }

    @Override
    public void renderAllStrings(Object object) {
        if (this.isWebGL) {
            return;
        }
        this.gdata.renderAllStrings(this);
    }
}

