/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.bootstrap;

import java.io.FilePermission;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.AccessMode;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.Permissions;
import java.security.Policy;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.elasticsearch.bootstrap.ESPolicy;
import org.elasticsearch.bootstrap.JarHell;
import org.elasticsearch.common.SuppressForbidden;
import org.elasticsearch.common.io.PathUtils;
import org.elasticsearch.env.Environment;

final class Security {
    private static final Map<Pattern, String> SPECIAL_JARS;

    private Security() {
    }

    static void configure(Environment environment, boolean filterBadDefaults) throws Exception {
        Security.setCodebaseProperties();
        Policy.setPolicy(new ESPolicy(Security.createPermissions(environment), filterBadDefaults));
        System.setSecurityManager(new SecurityManager(){

            @Override
            public void checkExit(int status) {
                throw new SecurityException("exit(" + status + ") not allowed by system policy");
            }
        });
        Security.selfTest();
    }

    @SuppressForbidden(reason="proper use of URL")
    static void setCodebaseProperties() {
        for (URL url : JarHell.parseClassPath()) {
            for (Map.Entry<Pattern, String> e : SPECIAL_JARS.entrySet()) {
                if (!e.getKey().matcher(url.getPath()).matches()) continue;
                String prop = e.getValue();
                if (System.getProperty(prop) != null) {
                    throw new IllegalStateException("property: " + prop + " is unexpectedly set: " + System.getProperty(prop));
                }
                System.setProperty(prop, url.toString());
            }
        }
        for (String prop : SPECIAL_JARS.values()) {
            if (System.getProperty(prop) != null) continue;
            System.setProperty(prop, "file:/dev/null");
        }
    }

    @SuppressForbidden(reason="accesses fully qualified URLs to configure security")
    static void addClasspathPermissions(Permissions policy) throws IOException {
        for (URL url : JarHell.parseClassPath()) {
            Path path;
            try {
                path = PathUtils.get(url.toURI());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            policy.add(new FilePermission(path.toString(), "read,readlink"));
            if (!Files.isDirectory(path, new LinkOption[0])) continue;
            policy.add(new FilePermission(path.toString() + path.getFileSystem().getSeparator() + "-", "read,readlink"));
        }
    }

    static Permissions createPermissions(Environment environment) throws IOException {
        Permissions policy = new Permissions();
        Security.addClasspathPermissions(policy);
        Security.addFilePermissions(policy, environment);
        return policy;
    }

    static void addFilePermissions(Permissions policy, Environment environment) throws IOException {
        Security.addPath(policy, "path.home", environment.binFile(), "read,readlink");
        Security.addPath(policy, "path.home", environment.libFile(), "read,readlink");
        Security.addPath(policy, "path.plugins", environment.pluginsFile(), "read,readlink");
        Security.addPath(policy, "path.conf", environment.configFile(), "read,readlink");
        Security.addPath(policy, "path.scripts", environment.scriptsFile(), "read,readlink");
        Security.addPath(policy, "java.io.tmpdir", environment.tmpFile(), "read,readlink,write,delete");
        Security.addPath(policy, "path.logs", environment.logsFile(), "read,readlink,write,delete");
        if (environment.sharedDataFile() != null) {
            Security.addPath(policy, "path.shared_data", environment.sharedDataFile(), "read,readlink,write,delete");
        }
        for (Path path : environment.dataFiles()) {
            Security.addPath(policy, "path.data", path, "read,readlink,write,delete");
        }
        for (Path path : environment.dataWithClusterFiles()) {
            Security.addPath(policy, "path.data", path, "read,readlink,write,delete");
        }
        for (Path path : environment.repoFiles()) {
            Security.addPath(policy, "path.repo", path, "read,readlink,write,delete");
        }
        if (environment.pidFile() != null) {
            policy.add(new FilePermission(environment.pidFile().toString(), "delete"));
        }
    }

    static void addPath(Permissions policy, String configurationName, Path path, String permissions) {
        try {
            Security.ensureDirectoryExists(path);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to access '" + configurationName + "' (" + path + ")", e);
        }
        policy.add(new FilePermission(path.toString(), permissions));
        policy.add(new FilePermission(path.toString() + path.getFileSystem().getSeparator() + "-", permissions));
    }

    static void ensureDirectoryExists(Path path) throws IOException {
        if (Files.isDirectory(path, new LinkOption[0])) {
            path.getFileSystem().provider().checkAccess(path.toRealPath(new LinkOption[0]), AccessMode.READ);
        } else {
            try {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException e) {
                NotDirectoryException e2 = new NotDirectoryException(path.toString());
                e2.addSuppressed(e);
                throw e2;
            }
        }
    }

    @SuppressForbidden(reason="accesses jvm default tempdir as a self-test")
    static void selfTest() throws IOException {
        try {
            Path p = Files.createTempFile(null, null, new FileAttribute[0]);
            try {
                Files.delete(p);
            }
            catch (IOException iOException) {}
        }
        catch (SecurityException problem) {
            throw new SecurityException("Security misconfiguration: cannot access java.io.tmpdir", problem);
        }
    }

    static {
        IdentityHashMap<Pattern, String> m = new IdentityHashMap<Pattern, String>();
        m.put(Pattern.compile(".*lucene-core-.*\\.jar$"), "es.security.jar.lucene.core");
        m.put(Pattern.compile(".*jsr166e-.*\\.jar$"), "es.security.jar.twitter.jsr166e");
        m.put(Pattern.compile(".*securemock-.*\\.jar$"), "es.security.jar.elasticsearch.securemock");
        SPECIAL_JARS = Collections.unmodifiableMap(m);
    }
}

