/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.command;

import java.io.IOException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.RerouteExplanation;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.command.AllocationCommand;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.shard.ShardId;

public class MoveAllocationCommand
implements AllocationCommand {
    public static final String NAME = "move";
    private final ShardId shardId;
    private final String fromNode;
    private final String toNode;

    public MoveAllocationCommand(ShardId shardId, String fromNode, String toNode) {
        this.shardId = shardId;
        this.fromNode = fromNode;
        this.toNode = toNode;
    }

    @Override
    public String name() {
        return NAME;
    }

    public ShardId shardId() {
        return this.shardId;
    }

    public String fromNode() {
        return this.fromNode;
    }

    public String toNode() {
        return this.toNode;
    }

    @Override
    public RerouteExplanation execute(RoutingAllocation allocation, boolean explain) {
        DiscoveryNode fromDiscoNode = allocation.nodes().resolveNode(this.fromNode);
        DiscoveryNode toDiscoNode = allocation.nodes().resolveNode(this.toNode);
        Decision decision = null;
        boolean found = false;
        for (ShardRouting shardRouting : allocation.routingNodes().node(fromDiscoNode.id())) {
            if (!shardRouting.shardId().equals(this.shardId)) continue;
            found = true;
            if (!shardRouting.started()) {
                if (explain) {
                    return new RerouteExplanation(this, allocation.decision(Decision.NO, "move_allocation_command", "shard " + this.shardId + " has not been started", new Object[0]));
                }
                throw new IllegalArgumentException("[move_allocation] can't move " + this.shardId + ", shard is not started (state = " + (Object)((Object)shardRouting.state()) + "]");
            }
            RoutingNode toRoutingNode = allocation.routingNodes().node(toDiscoNode.id());
            decision = allocation.deciders().canAllocate(shardRouting, toRoutingNode, allocation);
            if (decision.type() == Decision.Type.NO) {
                if (explain) {
                    return new RerouteExplanation(this, decision);
                }
                throw new IllegalArgumentException("[move_allocation] can't move " + this.shardId + ", from " + fromDiscoNode + ", to " + toDiscoNode + ", since its not allowed, reason: " + decision);
            }
            if (decision.type() == Decision.Type.THROTTLE) {
                // empty if block
            }
            allocation.routingNodes().relocate(shardRouting, toRoutingNode.nodeId(), allocation.clusterInfo().getShardSize(shardRouting, -1L));
        }
        if (!found) {
            if (explain) {
                return new RerouteExplanation(this, allocation.decision(Decision.NO, "move_allocation_command", "shard " + this.shardId + " not found", new Object[0]));
            }
            throw new IllegalArgumentException("[move_allocation] can't move " + this.shardId + ", failed to find it on node " + fromDiscoNode);
        }
        return new RerouteExplanation(this, decision);
    }

    public static class Factory
    implements AllocationCommand.Factory<MoveAllocationCommand> {
        @Override
        public MoveAllocationCommand readFrom(StreamInput in) throws IOException {
            return new MoveAllocationCommand(ShardId.readShardId(in), in.readString(), in.readString());
        }

        @Override
        public void writeTo(MoveAllocationCommand command, StreamOutput out) throws IOException {
            command.shardId().writeTo(out);
            out.writeString(command.fromNode());
            out.writeString(command.toNode());
        }

        @Override
        public MoveAllocationCommand fromXContent(XContentParser parser) throws IOException {
            XContentParser.Token token;
            String index = null;
            int shardId = -1;
            String fromNode = null;
            String toNode = null;
            String currentFieldName = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token.isValue()) {
                    if ("index".equals(currentFieldName)) {
                        index = parser.text();
                        continue;
                    }
                    if ("shard".equals(currentFieldName)) {
                        shardId = parser.intValue();
                        continue;
                    }
                    if ("from_node".equals(currentFieldName) || "fromNode".equals(currentFieldName)) {
                        fromNode = parser.text();
                        continue;
                    }
                    if ("to_node".equals(currentFieldName) || "toNode".equals(currentFieldName)) {
                        toNode = parser.text();
                        continue;
                    }
                    throw new ElasticsearchParseException("[{}] command does not support field [{}]", MoveAllocationCommand.NAME, currentFieldName);
                }
                throw new ElasticsearchParseException("[{}] command does not support complex json tokens [{}]", new Object[]{MoveAllocationCommand.NAME, token});
            }
            if (index == null) {
                throw new ElasticsearchParseException("[{}] command missing the index parameter", MoveAllocationCommand.NAME);
            }
            if (shardId == -1) {
                throw new ElasticsearchParseException("[{}] command missing the shard parameter", MoveAllocationCommand.NAME);
            }
            if (fromNode == null) {
                throw new ElasticsearchParseException("[{}] command missing the from_node parameter", MoveAllocationCommand.NAME);
            }
            if (toNode == null) {
                throw new ElasticsearchParseException("[{}] command missing the to_node parameter", MoveAllocationCommand.NAME);
            }
            return new MoveAllocationCommand(new ShardId(index, shardId), fromNode, toNode);
        }

        @Override
        public void toXContent(MoveAllocationCommand command, XContentBuilder builder, ToXContent.Params params, String objectName) throws IOException {
            if (objectName == null) {
                builder.startObject();
            } else {
                builder.startObject(objectName);
            }
            builder.field("index", command.shardId().index().name());
            builder.field("shard", command.shardId().id());
            builder.field("from_node", command.fromNode());
            builder.field("to_node", command.toNode());
            builder.endObject();
        }
    }
}

