/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import com.carrotsearch.hppc.ObjectObjectHashMap;
import com.carrotsearch.hppc.ObjectObjectMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.lucene.all.AllEntries;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.analysis.AnalysisService;
import org.elasticsearch.index.mapper.ContentPath;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.DocumentMapperParser;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.MapperUtils;
import org.elasticsearch.index.mapper.SourceToParse;
import org.elasticsearch.index.mapper.object.RootObjectMapper;

public abstract class ParseContext {
    public abstract boolean flyweight();

    public abstract DocumentMapperParser docMapperParser();

    public final ParseContext createCopyToContext() {
        return new FilterParseContext(this){

            @Override
            public boolean isWithinCopyTo() {
                return true;
            }
        };
    }

    public boolean isWithinCopyTo() {
        return false;
    }

    public final ParseContext createMultiFieldContext() {
        return new FilterParseContext(this){

            @Override
            public boolean isWithinMultiFields() {
                return true;
            }
        };
    }

    public final ParseContext createNestedContext(String fullPath) {
        Document doc = new Document(fullPath, this.doc());
        this.addDoc(doc);
        return this.switchDoc(doc);
    }

    public final ParseContext switchDoc(final Document document) {
        return new FilterParseContext(this){

            @Override
            public Document doc() {
                return document;
            }
        };
    }

    public final ParseContext overridePath(final ContentPath path) {
        return new FilterParseContext(this){

            @Override
            public ContentPath path() {
                return path;
            }
        };
    }

    public boolean isWithinMultiFields() {
        return false;
    }

    public abstract String index();

    @Nullable
    public abstract Settings indexSettings();

    public abstract String type();

    public abstract SourceToParse sourceToParse();

    public abstract BytesReference source();

    public abstract void source(BytesReference var1);

    public abstract ContentPath path();

    public abstract XContentParser parser();

    public abstract Document rootDoc();

    public abstract List<Document> docs();

    public abstract Document doc();

    public abstract void addDoc(Document var1);

    public abstract RootObjectMapper root();

    public abstract DocumentMapper docMapper();

    public abstract AnalysisService analysisService();

    public abstract MapperService mapperService();

    public abstract String id();

    public abstract void ignoredValue(String var1, String var2);

    public abstract String ignoredValue(String var1);

    public abstract void id(String var1);

    public abstract Field uid();

    public abstract void uid(Field var1);

    public abstract Field version();

    public abstract void version(Field var1);

    public final boolean includeInAll(Boolean includeInAll, FieldMapper mapper) {
        return this.includeInAll(includeInAll, mapper.fieldType().indexOptions() != IndexOptions.NONE);
    }

    private boolean includeInAll(Boolean specificIncludeInAll, boolean indexed) {
        if (this.isWithinCopyTo()) {
            return false;
        }
        if (this.isWithinMultiFields()) {
            return false;
        }
        if (!this.docMapper().allFieldMapper().enabled()) {
            return false;
        }
        if (specificIncludeInAll == null) {
            return indexed;
        }
        return specificIncludeInAll;
    }

    public abstract AllEntries allEntries();

    public final ParseContext createExternalValueContext(final Object externalValue) {
        return new FilterParseContext(this){

            @Override
            public boolean externalValueSet() {
                return true;
            }

            @Override
            public Object externalValue() {
                return externalValue;
            }
        };
    }

    public boolean externalValueSet() {
        return false;
    }

    public Object externalValue() {
        throw new IllegalStateException("External value is not set");
    }

    public final <T> T parseExternalValue(Class<T> clazz) {
        if (!this.externalValueSet() || this.externalValue() == null) {
            return null;
        }
        if (!clazz.isInstance(this.externalValue())) {
            throw new IllegalArgumentException("illegal external value class [" + this.externalValue().getClass().getName() + "]. Should be " + clazz.getName());
        }
        return clazz.cast(this.externalValue());
    }

    public abstract float docBoost();

    public abstract void docBoost(float var1);

    public abstract StringBuilder stringBuilder();

    public abstract void addDynamicMappingsUpdate(Mapper var1);

    public abstract Mapper dynamicMappingsUpdate();

    public static class InternalParseContext
    extends ParseContext {
        private final DocumentMapper docMapper;
        private final DocumentMapperParser docMapperParser;
        private final ContentPath path;
        private XContentParser parser;
        private Document document;
        private List<Document> documents = new ArrayList<Document>();
        @Nullable
        private final Settings indexSettings;
        private SourceToParse sourceToParse;
        private BytesReference source;
        private String id;
        private Field uid;
        private Field version;
        private StringBuilder stringBuilder = new StringBuilder();
        private Map<String, String> ignoredValues = new HashMap<String, String>();
        private AllEntries allEntries = new AllEntries();
        private float docBoost = 1.0f;
        private Mapper dynamicMappingsUpdate = null;

        public InternalParseContext(@Nullable Settings indexSettings, DocumentMapperParser docMapperParser, DocumentMapper docMapper, ContentPath path) {
            this.indexSettings = indexSettings;
            this.docMapper = docMapper;
            this.docMapperParser = docMapperParser;
            this.path = path;
        }

        public void reset(XContentParser parser, Document document, SourceToParse source) {
            this.parser = parser;
            this.document = document;
            if (document != null) {
                this.documents = new ArrayList<Document>();
                this.documents.add(document);
            } else {
                this.documents = null;
            }
            this.uid = null;
            this.version = null;
            this.id = null;
            this.sourceToParse = source;
            this.source = source == null ? null : this.sourceToParse.source();
            this.path.reset();
            this.allEntries = new AllEntries();
            this.ignoredValues.clear();
            this.docBoost = 1.0f;
            this.dynamicMappingsUpdate = null;
        }

        @Override
        public boolean flyweight() {
            return this.sourceToParse.flyweight();
        }

        @Override
        public DocumentMapperParser docMapperParser() {
            return this.docMapperParser;
        }

        @Override
        public String index() {
            return this.sourceToParse.index();
        }

        @Override
        @Nullable
        public Settings indexSettings() {
            return this.indexSettings;
        }

        @Override
        public String type() {
            return this.sourceToParse.type();
        }

        @Override
        public SourceToParse sourceToParse() {
            return this.sourceToParse;
        }

        @Override
        public BytesReference source() {
            return this.source;
        }

        @Override
        public void source(BytesReference source) {
            this.source = source;
        }

        @Override
        public ContentPath path() {
            return this.path;
        }

        @Override
        public XContentParser parser() {
            return this.parser;
        }

        @Override
        public Document rootDoc() {
            return this.documents.get(0);
        }

        @Override
        public List<Document> docs() {
            return this.documents;
        }

        @Override
        public Document doc() {
            return this.document;
        }

        @Override
        public void addDoc(Document doc) {
            this.documents.add(doc);
        }

        @Override
        public RootObjectMapper root() {
            return this.docMapper.root();
        }

        @Override
        public DocumentMapper docMapper() {
            return this.docMapper;
        }

        @Override
        public AnalysisService analysisService() {
            return this.docMapperParser.analysisService;
        }

        @Override
        public MapperService mapperService() {
            return this.docMapperParser.mapperService;
        }

        @Override
        public String id() {
            return this.id;
        }

        @Override
        public void ignoredValue(String indexName, String value) {
            this.ignoredValues.put(indexName, value);
        }

        @Override
        public String ignoredValue(String indexName) {
            return this.ignoredValues.get(indexName);
        }

        @Override
        public void id(String id) {
            this.id = id;
        }

        @Override
        public Field uid() {
            return this.uid;
        }

        @Override
        public void uid(Field uid) {
            this.uid = uid;
        }

        @Override
        public Field version() {
            return this.version;
        }

        @Override
        public void version(Field version) {
            this.version = version;
        }

        @Override
        public AllEntries allEntries() {
            return this.allEntries;
        }

        @Override
        public float docBoost() {
            return this.docBoost;
        }

        @Override
        public void docBoost(float docBoost) {
            this.docBoost = docBoost;
        }

        @Override
        public StringBuilder stringBuilder() {
            this.stringBuilder.setLength(0);
            return this.stringBuilder;
        }

        @Override
        public void addDynamicMappingsUpdate(Mapper mapper) {
            assert (mapper instanceof RootObjectMapper) : mapper;
            if (this.dynamicMappingsUpdate == null) {
                this.dynamicMappingsUpdate = mapper;
            } else {
                MapperUtils.merge(this.dynamicMappingsUpdate, mapper);
            }
        }

        @Override
        public Mapper dynamicMappingsUpdate() {
            return this.dynamicMappingsUpdate;
        }
    }

    private static class FilterParseContext
    extends ParseContext {
        private final ParseContext in;

        private FilterParseContext(ParseContext in) {
            this.in = in;
        }

        @Override
        public boolean flyweight() {
            return this.in.flyweight();
        }

        @Override
        public DocumentMapperParser docMapperParser() {
            return this.in.docMapperParser();
        }

        @Override
        public boolean isWithinCopyTo() {
            return this.in.isWithinCopyTo();
        }

        @Override
        public boolean isWithinMultiFields() {
            return this.in.isWithinMultiFields();
        }

        @Override
        public String index() {
            return this.in.index();
        }

        @Override
        public Settings indexSettings() {
            return this.in.indexSettings();
        }

        @Override
        public String type() {
            return this.in.type();
        }

        @Override
        public SourceToParse sourceToParse() {
            return this.in.sourceToParse();
        }

        @Override
        public BytesReference source() {
            return this.in.source();
        }

        @Override
        public void source(BytesReference source) {
            this.in.source(source);
        }

        @Override
        public ContentPath path() {
            return this.in.path();
        }

        @Override
        public XContentParser parser() {
            return this.in.parser();
        }

        @Override
        public Document rootDoc() {
            return this.in.rootDoc();
        }

        @Override
        public List<Document> docs() {
            return this.in.docs();
        }

        @Override
        public Document doc() {
            return this.in.doc();
        }

        @Override
        public void addDoc(Document doc) {
            this.in.addDoc(doc);
        }

        @Override
        public RootObjectMapper root() {
            return this.in.root();
        }

        @Override
        public DocumentMapper docMapper() {
            return this.in.docMapper();
        }

        @Override
        public AnalysisService analysisService() {
            return this.in.analysisService();
        }

        @Override
        public MapperService mapperService() {
            return this.in.mapperService();
        }

        @Override
        public String id() {
            return this.in.id();
        }

        @Override
        public void ignoredValue(String indexName, String value) {
            this.in.ignoredValue(indexName, value);
        }

        @Override
        public String ignoredValue(String indexName) {
            return this.in.ignoredValue(indexName);
        }

        @Override
        public void id(String id) {
            this.in.id(id);
        }

        @Override
        public Field uid() {
            return this.in.uid();
        }

        @Override
        public void uid(Field uid) {
            this.in.uid(uid);
        }

        @Override
        public Field version() {
            return this.in.version();
        }

        @Override
        public void version(Field version) {
            this.in.version(version);
        }

        @Override
        public AllEntries allEntries() {
            return this.in.allEntries();
        }

        @Override
        public boolean externalValueSet() {
            return this.in.externalValueSet();
        }

        @Override
        public Object externalValue() {
            return this.in.externalValue();
        }

        @Override
        public float docBoost() {
            return this.in.docBoost();
        }

        @Override
        public void docBoost(float docBoost) {
            this.in.docBoost(docBoost);
        }

        @Override
        public StringBuilder stringBuilder() {
            return this.in.stringBuilder();
        }

        @Override
        public void addDynamicMappingsUpdate(Mapper update) {
            this.in.addDynamicMappingsUpdate(update);
        }

        @Override
        public Mapper dynamicMappingsUpdate() {
            return this.in.dynamicMappingsUpdate();
        }
    }

    public static class Document
    implements Iterable<IndexableField> {
        private final Document parent;
        private final String path;
        private final String prefix;
        private final List<IndexableField> fields = new ArrayList<IndexableField>();
        private ObjectObjectMap<Object, IndexableField> keyedFields;

        private Document(String path, Document parent) {
            this.path = path;
            this.prefix = path.isEmpty() ? "" : path + ".";
            this.parent = parent;
        }

        public Document() {
            this("", null);
        }

        public String getPath() {
            return this.path;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public Document getParent() {
            return this.parent;
        }

        @Override
        public Iterator<IndexableField> iterator() {
            return this.fields.iterator();
        }

        public List<IndexableField> getFields() {
            return this.fields;
        }

        public void add(IndexableField field) {
            assert (field.name().startsWith("_") || field.name().startsWith(this.prefix)) : field.name() + " " + this.prefix;
            this.fields.add(field);
        }

        public void addWithKey(Object key, IndexableField field) {
            if (this.keyedFields == null) {
                this.keyedFields = new ObjectObjectHashMap();
            } else if (this.keyedFields.containsKey(key)) {
                throw new IllegalStateException("Only one field can be stored per key");
            }
            this.keyedFields.put(key, (Object)field);
            this.add(field);
        }

        public IndexableField getByKey(Object key) {
            return this.keyedFields == null ? null : (IndexableField)this.keyedFields.get(key);
        }

        public IndexableField[] getFields(String name) {
            ArrayList<IndexableField> f = new ArrayList<IndexableField>();
            for (IndexableField field : this.fields) {
                if (!field.name().equals(name)) continue;
                f.add(field);
            }
            return f.toArray(new IndexableField[f.size()]);
        }

        public final String[] getValues(String name) {
            ArrayList<String> result = new ArrayList<String>();
            for (IndexableField field : this.fields) {
                if (!field.name().equals(name) || field.stringValue() == null) continue;
                result.add(field.stringValue());
            }
            return result.toArray(new String[result.size()]);
        }

        public IndexableField getField(String name) {
            for (IndexableField field : this.fields) {
                if (!field.name().equals(name)) continue;
                return field;
            }
            return null;
        }

        public String get(String name) {
            for (IndexableField f : this.fields) {
                if (!f.name().equals(name) || f.stringValue() == null) continue;
                return f.stringValue();
            }
            return null;
        }

        public BytesRef getBinaryValue(String name) {
            for (IndexableField f : this.fields) {
                if (!f.name().equals(name) || f.binaryValue() == null) continue;
                return f.binaryValue();
            }
            return null;
        }
    }
}

