/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.geo;

import com.carrotsearch.hppc.ObjectHashSet;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.google.common.collect.Iterators;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.XGeoHashUtils;
import org.elasticsearch.Version;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.geo.GeoDistance;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.geo.GeoUtils;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.common.util.ByteUtils;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.mapper.ContentPath;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilders;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MergeMappingException;
import org.elasticsearch.index.mapper.MergeResult;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.core.DoubleFieldMapper;
import org.elasticsearch.index.mapper.core.NumberFieldMapper;
import org.elasticsearch.index.mapper.core.StringFieldMapper;
import org.elasticsearch.index.mapper.core.TypeParsers;
import org.elasticsearch.index.mapper.object.ArrayValueMapperParser;

public class GeoPointFieldMapper
extends FieldMapper
implements ArrayValueMapperParser {
    public static final String CONTENT_TYPE = "geo_point";
    private final ContentPath.Type pathType;
    private final DoubleFieldMapper latMapper;
    private final DoubleFieldMapper lonMapper;
    private final StringFieldMapper geohashMapper;
    protected Explicit<Boolean> ignoreMalformed;
    protected Explicit<Boolean> coerce;

    public GeoPointFieldMapper(String simpleName, MappedFieldType fieldType, MappedFieldType defaultFieldType, Settings indexSettings, ContentPath.Type pathType, DoubleFieldMapper latMapper, DoubleFieldMapper lonMapper, StringFieldMapper geohashMapper, FieldMapper.MultiFields multiFields, Explicit<Boolean> ignoreMalformed, Explicit<Boolean> coerce) {
        super(simpleName, fieldType, defaultFieldType, indexSettings, multiFields, null);
        this.pathType = pathType;
        this.latMapper = latMapper;
        this.lonMapper = lonMapper;
        this.geohashMapper = geohashMapper;
        this.ignoreMalformed = ignoreMalformed;
        this.coerce = coerce;
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    public GeoPointFieldType fieldType() {
        return (GeoPointFieldType)super.fieldType();
    }

    @Override
    public void merge(Mapper mergeWith, MergeResult mergeResult) throws MergeMappingException {
        super.merge(mergeWith, mergeResult);
        if (!this.getClass().equals(mergeWith.getClass())) {
            return;
        }
        GeoPointFieldMapper gpfmMergeWith = (GeoPointFieldMapper)mergeWith;
        if (gpfmMergeWith.coerce.explicit() && this.coerce.explicit() && this.coerce.value() != gpfmMergeWith.coerce.value()) {
            mergeResult.addConflict("mapper [" + this.fieldType().names().fullName() + "] has different [coerce]");
        }
        if (!mergeResult.simulate() && !mergeResult.hasConflicts()) {
            if (gpfmMergeWith.ignoreMalformed.explicit()) {
                this.ignoreMalformed = gpfmMergeWith.ignoreMalformed;
            }
            if (gpfmMergeWith.coerce.explicit()) {
                this.coerce = gpfmMergeWith.coerce;
            }
        }
    }

    @Override
    protected void parseCreateField(ParseContext context, List<Field> fields) throws IOException {
        throw new UnsupportedOperationException("Parsing is implemented in parse(), this method should NEVER be called");
    }

    @Override
    public Mapper parse(ParseContext context) throws IOException {
        ContentPath.Type origPathType = context.path().pathType();
        context.path().pathType(this.pathType);
        context.path().add(this.simpleName());
        GeoPoint sparse = context.parseExternalValue(GeoPoint.class);
        if (sparse != null) {
            this.parse(context, sparse, null);
        } else {
            sparse = new GeoPoint();
            XContentParser.Token token = context.parser().currentToken();
            if (token == XContentParser.Token.START_ARRAY) {
                token = context.parser().nextToken();
                if (token == XContentParser.Token.START_ARRAY) {
                    while (token != XContentParser.Token.END_ARRAY) {
                        this.parse(context, GeoUtils.parseGeoPoint(context.parser(), sparse), null);
                        token = context.parser().nextToken();
                    }
                } else if (token == XContentParser.Token.VALUE_NUMBER) {
                    double lon = context.parser().doubleValue();
                    token = context.parser().nextToken();
                    double lat = context.parser().doubleValue();
                    while ((token = context.parser().nextToken()) != XContentParser.Token.END_ARRAY) {
                    }
                    this.parse(context, sparse.reset(lat, lon), null);
                } else {
                    while (token != XContentParser.Token.END_ARRAY) {
                        if (token == XContentParser.Token.VALUE_STRING) {
                            this.parsePointFromString(context, sparse, context.parser().text());
                        } else {
                            this.parse(context, GeoUtils.parseGeoPoint(context.parser(), sparse), null);
                        }
                        token = context.parser().nextToken();
                    }
                }
            } else if (token == XContentParser.Token.VALUE_STRING) {
                this.parsePointFromString(context, sparse, context.parser().text());
            } else if (token != XContentParser.Token.VALUE_NULL) {
                this.parse(context, GeoUtils.parseGeoPoint(context.parser(), sparse), null);
            }
        }
        context.path().remove();
        context.path().pathType(origPathType);
        return null;
    }

    private void addGeohashField(ParseContext context, String geohash) throws IOException {
        int len = Math.min(this.fieldType().geohashPrecision(), geohash.length());
        int min = this.fieldType().isGeohashPrefixEnabled() ? 1 : len;
        for (int i = len; i >= min; --i) {
            this.geohashMapper.parse(context.createExternalValueContext(geohash.substring(0, i)));
        }
    }

    private void parsePointFromString(ParseContext context, GeoPoint sparse, String point) throws IOException {
        if (point.indexOf(44) < 0) {
            this.parse(context, sparse.resetFromGeoHash(point), point);
        } else {
            this.parse(context, sparse.resetFromString(point), null);
        }
    }

    private void parse(ParseContext context, GeoPoint point, String geohash) throws IOException {
        Object field;
        boolean validPoint = false;
        if (!this.coerce.value().booleanValue() && !this.ignoreMalformed.value().booleanValue()) {
            if (point.lat() > 90.0 || point.lat() < -90.0) {
                throw new IllegalArgumentException("illegal latitude value [" + point.lat() + "] for " + this.name());
            }
            if (point.lon() > 180.0 || point.lon() < -180.0) {
                throw new IllegalArgumentException("illegal longitude value [" + point.lon() + "] for " + this.name());
            }
            validPoint = true;
        }
        if (this.coerce.value().booleanValue() && !validPoint) {
            GeoUtils.normalizePoint(point, true, true);
        }
        if (this.fieldType().indexOptions() != IndexOptions.NONE || this.fieldType().stored()) {
            field = new Field(this.fieldType().names().indexName(), Double.toString(point.lat()) + ',' + Double.toString(point.lon()), (FieldType)this.fieldType());
            context.doc().add((IndexableField)field);
        }
        if (this.fieldType().isGeohashEnabled()) {
            if (geohash == null) {
                geohash = XGeoHashUtils.stringEncode(point.lon(), point.lat());
            }
            this.addGeohashField(context, geohash);
        }
        if (this.fieldType().isLatLonEnabled()) {
            this.latMapper.parse(context.createExternalValueContext(point.lat()));
            this.lonMapper.parse(context.createExternalValueContext(point.lon()));
        }
        if (this.fieldType().hasDocValues()) {
            field = (CustomGeoPointDocValuesField)context.doc().getByKey(this.fieldType().names().indexName());
            if (field == null) {
                field = new CustomGeoPointDocValuesField(this.fieldType().names().indexName(), point.lat(), point.lon());
                context.doc().addWithKey(this.fieldType().names().indexName(), (IndexableField)field);
            } else {
                ((CustomGeoPointDocValuesField)field).add(point.lat(), point.lon());
            }
        }
        this.multiFields.parse(this, context);
    }

    @Override
    public Iterator<Mapper> iterator() {
        ArrayList<FieldMapper> extras = new ArrayList<FieldMapper>();
        if (this.fieldType().isGeohashEnabled()) {
            extras.add(this.geohashMapper);
        }
        if (this.fieldType().isLatLonEnabled()) {
            extras.add(this.latMapper);
            extras.add(this.lonMapper);
        }
        return Iterators.concat(super.iterator(), extras.iterator());
    }

    @Override
    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        super.doXContentBody(builder, includeDefaults, params);
        if (includeDefaults || this.pathType != Defaults.PATH_TYPE) {
            builder.field("path", this.pathType.name().toLowerCase(Locale.ROOT));
        }
        if (includeDefaults || this.fieldType().isLatLonEnabled()) {
            builder.field("lat_lon", this.fieldType().isLatLonEnabled());
        }
        if (includeDefaults || this.fieldType().isGeohashEnabled()) {
            builder.field("geohash", this.fieldType().isGeohashEnabled());
        }
        if (includeDefaults || this.fieldType().isGeohashPrefixEnabled()) {
            builder.field("geohash_prefix", this.fieldType().isGeohashPrefixEnabled());
        }
        if (this.fieldType().isGeohashEnabled() && (includeDefaults || this.fieldType().geohashPrecision() != 12)) {
            builder.field("geohash_precision", this.fieldType().geohashPrecision());
        }
        if (this.fieldType().isLatLonEnabled() && (includeDefaults || this.fieldType().latFieldType().numericPrecisionStep() != 16)) {
            builder.field("precision_step", this.fieldType().latFieldType().numericPrecisionStep());
        }
        if (includeDefaults || this.coerce.explicit()) {
            builder.field("coerce", (Object)this.coerce.value());
        }
        if (includeDefaults || this.ignoreMalformed.explicit()) {
            builder.field("ignore_malformed", (Object)this.ignoreMalformed.value());
        }
    }

    public static class CustomGeoPointDocValuesField
    extends NumberFieldMapper.CustomNumericDocValuesField {
        private final ObjectHashSet<GeoPoint> points = new ObjectHashSet(2);

        public CustomGeoPointDocValuesField(String name, double lat, double lon) {
            super(name);
            this.points.add((Object)new GeoPoint(lat, lon));
        }

        public void add(double lat, double lon) {
            this.points.add((Object)new GeoPoint(lat, lon));
        }

        public BytesRef binaryValue() {
            byte[] bytes = new byte[this.points.size() * 16];
            int off = 0;
            Iterator it = this.points.iterator();
            while (it.hasNext()) {
                GeoPoint point = (GeoPoint)((ObjectCursor)it.next()).value;
                ByteUtils.writeDoubleLE(point.getLat(), bytes, off);
                ByteUtils.writeDoubleLE(point.getLon(), bytes, off + 8);
                off += 16;
            }
            return new BytesRef(bytes);
        }
    }

    public static final class Encoding {
        private static final int MAX_NUM_BYTES = 14;
        private static final Encoding[] INSTANCES = new Encoding[15];
        private final DistanceUnit.Distance precision;
        private final int numBytes;
        private final int numBytesPerCoordinate;
        private final double factor;

        public static final Encoding of(int numBytesPerValue) {
            Encoding instance = INSTANCES[numBytesPerValue];
            if (instance == null) {
                throw new IllegalStateException("No encoding for " + numBytesPerValue + " bytes per value");
            }
            return instance;
        }

        public static final Encoding of(DistanceUnit.Distance precision) {
            for (Encoding encoding : INSTANCES) {
                if (encoding == null || encoding.precision().compareTo(precision) > 0) continue;
                return encoding;
            }
            return INSTANCES[14];
        }

        private Encoding(int numBytes) {
            assert (numBytes >= 1 && numBytes <= 14);
            assert ((numBytes & 1) == 0);
            this.numBytes = numBytes;
            this.numBytesPerCoordinate = numBytes / 2;
            this.factor = Math.pow(2.0, -this.numBytesPerCoordinate * 8 + 9);
            assert ((double)(1L << this.numBytesPerCoordinate * 8 - 1) * this.factor > 180.0 && (double)(1L << this.numBytesPerCoordinate * 8 - 2) * this.factor < 180.0) : this.numBytesPerCoordinate + " " + this.factor;
            this.precision = numBytes == 14 ? new DistanceUnit.Distance(0.0, DistanceUnit.DEFAULT) : new DistanceUnit.Distance(GeoDistance.PLANE.calculate(0.0, 0.0, this.factor / 2.0, this.factor / 2.0, DistanceUnit.DEFAULT), DistanceUnit.DEFAULT);
        }

        public DistanceUnit.Distance precision() {
            return this.precision;
        }

        public final int numBytes() {
            return this.numBytes;
        }

        public int numBitsPerCoordinate() {
            return this.numBytesPerCoordinate << 3;
        }

        public long encodeCoordinate(double lat) {
            return Math.round((lat + 180.0) / this.factor);
        }

        public double decodeCoordinate(long bits) {
            return (double)bits * this.factor - 180.0;
        }

        private void encodeBits(long bits, byte[] out, int offset) {
            for (int i = 0; i < this.numBytesPerCoordinate; ++i) {
                out[offset++] = (byte)bits;
                bits >>>= 8;
            }
            assert (bits == 0L);
        }

        private long decodeBits(byte[] in, int offset) {
            long r = (long)in[offset++] & 0xFFL;
            for (int i = 1; i < this.numBytesPerCoordinate; ++i) {
                r = ((long)in[offset++] & 0xFFL) << i * 8;
            }
            return r;
        }

        public void encode(double lat, double lon, byte[] out, int offset) {
            this.encodeBits(this.encodeCoordinate(lat), out, offset);
            this.encodeBits(this.encodeCoordinate(lon), out, offset + this.numBytesPerCoordinate);
        }

        public GeoPoint decode(byte[] in, int offset, GeoPoint out) {
            long latBits = this.decodeBits(in, offset);
            long lonBits = this.decodeBits(in, offset + this.numBytesPerCoordinate);
            return this.decode(latBits, lonBits, out);
        }

        public GeoPoint decode(long latBits, long lonBits, GeoPoint out) {
            double lat = this.decodeCoordinate(latBits);
            double lon = this.decodeCoordinate(lonBits);
            return out.reset(lat, lon);
        }

        static {
            for (int numBytes = 2; numBytes <= 14; numBytes += 2) {
                Encoding.INSTANCES[numBytes] = new Encoding(numBytes);
            }
        }
    }

    public static final class GeoPointFieldType
    extends MappedFieldType {
        private MappedFieldType geohashFieldType;
        private int geohashPrecision;
        private boolean geohashPrefixEnabled;
        private MappedFieldType latFieldType;
        private MappedFieldType lonFieldType;

        public GeoPointFieldType() {
        }

        protected GeoPointFieldType(GeoPointFieldType ref) {
            super(ref);
            this.geohashFieldType = ref.geohashFieldType;
            this.geohashPrecision = ref.geohashPrecision;
            this.geohashPrefixEnabled = ref.geohashPrefixEnabled;
            this.latFieldType = ref.latFieldType;
            this.lonFieldType = ref.lonFieldType;
        }

        @Override
        public MappedFieldType clone() {
            return new GeoPointFieldType(this);
        }

        @Override
        public boolean equals(Object o) {
            if (!super.equals(o)) {
                return false;
            }
            GeoPointFieldType that = (GeoPointFieldType)((Object)o);
            return this.geohashPrecision == that.geohashPrecision && this.geohashPrefixEnabled == that.geohashPrefixEnabled && Objects.equals((Object)this.geohashFieldType, (Object)that.geohashFieldType) && Objects.equals((Object)this.latFieldType, (Object)that.latFieldType) && Objects.equals((Object)this.lonFieldType, (Object)that.lonFieldType);
        }

        @Override
        public int hashCode() {
            return Objects.hash(new Object[]{super.hashCode(), this.geohashFieldType, this.geohashPrecision, this.geohashPrefixEnabled, this.latFieldType, this.lonFieldType});
        }

        @Override
        public String typeName() {
            return GeoPointFieldMapper.CONTENT_TYPE;
        }

        @Override
        public void checkCompatibility(MappedFieldType fieldType, List<String> conflicts, boolean strict) {
            super.checkCompatibility(fieldType, conflicts, strict);
            GeoPointFieldType other = (GeoPointFieldType)fieldType;
            if (this.isLatLonEnabled() != other.isLatLonEnabled()) {
                conflicts.add("mapper [" + this.names().fullName() + "] has different [lat_lon]");
            }
            if (this.isGeohashEnabled() != other.isGeohashEnabled()) {
                conflicts.add("mapper [" + this.names().fullName() + "] has different [geohash]");
            }
            if (this.geohashPrecision() != other.geohashPrecision()) {
                conflicts.add("mapper [" + this.names().fullName() + "] has different [geohash_precision]");
            }
            if (this.isGeohashPrefixEnabled() != other.isGeohashPrefixEnabled()) {
                conflicts.add("mapper [" + this.names().fullName() + "] has different [geohash_prefix]");
            }
            if (this.isLatLonEnabled() && other.isLatLonEnabled() && this.latFieldType().numericPrecisionStep() != other.latFieldType().numericPrecisionStep()) {
                conflicts.add("mapper [" + this.names().fullName() + "] has different [precision_step]");
            }
        }

        public boolean isGeohashEnabled() {
            return this.geohashFieldType != null;
        }

        public MappedFieldType geohashFieldType() {
            return this.geohashFieldType;
        }

        public int geohashPrecision() {
            return this.geohashPrecision;
        }

        public boolean isGeohashPrefixEnabled() {
            return this.geohashPrefixEnabled;
        }

        public void setGeohashEnabled(MappedFieldType geohashFieldType, int geohashPrecision, boolean geohashPrefixEnabled) {
            this.checkIfFrozen();
            this.geohashFieldType = geohashFieldType;
            this.geohashPrecision = geohashPrecision;
            this.geohashPrefixEnabled = geohashPrefixEnabled;
        }

        public boolean isLatLonEnabled() {
            return this.latFieldType != null;
        }

        public MappedFieldType latFieldType() {
            return this.latFieldType;
        }

        public MappedFieldType lonFieldType() {
            return this.lonFieldType;
        }

        public void setLatLonEnabled(MappedFieldType latFieldType, MappedFieldType lonFieldType) {
            this.checkIfFrozen();
            this.latFieldType = latFieldType;
            this.lonFieldType = lonFieldType;
        }

        @Override
        public GeoPoint value(Object value) {
            if (value instanceof GeoPoint) {
                return (GeoPoint)value;
            }
            return GeoPoint.parseFromLatLon(value.toString());
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        @Override
        public Mapper.Builder<?, ?> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = MapperBuilders.geoPointField(name);
            boolean indexCreatedBeforeV2_0 = parserContext.indexVersionCreated().before(Version.V_2_0_0);
            TypeParsers.parseField(builder, name, node, parserContext);
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String propName = Strings.toUnderscoreCase(entry.getKey());
                Object propNode = entry.getValue();
                if (propName.equals("path") && parserContext.indexVersionCreated().before(Version.V_2_0_0_beta1)) {
                    builder.multiFieldPathType(TypeParsers.parsePathType(name, propNode.toString()));
                    iterator.remove();
                    continue;
                }
                if (propName.equals("lat_lon")) {
                    builder.enableLatLon(XContentMapValues.nodeBooleanValue(propNode));
                    iterator.remove();
                    continue;
                }
                if (propName.equals("geohash")) {
                    builder.enableGeoHash(XContentMapValues.nodeBooleanValue(propNode));
                    iterator.remove();
                    continue;
                }
                if (propName.equals("geohash_prefix")) {
                    builder.geohashPrefix(XContentMapValues.nodeBooleanValue(propNode));
                    if (XContentMapValues.nodeBooleanValue(propNode)) {
                        builder.enableGeoHash(true);
                    }
                    iterator.remove();
                    continue;
                }
                if (propName.equals("precision_step")) {
                    builder.precisionStep(XContentMapValues.nodeIntegerValue(propNode));
                    iterator.remove();
                    continue;
                }
                if (propName.equals("geohash_precision")) {
                    if (propNode instanceof Integer) {
                        builder.geoHashPrecision(XContentMapValues.nodeIntegerValue(propNode));
                    } else {
                        builder.geoHashPrecision(GeoUtils.geoHashLevelsForPrecision(propNode.toString()));
                    }
                    iterator.remove();
                    continue;
                }
                if (propName.equals("ignore_malformed")) {
                    builder.ignoreMalformed(XContentMapValues.nodeBooleanValue(propNode));
                    iterator.remove();
                    continue;
                }
                if (indexCreatedBeforeV2_0 && propName.equals("validate")) {
                    builder.ignoreMalformed(!XContentMapValues.nodeBooleanValue(propNode));
                    iterator.remove();
                    continue;
                }
                if (indexCreatedBeforeV2_0 && propName.equals("validate_lon")) {
                    builder.ignoreMalformed(!XContentMapValues.nodeBooleanValue(propNode));
                    iterator.remove();
                    continue;
                }
                if (indexCreatedBeforeV2_0 && propName.equals("validate_lat")) {
                    builder.ignoreMalformed(!XContentMapValues.nodeBooleanValue(propNode));
                    iterator.remove();
                    continue;
                }
                if (propName.equals("coerce")) {
                    builder.coerce(XContentMapValues.nodeBooleanValue(propNode));
                    iterator.remove();
                    continue;
                }
                if (indexCreatedBeforeV2_0 && propName.equals("normalize")) {
                    builder.coerce(XContentMapValues.nodeBooleanValue(propNode));
                    iterator.remove();
                    continue;
                }
                if (indexCreatedBeforeV2_0 && propName.equals("normalize_lat")) {
                    builder.coerce(XContentMapValues.nodeBooleanValue(propNode));
                    iterator.remove();
                    continue;
                }
                if (indexCreatedBeforeV2_0 && propName.equals("normalize_lon")) {
                    builder.coerce(XContentMapValues.nodeBooleanValue(propNode));
                    iterator.remove();
                    continue;
                }
                if (!TypeParsers.parseMultiField(builder, name, parserContext, propName, propNode)) continue;
                iterator.remove();
            }
            return builder;
        }
    }

    public static class Builder
    extends FieldMapper.Builder<Builder, GeoPointFieldMapper> {
        private ContentPath.Type pathType = Defaults.PATH_TYPE;
        private boolean enableGeoHash = false;
        private boolean enableGeohashPrefix = false;
        private boolean enableLatLon = false;
        private Integer precisionStep;
        private int geoHashPrecision = 12;
        private Boolean ignoreMalformed;
        private Boolean coerce;

        public Builder(String name) {
            super(name, Defaults.FIELD_TYPE);
            this.builder = this;
        }

        public Builder ignoreMalformed(boolean ignoreMalformed) {
            this.ignoreMalformed = ignoreMalformed;
            return (Builder)this.builder;
        }

        protected Explicit<Boolean> ignoreMalformed(Mapper.BuilderContext context) {
            if (this.ignoreMalformed != null) {
                return new Explicit<Boolean>(this.ignoreMalformed, true);
            }
            if (context.indexSettings() != null) {
                return new Explicit<Boolean>(context.indexSettings().getAsBoolean("index.mapping.ignore_malformed", Defaults.IGNORE_MALFORMED.value()), false);
            }
            return Defaults.IGNORE_MALFORMED;
        }

        public Builder coerce(boolean coerce) {
            this.coerce = coerce;
            return (Builder)this.builder;
        }

        protected Explicit<Boolean> coerce(Mapper.BuilderContext context) {
            if (this.coerce != null) {
                return new Explicit<Boolean>(this.coerce, true);
            }
            if (context.indexSettings() != null) {
                return new Explicit<Boolean>(context.indexSettings().getAsBoolean("index.mapping.coerce", Defaults.COERCE.value()), false);
            }
            return Defaults.COERCE;
        }

        @Override
        public GeoPointFieldType fieldType() {
            return (GeoPointFieldType)this.fieldType;
        }

        @Override
        public Builder multiFieldPathType(ContentPath.Type pathType) {
            this.pathType = pathType;
            return this;
        }

        public Builder enableGeoHash(boolean enableGeoHash) {
            this.enableGeoHash = enableGeoHash;
            return this;
        }

        public Builder geohashPrefix(boolean enableGeohashPrefix) {
            this.enableGeohashPrefix = enableGeohashPrefix;
            return this;
        }

        public Builder enableLatLon(boolean enableLatLon) {
            this.enableLatLon = enableLatLon;
            return this;
        }

        public Builder precisionStep(int precisionStep) {
            this.precisionStep = precisionStep;
            return this;
        }

        public Builder geoHashPrecision(int precision) {
            this.geoHashPrecision = precision;
            return this;
        }

        @Override
        public Builder fieldDataSettings(Settings settings) {
            this.fieldDataSettings = settings;
            return (Builder)this.builder;
        }

        @Override
        public GeoPointFieldMapper build(Mapper.BuilderContext context) {
            ContentPath.Type origPathType = context.path().pathType();
            context.path().pathType(this.pathType);
            DoubleFieldMapper latMapper = null;
            DoubleFieldMapper lonMapper = null;
            GeoPointFieldType geoPointFieldType = (GeoPointFieldType)this.fieldType;
            context.path().add(this.name);
            if (this.enableLatLon) {
                NumberFieldMapper.Builder latMapperBuilder = (NumberFieldMapper.Builder)MapperBuilders.doubleField("lat").includeInAll(false);
                NumberFieldMapper.Builder lonMapperBuilder = (NumberFieldMapper.Builder)MapperBuilders.doubleField("lon").includeInAll(false);
                if (this.precisionStep != null) {
                    latMapperBuilder.precisionStep(this.precisionStep);
                    lonMapperBuilder.precisionStep(this.precisionStep);
                }
                latMapper = (DoubleFieldMapper)((Mapper.Builder)((FieldMapper.Builder)((NumberFieldMapper.Builder)latMapperBuilder.includeInAll(false)).store(this.fieldType.stored())).docValues(false)).build(context);
                lonMapper = (DoubleFieldMapper)((Mapper.Builder)((FieldMapper.Builder)((NumberFieldMapper.Builder)lonMapperBuilder.includeInAll(false)).store(this.fieldType.stored())).docValues(false)).build(context);
                geoPointFieldType.setLatLonEnabled(latMapper.fieldType(), lonMapper.fieldType());
            }
            StringFieldMapper geohashMapper = null;
            if (this.enableGeoHash || this.enableGeohashPrefix) {
                geohashMapper = ((StringFieldMapper.Builder)((StringFieldMapper.Builder)((StringFieldMapper.Builder)((StringFieldMapper.Builder)((StringFieldMapper.Builder)((StringFieldMapper.Builder)MapperBuilders.stringField("geohash").index(true)).tokenized(false)).includeInAll(false)).store(this.fieldType.stored())).omitNorms(true)).indexOptions(IndexOptions.DOCS)).build(context);
                geoPointFieldType.setGeohashEnabled(geohashMapper.fieldType(), this.geoHashPrecision, this.enableGeohashPrefix);
            }
            context.path().remove();
            context.path().pathType(origPathType);
            this.fieldType.setTokenized(false);
            this.setupFieldType(context);
            this.fieldType.setHasDocValues(false);
            this.defaultFieldType.setHasDocValues(false);
            return new GeoPointFieldMapper(this.name, this.fieldType, this.defaultFieldType, context.indexSettings(), origPathType, latMapper, lonMapper, geohashMapper, this.multiFieldsBuilder.build(this, context), this.ignoreMalformed(context), this.coerce(context));
        }
    }

    public static class Defaults {
        public static final ContentPath.Type PATH_TYPE = ContentPath.Type.FULL;
        public static final boolean ENABLE_LATLON = false;
        public static final boolean ENABLE_GEOHASH = false;
        public static final boolean ENABLE_GEOHASH_PREFIX = false;
        public static final int GEO_HASH_PRECISION = 12;
        public static final Explicit<Boolean> IGNORE_MALFORMED = new Explicit<Boolean>(false, false);
        public static final Explicit<Boolean> COERCE = new Explicit<Boolean>(false, false);
        public static final MappedFieldType FIELD_TYPE = new GeoPointFieldType();

        static {
            FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.freeze();
        }
    }

    public static class Names {
        public static final String LAT = "lat";
        public static final String LAT_SUFFIX = ".lat";
        public static final String LON = "lon";
        public static final String LON_SUFFIX = ".lon";
        public static final String GEOHASH = "geohash";
        public static final String GEOHASH_SUFFIX = ".geohash";
        public static final String IGNORE_MALFORMED = "ignore_malformed";
        public static final String COERCE = "coerce";
    }
}

