/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import org.scilab.forge.jlatexmath.Box;
import org.scilab.forge.jlatexmath.GlueBox;
import org.scilab.forge.jlatexmath.GlueSettingsParser;
import org.scilab.forge.jlatexmath.TeXEnvironment;
import org.scilab.forge.jlatexmath.TeXFont;

public class Glue {
    private final float space;
    private final float stretch;
    private final float shrink;
    private final String name;
    private static Glue[] glueTypes;
    private static final int[][][] glueTable;

    public Glue(float f, float f2, float f3, String string) {
        this.space = f;
        this.stretch = f2;
        this.shrink = f3;
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public static Box get(int n, int n2, TeXEnvironment teXEnvironment) {
        int n3 = n > 7 ? 0 : n;
        int n4 = n2 > 7 ? 0 : n2;
        int n5 = glueTable[n3][n4][teXEnvironment.getStyle() / 2];
        return glueTypes[n5].createBox(teXEnvironment);
    }

    private Box createBox(TeXEnvironment teXEnvironment) {
        TeXFont teXFont = teXEnvironment.getTeXFont();
        float f = teXFont.getQuad(teXEnvironment.getStyle(), teXFont.getMuFontId());
        return new GlueBox(this.space / 18.0f * f, this.stretch / 18.0f * f, this.shrink / 18.0f * f);
    }

    static {
        GlueSettingsParser glueSettingsParser = new GlueSettingsParser();
        glueTypes = glueSettingsParser.getGlueTypes();
        glueTable = glueSettingsParser.createGlueTable();
    }
}

