/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.mozilla.javascript.FunctionNode;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.ObjArray;
import org.mozilla.javascript.ScriptOrFnNode;
import org.mozilla.javascript.ScriptRuntime;

public class NodeTransformer {
    private ObjArray loops;
    private ObjArray loopEnds;
    private boolean hasFinally;

    public final void transform(ScriptOrFnNode scriptOrFnNode) {
        this.transformCompilationUnit(scriptOrFnNode);
        for (int i = 0; i != scriptOrFnNode.getFunctionCount(); ++i) {
            FunctionNode functionNode = scriptOrFnNode.getFunctionNode(i);
            this.transform(functionNode);
        }
    }

    private void transformCompilationUnit(ScriptOrFnNode scriptOrFnNode) {
        this.loops = new ObjArray();
        this.loopEnds = new ObjArray();
        this.hasFinally = false;
        boolean bl = scriptOrFnNode.getType() != 108 || ((FunctionNode)scriptOrFnNode).requiresActivation();
        scriptOrFnNode.flattenSymbolTable(!bl);
        this.transformCompilationUnit_r(scriptOrFnNode, scriptOrFnNode, scriptOrFnNode, bl);
    }

    private void transformCompilationUnit_r(ScriptOrFnNode scriptOrFnNode, Node node, Node.Scope scope, boolean bl) {
        Node node2 = null;
        block16: while (true) {
            Object object;
            Node node3;
            Object object2;
            Object object3;
            Node node4 = null;
            if (node2 == null) {
                node2 = node.getFirstChild();
            } else {
                node4 = node2;
                node2 = node2.getNext();
            }
            if (node2 == null) break;
            int n = node2.getType();
            if (bl && (n == 128 || n == 131 || n == 156) && node2 instanceof Node.Scope) {
                object3 = (Node.Scope)node2;
                if (((Node.Scope)object3).symbolTable != null) {
                    object2 = new Node(n == 156 ? 157 : 152);
                    node3 = new Node(152);
                    ((Node)object2).addChildToBack(node3);
                    for (String string : ((Node.Scope)object3).symbolTable.keySet()) {
                        node3.addChildToBack(Node.newString(39, string));
                    }
                    ((Node.Scope)object3).symbolTable = null;
                    object = node2;
                    node2 = NodeTransformer.replaceCurrent(node, node4, node2, (Node)object2);
                    n = node2.getType();
                    ((Node)object2).addChildToBack((Node)object);
                }
            }
            switch (n) {
                case 113: 
                case 129: 
                case 131: {
                    this.loops.push(node2);
                    this.loopEnds.push(((Node.Jump)node2).target);
                    break;
                }
                case 122: {
                    this.loops.push(node2);
                    object3 = node2.getNext();
                    if (((Node)object3).getType() != 3) {
                        Kit.codeBug();
                    }
                    this.loopEnds.push(object3);
                    break;
                }
                case 80: {
                    object3 = (Node.Jump)node2;
                    object2 = ((Node.Jump)object3).getFinally();
                    if (object2 == null) break;
                    this.hasFinally = true;
                    this.loops.push(node2);
                    this.loopEnds.push(object2);
                    break;
                }
                case 3: 
                case 130: {
                    if (this.loopEnds.isEmpty() || this.loopEnds.peek() != node2) break;
                    this.loopEnds.pop();
                    this.loops.pop();
                    break;
                }
                case 72: {
                    ((FunctionNode)scriptOrFnNode).addResumptionPoint(node2);
                    break;
                }
                case 4: {
                    Node node5;
                    Node.Jump jump;
                    boolean bl2;
                    boolean bl3 = bl2 = scriptOrFnNode.getType() == 108 && ((FunctionNode)scriptOrFnNode).isGenerator();
                    if (bl2) {
                        node2.putIntProp(20, 1);
                    }
                    if (!this.hasFinally) break;
                    object2 = null;
                    for (int i = this.loops.size() - 1; i >= 0; --i) {
                        object = (Node)this.loops.get(i);
                        int n2 = ((Node)object).getType();
                        if (n2 != 80 && n2 != 122) continue;
                        if (n2 == 80) {
                            Node node6;
                            jump = new Node.Jump(134);
                            jump.target = node6 = ((Node.Jump)object).getFinally();
                            node5 = jump;
                        } else {
                            node5 = new Node(3);
                        }
                        if (object2 == null) {
                            object2 = new Node(128, node2.getLineno());
                        }
                        ((Node)object2).addChildToBack(node5);
                    }
                    if (object2 == null) break;
                    Node node7 = node2;
                    object = node7.getFirstChild();
                    node2 = NodeTransformer.replaceCurrent(node, node4, node2, (Node)object2);
                    if (object == null || bl2) {
                        ((Node)object2).addChildToBack(node7);
                        continue block16;
                    }
                    Node node8 = new Node(133, (Node)object);
                    ((Node)object2).addChildToFront(node8);
                    node7 = new Node(64);
                    ((Node)object2).addChildToBack(node7);
                    this.transformCompilationUnit_r(scriptOrFnNode, node8, scope, bl);
                    continue block16;
                }
                case 119: 
                case 120: {
                    Node node5;
                    Node.Jump jump;
                    object3 = (Node.Jump)node2;
                    object2 = ((Node.Jump)object3).getJumpStatement();
                    if (object2 == null) {
                        Kit.codeBug();
                    }
                    int n3 = this.loops.size();
                    while (true) {
                        if (n3 == 0) {
                            throw Kit.codeBug();
                        }
                        if ((object = (Node)this.loops.get(--n3)) == object2) break;
                        int n4 = ((Node)object).getType();
                        if (n4 == 122) {
                            node5 = new Node(3);
                            node4 = NodeTransformer.addBeforeCurrent(node, node4, node2, node5);
                            continue;
                        }
                        if (n4 != 80) continue;
                        node5 = (Node.Jump)object;
                        jump = new Node.Jump(134);
                        jump.target = ((Node.Jump)node5).getFinally();
                        node4 = NodeTransformer.addBeforeCurrent(node, node4, node2, jump);
                    }
                    ((Node.Jump)object3).target = n == 119 ? ((Node.Jump)object2).target : ((Node.Jump)object2).getContinue();
                    ((Node)object3).setType(5);
                    break;
                }
                case 38: {
                    this.visitCall(node2, scriptOrFnNode);
                    break;
                }
                case 30: {
                    this.visitNew(node2, scriptOrFnNode);
                    break;
                }
                case 152: 
                case 157: {
                    object3 = node2.getFirstChild();
                    if (((Node)object3).getType() == 152) {
                        boolean bl4 = scriptOrFnNode.getType() != 108 || ((FunctionNode)scriptOrFnNode).requiresActivation();
                        node2 = this.visitLet(bl4, node, node4, node2);
                        break;
                    }
                }
                case 121: 
                case 153: {
                    object3 = new Node(128);
                    object2 = node2.getFirstChild();
                    while (object2 != null) {
                        node3 = object2;
                        object2 = ((Node)object2).getNext();
                        if (node3.getType() == 39) {
                            if (!node3.hasChildren()) continue;
                            object = node3.getFirstChild();
                            node3.removeChild((Node)object);
                            node3.setType(49);
                            node3 = new Node(n == 153 ? 154 : 8, node3, (Node)object);
                        } else if (node3.getType() != 157) {
                            throw Kit.codeBug();
                        }
                        object = new Node(132, node3, node2.getLineno());
                        ((Node)object3).addChildToBack((Node)object);
                    }
                    node2 = NodeTransformer.replaceCurrent(node, node4, node2, (Node)object3);
                    break;
                }
                case 136: {
                    object3 = scope.getDefiningScope(node2.getString());
                    if (object3 == null) break;
                    node2.setScope((Node.Scope)object3);
                    break;
                }
                case 7: 
                case 32: {
                    object3 = node2.getFirstChild();
                    if (n == 7) {
                        while (((Node)object3).getType() == 26) {
                            object3 = ((Node)object3).getFirstChild();
                        }
                        if (((Node)object3).getType() == 12 || ((Node)object3).getType() == 13) {
                            object2 = ((Node)object3).getFirstChild();
                            node3 = ((Node)object3).getLastChild();
                            if (((Node)object2).getType() == 39 && ((Node)object2).getString().equals("undefined")) {
                                object3 = node3;
                            } else if (node3.getType() == 39 && node3.getString().equals("undefined")) {
                                object3 = object2;
                            }
                        }
                    }
                    if (((Node)object3).getType() != 33) break;
                    ((Node)object3).setType(34);
                    break;
                }
                case 8: 
                case 31: 
                case 39: 
                case 154: {
                    if (bl) break;
                    if (n == 39) {
                        object3 = node2;
                    } else {
                        object3 = node2.getFirstChild();
                        if (((Node)object3).getType() != 49) {
                            if (n == 31) break;
                            throw Kit.codeBug();
                        }
                    }
                    if (((Node)object3).getScope() != null || (node3 = scope.getDefiningScope((String)(object2 = ((Node)object3).getString()))) == null) break;
                    ((Node)object3).setScope((Node.Scope)node3);
                    if (n == 39) {
                        node2.setType(55);
                        break;
                    }
                    if (n == 8) {
                        node2.setType(56);
                        ((Node)object3).setType(41);
                        break;
                    }
                    if (n == 154) {
                        node2.setType(155);
                        ((Node)object3).setType(41);
                        break;
                    }
                    if (n == 31) {
                        object = new Node(44);
                        node2 = NodeTransformer.replaceCurrent(node, node4, node2, (Node)object);
                        break;
                    }
                    throw Kit.codeBug();
                }
            }
            this.transformCompilationUnit_r(scriptOrFnNode, node2, node2 instanceof Node.Scope ? (Node.Scope)node2 : scope, bl);
        }
    }

    protected void visitNew(Node node, ScriptOrFnNode scriptOrFnNode) {
    }

    protected void visitCall(Node node, ScriptOrFnNode scriptOrFnNode) {
    }

    protected Node visitLet(boolean bl, Node node, Node node2, Node node3) {
        Node node4;
        boolean bl2;
        Node node5 = node3.getFirstChild();
        Node node6 = node5.getNext();
        node3.removeChild(node5);
        node3.removeChild(node6);
        boolean bl3 = bl2 = node3.getType() == 157;
        if (bl) {
            node4 = new Node(bl2 ? 158 : 128);
            node4 = NodeTransformer.replaceCurrent(node, node2, node3, node4);
            ArrayList<Object> arrayList = new ArrayList<Object>();
            Node node7 = new Node(66);
            for (Node node8 = node5.getFirstChild(); node8 != null; node8 = node8.getNext()) {
                Object object;
                Node node9 = node8;
                if (node9.getType() == 157) {
                    object = (List)node9.getProp(22);
                    Node node10 = node9.getFirstChild();
                    if (node10.getType() != 152) {
                        throw Kit.codeBug();
                    }
                    node6 = bl2 ? new Node(88, node10.getNext(), node6) : new Node(128, new Node(132, node10.getNext()), node6);
                    if (object != null) {
                        arrayList.addAll((Collection<Object>)object);
                        for (int i = 0; i < object.size(); ++i) {
                            node7.addChildToBack(new Node(125, Node.newNumber(0.0)));
                        }
                    }
                    node9 = node10.getFirstChild();
                }
                if (node9.getType() != 39) {
                    throw Kit.codeBug();
                }
                arrayList.add(ScriptRuntime.getIndexObject(node9.getString()));
                object = node9.getFirstChild();
                if (object == null) {
                    object = new Node(125, Node.newNumber(0.0));
                }
                node7.addChildToBack((Node)object);
            }
            node7.putProp(12, arrayList.toArray());
            Node node11 = new Node(2, node7);
            node4.addChildToBack(node11);
            node4.addChildToBack(new Node(122, node6));
            node4.addChildToBack(new Node(3));
        } else {
            node4 = new Node(bl2 ? 88 : 128);
            node4 = NodeTransformer.replaceCurrent(node, node2, node3, node4);
            Node node12 = new Node(88);
            for (Node node13 = node5.getFirstChild(); node13 != null; node13 = node13.getNext()) {
                Node node14;
                Node node15 = node13;
                if (node15.getType() == 157) {
                    node14 = node15.getFirstChild();
                    if (node14.getType() != 152) {
                        throw Kit.codeBug();
                    }
                    node6 = bl2 ? new Node(88, node14.getNext(), node6) : new Node(128, new Node(132, node14.getNext()), node6);
                    Node.Scope.joinScopes((Node.Scope)node15, (Node.Scope)node3);
                    node15 = node14.getFirstChild();
                }
                if (node15.getType() != 39) {
                    throw Kit.codeBug();
                }
                node14 = Node.newString(node15.getString());
                node14.setScope((Node.Scope)node3);
                Node node16 = node15.getFirstChild();
                if (node16 == null) {
                    node16 = new Node(125, Node.newNumber(0.0));
                }
                node12.addChildToBack(new Node(56, node14, node16));
            }
            if (bl2) {
                node4.addChildToBack(node12);
                node3.setType(88);
                node4.addChildToBack(node3);
                node3.addChildToBack(node6);
            } else {
                node4.addChildToBack(new Node(132, node12));
                node3.setType(128);
                node4.addChildToBack(node3);
                node3.addChildrenToBack(node6);
            }
        }
        return node4;
    }

    private static Node addBeforeCurrent(Node node, Node node2, Node node3, Node node4) {
        if (node2 == null) {
            if (node3 != node.getFirstChild()) {
                Kit.codeBug();
            }
            node.addChildToFront(node4);
        } else {
            if (node3 != node2.getNext()) {
                Kit.codeBug();
            }
            node.addChildAfter(node4, node2);
        }
        return node4;
    }

    private static Node replaceCurrent(Node node, Node node2, Node node3, Node node4) {
        if (node2 == null) {
            if (node3 != node.getFirstChild()) {
                Kit.codeBug();
            }
            node.replaceChild(node3, node4);
        } else if (node2.next == node3) {
            node.replaceChildAfter(node2, node4);
        } else {
            node.replaceChild(node3, node4);
        }
        return node4;
    }
}

