/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.operands;

import org.jruby.ir.IRVisitor;
import org.jruby.ir.operands.ImmutableLiteral;
import org.jruby.ir.operands.OperandType;
import org.jruby.runtime.ThreadContext;

public class Rational
extends ImmutableLiteral {
    private final long numerator;
    private final long denominator;

    public Rational(long numerator2, long denominator2) {
        this.numerator = numerator2;
        this.denominator = denominator2;
    }

    @Override
    public OperandType getOperandType() {
        return OperandType.RATIONAL;
    }

    @Override
    public Object createCacheObject(ThreadContext context) {
        return context.runtime.newRational(this.numerator, this.denominator);
    }

    public String toString() {
        return "Rational:" + this.numerator + "/1";
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.Rational(this);
    }

    public long getNumerator() {
        return this.numerator;
    }

    public long getDenominator() {
        return this.denominator;
    }
}

