/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.instrument;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.instrument.ASTProber;
import com.oracle.truffle.api.instrument.Instrument;
import com.oracle.truffle.api.instrument.ProbeListener;
import com.oracle.truffle.api.instrument.ProbeNode;
import com.oracle.truffle.api.instrument.SyntaxTag;
import com.oracle.truffle.api.instrument.SyntaxTagTrap;
import com.oracle.truffle.api.nodes.InvalidAssumptionException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeVisitor;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.CyclicAssumption;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class Probe {
    private static final List<ASTProber> astProbers = new ArrayList<ASTProber>();
    private static final List<ProbeListener> probeListeners = new ArrayList<ProbeListener>();
    private static final List<WeakReference<Probe>> probes = new ArrayList<WeakReference<Probe>>();
    @CompilerDirectives.CompilationFinal
    private static SyntaxTagTrap beforeTagTrap = null;
    @CompilerDirectives.CompilationFinal
    private static SyntaxTagTrap afterTagTrap = null;
    private final SourceSection sourceSection;
    private final ArrayList<SyntaxTag> tags = new ArrayList();
    private final List<WeakReference<ProbeNode>> probeNodeClones = new ArrayList<WeakReference<ProbeNode>>();
    private final CyclicAssumption probeStateUnchangedCyclic = new CyclicAssumption("Probe state unchanged");
    @CompilerDirectives.CompilationFinal
    private Assumption probeStateUnchangedAssumption = this.probeStateUnchangedCyclic.getAssumption();
    @CompilerDirectives.CompilationFinal
    private boolean isBeforeTrapActive = false;
    @CompilerDirectives.CompilationFinal
    private boolean isAfterTrapActive = false;

    private static Source findSource(Node node) {
        FindSourceVisitor visitor = new FindSourceVisitor();
        node.accept(visitor);
        return visitor.source;
    }

    public static void registerASTProber(ASTProber prober) {
        astProbers.add(prober);
    }

    public static void unregisterASTProber(ASTProber prober) {
        astProbers.remove(prober);
    }

    public static void applyASTProbers(Node node) {
        Source source = Probe.findSource(node);
        for (ProbeListener listener : probeListeners) {
            listener.startASTProbing(source);
        }
        for (ASTProber prober : astProbers) {
            prober.probeAST(node);
        }
        for (ProbeListener listener : probeListeners) {
            listener.endASTProbing(source);
        }
    }

    public static void addProbeListener(ProbeListener listener) {
        assert (listener != null);
        probeListeners.add(listener);
    }

    public static void removeProbeListener(ProbeListener listener) {
        probeListeners.remove(listener);
    }

    public static Collection<Probe> findProbesTaggedAs(SyntaxTag tag) {
        ArrayList<Probe> taggedProbes = new ArrayList<Probe>();
        for (WeakReference<Probe> ref : probes) {
            Probe probe = (Probe)ref.get();
            if (probe == null || tag != null && !probe.isTaggedAs(tag)) continue;
            taggedProbes.add((Probe)ref.get());
        }
        return taggedProbes;
    }

    public static void setBeforeTagTrap(SyntaxTagTrap newBeforeTagTrap) {
        beforeTagTrap = newBeforeTagTrap;
        for (WeakReference<Probe> ref : probes) {
            Probe probe = (Probe)ref.get();
            if (probe == null) continue;
            probe.notifyTrapsChanged();
        }
    }

    public static void setAfterTagTrap(SyntaxTagTrap newAfterTagTrap) {
        afterTagTrap = newAfterTagTrap;
        for (WeakReference<Probe> ref : probes) {
            Probe probe = (Probe)ref.get();
            if (probe == null) continue;
            probe.notifyTrapsChanged();
        }
    }

    Probe(ProbeNode probeNode, SourceSection sourceSection) {
        this.sourceSection = sourceSection;
        probes.add(new WeakReference<Probe>(this));
        this.registerProbeNodeClone(probeNode);
        for (ProbeListener listener : probeListeners) {
            listener.newProbeInserted(this);
        }
    }

    public boolean isTaggedAs(SyntaxTag tag) {
        assert (tag != null);
        return this.tags.contains(tag);
    }

    public Collection<SyntaxTag> getSyntaxTags() {
        return Collections.unmodifiableCollection(this.tags);
    }

    public void tagAs(SyntaxTag tag, Object tagValue) {
        assert (tag != null);
        if (!this.tags.contains(tag)) {
            this.tags.add(tag);
            for (ProbeListener listener : probeListeners) {
                listener.probeTaggedAs(this, tag, tagValue);
            }
            boolean tagTrapsChanged = false;
            if (beforeTagTrap != null && tag == beforeTagTrap.getTag()) {
                this.isBeforeTrapActive = true;
                tagTrapsChanged = true;
            }
            if (afterTagTrap != null && tag == afterTagTrap.getTag()) {
                this.isAfterTrapActive = true;
                tagTrapsChanged = true;
            }
            if (tagTrapsChanged) {
                this.invalidateProbeUnchanged();
            }
        }
    }

    public void attach(Instrument instrument) throws IllegalStateException {
        if (instrument.isDisposed()) {
            throw new IllegalStateException("Attempt to attach disposed instrument");
        }
        if (instrument.getProbe() != null) {
            throw new IllegalStateException("Attampt to attach an already attached instrument");
        }
        instrument.setAttachedTo(this);
        for (WeakReference<ProbeNode> ref : this.probeNodeClones) {
            ProbeNode probeNode = (ProbeNode)ref.get();
            if (probeNode == null) continue;
            probeNode.addInstrument(instrument);
        }
        this.invalidateProbeUnchanged();
    }

    public SourceSection getProbedSourceSection() {
        return this.sourceSection;
    }

    public String getShortDescription() {
        String location = this.sourceSection == null ? "<unknown>" : this.sourceSection.getShortDescription();
        return "Probe@" + location + this.getTagsDescription();
    }

    void disposeInstrument(Instrument instrument) throws IllegalStateException {
        for (WeakReference<ProbeNode> ref : this.probeNodeClones) {
            ProbeNode probeNode = (ProbeNode)ref.get();
            if (probeNode == null) continue;
            probeNode.removeInstrument(instrument);
        }
        this.invalidateProbeUnchanged();
    }

    void registerProbeNodeClone(ProbeNode probeNode) {
        this.probeNodeClones.add(new WeakReference<ProbeNode>(probeNode));
    }

    SyntaxTagTrap getBeforeTrap() {
        this.checkProbeUnchanged();
        return this.isBeforeTrapActive ? beforeTagTrap : null;
    }

    SyntaxTagTrap getAfterTrap() {
        this.checkProbeUnchanged();
        return this.isAfterTrapActive ? afterTagTrap : null;
    }

    void checkProbeUnchanged() {
        try {
            this.probeStateUnchangedAssumption.check();
        }
        catch (InvalidAssumptionException ex) {
            this.probeStateUnchangedAssumption = this.probeStateUnchangedCyclic.getAssumption();
        }
    }

    void invalidateProbeUnchanged() {
        this.probeStateUnchangedCyclic.invalidate();
    }

    private void notifyTrapsChanged() {
        this.isBeforeTrapActive = beforeTagTrap != null && this.isTaggedAs(beforeTagTrap.getTag());
        this.isAfterTrapActive = afterTagTrap != null && this.isTaggedAs(afterTagTrap.getTag());
        this.invalidateProbeUnchanged();
    }

    private String getTagsDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        String prefix = "";
        for (SyntaxTag tag : this.tags) {
            sb.append(prefix);
            prefix = ",";
            sb.append(tag.toString());
        }
        sb.append("]");
        return sb.toString();
    }

    private static final class FindSourceVisitor
    implements NodeVisitor {
        Source source = null;

        private FindSourceVisitor() {
        }

        @Override
        public boolean visit(Node node) {
            SourceSection sourceSection = node.getSourceSection();
            if (sourceSection != null) {
                this.source = sourceSection.getSource();
                return false;
            }
            return true;
        }
    }
}

