/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.control.basics.geom;

import com.baselet.control.basics.geom.PointDouble;

public class Point {
    public int x;
    public int y;

    public Point() {
    }

    public Point(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int n) {
        this.x = n;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int n) {
        this.y = n;
    }

    public Point move(int n, int n2) {
        this.x += n;
        this.y += n2;
        return this;
    }

    public double distance(Point point) {
        double d = point.getX() - this.getX();
        double d2 = point.getY() - this.getY();
        return Math.sqrt(d * d + d2 * d2);
    }

    public Point copy() {
        return new Point(this.x, this.y);
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.x;
        n = 31 * n + this.y;
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Point point = (Point)object;
        if (this.x != point.x) {
            return false;
        }
        return this.y == point.y;
    }

    public String toString() {
        return "p(x=" + this.x + ", y=" + this.y + ")";
    }

    public PointDouble toPointDouble() {
        return new PointDouble(this.x, this.y);
    }
}

