/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.diagram;

import com.baselet.control.basics.geom.DimensionDouble;
import com.baselet.control.basics.geom.Rectangle;
import com.baselet.diagram.FontHandler;
import com.baselet.diagram.FormattedFont;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import javax.swing.JComponent;

public class DiagramNotification
extends JComponent {
    private static final long serialVersionUID = 1L;
    private final String message;
    private final Rectangle drawPanelSize;
    private static final Font notificationFont = new Font("SansSerif", 0, 10);
    private static final FontRenderContext frc = new FontRenderContext(null, true, true);

    public DiagramNotification(Rectangle drawPanelSize, String message) {
        this.message = message;
        this.drawPanelSize = drawPanelSize;
        this.setSize(100, 20);
        this.adaptDimensions();
    }

    @Override
    public final void paint(Graphics g) {
        super.paint(g);
        Graphics2D g2 = (Graphics2D)g;
        Composite old = g2.getComposite();
        g2.setComposite(AlphaComposite.getInstance(3, 0.4f));
        g2.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        Font drawFont = g2.getFont();
        g2.setFont(notificationFont);
        this.adaptDimensions();
        int textX = 5;
        int textY = this.getHeight() / 2 + 3;
        g2.setComposite(AlphaComposite.getInstance(3, 0.7f));
        g2.drawString(this.message, textX, textY);
        g2.setComposite(AlphaComposite.getInstance(3, 0.05f));
        g2.setColor(Color.blue);
        g2.fillRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        g2.setComposite(old);
        g2.setFont(drawFont);
    }

    private void adaptDimensions() {
        DimensionDouble textSize = FontHandler.getTextSizeStatic(new FormattedFont(this.message, notificationFont.getSize(), notificationFont, frc));
        int x = (int)((double)this.drawPanelSize.getX2() - textSize.getWidth() - 20.0);
        int y = this.drawPanelSize.getY() + 10;
        this.setLocation(x, y);
        this.setSize((int)textSize.getWidth() + 10, (int)textSize.getHeight() + 10);
    }
}

