/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element;

import com.baselet.element.interfaces.GridElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class Selector {
    private void selectHelper(boolean bl, Collection<GridElement> collection) {
        for (GridElement gridElement : this.expand(collection)) {
            if (this.getSelectedElements().contains(gridElement)) continue;
            this.getSelectedElements().add(gridElement);
            this.doAfterSelect(gridElement);
        }
        if (bl) {
            this.doAfterSelectionChanged();
        }
    }

    private void deselectHelper(boolean bl, Collection<GridElement> collection) {
        for (GridElement gridElement : this.expand(collection)) {
            Iterator<GridElement> iterator = this.getSelectedElements().iterator();
            while (iterator.hasNext()) {
                if (!iterator.next().equals(gridElement)) continue;
                iterator.remove();
                this.doAfterDeselect(gridElement);
            }
        }
        if (bl) {
            this.doAfterSelectionChanged();
        }
    }

    private List<GridElement> expand(Collection<GridElement> collection) {
        Map<Integer, Collection<GridElement>> map = Selector.createGroupElementMap(this.getAllElements());
        ArrayList<GridElement> arrayList = new ArrayList<GridElement>();
        for (GridElement gridElement : collection) {
            Collection<GridElement> collection2;
            if (gridElement.getGroup() == null || (collection2 = map.get(gridElement.getGroup())) == null) continue;
            for (GridElement gridElement2 : collection2) {
                if (gridElement2 == gridElement) continue;
                arrayList.add(gridElement2);
            }
        }
        arrayList.addAll(collection);
        return arrayList;
    }

    public void select(GridElement gridElement) {
        this.select(Arrays.asList(gridElement));
    }

    public void deselect(GridElement gridElement) {
        this.deselect(Arrays.asList(gridElement));
    }

    public abstract List<GridElement> getSelectedElements();

    public boolean isSelected(GridElement gridElement) {
        return this.getSelectedElements().contains(gridElement);
    }

    public boolean isSelectedOnly(GridElement gridElement) {
        return this.getSelectedElements().size() == 1 && this.isSelected(gridElement);
    }

    public void selectOnly(GridElement gridElement) {
        this.selectOnly(Arrays.asList(gridElement));
    }

    public void selectOnly(Collection<GridElement> collection) {
        this.deselectHelper(false, this.getSelectedElements());
        this.selectHelper(true, collection);
    }

    public void select(Collection<GridElement> collection) {
        this.selectHelper(true, collection);
    }

    public void deselect(Collection<GridElement> collection) {
        this.deselectHelper(true, collection);
    }

    public void deselectAll() {
        this.deselect(this.getSelectedElements());
    }

    public void deselectAllWithoutAfterAction() {
        this.deselectHelper(false, this.getSelectedElements());
    }

    public void doAfterDeselect(GridElement gridElement) {
        gridElement.getComponent().afterModelUpdate();
    }

    public void doAfterSelectionChanged() {
    }

    public void doAfterSelect(GridElement gridElement) {
        gridElement.getComponent().afterModelUpdate();
    }

    public void moveToLastPosInList(GridElement gridElement) {
        List<GridElement> list = this.getSelectedElements();
        list.remove(gridElement);
        list.add(gridElement);
    }

    public Integer getUnusedGroup() {
        return Selector.getUnusedGroupId(Selector.createGroupElementMap(this.getAllElements()).keySet());
    }

    public abstract List<GridElement> getAllElements();

    public static void replaceGroupsWithNewGroups(Collection<GridElement> collection, Selector selector) {
        HashSet<Integer> hashSet = new HashSet<Integer>(Selector.createGroupElementMap(selector.getAllElements()).keySet());
        Map<Integer, Collection<GridElement>> map = Selector.createGroupElementMap(collection);
        for (Map.Entry<Integer, Collection<GridElement>> entry : map.entrySet()) {
            Integer n = Selector.getUnusedGroupId(hashSet);
            hashSet.add(n);
            for (GridElement gridElement : entry.getValue()) {
                gridElement.setProperty("group", n);
            }
        }
    }

    public static Integer getUnusedGroupId(Collection<Integer> collection) {
        Integer n = collection.isEmpty() ? Integer.valueOf(1) : Integer.valueOf(Collections.max(collection) + 1);
        return n;
    }

    public static Map<Integer, Collection<GridElement>> createGroupElementMap(Collection<GridElement> collection) {
        HashMap<Integer, Collection<GridElement>> hashMap = new HashMap<Integer, Collection<GridElement>>();
        for (GridElement gridElement : collection) {
            if (gridElement.getGroup() == null) continue;
            ArrayList<GridElement> arrayList = (ArrayList<GridElement>)hashMap.get(gridElement.getGroup());
            if (arrayList == null) {
                arrayList = new ArrayList<GridElement>();
                hashMap.put(gridElement.getGroup(), arrayList);
            }
            arrayList.add(gridElement);
        }
        return hashMap;
    }
}

