/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.facet;

import com.baselet.control.basics.XValues;
import com.baselet.control.enums.AlignHorizontal;
import com.baselet.control.enums.AlignVertical;
import com.baselet.control.enums.ElementStyle;
import com.baselet.element.facet.Facet;
import com.baselet.element.facet.common.BackgroundColorFacet;
import com.baselet.element.facet.common.ElementStyleFacet;
import com.baselet.element.facet.common.FontSizeFacet;
import com.baselet.element.facet.common.ForegroundColorFacet;
import com.baselet.element.facet.common.GroupFacet;
import com.baselet.element.facet.common.HorizontalAlignFacet;
import com.baselet.element.facet.common.LayerFacet;
import com.baselet.element.facet.common.LineTypeFacet;
import com.baselet.element.facet.common.LineWidthFacet;
import com.baselet.element.facet.common.SeparatorLineFacet;
import com.baselet.element.facet.common.TextPrintFacet;
import com.baselet.element.facet.common.TransparencyFacet;
import com.baselet.element.facet.common.VerticalAlignFacet;
import com.baselet.element.facet.specific.HierarchyFacet;
import com.baselet.element.relation.facet.LineDescriptionFacet;
import com.baselet.element.relation.facet.LineDescriptionPositionFacet;
import com.baselet.element.relation.facet.RelationLineTypeFacet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public abstract class Settings {
    private static final List<Facet> BASE = Settings.listOf(BackgroundColorFacet.INSTANCE, TransparencyFacet.INSTANCE, ForegroundColorFacet.INSTANCE, LayerFacet.INSTANCE, LineWidthFacet.INSTANCE, GroupFacet.INSTANCE);
    private static final List<Facet> BASE_WITH_LINETYPE = Settings.listOf(BASE, LineTypeFacet.INSTANCE);
    private static final List<Facet> BASE_EXTENDED = Settings.listOf(BASE_WITH_LINETYPE, TextPrintFacet.INSTANCE, FontSizeFacet.INSTANCE);
    protected static final List<Facet> RELATION = Settings.listOf(BASE, FontSizeFacet.INSTANCE, RelationLineTypeFacet.INSTANCE, LineDescriptionFacet.INSTANCE, LineDescriptionPositionFacet.INSTANCE_MESSAGE_START, LineDescriptionPositionFacet.INSTANCE_MESSAGE_END, LineDescriptionPositionFacet.INSTANCE_ROLE_START, LineDescriptionPositionFacet.INSTANCE_ROLE_END);
    protected static final List<Facet> MANUALRESIZE = Settings.listOf(BASE_EXTENDED, VerticalAlignFacet.INSTANCE, HorizontalAlignFacet.INSTANCE, ElementStyleFacet.INSTANCE);
    protected static final List<Facet> NOTEXT = BASE_WITH_LINETYPE;
    protected static final List<Facet> AUTORESIZE = Settings.listOf(BASE_EXTENDED, SeparatorLineFacet.INSTANCE);
    protected static final List<Facet> HIERARCHY = Settings.listOf(BASE_WITH_LINETYPE, FontSizeFacet.INSTANCE, ElementStyleFacet.INSTANCE_AUTORESIZEONLY, HierarchyFacet.INSTANCE);
    private List<Facet> firstRunFacets;
    private List<Facet> secondRunFacets;

    protected static List<Facet> listOf(Facet ... facetArray) {
        ArrayList<Facet> arrayList = new ArrayList<Facet>();
        arrayList.addAll(Arrays.asList(facetArray));
        return arrayList;
    }

    protected static List<Facet> listOf(List<Facet> list, Facet ... facetArray) {
        ArrayList<Facet> arrayList = new ArrayList<Facet>(list);
        arrayList.addAll(Arrays.asList(facetArray));
        return arrayList;
    }

    public XValues getXValues(double d, int n, int n2) {
        return new XValues(0.0, n2);
    }

    public AlignVertical getVAlign() {
        return AlignVertical.TOP;
    }

    public AlignHorizontal getHAlign() {
        return AlignHorizontal.CENTER;
    }

    public abstract ElementStyle getElementStyle();

    protected abstract List<Facet> createFacets();

    private void initFacets() {
        if (this.firstRunFacets == null) {
            this.firstRunFacets = new ArrayList<Facet>();
            this.secondRunFacets = new ArrayList<Facet>();
            this.addAll(this.createFacets());
            this.sortListByPriority(this.firstRunFacets);
            this.sortListByPriority(this.secondRunFacets);
        }
    }

    private void addAll(List<Facet> list) {
        for (Facet facet : list) {
            if (facet.handleOnFirstRun()) {
                this.secondRunFacets.add(facet);
                continue;
            }
            this.firstRunFacets.add(facet);
        }
    }

    private void sortListByPriority(List<? extends Facet> list) {
        Collections.sort(list, new Comparator<Facet>(){

            @Override
            public int compare(Facet facet, Facet facet2) {
                return facet.getPriority().compareTo(facet2.getPriority());
            }
        });
    }

    public final List<Facet> getFacetsForSecondRun() {
        this.initFacets();
        return this.firstRunFacets;
    }

    public final List<Facet> getFacetsForFirstRun() {
        this.initFacets();
        return this.secondRunFacets;
    }
}

