/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.facet.specific;

import com.baselet.control.basics.XValues;
import com.baselet.control.enums.AlignHorizontal;
import com.baselet.control.enums.AlignVertical;
import com.baselet.diagram.draw.DrawHandler;
import com.baselet.diagram.draw.helper.ColorOwn;
import com.baselet.element.facet.Alignment;
import com.baselet.element.facet.Facet;
import com.baselet.element.facet.PropertiesParserState;
import com.baselet.gui.AutocompletionText;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;

public class InnerClassFacet
extends Facet {
    public static final InnerClassFacet INSTANCE = new InnerClassFacet();
    private static final int BUFFER_PIXEL_PER_INNER = 5;
    private static final int H_SPACE = 4;
    private static final String START = "{innerclass";
    private static final String END = "innerclass}";

    private InnerClassFacet() {
    }

    @Override
    public boolean checkStart(String string, PropertiesParserState propertiesParserState) {
        return string.equals(START) || string.equals(END);
    }

    @Override
    public void handleLine(String string, PropertiesParserState propertiesParserState) {
        Stack<ClassSettings> stack = this.getOrInit(propertiesParserState);
        DrawHandler drawHandler = propertiesParserState.getDrawer();
        if (string.equals(START)) {
            ClassSettings classSettings = new ClassSettings(propertiesParserState.getAlignment().getHorizontal(), propertiesParserState.getAlignment().getVertical(), this.getDividerPos(drawHandler, propertiesParserState));
            stack.add(classSettings);
            propertiesParserState.getBuffer().addToLeftAndRight(5.0);
            propertiesParserState.increaseTextPrintPosition(4.0);
            propertiesParserState.getAlignment().reset();
        } else if (string.equals(END)) {
            ClassSettings classSettings = stack.pop();
            double d = classSettings.start;
            double d2 = this.getDividerPos(drawHandler, propertiesParserState) - d;
            XValues xValues = propertiesParserState.getXLimits(d2);
            ColorOwn colorOwn = drawHandler.getBackgroundColor();
            drawHandler.setBackgroundColor(ColorOwn.TRANSPARENT);
            drawHandler.drawRectangle(xValues.getLeft(), d, xValues.getSpace(), d2);
            drawHandler.setBackgroundColor(colorOwn);
            propertiesParserState.increaseTextPrintPosition(4.0);
            propertiesParserState.getBuffer().addToLeftAndRight(-5.0);
            Alignment alignment = propertiesParserState.getAlignment();
            alignment.setHorizontal(false, classSettings.hAlign);
            alignment.setVertical(false, classSettings.vAlign);
        }
    }

    private double getDividerPos(DrawHandler drawHandler, PropertiesParserState propertiesParserState) {
        return propertiesParserState.getTextPrintPosition() - drawHandler.textHeightMax();
    }

    private Stack<ClassSettings> getOrInit(PropertiesParserState propertiesParserState) {
        return propertiesParserState.getOrInitFacetResponse(InnerClassFacet.class, new Stack());
    }

    @Override
    public List<AutocompletionText> getAutocompletionStrings() {
        return Arrays.asList(new AutocompletionText(START, "begin inner class"), new AutocompletionText(END, "end inner class"));
    }

    private static class ClassSettings {
        private final AlignHorizontal hAlign;
        private final AlignVertical vAlign;
        private final double start;

        public ClassSettings(AlignHorizontal alignHorizontal, AlignVertical alignVertical, double d) {
            this.hAlign = alignHorizontal;
            this.vAlign = alignVertical;
            this.start = d;
        }
    }
}

