/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.generator.java.bcel;

import com.baselet.generator.java.Method;
import com.baselet.generator.java.bcel.BcelAccessible;
import org.apache.bcel.classfile.FieldOrMethod;
import org.apache.bcel.generic.Type;

public class BcelMethod
extends BcelAccessible
implements Method {
    private final org.apache.bcel.classfile.Method method;
    private final String className;
    private boolean isConstructor;

    public BcelMethod(org.apache.bcel.classfile.Method method, String className) {
        super((FieldOrMethod)method);
        this.method = method;
        this.className = className;
        this.isConstructor = method.getName().equals("<init>") || method.getName().equals("<clinit>");
    }

    @Override
    public String getName() {
        if (this.isConstructor) {
            return this.className;
        }
        return this.method.getName();
    }

    @Override
    public String getReturnType() {
        if (this.isConstructor) {
            return "ctor";
        }
        return this.method.getReturnType().toString();
    }

    @Override
    public String getSignature() {
        StringBuilder sb = new StringBuilder("");
        Type[] arguments = this.method.getArgumentTypes();
        boolean first = true;
        Type[] typeArray = arguments;
        int n = arguments.length;
        int n2 = 0;
        while (n2 < n) {
            Type argument = typeArray[n2];
            if (first) {
                first = false;
                sb.append(argument);
            } else {
                sb.append(", ").append(argument);
            }
            ++n2;
        }
        return sb.toString();
    }
}

