/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.gui.listener;

import com.baselet.control.Main;
import com.baselet.control.basics.geom.Point;
import com.baselet.control.constants.Constants;
import com.baselet.control.constants.SystemInfo;
import com.baselet.diagram.CurrentDiagram;
import com.baselet.diagram.DiagramHandler;
import com.baselet.diagram.SelectorFrame;
import com.baselet.gui.CurrentGui;
import com.baselet.gui.listener.UniversalListener;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class DiagramListener
extends UniversalListener
implements MouseWheelListener {
    private static final Logger log = Logger.getLogger(DiagramListener.class);

    public DiagramListener(DiagramHandler handler) {
        super(handler);
    }

    @Override
    public void mousePressed(MouseEvent me) {
        super.mousePressed(me);
        if (!this.selector.getSelectedElements().isEmpty() && (me.getModifiers() & SystemInfo.META_KEY.getMask()) != 0) {
            return;
        }
        this.selector.deselectAll();
        for (DiagramHandler h : Main.getInstance().getDiagramsAndPalettes()) {
            h.getDrawPanel().getSelector().deselectAllWithoutUpdatePropertyPanel();
        }
        this.selector.updateSelectorInformation();
        if ((me.getModifiers() & SystemInfo.META_KEY.getMask()) != 0) {
            SelectorFrame selframe = this.selector.getSelectorFrame();
            selframe.setLocation(this.getOffset(me).getX(), this.getOffset(me).getY());
            selframe.setSize(1, 1);
            ((JComponent)me.getComponent()).add((Component)selframe, 0);
            this.selector.setSelectorFrameActive(true);
        }
    }

    @Override
    public void mouseMoved(MouseEvent me) {
        super.mouseMoved(me);
        CurrentGui.getInstance().getGui().setCursor(Constants.DEFAULT_CURSOR);
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        super.mouseDragged(me);
        log.debug((Object)"mouseDragged!!");
        this.dragDiagram();
    }

    @Override
    protected Point getOffset(MouseEvent me) {
        return new Point(me.getX(), me.getY());
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if ((e.getModifiersEx() & SystemInfo.META_KEY.getMaskDown()) == SystemInfo.META_KEY.getMaskDown()) {
            int actualZoom = CurrentDiagram.getInstance().getDiagramHandler().getGridSize();
            CurrentDiagram.getInstance().getDiagramHandler().setGridAndZoom(actualZoom - e.getWheelRotation());
        } else {
            CurrentDiagram.getInstance().getDiagramHandler().getDrawPanel().scroll(e.getWheelRotation());
        }
    }
}

