/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.smiles;

import javajs.util.P3;
import javajs.util.PT;
import javajs.util.T3;
import org.jmol.smiles.SmilesSearch;
import org.jmol.smiles.VTemp;

public class SmilesMeasure {
    SmilesSearch search;
    int nPoints;
    int type;
    int index;
    boolean isNot;
    private int[] indices = new int[4];
    static final String TYPES = "__dat";
    private final float[] minmax;
    private static final float radiansPerDegree = (float)Math.PI / 180;
    private final P3[] points = new P3[4];

    SmilesMeasure(SmilesSearch smilesSearch, int n, int n2, boolean bl, float[] fArray) {
        this.search = smilesSearch;
        this.type = Math.min(4, Math.max(n2, 2));
        this.index = n;
        this.isNot = bl;
        this.minmax = fArray;
        for (int i = fArray.length - 2; i >= 0; i -= 2) {
            if (!(fArray[i] > fArray[i + 1])) continue;
            float f = fArray[i + 1];
            fArray[i + 1] = fArray[i];
            fArray[i] = f;
        }
    }

    boolean addPoint(int n) {
        if (this.nPoints == this.type) {
            return false;
        }
        if (this.nPoints == 0) {
            for (int i = 1; i < this.type; ++i) {
                this.indices[i] = n + i;
            }
        }
        this.indices[this.nPoints++] = n;
        return true;
    }

    boolean check() {
        int n;
        for (int i = 0; i < this.type; ++i) {
            n = this.search.patternAtoms[this.indices[i]].getMatchingAtomIndex();
            this.points[i] = (P3)this.search.jmolAtoms[n];
        }
        float f = 0.0f;
        switch (this.type) {
            case 2: {
                f = this.points[0].distance((T3)this.points[1]);
                break;
            }
            case 3: {
                this.search.v.vA.sub2((T3)this.points[0], (T3)this.points[1]);
                this.search.v.vB.sub2((T3)this.points[2], (T3)this.points[1]);
                f = this.search.v.vA.angle(this.search.v.vB) / ((float)Math.PI / 180);
                break;
            }
            case 4: {
                SmilesMeasure.setTorsionData(this.points[0], this.points[1], this.points[2], this.points[3], this.search.v, true);
                f = this.search.v.vTemp1.angle(this.search.v.vTemp2) / ((float)Math.PI / 180) * (float)(this.search.v.vNorm1.dot((T3)this.search.v.vNorm2) < 0.0f ? 1 : -1);
            }
        }
        for (n = this.minmax.length - 2; n >= 0; n -= 2) {
            if (!(f >= this.minmax[n]) || !(f <= this.minmax[n + 1])) continue;
            return !this.isNot;
        }
        return this.isNot;
    }

    public static void setTorsionData(P3 p3, P3 p32, P3 p33, P3 p34, VTemp vTemp, boolean bl) {
        vTemp.vTemp1.sub2((T3)p3, (T3)p32);
        vTemp.vTemp2.sub2((T3)p34, (T3)p33);
        if (!bl) {
            return;
        }
        vTemp.vNorm1.sub2((T3)p32, (T3)p33);
        vTemp.vNorm1.normalize();
        vTemp.vTemp1.cross((T3)vTemp.vTemp1, (T3)vTemp.vNorm1);
        vTemp.vTemp1.normalize();
        vTemp.vTemp2.cross((T3)vTemp.vTemp2, (T3)vTemp.vNorm1);
        vTemp.vTemp2.normalize();
        vTemp.vNorm2.cross((T3)vTemp.vTemp1, (T3)vTemp.vTemp2);
    }

    public String toString() {
        String string = "(." + TYPES.charAt(this.type) + this.index + ":" + PT.toJSON(null, (Object)this.minmax) + ") for";
        for (int i = 0; i < this.type; ++i) {
            string = string + " " + (i >= this.nPoints ? "?" : "" + this.indices[i]);
        }
        return string;
    }
}

