/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.data;

import java.util.Map;
import javajs.util.Lst;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.XmlUtil;
import org.jmol.java.BS;
import org.jmol.jvxl.data.JvxlData;
import org.jmol.jvxl.data.MeshData;
import org.jmol.jvxl.data.VolumeData;
import org.jmol.util.BSUtil;
import org.jmol.util.C;
import org.jmol.util.Escape;
import org.jmol.util.Logger;

public class JvxlCoder {
    public static final String JVXL_VERSION1 = "2.0";
    public static final String JVXL_VERSION_XML = "2.3";
    public static final int CONTOUR_NPOLYGONS = 0;
    public static final int CONTOUR_BITSET = 1;
    public static final int CONTOUR_VALUE = 2;
    public static final int CONTOUR_COLIX = 3;
    public static final int CONTOUR_COLOR = 4;
    public static final int CONTOUR_FDATA = 5;
    public static final int CONTOUR_POINTS = 6;
    public static final int defaultEdgeFractionBase = 35;
    public static final int defaultEdgeFractionRange = 90;
    public static final int defaultColorFractionBase = 35;
    public static final int defaultColorFractionRange = 90;

    public static String jvxlGetFile(VolumeData volumeData, JvxlData jvxlData, String[] stringArray) {
        int[] nArray = volumeData.getVoxelCounts();
        jvxlData.nPointsX = nArray[0];
        jvxlData.nPointsY = nArray[1];
        jvxlData.nPointsZ = nArray[2];
        jvxlData.jvxlVolumeDataXml = volumeData.setVolumetricXml();
        return JvxlCoder.jvxlGetFile(jvxlData, null, stringArray, null, true, 1, null, null);
    }

    public static String jvxlGetFile(JvxlData jvxlData, MeshData meshData, String[] stringArray, String string, boolean bl, int n, String string2, String string3) {
        return JvxlCoder.jvxlGetFileXml(jvxlData, meshData, stringArray, string, bl, n, string2, string3);
    }

    private static String jvxlGetFileXml(JvxlData jvxlData, MeshData meshData, String[] stringArray, String string, boolean bl, int n, String string2, String string3) {
        String[] stringArray2;
        int n2;
        String string4;
        Object object;
        SB sB = new SB();
        if ("TRAILERONLY".equals(string)) {
            XmlUtil.closeTag(sB, "jvxlSurfaceSet");
            XmlUtil.closeTag(sB, "jvxl");
            return sB.toString();
        }
        boolean bl2 = meshData != null;
        boolean bl3 = "HEADERONLY".equals(string);
        if (bl) {
            XmlUtil.openDocument(sB);
            XmlUtil.openTagAttr(sB, "jvxl", new String[]{"version", JVXL_VERSION_XML, "jmolVersion", jvxlData.version, "xmlns", "http://jmol.org/jvxl_schema", "xmlns:cml", "http://www.xml-cml.org/schema"});
            if (jvxlData.jvxlFileTitle != null) {
                XmlUtil.appendCdata(sB, "jvxlFileTitle", null, "\n" + jvxlData.jvxlFileTitle);
            }
            if (jvxlData.moleculeXml != null) {
                sB.append(jvxlData.moleculeXml);
            }
            Object object2 = object = bl2 ? null : jvxlData.jvxlVolumeDataXml;
            if (object == null) {
                object = new VolumeData().setVolumetricXml();
            }
            sB.append((String)object);
            XmlUtil.openTagAttr(sB, "jvxlSurfaceSet", new String[]{"count", "" + (n > 0 ? n : 1)});
            if (bl3) {
                return sB.toString();
            }
        }
        String string5 = bl2 ? "pmesh" : (string4 = jvxlData.jvxlPlane == null ? "isosurface" : "plane");
        if (jvxlData.jvxlColorData != null && jvxlData.jvxlColorData.length() > 0) {
            string4 = "mapped " + string4;
        }
        XmlUtil.openTagAttr(sB, "jvxlSurface", new String[]{"type", string4});
        sB.append(JvxlCoder.jvxlGetInfoData(jvxlData, bl2));
        JvxlCoder.jvxlAppendCommandState(sB, string3, string2);
        if (stringArray != null || string != null && string.length() > 0) {
            object = new SB();
            if (string != null && string.length() > 0) {
                ((SB)object).append(string).append("\n");
            }
            if (stringArray != null) {
                for (n2 = 0; n2 < stringArray.length; ++n2) {
                    ((SB)object).append(stringArray[n2]).appendC('\n');
                }
            }
            XmlUtil.appendCdata(sB, "jvxlSurfaceTitle", null, ((SB)object).toString());
        }
        object = new SB();
        if (bl2 || jvxlData.jvxlPlane == null) {
            stringArray2 = null;
        } else if (jvxlData.mapLattice == null) {
            String[] stringArray3 = new String[2];
            stringArray3[0] = "plane";
            stringArray2 = stringArray3;
            stringArray3[1] = Escape.eP4(jvxlData.jvxlPlane);
        } else {
            String[] stringArray4 = new String[4];
            stringArray4[0] = "plane";
            stringArray4[1] = Escape.eP4(jvxlData.jvxlPlane);
            stringArray4[2] = "maplattice";
            stringArray2 = stringArray4;
            stringArray4[3] = Escape.eP(jvxlData.mapLattice);
        }
        XmlUtil.openTagAttr((SB)object, "jvxlSurfaceData", stringArray2);
        if (bl2) {
            JvxlCoder.appendXmlVertexOnlyData((SB)object, jvxlData, meshData, true);
        } else if (jvxlData.jvxlPlane == null) {
            if (jvxlData.jvxlEdgeData == null) {
                return "";
            }
            JvxlCoder.appendXmlEdgeData((SB)object, jvxlData);
            JvxlCoder.appendXmlColorData((SB)object, jvxlData.jvxlColorData, true, jvxlData.isJvxlPrecisionColor, jvxlData.valueMappedToRed, jvxlData.valueMappedToBlue);
        } else {
            JvxlCoder.appendXmlColorData((SB)object, jvxlData.jvxlColorData, true, jvxlData.isJvxlPrecisionColor, jvxlData.valueMappedToRed, jvxlData.valueMappedToBlue);
        }
        JvxlCoder.appendEncodedBitSetTag((SB)object, "jvxlInvalidatedVertexData", jvxlData.jvxlExcluded[1], -1, null);
        if (jvxlData.excludedVertexCount > 0) {
            JvxlCoder.appendEncodedBitSetTag((SB)object, "jvxlExcludedVertexData", jvxlData.jvxlExcluded[0], jvxlData.excludedVertexCount, null);
            JvxlCoder.appendEncodedBitSetTag((SB)object, "jvxlExcludedPlaneData", jvxlData.jvxlExcluded[2], -1, null);
        }
        JvxlCoder.appendEncodedBitSetTag((SB)object, "jvxlExcludedTriangleData", jvxlData.jvxlExcluded[3], jvxlData.excludedTriangleCount, null);
        XmlUtil.closeTag((SB)object, "jvxlSurfaceData");
        n2 = ((SB)object).length();
        sB.appendSB((SB)object);
        if (jvxlData.vContours != null && jvxlData.vContours.length > 0) {
            JvxlCoder.jvxlEncodeContourData(jvxlData.vContours, sB);
        }
        if (jvxlData.vertexColorMap != null) {
            if (jvxlData.baseColor == null) {
                XmlUtil.openTag(sB, "jvxlVertexColorData");
            } else {
                XmlUtil.openTagAttr(sB, "jvxlVertexColorData", new String[]{"baseColor", jvxlData.baseColor});
            }
            for (Map.Entry<String, BS> entry : jvxlData.vertexColorMap.entrySet()) {
                JvxlCoder.appendEncodedBitSetTag(sB, "jvxlColorMap", entry.getValue(), -1, new Object[]{"color", entry.getKey()});
            }
            jvxlData.vertexColorMap = null;
            XmlUtil.closeTag(sB, "jvxlVertexColorData");
        }
        XmlUtil.closeTag(sB, "jvxlSurface");
        if (bl) {
            XmlUtil.closeTag(sB, "jvxlSurfaceSet");
            XmlUtil.closeTag(sB, "jvxl");
        }
        return JvxlCoder.jvxlSetCompressionRatio(sB, jvxlData, n2);
    }

    private static void appendEncodedBitSetTag(SB sB, String string, BS bS, int n, Object[] objectArray) {
        if (n < 0) {
            n = BSUtil.cardinalityOf(bS);
        }
        if (n == 0) {
            return;
        }
        SB sB2 = new SB();
        sB2.append("\n ");
        JvxlCoder.jvxlEncodeBitSetBuffer(bS, -1, sB2);
        XmlUtil.appendTagObj(sB, string, new Object[]{objectArray, "bsEncoding", "base90+35", "count", "" + n, "len", "" + bS.length()}, JvxlCoder.jvxlCompressString(sB2.toString(), true));
    }

    private static String jvxlSetCompressionRatio(SB sB, JvxlData jvxlData, int n) {
        String string = sB.toString();
        int n2 = (int)(jvxlData.nBytes > 0L ? (float)jvxlData.nBytes / (float)n : (float)(jvxlData.nPointsX * jvxlData.nPointsY * jvxlData.nPointsZ * 13) / (float)n);
        return PT.rep(string, "\"not calculated\"", n2 > 0 ? "\"" + n2 + ":1\"" : "\"?\"");
    }

    private static void appendXmlEdgeData(SB sB, JvxlData jvxlData) {
        XmlUtil.appendTagObj(sB, "jvxlEdgeData", new String[]{"count", "" + (jvxlData.jvxlEdgeData.length() - 1), "encoding", "base90f1", "bsEncoding", "base90+35c", "isXLowToHigh", "" + jvxlData.isXLowToHigh, "data", JvxlCoder.jvxlCompressString(jvxlData.jvxlEdgeData, true)}, "\n" + JvxlCoder.jvxlCompressString(jvxlData.jvxlSurfaceData, true));
    }

    private static void jvxlAppendCommandState(SB sB, String string, String string2) {
        if (string != null) {
            XmlUtil.appendCdata(sB, "jvxlIsosurfaceCommand", null, "\n" + (string.indexOf("#") < 0 ? string : string.substring(0, string.indexOf("#"))) + "\n");
        }
        if (string2 != null) {
            if (string2.indexOf("** XML ** ") >= 0) {
                string2 = PT.split(string2, "** XML **")[1].trim();
                XmlUtil.appendTag(sB, "jvxlIsosurfaceState", "\n" + string2 + "\n");
            } else {
                XmlUtil.appendCdata(sB, "jvxlIsosurfaceState", null, "\n" + string2);
            }
        }
    }

    private static void appendXmlColorData(SB sB, String string, boolean bl, boolean bl2, float f, float f2) {
        int n;
        if (string == null || (n = string.length() - 1) < 0) {
            return;
        }
        if (bl2) {
            n /= 2;
        }
        XmlUtil.appendTagObj(sB, "jvxlColorData", new String[]{"count", "" + n, "encoding", bl ? "base90f" + (bl2 ? "2" : "1") : "none", "min", "" + f, "max", "" + f2, "data", JvxlCoder.jvxlCompressString(string, true)}, null);
    }

    public static String jvxlGetInfo(JvxlData jvxlData) {
        return JvxlCoder.jvxlGetInfoData(jvxlData, jvxlData.vertexDataOnly);
    }

    public static String jvxlGetInfoData(JvxlData jvxlData, boolean bl) {
        float f;
        int n;
        int n2;
        if (jvxlData.jvxlSurfaceData == null) {
            return "";
        }
        Lst<String[]> lst = new Lst<String[]>();
        int n3 = jvxlData.nSurfaceInts;
        int n4 = bl ? 0 : jvxlData.jvxlEdgeData.length() - 1;
        int n5 = n2 = jvxlData.jvxlColorData == null ? -1 : jvxlData.jvxlColorData.length() - 1;
        if (!bl) {
            JvxlCoder.addAttrib(lst, "\n  cutoff", "" + jvxlData.cutoff);
            JvxlCoder.addAttrib(lst, "\n  isCutoffAbsolute", "" + jvxlData.isCutoffAbsolute);
            JvxlCoder.addAttrib(lst, "\n  pointsPerAngstrom", "" + jvxlData.pointsPerAngstrom);
            n = jvxlData.jvxlSurfaceData.length() + n4 + n2 + 1;
            if (n > 0) {
                JvxlCoder.addAttrib(lst, "\n  nBytesData", "" + n);
            }
            JvxlCoder.addAttrib(lst, "\n  isXLowToHigh", "" + jvxlData.isXLowToHigh);
            if (jvxlData.jvxlPlane == null) {
                JvxlCoder.addAttrib(lst, "\n  nSurfaceInts", "" + n3);
                JvxlCoder.addAttrib(lst, "\n  nBytesUncompressedEdgeData", "" + n4);
            }
            if (n2 > 0) {
                JvxlCoder.addAttrib(lst, "\n  nBytesUncompressedColorData", "" + n2);
            }
        }
        jvxlData.excludedVertexCount = BSUtil.cardinalityOf(jvxlData.jvxlExcluded[0]);
        jvxlData.excludedTriangleCount = BSUtil.cardinalityOf(jvxlData.jvxlExcluded[3]);
        if (jvxlData.excludedVertexCount > 0) {
            JvxlCoder.addAttrib(lst, "\n  nExcludedVertexes", "" + jvxlData.excludedVertexCount);
        }
        if (jvxlData.excludedTriangleCount > 0) {
            JvxlCoder.addAttrib(lst, "\n  nExcludedTriangles", "" + jvxlData.excludedTriangleCount);
        }
        if ((n = BSUtil.cardinalityOf(jvxlData.jvxlExcluded[1])) > 0) {
            JvxlCoder.addAttrib(lst, "\n  nInvalidatedVertexes", "" + n);
        }
        if (jvxlData.slabInfo != null) {
            JvxlCoder.addAttrib(lst, "\n  slabInfo", jvxlData.slabInfo);
        }
        if (jvxlData.isJvxlPrecisionColor) {
            JvxlCoder.addAttrib(lst, "\n  precisionColor", "true");
        }
        if (jvxlData.colorDensity) {
            JvxlCoder.addAttrib(lst, "\n  colorDensity", "true");
        }
        if (!Float.isNaN(jvxlData.pointSize)) {
            JvxlCoder.addAttrib(lst, "\n  pointSize", "" + jvxlData.pointSize);
        } else if (jvxlData.diameter != 0) {
            JvxlCoder.addAttrib(lst, "\n  diameter", "" + jvxlData.diameter);
        }
        if (!jvxlData.allowVolumeRender) {
            JvxlCoder.addAttrib(lst, "\n  allowVolumeRender", "false");
        }
        if (jvxlData.jvxlPlane == null || bl) {
            if (jvxlData.fixedLattice != null && !bl) {
                JvxlCoder.addAttrib(lst, "\n  fixedLattice", "" + jvxlData.fixedLattice);
            }
            if (jvxlData.isContoured) {
                JvxlCoder.addAttrib(lst, "\n  contoured", "true");
                JvxlCoder.addAttrib(lst, "\n  colorMapped", "true");
            } else if (jvxlData.isBicolorMap) {
                JvxlCoder.addAttrib(lst, "\n  bicolorMap", "true");
                JvxlCoder.addAttrib(lst, "\n  colorNegative", C.getHexCode(jvxlData.minColorIndex));
                JvxlCoder.addAttrib(lst, "\n  colorPositive", C.getHexCode(jvxlData.maxColorIndex));
            } else if (n2 > 0) {
                JvxlCoder.addAttrib(lst, "\n  colorMapped", "true");
            }
            if (jvxlData.vContours != null && jvxlData.vContours.length > 0) {
                JvxlCoder.addAttrib(lst, "\n  nContourData", "" + jvxlData.vContours.length);
            }
        } else {
            if (jvxlData.mapLattice != null) {
                JvxlCoder.addAttrib(lst, "\n  mapLattice", "" + jvxlData.mapLattice);
            }
            if (jvxlData.scale3d != 0.0f) {
                JvxlCoder.addAttrib(lst, "\n  scale3d", "" + jvxlData.scale3d);
            }
            if (n2 > 0) {
                JvxlCoder.addAttrib(lst, "\n  colorMapped", "true");
            }
            JvxlCoder.addAttrib(lst, "\n  plane", Escape.eP4(jvxlData.jvxlPlane));
        }
        if (jvxlData.color != null && jvxlData.color.indexOf("null") < 0) {
            JvxlCoder.addAttrib(lst, "\n  color", jvxlData.color);
        }
        JvxlCoder.addAttrib(lst, "\n  translucency", "" + jvxlData.translucency);
        if (jvxlData.meshColor != null) {
            JvxlCoder.addAttrib(lst, "\n  meshColor", jvxlData.meshColor);
        }
        if (jvxlData.colorScheme != null) {
            JvxlCoder.addAttrib(lst, "\n  colorScheme", jvxlData.colorScheme);
        }
        if (jvxlData.rendering != null) {
            JvxlCoder.addAttrib(lst, "\n  rendering", jvxlData.rendering);
        }
        if (jvxlData.thisSet >= 0) {
            JvxlCoder.addAttrib(lst, "\n  set", "" + (jvxlData.thisSet + 1));
        }
        if (jvxlData.slabValue != Integer.MIN_VALUE) {
            JvxlCoder.addAttrib(lst, "\n  slabValue", "" + jvxlData.slabValue);
        }
        if (jvxlData.isSlabbable) {
            JvxlCoder.addAttrib(lst, "\n  slabbable", "true");
        }
        if (jvxlData.nVertexColors > 0) {
            JvxlCoder.addAttrib(lst, "\n  nVertexColors", "" + jvxlData.nVertexColors);
        }
        float f2 = jvxlData.mappedDataMin == Float.MAX_VALUE ? 0.0f : jvxlData.mappedDataMin;
        float f3 = jvxlData.isColorReversed ? jvxlData.valueMappedToRed : jvxlData.valueMappedToBlue;
        float f4 = f = jvxlData.isColorReversed ? jvxlData.valueMappedToBlue : jvxlData.valueMappedToRed;
        if (jvxlData.jvxlColorData != null && jvxlData.jvxlColorData.length() > 0 && !jvxlData.isBicolorMap) {
            JvxlCoder.addAttrib(lst, "\n  dataMinimum", "" + f2);
            JvxlCoder.addAttrib(lst, "\n  dataMaximum", "" + jvxlData.mappedDataMax);
            JvxlCoder.addAttrib(lst, "\n  valueMappedToRed", "" + f);
            JvxlCoder.addAttrib(lst, "\n  valueMappedToBlue", "" + f3);
        }
        if (jvxlData.isContoured) {
            if (jvxlData.contourValues == null || jvxlData.contourColixes == null) {
                if (jvxlData.vContours == null) {
                    JvxlCoder.addAttrib(lst, "\n  nContours", "" + Math.abs(jvxlData.nContours));
                }
            } else {
                if (jvxlData.jvxlPlane != null) {
                    JvxlCoder.addAttrib(lst, "\n  contoured", "true");
                }
                JvxlCoder.addAttrib(lst, "\n  nContours", "" + jvxlData.contourValues.length);
                JvxlCoder.addAttrib(lst, "\n  contourValues", Escape.eAF(jvxlData.contourValuesUsed == null ? jvxlData.contourValues : jvxlData.contourValuesUsed));
                JvxlCoder.addAttrib(lst, "\n  contourColors", jvxlData.contourColors);
            }
            if (jvxlData.thisContour > 0) {
                JvxlCoder.addAttrib(lst, "\n  thisContour", "" + jvxlData.thisContour);
            }
        }
        if (jvxlData.insideOut) {
            JvxlCoder.addAttrib(lst, "\n  insideOut", "true");
        }
        if (jvxlData.vertexDataOnly) {
            JvxlCoder.addAttrib(lst, "\n  note", "vertex/face data only");
        } else if (jvxlData.isXLowToHigh) {
            JvxlCoder.addAttrib(lst, "\n  note", "progressive JVXL+ -- X values read from low(0) to high(" + (jvxlData.nPointsX - 1) + ")");
        }
        JvxlCoder.addAttrib(lst, "\n  xyzMin", Escape.eP(jvxlData.boundingBox[0]));
        JvxlCoder.addAttrib(lst, "\n  xyzMax", Escape.eP(jvxlData.boundingBox[1]));
        JvxlCoder.addAttrib(lst, "\n  approximateCompressionRatio", "not calculated");
        JvxlCoder.addAttrib(lst, "\n  jmolVersion", jvxlData.version);
        SB sB = new SB();
        XmlUtil.openTagAttr(sB, "jvxlSurfaceInfo", lst.toArray(new Object[lst.size()]));
        XmlUtil.closeTag(sB, "jvxlSurfaceInfo");
        return sB.toString();
    }

    private static void addAttrib(Lst<String[]> lst, String string, String string2) {
        lst.addLast(new String[]{string, string2});
    }

    private static void jvxlEncodeContourData(Lst<Object>[] lstArray, SB sB) {
        XmlUtil.openTagAttr(sB, "jvxlContourData", new String[]{"count", "" + lstArray.length});
        for (int i = 0; i < lstArray.length; ++i) {
            if (lstArray[i].size() < 6) continue;
            int n = (Integer)lstArray[i].get(0);
            SB sB2 = new SB();
            sB2.append("\n");
            BS bS = (BS)lstArray[i].get(1);
            JvxlCoder.jvxlEncodeBitSetBuffer(bS, n, sB2);
            XmlUtil.appendTagObj(sB, "jvxlContour", new String[]{"index", "" + i, "value", "" + lstArray[i].get(2), "color", Escape.escapeColor(((int[])lstArray[i].get(4))[0]), "count", "" + bS.length(), "encoding", "base90iff1", "bsEncoding", "base90+35c", "data", JvxlCoder.jvxlCompressString(lstArray[i].get(5).toString(), true)}, JvxlCoder.jvxlCompressString(sB2.toString(), true));
        }
        XmlUtil.closeTag(sB, "jvxlContourData");
    }

    public static void set3dContourVector(Lst<Object> lst, int[][] nArray, T3[] t3Array) {
        if (lst.size() < 6) {
            return;
        }
        SB sB = (SB)lst.get(5);
        BS bS = (BS)lst.get(1);
        int n = 0;
        int n2 = sB.length();
        int n3 = 0;
        int n4 = 32;
        int n5 = 32;
        int n6 = bS.nextSetBit(0);
        while (n6 >= 0) {
            int n7;
            int n8;
            int n9;
            int n10;
            int[] nArray2 = nArray[n6];
            while (n < n2) {
                char c = sB.charAt(n++);
                n4 = c;
                if (!PT.isDigit(c)) continue;
            }
            n3 = n4 - 48;
            while (n < n2) {
                char c = sB.charAt(n++);
                n4 = c;
                if (PT.isWhitespace(c)) continue;
            }
            while (n < n2) {
                char c = sB.charAt(n++);
                n5 = c;
                if (PT.isWhitespace(c)) continue;
            }
            float f = JvxlCoder.jvxlFractionFromCharacter(n4, 35, 90, 0.0f);
            float f2 = JvxlCoder.jvxlFractionFromCharacter(n5, 35, 90, 0.0f);
            if ((n3 & 1) == 0) {
                n10 = nArray2[1];
                n8 = n9 = nArray2[2];
                n7 = nArray2[0];
            } else {
                n10 = nArray2[0];
                n8 = nArray2[1];
                if ((n3 & 2) != 0) {
                    n9 = n8;
                    n7 = nArray2[2];
                } else {
                    n9 = nArray2[2];
                    n7 = n10;
                }
            }
            lst.addLast(JvxlCoder.getContourPoint(t3Array, n10, n8, f));
            lst.addLast(JvxlCoder.getContourPoint(t3Array, n9, n7, f2));
            n6 = bS.nextSetBit(n6 + 1);
        }
    }

    private static T3 getContourPoint(T3[] t3Array, int n, int n2, float f) {
        P3 p3 = new P3();
        p3.sub2(t3Array[n2], t3Array[n]);
        p3.scaleAdd2(f, p3, t3Array[n]);
        return p3;
    }

    public static void appendContourTriangleIntersection(int n, float f, float f2, SB sB) {
        sB.appendI(n);
        sB.appendC(JvxlCoder.jvxlFractionAsCharacter(f));
        sB.appendC(JvxlCoder.jvxlFractionAsCharacter(f2));
    }

    public static void jvxlCreateColorData(JvxlData jvxlData, float[] fArray) {
        int n;
        if (fArray == null) {
            jvxlData.jvxlColorData = "";
            return;
        }
        boolean bl = jvxlData.isJvxlPrecisionColor;
        boolean bl2 = jvxlData.isTruncated;
        int n2 = jvxlData.colorFractionBase;
        int n3 = jvxlData.colorFractionRange;
        float f = jvxlData.valueMappedToBlue;
        float f2 = jvxlData.valueMappedToRed;
        int n4 = n = jvxlData.saveVertexCount > 0 ? jvxlData.saveVertexCount : jvxlData.vertexCount;
        if (n > fArray.length) {
            System.out.println("JVXLCODER ERROR");
        }
        float f3 = jvxlData.mappedDataMin;
        float f4 = jvxlData.mappedDataMax;
        SB sB = new SB();
        SB sB2 = new SB();
        if (fArray.length < n) {
            System.out.println("JVXLCOLOR OHOHO");
        }
        for (int i = 0; i < n; ++i) {
            float f5 = fArray[i];
            if (Float.isNaN(f5)) {
                f5 = f3;
            }
            if (bl2) {
                float f6 = f5 = f5 > 0.0f ? 0.999f : -0.999f;
            }
            if (bl) {
                JvxlCoder.jvxlAppendCharacter2(f5, f3, f4, n2, n3, sB, sB2);
                continue;
            }
            sB.appendC(JvxlCoder.jvxlValueAsCharacter(f5, f2, f, n2, n3));
        }
        jvxlData.jvxlColorData = sB.appendSB(sB2).appendC('\n').toString();
    }

    private static void appendXmlVertexOnlyData(SB sB, JvxlData jvxlData, MeshData meshData, boolean bl) {
        int[] nArray = new int[meshData.vc];
        if (JvxlCoder.appendXmlTriangleData(sB, meshData.pis, meshData.pc, meshData.bsSlabDisplay, nArray, bl)) {
            JvxlCoder.appendXmlVertexData(sB, jvxlData, nArray, meshData.vs, meshData.vvs, meshData.vc, meshData.polygonColorData, meshData.pc, meshData.bsSlabDisplay, jvxlData.vertexColors, jvxlData.jvxlColorData.length() > 0, bl);
        }
    }

    private static boolean appendXmlTriangleData(SB sB, int[][] nArray, int n, BS bS, int[] nArray2, boolean bl) {
        SB sB2 = new SB();
        SB sB3 = new SB();
        int n2 = 1;
        int n3 = 0;
        int n4 = 0;
        boolean bl2 = false;
        int n5 = 0;
        boolean bl3 = bS != null;
        int n6 = 0;
        while (n6 < n) {
            if (nArray[n6] == null || bl3 && !bS.get(n6)) {
                ++n6;
                continue;
            }
            int n7 = nArray[n6][n3];
            n7 = nArray2[n7] > 0 ? nArray2[n7] : (nArray2[n7] = ++n4);
            int n8 = n7 - n2;
            n2 = n7;
            if (n8 == 0) {
                sB2.appendC('!');
                bl2 = false;
            } else if (n8 > 32) {
                if (bl2) {
                    sB2.appendC('+');
                }
                sB2.appendI(n8);
                bl2 = true;
            } else if (n8 < -32) {
                sB2.appendI(n8);
                bl2 = true;
            } else {
                sB2.appendC((char)(92 + n8));
                bl2 = false;
            }
            if (++n3 % 3 != 0) continue;
            sB3.appendI(nArray[n6][3]);
            n3 = 0;
            ++n6;
            ++n5;
        }
        if (sB2.length() == 0) {
            return true;
        }
        XmlUtil.appendTagObj(sB, "jvxlTriangleData", new String[]{"count", "" + n5, "encoding", "jvxltdiff", "data", JvxlCoder.jvxlCompressString(sB2.toString(), bl)}, null);
        XmlUtil.appendTagObj(sB, "jvxlTriangleEdgeData", new String[]{"count", "" + n5, "encoding", "jvxlsc", "data", JvxlCoder.jvxlCompressString(sB3.toString(), bl)}, null);
        return true;
    }

    private static void appendXmlVertexData(SB sB, JvxlData jvxlData, int[] nArray, T3[] t3Array, float[] fArray, int n, String string, int n2, BS bS, int[] nArray2, boolean bl, boolean bl2) {
        int n3;
        int n4;
        boolean bl3;
        int n5 = jvxlData.colorFractionBase;
        int n6 = jvxlData.colorFractionRange;
        P3 p3 = jvxlData.boundingBox[0];
        P3 p32 = jvxlData.boundingBox[1];
        SB sB2 = new SB();
        SB sB3 = new SB();
        int[] nArray3 = null;
        boolean bl4 = bl3 = bS != null;
        if (n2 > 0) {
            if (bl3) {
                n2 = bS.cardinality();
            }
            bl3 = false;
            nArray3 = new int[n];
            for (n4 = 0; n4 < n; ++n4) {
                if (nArray[n4] <= 0) continue;
                nArray3[nArray[n4] - 1] = n4;
            }
        }
        n4 = 0;
        for (n3 = 0; n3 < n; ++n3) {
            if (bl3 && !bS.get(n3)) continue;
            ++n4;
            T3 t3 = t3Array[n2 == 0 ? n3 : nArray3[n3]];
            JvxlCoder.jvxlAppendCharacter2(t3.x, p3.x, p32.x, n5, n6, sB2, sB3);
            JvxlCoder.jvxlAppendCharacter2(t3.y, p3.y, p32.y, n5, n6, sB2, sB3);
            JvxlCoder.jvxlAppendCharacter2(t3.z, p3.z, p32.z, n5, n6, sB2, sB3);
        }
        sB2.appendSB(sB3);
        XmlUtil.appendTagObj(sB, "jvxlVertexData", new String[]{"count", "" + n4, "min", Escape.eP(p3), "max", Escape.eP(p32), "encoding", "base90xyz2", "data", JvxlCoder.jvxlCompressString(sB2.toString(), bl2)}, null);
        if (string != null) {
            XmlUtil.appendTagObj(sB, "jvxlPolygonColorData", new String[]{"encoding", "jvxlnc", "count", "" + n2}, "\n" + string);
        }
        if (!bl) {
            return;
        }
        sB2 = new SB();
        sB3 = new SB();
        if (nArray2 == null) {
            for (n3 = 0; n3 < n; ++n3) {
                if (bl3 && !bS.get(n3)) continue;
                float f = fArray[n2 == 0 ? n3 : nArray3[n3]];
                JvxlCoder.jvxlAppendCharacter2(f, jvxlData.mappedDataMin, jvxlData.mappedDataMax, n5, n6, sB2, sB3);
            }
        } else {
            n3 = 0;
            sB2.appendI(n4).append(" ");
            for (int i = 0; i < n; ++i) {
                if (bl3 && !bS.get(i)) continue;
                int n7 = nArray2[n2 == 0 ? i : nArray3[i]];
                if (n7 == n3) {
                    n7 = 0;
                } else {
                    n3 = n7;
                }
                sB2.appendI(n7);
                sB2.append(" ");
            }
        }
        JvxlCoder.appendXmlColorData(sB, sB2.appendSB(sB3).append("\n").toString(), nArray2 == null, true, jvxlData.valueMappedToRed, jvxlData.valueMappedToBlue);
    }

    public static char jvxlFractionAsCharacter(float f) {
        return JvxlCoder.jvxlFractionAsCharacterRange(f, 35, 90);
    }

    public static char jvxlFractionAsCharacterRange(float f, int n, int n2) {
        if (f > 0.9999f) {
            f = 0.9999f;
        } else if (Float.isNaN(f)) {
            f = 1.0001f;
        }
        int n3 = (int)Math.floor(f * (float)n2 + (float)n);
        if (n3 < n) {
            return (char)n;
        }
        if (n3 == 92) {
            return '!';
        }
        return (char)n3;
    }

    private static void jvxlAppendCharacter2(float f, float f2, float f3, int n, int n2, SB sB, SB sB2) {
        float f4 = f2 == f3 ? f : (f - f2) / (f3 - f2);
        char c = JvxlCoder.jvxlFractionAsCharacterRange(f4, n, n2);
        sB.appendC(c);
        sB2.appendC(JvxlCoder.jvxlFractionAsCharacterRange((f4 -= JvxlCoder.jvxlFractionFromCharacter(c, n, n2, 0.0f)) * (float)n2, n, n2));
    }

    public static float jvxlFractionFromCharacter(int n, int n2, int n3, float f) {
        float f2;
        if (n == n2 + n3) {
            return Float.NaN;
        }
        if (n < n2) {
            n = 92;
        }
        if ((f2 = ((float)(n - n2) + f) / (float)n3) < 0.0f) {
            return 0.0f;
        }
        if (f2 > 1.0f) {
            return 0.999999f;
        }
        return f2;
    }

    public static float jvxlFractionFromCharacter2(int n, int n2, int n3, int n4) {
        float f = JvxlCoder.jvxlFractionFromCharacter(n, n3, n4, 0.0f);
        float f2 = JvxlCoder.jvxlFractionFromCharacter(n2, n3, n4, 0.5f);
        return f + f2 / (float)n4;
    }

    public static char jvxlValueAsCharacter(float f, float f2, float f3, int n, int n2) {
        float f4 = f2 == f3 ? f : (f - f2) / (f3 - f2);
        return JvxlCoder.jvxlFractionAsCharacterRange(f4, n, n2);
    }

    protected static float jvxlValueFromCharacter2(int n, int n2, float f, float f2, int n3, int n4) {
        float f3 = JvxlCoder.jvxlFractionFromCharacter2(n, n2, n3, n4);
        return f2 == f ? f3 : f + f3 * (f2 - f);
    }

    public static int jvxlEncodeBitSet0(BS bS, int n, SB sB) {
        int n2 = 0;
        int n3 = -1;
        int n4 = 0;
        if (n < 0) {
            n = bS.length();
        }
        int n5 = 0;
        boolean bl = false;
        int n6 = n - 1;
        for (int i = 0; i < n; ++i) {
            if (bl == bS.get(i)) {
                ++n2;
                continue;
            }
            if (n2 == n3 && i != n6) {
                ++n4;
            } else {
                if (n4 > 0) {
                    sB.appendC(' ').appendI(-n4);
                    n4 = 0;
                    ++n5;
                }
                sB.appendC(' ').appendI(n2);
                ++n5;
                n3 = n2;
            }
            n2 = 1;
            bl = !bl;
        }
        sB.appendC(' ').appendI(n2).appendC('\n');
        return n5;
    }

    public static String jvxlEncodeBitSet(BS bS) {
        SB sB = new SB();
        JvxlCoder.jvxlEncodeBitSetBuffer(bS, -1, sB);
        return sB.toString();
    }

    public static int jvxlEncodeBitSetBuffer(BS bS, int n, SB sB) {
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        if (n < 0) {
            n = bS.length();
        }
        if (n == 0) {
            return 0;
        }
        sB.append("-");
        for (int i = 0; i < n; ++i) {
            if (bl == bS.get(i)) {
                ++n2;
                continue;
            }
            JvxlCoder.jvxlAppendEncodedNumber(sB, n2, 35, 90);
            ++n3;
            n2 = 1;
            bl = !bl;
        }
        JvxlCoder.jvxlAppendEncodedNumber(sB, n2, 35, 90);
        sB.appendC('\n');
        return n3;
    }

    public static void jvxlAppendEncodedNumber(SB sB, int n, int n2, int n3) {
        boolean bl;
        boolean bl2 = bl = n < n3;
        if (n == 0) {
            sB.appendC((char)n2);
        } else if (!bl) {
            sB.appendC((char)(n2 + n3));
        }
        while (n > 0) {
            int n4 = n / n3;
            int n5 = n2 + n - n4 * n3;
            if (n5 == 92) {
                n5 = 33;
            }
            sB.appendC((char)n5);
            n = n4;
        }
        if (!bl) {
            sB.append(" ");
        }
    }

    public static BS jvxlDecodeBitSetRange(String string, int n, int n2) {
        BS bS = new BS();
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        int[] nArray = new int[1];
        while ((n3 = JvxlCoder.jvxlParseEncodedInt(string, n, n2, nArray)) != Integer.MIN_VALUE) {
            if (bl) {
                bS.setBits(n4, n4 + n3);
            }
            n4 += n3;
            bl = !bl;
        }
        return bS;
    }

    public static int jvxlParseEncodedInt(String string, int n, int n2, int[] nArray) {
        boolean bl;
        int n3;
        boolean bl2 = false;
        int n4 = 0;
        int n5 = string.length();
        if (n3 < 0) {
            return Integer.MIN_VALUE;
        }
        for (n3 = nArray[0]; n3 < n5 && PT.isWhitespace(string.charAt(n3)); ++n3) {
        }
        if (n3 >= n5) {
            return Integer.MIN_VALUE;
        }
        int n6 = 1;
        boolean bl3 = bl = string.charAt(n3) == n + n2;
        if (bl) {
            ++n3;
        }
        while (n3 < n5 && !PT.isWhitespace(string.charAt(n3))) {
            int n7 = string.charAt(n3);
            if (n7 < n) {
                n7 = 92;
            }
            n4 += (n7 - n) * n6;
            bl2 = true;
            ++n3;
            if (!bl) break;
            n6 *= n2;
        }
        if (!bl2) {
            n4 = Integer.MIN_VALUE;
        }
        nArray[0] = n3;
        return n4;
    }

    public static BS jvxlDecodeBitSet(String string) {
        if (string.startsWith("-")) {
            return JvxlCoder.jvxlDecodeBitSetRange(JvxlCoder.jvxlDecompressString(string.substring(1)), 35, 90);
        }
        BS bS = new BS();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        int[] nArray = new int[1];
        while (true) {
            int n5 = n = n3++ < 0 ? n : PT.parseIntNext(string, nArray);
            if (n == Integer.MIN_VALUE) break;
            if (n < 0) {
                n3 = n;
                n = n2;
                continue;
            }
            if (bl) {
                bS.setBits(n4, n4 + n);
            }
            n4 += n;
            n2 = n;
            bl = !bl;
        }
        return bS;
    }

    public static String jvxlCompressString(String string, boolean bl) {
        if (string.indexOf("~") >= 0) {
            return string;
        }
        SB sB = new SB();
        char c = '\u0000';
        boolean bl2 = false;
        boolean bl3 = false;
        int n = 0;
        int n2 = string.length();
        block4: for (int i = 0; i <= n2; ++i) {
            char c2 = i == n2 ? (char)'\u0000' : string.charAt(i);
            switch (c2) {
                case '\n': 
                case '\r': {
                    continue block4;
                }
                case '&': 
                case '<': {
                    bl2 = bl;
                    break;
                }
                default: {
                    bl2 = false;
                }
            }
            if (c2 == c) {
                ++n;
                c2 = '\u0000';
            } else if (n > 0 || bl3) {
                if (n < 4 && !bl3 || c == ' ' || c == '\t') {
                    while (--n >= 0) {
                        sB.appendC(c);
                    }
                } else {
                    if (bl3) {
                        bl3 = false;
                    } else {
                        sB.appendC('~');
                    }
                    sB.appendI(n);
                    sB.appendC(' ');
                }
                n = 0;
            }
            if (c2 == '\u0000') continue;
            if (bl2) {
                bl3 = true;
                bl2 = false;
                sB.appendC('~');
                c = c2;
                c2 = (char)(c2 - '\u0001');
            } else {
                c = c2;
            }
            sB.appendC(c2);
        }
        return sB.toString();
    }

    public static String jvxlDecompressString(String string) {
        if (string.indexOf("~") < 0) {
            return string;
        }
        SB sB = new SB();
        char c = '\u0000';
        int[] nArray = new int[1];
        block5: for (int i = 0; i < string.length(); ++i) {
            char c2 = string.charAt(i);
            if (c2 == '~') {
                nArray[0] = ++i;
                c2 = string.charAt(i);
                switch (c2) {
                    case '%': 
                    case ';': {
                        nArray[0] = nArray[0] + 1;
                        c = c2 = (char)(c2 + '\u0001');
                        sB.appendC(c);
                    }
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        int n = PT.parseIntNext(string, nArray);
                        for (int j = 0; j < n; ++j) {
                            sB.appendC(c);
                        }
                        i = nArray[0];
                        continue block5;
                    }
                    case '~': {
                        --i;
                        break;
                    }
                    default: {
                        Logger.error("Error uncompressing string " + string.substring(0, i) + "?");
                    }
                }
            }
            sB.appendC(c2);
            c = c2;
        }
        return sB.toString();
    }

    public static void jvxlCreateHeaderWithoutTitleOrAtoms(VolumeData volumeData, SB sB) {
        JvxlCoder.jvxlCreateHeader(volumeData, sB);
    }

    public static void jvxlCreateHeader(VolumeData volumeData, SB sB) {
        volumeData.setVolumetricXml();
        if (sB.length() == 0) {
            sB.append("Line 1\nLine 2\n");
        }
    }
}

