/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import javajs.util.P3;
import javajs.util.Quat;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.c.STR;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Chain;
import org.jmol.modelset.Structure;
import org.jmol.modelsetbio.Monomer;

public class PhosphorusMonomer
extends Monomer {
    protected static final byte P = 0;
    private static final byte[] phosphorusOffsets = new byte[]{0};
    private static float MAX_ADJACENT_PHOSPHORUS_DISTANCE = 8.0f;

    public final boolean isNucleic() {
        return true;
    }

    protected PhosphorusMonomer() {
    }

    static Monomer validateAndAllocateP(Chain chain, String string, int n, int n2, int n3, int[] nArray) {
        return n2 != n3 || nArray[13] != n2 ? null : new PhosphorusMonomer().set2(chain, string, n, n2, n3, phosphorusOffsets);
    }

    public boolean isDna() {
        return this.isDnaByID();
    }

    public boolean isRna() {
        return this.isRnaByID();
    }

    public boolean isPurine() {
        return this.isPurineByID();
    }

    public boolean isPyrimidine() {
        return this.isPyrimidineByID();
    }

    public Structure getStructure() {
        return this.chain;
    }

    @Override
    public STR getProteinStructureType() {
        return STR.NONE;
    }

    @Override
    boolean isConnectedAfter(Monomer monomer) {
        return this.isCA2(monomer);
    }

    protected boolean isCA2(Monomer monomer) {
        if (monomer == null) {
            return true;
        }
        float f = this.getLeadAtom().distance((T3)monomer.getLeadAtom());
        return f <= MAX_ADJACENT_PHOSPHORUS_DISTANCE;
    }

    public Quat getQuaternion(char c) {
        return this.getQuaternionP();
    }

    protected Quat getQuaternionP() {
        int n = this.monomerIndex;
        if (n <= 0 || n >= this.bioPolymer.monomerCount - 1) {
            return null;
        }
        Atom atom = this.bioPolymer.monomers[n].getAtomFromOffsetIndex(0);
        Atom atom2 = this.bioPolymer.monomers[n + 1].getAtomFromOffsetIndex(0);
        Atom atom3 = this.bioPolymer.monomers[n - 1].getAtomFromOffsetIndex(0);
        if (atom == null || atom2 == null || atom3 == null) {
            return null;
        }
        V3 v3 = new V3();
        V3 v32 = new V3();
        v3.sub2((T3)atom2, (T3)atom);
        v32.sub2((T3)atom3, (T3)atom);
        return Quat.getQuaternionFrameV((V3)v3, (V3)v32, null, (boolean)false);
    }

    @Override
    P3 getQuaternionFrameCenter(char c) {
        return this.getAtomFromOffsetIndex(0);
    }

    public Object getHelixData(int n, char c, int n2) {
        return this.getHelixData2(n, c, n2);
    }
}

