/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapespecial;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.M4;
import javajs.util.Measure;
import javajs.util.P3;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.api.SmilesMatcherInterface;
import org.jmol.api.SymmetryInterface;
import org.jmol.java.BS;
import org.jmol.modelset.Atom;
import org.jmol.script.SV;
import org.jmol.util.Elements;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Node;
import org.jmol.util.Normix;
import org.jmol.util.Point3fi;
import org.jmol.viewer.Viewer;

public class Polyhedron {
    public Atom centralAtom;
    public P3[] vertices;
    public int[][] triangles;
    public int[][] faces;
    int nVertices;
    boolean collapsed;
    private BS bsFlat;
    private float distanceRef;
    private V3[] normals;
    private short[] normixes;
    public String smiles;
    public String smarts;
    public String polySmiles;
    private SymmetryInterface pointGroup;
    private Float volume;
    boolean visible = true;
    boolean isFullyLit;
    public boolean isValid = true;
    public short colixEdge = 0;
    public int visibilityFlags = 0;
    Map<String, Object> info;

    Polyhedron() {
    }

    Polyhedron set(Atom atom, P3[] p3Array, int n, int n2, int[][] nArray, int n3, int[][] nArray2, V3[] v3Array, BS bS, boolean bl, float f) {
        this.distanceRef = f;
        this.centralAtom = atom;
        this.nVertices = n2;
        this.vertices = new P3[n + 1];
        this.normals = new V3[n3];
        this.faces = nArray2;
        this.bsFlat = bS;
        this.triangles = AU.newInt2(n3);
        int n4 = n + 1;
        while (--n4 >= 0) {
            this.vertices[n4] = p3Array[n4];
        }
        n4 = n3;
        while (--n4 >= 0) {
            this.normals[n4] = V3.newV(v3Array[n4]);
        }
        n4 = n3;
        while (--n4 >= 0) {
            this.triangles[n4] = nArray[n4];
        }
        this.collapsed = bl;
        return this;
    }

    Polyhedron setInfo(Map<String, SV> map, Atom[] atomArray) {
        try {
            T3 t3;
            this.collapsed = map.containsKey("collapsed");
            this.centralAtom = atomArray[map.get((Object)"atomIndex").intValue];
            Lst<SV> lst = map.get("vertices").getList();
            SV sV = map.get("vertexCount");
            if (sV == null) {
                this.nVertices = lst.size();
                this.vertices = new P3[this.nVertices + 1];
                this.vertices[this.nVertices] = SV.ptValue(map.get("ptRef"));
            } else {
                this.nVertices = sV.intValue;
                this.vertices = new P3[lst.size()];
                sV = map.get("r");
                if (sV != null) {
                    this.distanceRef = sV.asFloat();
                }
            }
            int n = lst.size();
            while (--n >= 0) {
                this.vertices[n] = SV.ptValue((SV)lst.get(n));
            }
            lst = map.get("elemNos").getList();
            n = this.nVertices;
            while (--n >= 0) {
                int n2 = ((SV)lst.get((int)n)).intValue;
                if (n2 <= 0) continue;
                t3 = new Point3fi();
                t3.setT(this.vertices[n]);
                t3.sD = (short)n2;
                this.vertices[n] = t3;
            }
            SV sV2 = map.get("faces");
            SV sV3 = map.get("triangles");
            if (sV3 == null) {
                sV3 = sV2;
            } else {
                this.faces = this.toInt2(sV2);
            }
            this.triangles = this.toInt2(sV3);
            this.normals = new V3[this.triangles.length];
            t3 = new V3();
            int n3 = this.triangles.length;
            while (--n3 >= 0) {
                this.normals[n3] = new V3();
                int[] nArray = this.triangles[n3];
                Measure.getNormalThroughPoints(this.vertices[nArray[0]], this.vertices[nArray[1]], this.vertices[nArray[2]], this.normals[n3], (V3)t3);
            }
            this.bsFlat = SV.getBitSet(map.get("bsFlat"), false);
        }
        catch (Exception exception) {
            return null;
        }
        return this;
    }

    private int[][] toInt2(SV sV) {
        Lst<SV> lst = sV.getList();
        int[][] nArray = AU.newInt2(lst.size());
        int n = nArray.length;
        while (--n >= 0) {
            Lst<SV> lst2 = ((SV)lst.get(n)).getList();
            nArray[n] = new int[lst2.size()];
            int[] nArray2 = nArray[n];
            int n2 = nArray2.length;
            while (--n2 >= 0) {
                nArray2[n2] = ((SV)lst2.get((int)n2)).intValue;
            }
        }
        return nArray;
    }

    Map<String, Object> getInfo(Viewer viewer, boolean bl) {
        P3 p3;
        Object[] objectArray;
        if (bl && this.info != null && !Logger.debugging) {
            return this.info;
        }
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        if (bl) {
            Object object;
            this.info = hashtable;
            hashtable.put("modelIndex", this.centralAtom.mi);
            hashtable.put("modelNumber", this.centralAtom.getModelNumber());
            hashtable.put("center", P3.newP(this.centralAtom));
            hashtable.put("atomNumber", this.centralAtom.getAtomNumber());
            hashtable.put("atomName", this.centralAtom.getInfo());
            hashtable.put("element", this.centralAtom.getElementSymbol());
            hashtable.put("triangleCount", this.triangles.length);
            hashtable.put("volume", this.getVolume());
            objectArray = new String[this.nVertices];
            int n = this.nVertices;
            while (--n >= 0) {
                p3 = this.vertices[n];
                objectArray[n] = p3 instanceof Node ? ((Node)((Object)p3)).getAtomName() : (p3 instanceof Point3fi ? Elements.elementSymbolFromNumber(((Point3fi)p3).sD) : "");
            }
            if (this.faces != null) {
                hashtable.put("faceCount", this.faces.length);
            }
            hashtable.put("atomNames", objectArray);
            if (this.smarts != null) {
                hashtable.put("smarts", this.smarts);
            }
            if (this.smiles != null) {
                hashtable.put("smiles", this.smiles);
            }
            if (this.polySmiles != null) {
                hashtable.put("polySmiles", this.polySmiles);
            }
            if (this.pointGroup != null) {
                hashtable.put("pointGroup", this.pointGroup.getPointGroupName());
            }
            if ((object = viewer.ms.getInfo(this.centralAtom.mi, "Energy")) != null) {
                hashtable.put("energy", object);
            }
        }
        if (this.faces != null) {
            hashtable.put("faces", this.faces);
        }
        if (!bl || Logger.debugging) {
            hashtable.put("bsFlat", this.bsFlat);
            if (this.collapsed) {
                hashtable.put("collapsed", this.collapsed);
            }
            if (this.distanceRef != 0.0f) {
                hashtable.put("r", Float.valueOf(this.distanceRef));
            }
            objectArray = new P3[this.normals.length];
            int n = objectArray.length;
            while (--n >= 0) {
                objectArray[n] = P3.newP(this.normals[n]);
            }
            hashtable.put("normals", objectArray);
            hashtable.put("triangles", AU.arrayCopyII(this.triangles, this.triangles.length));
        }
        hashtable.put("vertexCount", this.nVertices);
        hashtable.put("atomIndex", this.centralAtom.i);
        hashtable.put("vertices", AU.arrayCopyPt(this.vertices, bl ? this.nVertices : this.vertices.length));
        objectArray = new int[this.nVertices];
        for (int i = 0; i < this.nVertices; ++i) {
            p3 = this.vertices[i];
            objectArray[i] = (P3)(p3 instanceof Node ? ((Node)((Object)p3)).getElementNumber() : (p3 instanceof Point3fi ? (int)((Point3fi)p3).sD : -2));
        }
        hashtable.put("elemNos", objectArray);
        return hashtable;
    }

    String getSymmetry(Viewer viewer, boolean bl) {
        this.info = null;
        SmilesMatcherInterface smilesMatcherInterface = viewer.getSmilesMatcher();
        try {
            String string;
            String string2 = string = this.distanceRef <= 0.0f ? null : "r=" + this.distanceRef;
            if (this.smarts == null) {
                this.smarts = smilesMatcherInterface.polyhedronToSmiles(this.centralAtom, this.faces, this.nVertices, null, 512, null);
                this.smiles = smilesMatcherInterface.polyhedronToSmiles(this.centralAtom, this.faces, this.nVertices, this.vertices, 1, null);
                this.polySmiles = smilesMatcherInterface.polyhedronToSmiles(this.centralAtom, this.faces, this.nVertices, this.vertices, 528385, string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.pointGroup == null && bl) {
            this.pointGroup = viewer.ms.getSymTemp(true).setPointGroup(null, this.vertices, null, false, viewer.getFloat(0x22000026), viewer.getFloat(0x22000028), true);
        }
        return this.centralAtom + " " + this.pointGroup.getPointGroupName();
    }

    private Float getVolume() {
        if (this.volume != null) {
            return this.volume;
        }
        V3 v3 = new V3();
        V3 v32 = new V3();
        V3 v33 = new V3();
        float f = 0.0f;
        if (this.bsFlat.cardinality() < this.triangles.length) {
            int n = this.triangles.length;
            while (--n >= 0) {
                int[] nArray = this.triangles[n];
                int n2 = nArray.length - 2;
                while (--n2 >= 0) {
                    if (nArray[n2 + 2] < 0) continue;
                    f += this.triangleVolume(nArray[n2], nArray[n2 + 1], nArray[n2 + 2], v3, v32, v33);
                }
            }
        }
        return Float.valueOf(f / 6.0f);
    }

    private float triangleVolume(int n, int n2, int n3, V3 v3, V3 v32, V3 v33) {
        v3.setT(this.vertices[n]);
        v32.setT(this.vertices[n2]);
        v33.cross(v3, v32);
        v32.setT(this.vertices[n3]);
        return v32.dot(v33);
    }

    String getState(Viewer viewer) {
        return "  polyhedron @{" + Escape.e(this.getInfo(viewer, false)) + "} " + (this.isFullyLit ? " fullyLit" : "") + ";" + (this.visible ? "" : "polyhedra ({" + this.centralAtom.i + "}) off;") + "\n";
    }

    public void move(M4 m4) {
        int n;
        this.info = null;
        for (n = 0; n < this.nVertices; ++n) {
            P3 p3 = this.vertices[n];
            if (p3 instanceof Atom) {
                p3 = this.vertices[n] = P3.newP(p3);
            }
            m4.rotTrans(p3);
        }
        n = this.normals.length;
        while (--n >= 0) {
            m4.rotate(this.normals[n]);
        }
        this.normixes = null;
    }

    public short[] getNormixes() {
        if (this.normixes == null) {
            this.normixes = new short[this.normals.length];
            BS bS = new BS();
            int n = this.normals.length;
            while (--n >= 0) {
                this.normixes[n] = this.bsFlat.get(n) ? Normix.get2SidedNormix(this.normals[n], bS) : Normix.getNormixV(this.normals[n], bS);
            }
        }
        return this.normixes;
    }
}

