/**
Copyright (c) 2012, Brice Videau <brice.videau@imag.fr>
Copyright (c) 2012, Vincent Danjean <Vincent.Danjean@ens-lyon.org>
All rights reserved.
      
Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    
1. Redistributions of source code must retain the above copyright notice, this
   list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.
        
THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

Do not edit this file. It is automatically generated.

*/

#ifndef OCL_ICD_H
#define OCL_ICD_H
#pragma GCC diagnostic push
#  pragma GCC diagnostic ignored "-Wcpp"
#  define CL_USE_DEPRECATED_OPENCL_1_0_APIS
#  define CL_USE_DEPRECATED_OPENCL_1_1_APIS
#  define CL_USE_DEPRECATED_OPENCL_1_2_APIS
#  include <CL/opencl.h>
#include <CL/cl.h>
#include <CL/cl_gl.h>
#include <CL/cl_ext.h>
#include <CL/cl_gl_ext.h>
#pragma GCC diagnostic pop

#define OCL_ICD_API_VERSION	1
#define OCL_ICD_IDENTIFIED_FUNCTIONS	116

struct _cl_icd_dispatch {
#ifdef CL_VERSION_1_0
  CL_API_ENTRY cl_int (CL_API_CALL*clGetPlatformIDs)(
    cl_uint          /* num_entries */,
    cl_platform_id * /* platforms */,
    cl_uint *        /* num_platforms */
  ) CL_API_SUFFIX__VERSION_1_0;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown0)(void);
#endif

#ifdef CL_VERSION_1_0
  CL_API_ENTRY cl_int (CL_API_CALL*
  clGetPlatformInfo)(
    cl_platform_id   /* platform */,
    cl_platform_info /* param_name */,
    size_t           /* param_value_size */,
    void *           /* param_value */,
    size_t *         /* param_value_size_ret */
  ) CL_API_SUFFIX__VERSION_1_0;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown1)(void);
#endif

#ifdef CL_VERSION_1_0
  CL_API_ENTRY cl_int (CL_API_CALL*clGetDeviceIDs)(
    cl_platform_id   /* platform */,
    cl_device_type   /* device_type */,
    cl_uint          /* num_entries */,
    cl_device_id *   /* devices */,
    cl_uint *        /* num_devices */
  ) CL_API_SUFFIX__VERSION_1_0;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown2)(void);
#endif

#ifdef CL_VERSION_1_0
  CL_API_ENTRY cl_int (CL_API_CALL*clGetDeviceInfo)(
    cl_device_id    /* device */,
    cl_device_info  /* param_name */,
    size_t          /* param_value_size */,
    void *          /* param_value */,
    size_t *        /* param_value_size_ret */
  ) CL_API_SUFFIX__VERSION_1_0;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown3)(void);
#endif

#ifdef CL_VERSION_1_0
  CL_API_ENTRY cl_context (CL_API_CALL*clCreateContext)(
    const cl_context_properties * /* properties */,
    cl_uint                       /* num_devices */,
    const cl_device_id *          /* devices */,
    void (CL_CALLBACK * /* pfn_notify */)(const char *, const void *, size_t, void *),
    void *                        /* user_data */,
    cl_int *                      /* errcode_ret */
  ) CL_API_SUFFIX__VERSION_1_0;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown4)(void);
#endif

#ifdef CL_VERSION_1_0
  CL_API_ENTRY cl_context (CL_API_CALL*clCreateContextFromType)(
    const cl_context_properties * /* properties */,
    cl_device_type                /* device_type */,
    void (CL_CALLBACK *     /* pfn_notify*/ )(const char *, const void *, size_t, void *),
    void *                        /* user_data */,
    cl_int *                      /* errcode_ret */
  ) CL_API_SUFFIX__VERSION_1_0;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown5)(void);
#endif

#ifdef CL_VERSION_1_0
  CL_API_ENTRY cl_int (CL_API_CALL*clRetainContext)(
    cl_context /* context */
  ) CL_API_SUFFIX__VERSION_1_0;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown6)(void);
#endif

#ifdef CL_VERSION_1_0
  CL_API_ENTRY cl_int (CL_API_CALL*clReleaseContext)(
    cl_context /* context */
  ) CL_API_SUFFIX__VERSION_1_0;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown7)(void);
#endif

#ifdef CL_VERSION_1_0
  CL_API_ENTRY cl_int (CL_API_CALL*clGetContextInfo)(
    cl_context         /* context */,
    cl_context_info    /* param_name */,
    size_t             /* param_value_size */,
    void *             /* param_value */,
    size_t *           /* param_value_size_ret */
  ) CL_API_SUFFIX__VERSION_1_0;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown8)(void);
#endif

#ifdef CL_VERSION_1_0
  CL_API_ENTRY cl_command_queue (CL_API_CALL*clCreateCommandQueue)(
    cl_context                     /* context */,
    cl_device_id                   /* device */,
    cl_command_queue_properties    /* properties */,
    cl_int *                       /* errcode_ret */
  ) CL_API_SUFFIX__VERSION_1_0;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown9)(void);
#endif

#ifdef CL_VERSION_1_0
  CL_API_ENTRY cl_int (CL_API_CALL*clRetainCommandQueue)(
    cl_command_queue /* command_queue */
  ) CL_API_SUFFIX__VERSION_1_0;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown10)(void);
#endif

#ifdef CL_VERSION_1_0
  CL_API_ENTRY cl_int (CL_API_CALL*clReleaseCommandQueue)(
    cl_command_queue /* command_queue */
  ) CL_API_SUFFIX__VERSION_1_0;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown11)(void);
#endif

#ifdef CL_VERSION_1_0
  CL_API_ENTRY cl_int (CL_API_CALL*clGetCommandQueueInfo)(
    cl_command_queue      /* command_queue */,
    cl_command_queue_info /* param_name */,
    size_t                /* param_value_size */,
    void *                /* param_value */,
    size_t *              /* param_value_size_ret */
  ) CL_API_SUFFIX__VERSION_1_0;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown12)(void);
#endif

  CL_API_ENTRY cl_int (CL_API_CALL*clSetCommandQueueProperty)(
    cl_command_queue              /* command_queue */,
    cl_command_queue_properties   /* properties */,
    cl_bool                        /* enable */,
    cl_command_queue_properties * /* old_properties */) CL_EXT_SUFFIX__VERSION_1_0_DEPRECATED;

#ifdef CL_VERSION_1_0
  CL_API_ENTRY cl_mem (CL_API_CALL*clCreateBuffer)(
    cl_context   /* context */,
    cl_mem_flags /* flags */,
    size_t       /* size */,
    void *       /* host_ptr */,
    cl_int *     /* errcode_ret */
  ) CL_API_SUFFIX__VERSION_1_0;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown14)(void);
#endif

#ifdef CL_VERSION_1_0
  CL_API_ENTRY cl_mem (CL_API_CALL*clCreateImage2D)(
    cl_context              /* context */,
    cl_mem_flags            /* flags */,
    const cl_image_format * /* image_format */,
    size_t                  /* image_width */,
    size_t                  /* image_height */,
    size_t                  /* image_row_pitch */,
    void *                  /* host_ptr */,
    cl_int *                /* errcode_ret */
  ) CL_API_SUFFIX__VERSION_1_0;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown15)(void);
#endif

#ifdef CL_VERSION_1_0
  CL_API_ENTRY cl_mem (CL_API_CALL*clCreateImage3D)(
    cl_context              /* context */,
    cl_mem_flags            /* flags */,
    const cl_image_format * /* image_format */,
    size_t                  /* image_width */,
    size_t                  /* image_height */,
    size_t                  /* image_depth */,
    size_t                  /* image_row_pitch */,
    size_t                  /* image_slice_pitch */,
    void *                  /* host_ptr */,
    cl_int *                /* errcode_ret */
  ) CL_API_SUFFIX__VERSION_1_0;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown16)(void);
#endif

#ifdef CL_VERSION_1_0
  CL_API_ENTRY cl_int (CL_API_CALL*clRetainMemObject)(
    cl_mem /* memobj */
  ) CL_API_SUFFIX__VERSION_1_0;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown17)(void);
#endif

#ifdef CL_VERSION_1_0
  CL_API_ENTRY cl_int (CL_API_CALL*clReleaseMemObject)(
    cl_mem /* memobj */
  ) CL_API_SUFFIX__VERSION_1_0;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown18)(void);
#endif

#ifdef CL_VERSION_1_0
  CL_API_ENTRY cl_int (CL_API_CALL*clGetSupportedImageFormats)(
    cl_context           /* context */,
    cl_mem_flags         /* flags */,
    cl_mem_object_type   /* image_type */,
    cl_uint              /* num_entries */,
    cl_image_format *    /* image_formats */,
    cl_uint *            /* num_image_formats */
  ) CL_API_SUFFIX__VERSION_1_0;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown19)(void);
#endif

#ifdef CL_VERSION_1_0
  CL_API_ENTRY cl_int (CL_API_CALL*clGetMemObjectInfo)(
    cl_mem           /* memobj */,
    cl_mem_info      /* param_name */,
    size_t           /* param_value_size */,
    void *           /* param_value */,
    size_t *         /* param_value_size_ret */
  ) CL_API_SUFFIX__VERSION_1_0;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown20)(void);
#endif

#ifdef CL_VERSION_1_0
  CL_API_ENTRY cl_int (CL_API_CALL*clGetImageInfo)(
    cl_mem           /* image */,
    cl_image_info    /* param_name */,
    size_t           /* param_value_size */,
    void *           /* param_value */,
    size_t *         /* param_value_size_ret */
  ) CL_API_SUFFIX__VERSION_1_0;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown21)(void);
#endif

#ifdef CL_VERSION_1_0
  CL_API_ENTRY cl_sampler (CL_API_CALL*clCreateSampler)(
    cl_context          /* context */,
    cl_bool             /* normalized_coords */,
    cl_addressing_mode  /* addressing_mode */,
    cl_filter_mode      /* filter_mode */,
    cl_int *            /* errcode_ret */
  ) CL_API_SUFFIX__VERSION_1_0;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown22)(void);
#endif

#ifdef CL_VERSION_1_0
  CL_API_ENTRY cl_int (CL_API_CALL*clRetainSampler)(
    cl_sampler /* sampler */
  ) CL_API_SUFFIX__VERSION_1_0;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown23)(void);
#endif

#ifdef CL_VERSION_1_0
  CL_API_ENTRY cl_int (CL_API_CALL*clReleaseSampler)(
    cl_sampler /* sampler */
  ) CL_API_SUFFIX__VERSION_1_0;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown24)(void);
#endif

#ifdef CL_VERSION_1_0
  CL_API_ENTRY cl_int (CL_API_CALL*clGetSamplerInfo)(
    cl_sampler         /* sampler */,
    cl_sampler_info    /* param_name */,
    size_t             /* param_value_size */,
    void *             /* param_value */,
    size_t *           /* param_value_size_ret */
  ) CL_API_SUFFIX__VERSION_1_0;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown25)(void);
#endif

#ifdef CL_VERSION_1_0
  CL_API_ENTRY cl_program (CL_API_CALL*clCreateProgramWithSource)(
    cl_context        /* context */,
    cl_uint           /* count */,
    const char **     /* strings */,
    const size_t *    /* lengths */,
    cl_int *          /* errcode_ret */
  ) CL_API_SUFFIX__VERSION_1_0;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown26)(void);
#endif

#ifdef CL_VERSION_1_0
  CL_API_ENTRY cl_program (CL_API_CALL*clCreateProgramWithBinary)(
    cl_context                     /* context */,
    cl_uint                        /* num_devices */,
    const cl_device_id *           /* device_list */,
    const size_t *                 /* lengths */,
    const unsigned char **         /* binaries */,
    cl_int *                       /* binary_status */,
    cl_int *                       /* errcode_ret */
  ) CL_API_SUFFIX__VERSION_1_0;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown27)(void);
#endif

#ifdef CL_VERSION_1_0
  CL_API_ENTRY cl_int (CL_API_CALL*clRetainProgram)(
    cl_program /* program */
  ) CL_API_SUFFIX__VERSION_1_0;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown28)(void);
#endif

#ifdef CL_VERSION_1_0
  CL_API_ENTRY cl_int (CL_API_CALL*clReleaseProgram)(
    cl_program /* program */
  ) CL_API_SUFFIX__VERSION_1_0;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown29)(void);
#endif

#ifdef CL_VERSION_1_0
  CL_API_ENTRY cl_int (CL_API_CALL*clBuildProgram)(
    cl_program           /* program */,
    cl_uint              /* num_devices */,
    const cl_device_id * /* device_list */,
    const char *         /* options */,
    void (CL_CALLBACK *  /* pfn_notify */)(cl_program /* program */, void * /* user_data */),
    void *               /* user_data */
  ) CL_API_SUFFIX__VERSION_1_0;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown30)(void);
#endif

#ifdef CL_VERSION_1_0
  CL_API_ENTRY cl_int (CL_API_CALL*clUnloadCompiler)(
    void
  ) CL_API_SUFFIX__VERSION_1_0;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown31)(void);
#endif

#ifdef CL_VERSION_1_0
  CL_API_ENTRY cl_int (CL_API_CALL*clGetProgramInfo)(
    cl_program         /* program */,
    cl_program_info    /* param_name */,
    size_t             /* param_value_size */,
    void *             /* param_value */,
    size_t *           /* param_value_size_ret */
  ) CL_API_SUFFIX__VERSION_1_0;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown32)(void);
#endif

#ifdef CL_VERSION_1_0
  CL_API_ENTRY cl_int (CL_API_CALL*clGetProgramBuildInfo)(
    cl_program            /* program */,
    cl_device_id          /* device */,
    cl_program_build_info /* param_name */,
    size_t                /* param_value_size */,
    void *                /* param_value */,
    size_t *              /* param_value_size_ret */
  ) CL_API_SUFFIX__VERSION_1_0;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown33)(void);
#endif

#ifdef CL_VERSION_1_0
  CL_API_ENTRY cl_kernel (CL_API_CALL*clCreateKernel)(
    cl_program      /* program */,
    const char *    /* kernel_name */,
    cl_int *        /* errcode_ret */
  ) CL_API_SUFFIX__VERSION_1_0;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown34)(void);
#endif

#ifdef CL_VERSION_1_0
  CL_API_ENTRY cl_int (CL_API_CALL*clCreateKernelsInProgram)(
    cl_program     /* program */,
    cl_uint        /* num_kernels */,
    cl_kernel *    /* kernels */,
    cl_uint *      /* num_kernels_ret */
  ) CL_API_SUFFIX__VERSION_1_0;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown35)(void);
#endif

#ifdef CL_VERSION_1_0
  CL_API_ENTRY cl_int (CL_API_CALL*clRetainKernel)(
    cl_kernel    /* kernel */
  ) CL_API_SUFFIX__VERSION_1_0;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown36)(void);
#endif

#ifdef CL_VERSION_1_0
  CL_API_ENTRY cl_int (CL_API_CALL*clReleaseKernel)(
    cl_kernel   /* kernel */
  ) CL_API_SUFFIX__VERSION_1_0;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown37)(void);
#endif

#ifdef CL_VERSION_1_0
  CL_API_ENTRY cl_int (CL_API_CALL*clSetKernelArg)(
    cl_kernel    /* kernel */,
    cl_uint      /* arg_index */,
    size_t       /* arg_size */,
    const void * /* arg_value */
  ) CL_API_SUFFIX__VERSION_1_0;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown38)(void);
#endif

#ifdef CL_VERSION_1_0
  CL_API_ENTRY cl_int (CL_API_CALL*clGetKernelInfo)(
    cl_kernel       /* kernel */,
    cl_kernel_info  /* param_name */,
    size_t          /* param_value_size */,
    void *          /* param_value */,
    size_t *        /* param_value_size_ret */
  ) CL_API_SUFFIX__VERSION_1_0;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown39)(void);
#endif

#ifdef CL_VERSION_1_0
  CL_API_ENTRY cl_int (CL_API_CALL*clGetKernelWorkGroupInfo)(
    cl_kernel                  /* kernel */,
    cl_device_id               /* device */,
    cl_kernel_work_group_info  /* param_name */,
    size_t                     /* param_value_size */,
    void *                     /* param_value */,
    size_t *                   /* param_value_size_ret */
  ) CL_API_SUFFIX__VERSION_1_0;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown40)(void);
#endif

#ifdef CL_VERSION_1_0
  CL_API_ENTRY cl_int (CL_API_CALL*clWaitForEvents)(
    cl_uint             /* num_events */,
    const cl_event *    /* event_list */
  ) CL_API_SUFFIX__VERSION_1_0;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown41)(void);
#endif

#ifdef CL_VERSION_1_0
  CL_API_ENTRY cl_int (CL_API_CALL*clGetEventInfo)(
    cl_event         /* event */,
    cl_event_info    /* param_name */,
    size_t           /* param_value_size */,
    void *           /* param_value */,
    size_t *         /* param_value_size_ret */
  ) CL_API_SUFFIX__VERSION_1_0;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown42)(void);
#endif

#ifdef CL_VERSION_1_0
  CL_API_ENTRY cl_int (CL_API_CALL*clRetainEvent)(
    cl_event /* event */
  ) CL_API_SUFFIX__VERSION_1_0;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown43)(void);
#endif

#ifdef CL_VERSION_1_0
  CL_API_ENTRY cl_int (CL_API_CALL*clReleaseEvent)(
    cl_event /* event */
  ) CL_API_SUFFIX__VERSION_1_0;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown44)(void);
#endif

#ifdef CL_VERSION_1_0
  CL_API_ENTRY cl_int (CL_API_CALL*clGetEventProfilingInfo)(
    cl_event            /* event */,
    cl_profiling_info   /* param_name */,
    size_t              /* param_value_size */,
    void *              /* param_value */,
    size_t *            /* param_value_size_ret */
  ) CL_API_SUFFIX__VERSION_1_0;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown45)(void);
#endif

#ifdef CL_VERSION_1_0
  CL_API_ENTRY cl_int (CL_API_CALL*clFlush)(
    cl_command_queue /* command_queue */
  ) CL_API_SUFFIX__VERSION_1_0;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown46)(void);
#endif

#ifdef CL_VERSION_1_0
  CL_API_ENTRY cl_int (CL_API_CALL*clFinish)(
    cl_command_queue /* command_queue */
  ) CL_API_SUFFIX__VERSION_1_0;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown47)(void);
#endif

#ifdef CL_VERSION_1_0
  CL_API_ENTRY cl_int (CL_API_CALL*clEnqueueReadBuffer)(
    cl_command_queue    /* command_queue */,
    cl_mem              /* buffer */,
    cl_bool             /* blocking_read */,
    size_t              /* offset */,
    size_t              /* cb */,
    void *              /* ptr */,
    cl_uint             /* num_events_in_wait_list */,
    const cl_event *    /* event_wait_list */,
    cl_event *          /* event */
  ) CL_API_SUFFIX__VERSION_1_0;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown48)(void);
#endif

#ifdef CL_VERSION_1_0
  CL_API_ENTRY cl_int (CL_API_CALL*clEnqueueWriteBuffer)(
    cl_command_queue   /* command_queue */,
    cl_mem             /* buffer */,
    cl_bool            /* blocking_write */,
    size_t             /* offset */,
    size_t             /* cb */,
    const void *       /* ptr */,
    cl_uint            /* num_events_in_wait_list */,
    const cl_event *   /* event_wait_list */,
    cl_event *         /* event */
  ) CL_API_SUFFIX__VERSION_1_0;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown49)(void);
#endif

#ifdef CL_VERSION_1_0
  CL_API_ENTRY cl_int (CL_API_CALL*clEnqueueCopyBuffer)(
    cl_command_queue    /* command_queue */,
    cl_mem              /* src_buffer */,
    cl_mem              /* dst_buffer */,
    size_t              /* src_offset */,
    size_t              /* dst_offset */,
    size_t              /* cb */,
    cl_uint             /* num_events_in_wait_list */,
    const cl_event *    /* event_wait_list */,
    cl_event *          /* event */
  ) CL_API_SUFFIX__VERSION_1_0;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown50)(void);
#endif

#ifdef CL_VERSION_1_0
  CL_API_ENTRY cl_int (CL_API_CALL*clEnqueueReadImage)(
    cl_command_queue     /* command_queue */,
    cl_mem               /* image */,
    cl_bool              /* blocking_read */,
    const size_t *       /* origin[3] */,
    const size_t *       /* region[3] */,
    size_t               /* row_pitch */,
    size_t               /* slice_pitch */,
    void *               /* ptr */,
    cl_uint              /* num_events_in_wait_list */,
    const cl_event *     /* event_wait_list */,
    cl_event *           /* event */
  ) CL_API_SUFFIX__VERSION_1_0;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown51)(void);
#endif

#ifdef CL_VERSION_1_0
  CL_API_ENTRY cl_int (CL_API_CALL*clEnqueueWriteImage)(
    cl_command_queue    /* command_queue */,
    cl_mem              /* image */,
    cl_bool             /* blocking_write */,
    const size_t *      /* origin[3] */,
    const size_t *      /* region[3] */,
    size_t              /* input_row_pitch */,
    size_t              /* input_slice_pitch */,
    const void *        /* ptr */,
    cl_uint             /* num_events_in_wait_list */,
    const cl_event *    /* event_wait_list */,
    cl_event *          /* event */
  ) CL_API_SUFFIX__VERSION_1_0;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown52)(void);
#endif

#ifdef CL_VERSION_1_0
  CL_API_ENTRY cl_int (CL_API_CALL*clEnqueueCopyImage)(
    cl_command_queue     /* command_queue */,
    cl_mem               /* src_image */,
    cl_mem               /* dst_image */,
    const size_t *       /* src_origin[3] */,
    const size_t *       /* dst_origin[3] */,
    const size_t *       /* region[3] */,
    cl_uint              /* num_events_in_wait_list */,
    const cl_event *     /* event_wait_list */,
    cl_event *           /* event */
  ) CL_API_SUFFIX__VERSION_1_0;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown53)(void);
#endif

#ifdef CL_VERSION_1_0
  CL_API_ENTRY cl_int (CL_API_CALL*clEnqueueCopyImageToBuffer)(
    cl_command_queue /* command_queue */,
    cl_mem           /* src_image */,
    cl_mem           /* dst_buffer */,
    const size_t *   /* src_origin[3] */,
    const size_t *   /* region[3] */,
    size_t           /* dst_offset */,
    cl_uint          /* num_events_in_wait_list */,
    const cl_event * /* event_wait_list */,
    cl_event *       /* event */
  ) CL_API_SUFFIX__VERSION_1_0;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown54)(void);
#endif

#ifdef CL_VERSION_1_0
  CL_API_ENTRY cl_int (CL_API_CALL*clEnqueueCopyBufferToImage)(
    cl_command_queue /* command_queue */,
    cl_mem           /* src_buffer */,
    cl_mem           /* dst_image */,
    size_t           /* src_offset */,
    const size_t *   /* dst_origin[3] */,
    const size_t *   /* region[3] */,
    cl_uint          /* num_events_in_wait_list */,
    const cl_event * /* event_wait_list */,
    cl_event *       /* event */
  ) CL_API_SUFFIX__VERSION_1_0;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown55)(void);
#endif

#ifdef CL_VERSION_1_0
  CL_API_ENTRY void * (CL_API_CALL*clEnqueueMapBuffer)(
    cl_command_queue /* command_queue */,
    cl_mem           /* buffer */,
    cl_bool          /* blocking_map */,
    cl_map_flags     /* map_flags */,
    size_t           /* offset */,
    size_t           /* cb */,
    cl_uint          /* num_events_in_wait_list */,
    const cl_event * /* event_wait_list */,
    cl_event *       /* event */,
    cl_int *         /* errcode_ret */
  ) CL_API_SUFFIX__VERSION_1_0;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown56)(void);
#endif

#ifdef CL_VERSION_1_0
  CL_API_ENTRY void * (CL_API_CALL*clEnqueueMapImage)(
    cl_command_queue  /* command_queue */,
    cl_mem            /* image */,
    cl_bool           /* blocking_map */,
    cl_map_flags      /* map_flags */,
    const size_t *    /* origin[3] */,
    const size_t *    /* region[3] */,
    size_t *          /* image_row_pitch */,
    size_t *          /* image_slice_pitch */,
    cl_uint           /* num_events_in_wait_list */,
    const cl_event *  /* event_wait_list */,
    cl_event *        /* event */,
    cl_int *          /* errcode_ret */
  ) CL_API_SUFFIX__VERSION_1_0;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown57)(void);
#endif

#ifdef CL_VERSION_1_0
  CL_API_ENTRY cl_int (CL_API_CALL*clEnqueueUnmapMemObject)(
    cl_command_queue /* command_queue */,
    cl_mem           /* memobj */,
    void *           /* mapped_ptr */,
    cl_uint          /* num_events_in_wait_list */,
    const cl_event *  /* event_wait_list */,
    cl_event *        /* event */
  ) CL_API_SUFFIX__VERSION_1_0;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown58)(void);
#endif

#ifdef CL_VERSION_1_0
  CL_API_ENTRY cl_int (CL_API_CALL*clEnqueueNDRangeKernel)(
    cl_command_queue /* command_queue */,
    cl_kernel        /* kernel */,
    cl_uint          /* work_dim */,
    const size_t *   /* global_work_offset */,
    const size_t *   /* global_work_size */,
    const size_t *   /* local_work_size */,
    cl_uint          /* num_events_in_wait_list */,
    const cl_event * /* event_wait_list */,
    cl_event *       /* event */
  ) CL_API_SUFFIX__VERSION_1_0;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown59)(void);
#endif

#ifdef CL_VERSION_1_0
  CL_API_ENTRY cl_int (CL_API_CALL*clEnqueueTask)(
    cl_command_queue  /* command_queue */,
    cl_kernel         /* kernel */,
    cl_uint           /* num_events_in_wait_list */,
    const cl_event *  /* event_wait_list */,
    cl_event *        /* event */
  ) CL_API_SUFFIX__VERSION_1_0;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown60)(void);
#endif

#ifdef CL_VERSION_1_0
  CL_API_ENTRY cl_int (CL_API_CALL*clEnqueueNativeKernel)(
    cl_command_queue  /* command_queue */,
    void (*user_func)(void *),
    void *            /* args */,
    size_t            /* cb_args */,
    cl_uint           /* num_mem_objects */,
    const cl_mem *    /* mem_list */,
    const void **     /* args_mem_loc */,
    cl_uint           /* num_events_in_wait_list */,
    const cl_event *  /* event_wait_list */,
    cl_event *        /* event */
  ) CL_API_SUFFIX__VERSION_1_0;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown61)(void);
#endif

#ifdef CL_VERSION_1_0
  CL_API_ENTRY cl_int (CL_API_CALL*clEnqueueMarker)(
    cl_command_queue    /* command_queue */,
    cl_event *          /* event */
  ) CL_API_SUFFIX__VERSION_1_0;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown62)(void);
#endif

#ifdef CL_VERSION_1_0
  CL_API_ENTRY cl_int (CL_API_CALL*clEnqueueWaitForEvents)(
    cl_command_queue /* command_queue */,
    cl_uint          /* num_events */,
    const cl_event * /* event_list */
  ) CL_API_SUFFIX__VERSION_1_0;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown63)(void);
#endif

#ifdef CL_VERSION_1_0
  CL_API_ENTRY cl_int (CL_API_CALL*clEnqueueBarrier)(
    cl_command_queue /* command_queue */
  ) CL_API_SUFFIX__VERSION_1_0;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown64)(void);
#endif

#ifdef CL_VERSION_1_0
  CL_API_ENTRY void * (CL_API_CALL*clGetExtensionFunctionAddress)(
    const char * /* func_name */
  ) CL_API_SUFFIX__VERSION_1_0;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown65)(void);
#endif

#ifdef CL_VERSION_1_0
  CL_API_ENTRY cl_mem (CL_API_CALL*clCreateFromGLBuffer)(
    cl_context     /* context */,
    cl_mem_flags   /* flags */,
    cl_GLuint      /* bufobj */,
    int *          /* errcode_ret */
  ) CL_API_SUFFIX__VERSION_1_0;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown66)(void);
#endif

#ifdef CL_VERSION_1_0
  CL_API_ENTRY cl_mem (CL_API_CALL*clCreateFromGLTexture2D)(
    cl_context      /* context */,
    cl_mem_flags    /* flags */,
    cl_GLenum       /* target */,
    cl_GLint        /* miplevel */,
    cl_GLuint       /* texture */,
    cl_int *        /* errcode_ret */
  ) CL_API_SUFFIX__VERSION_1_0;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown67)(void);
#endif

#ifdef CL_VERSION_1_0
  CL_API_ENTRY cl_mem (CL_API_CALL*clCreateFromGLTexture3D)(
    cl_context      /* context */,
    cl_mem_flags    /* flags */,
    cl_GLenum       /* target */,
    cl_GLint        /* miplevel */,
    cl_GLuint       /* texture */,
    cl_int *        /* errcode_ret */
  ) CL_API_SUFFIX__VERSION_1_0;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown68)(void);
#endif

#ifdef CL_VERSION_1_0
  CL_API_ENTRY cl_mem (CL_API_CALL*clCreateFromGLRenderbuffer)(
    cl_context   /* context */,
    cl_mem_flags /* flags */,
    cl_GLuint    /* renderbuffer */,
    cl_int *     /* errcode_ret */
  ) CL_API_SUFFIX__VERSION_1_0;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown69)(void);
#endif

#ifdef CL_VERSION_1_0
  CL_API_ENTRY cl_int (CL_API_CALL*clGetGLObjectInfo)(
    cl_mem                /* memobj */,
    cl_gl_object_type *   /* gl_object_type */,
    cl_GLuint *              /* gl_object_name */
  ) CL_API_SUFFIX__VERSION_1_0;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown70)(void);
#endif

#ifdef CL_VERSION_1_0
  CL_API_ENTRY cl_int (CL_API_CALL*clGetGLTextureInfo)(
    cl_mem               /* memobj */,
    cl_gl_texture_info   /* param_name */,
    size_t               /* param_value_size */,
    void *               /* param_value */,
    size_t *             /* param_value_size_ret */
  ) CL_API_SUFFIX__VERSION_1_0;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown71)(void);
#endif

#ifdef CL_VERSION_1_0
  CL_API_ENTRY cl_int (CL_API_CALL*clEnqueueAcquireGLObjects)(
    cl_command_queue      /* command_queue */,
    cl_uint               /* num_objects */,
    const cl_mem *        /* mem_objects */,
    cl_uint               /* num_events_in_wait_list */,
    const cl_event *      /* event_wait_list */,
    cl_event *            /* event */
  ) CL_API_SUFFIX__VERSION_1_0;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown72)(void);
#endif

#ifdef CL_VERSION_1_0
  CL_API_ENTRY cl_int (CL_API_CALL*clEnqueueReleaseGLObjects)(
    cl_command_queue      /* command_queue */,
    cl_uint               /* num_objects */,
    const cl_mem *        /* mem_objects */,
    cl_uint               /* num_events_in_wait_list */,
    const cl_event *      /* event_wait_list */,
    cl_event *            /* event */
  ) CL_API_SUFFIX__VERSION_1_0;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown73)(void);
#endif

#ifdef CL_VERSION_1_0
  CL_API_ENTRY cl_int (CL_API_CALL*clGetGLContextInfoKHR)(
    const cl_context_properties * /* properties */,
    cl_gl_context_info            /* param_name */,
    size_t                        /* param_value_size */,
    void *                        /* param_value */,
    size_t *                      /* param_value_size_ret */
  ) CL_API_SUFFIX__VERSION_1_0;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown74)(void);
#endif

  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown75)(
    void);

  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown76)(
    void);

  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown77)(
    void);

  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown78)(
    void);

  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown79)(
    void);

  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown80)(
    void);

#ifdef CL_VERSION_1_1
  CL_API_ENTRY cl_int (CL_API_CALL*clSetEventCallback)(
    cl_event    /* event */,
    cl_int      /* command_exec_callback_type */,
    void (CL_CALLBACK * /* pfn_notify */)(cl_event, cl_int, void *),
    void *      /* user_data */
  ) CL_API_SUFFIX__VERSION_1_1;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown81)(void);
#endif

#ifdef CL_VERSION_1_1
  CL_API_ENTRY cl_mem (CL_API_CALL*clCreateSubBuffer)(
    cl_mem                   /* buffer */,
    cl_mem_flags             /* flags */,
    cl_buffer_create_type    /* buffer_create_type */,
    const void *             /* buffer_create_info */,
    cl_int *                 /* errcode_ret */
  ) CL_API_SUFFIX__VERSION_1_1;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown82)(void);
#endif

#ifdef CL_VERSION_1_1
  CL_API_ENTRY cl_int (CL_API_CALL*clSetMemObjectDestructorCallback)(
    cl_mem /* memobj */,
    void (CL_CALLBACK * /*pfn_notify*/)( cl_mem /* memobj */, void* /*user_data*/),
    void * /*user_data */ )             CL_API_SUFFIX__VERSION_1_1;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown83)(void);
#endif

#ifdef CL_VERSION_1_1
  CL_API_ENTRY cl_event (CL_API_CALL*clCreateUserEvent)(
    cl_context    /* context */,
    cl_int *      /* errcode_ret */
  ) CL_API_SUFFIX__VERSION_1_1;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown84)(void);
#endif

#ifdef CL_VERSION_1_1
  CL_API_ENTRY cl_int (CL_API_CALL*clSetUserEventStatus)(
    cl_event   /* event */,
    cl_int     /* execution_status */
  ) CL_API_SUFFIX__VERSION_1_1;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown85)(void);
#endif

#ifdef CL_VERSION_1_1
  CL_API_ENTRY cl_int (CL_API_CALL*clEnqueueReadBufferRect)(
    cl_command_queue    /* command_queue */,
    cl_mem              /* buffer */,
    cl_bool             /* blocking_read */,
    const size_t *      /* buffer_origin */,
    const size_t *      /* host_origin */,
    const size_t *      /* region */,
    size_t              /* buffer_row_pitch */,
    size_t              /* buffer_slice_pitch */,
    size_t              /* host_row_pitch */,
    size_t              /* host_slice_pitch */,
    void *              /* ptr */,
    cl_uint             /* num_events_in_wait_list */,
    const cl_event *    /* event_wait_list */,
    cl_event *          /* event */
  ) CL_API_SUFFIX__VERSION_1_1;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown86)(void);
#endif

#ifdef CL_VERSION_1_1
  CL_API_ENTRY cl_int (CL_API_CALL*clEnqueueWriteBufferRect)(
    cl_command_queue    /* command_queue */,
    cl_mem              /* buffer */,
    cl_bool             /* blocking_write */,
    const size_t *      /* buffer_origin */,
    const size_t *      /* host_origin */,
    const size_t *      /* region */,
    size_t              /* buffer_row_pitch */,
    size_t              /* buffer_slice_pitch */,
    size_t              /* host_row_pitch */,
    size_t              /* host_slice_pitch */,
    const void *        /* ptr */,
    cl_uint             /* num_events_in_wait_list */,
    const cl_event *    /* event_wait_list */,
    cl_event *          /* event */
  ) CL_API_SUFFIX__VERSION_1_1;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown87)(void);
#endif

#ifdef CL_VERSION_1_1
  CL_API_ENTRY cl_int (CL_API_CALL*clEnqueueCopyBufferRect)(
    cl_command_queue    /* command_queue */,
    cl_mem              /* src_buffer */,
    cl_mem              /* dst_buffer */,
    const size_t *      /* src_origin */,
    const size_t *      /* dst_origin */,
    const size_t *      /* region */,
    size_t              /* src_row_pitch */,
    size_t              /* src_slice_pitch */,
    size_t              /* dst_row_pitch */,
    size_t              /* dst_slice_pitch */,
    cl_uint             /* num_events_in_wait_list */,
    const cl_event *    /* event_wait_list */,
    cl_event *          /* event */
  ) CL_API_SUFFIX__VERSION_1_1;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown88)(void);
#endif

  CL_API_ENTRY cl_int (CL_API_CALL*    clCreateSubDevicesEXT)(
    cl_device_id /*in_device*/,
    const cl_device_partition_property_ext * /* properties */,
    cl_uint /*num_entries*/,
    cl_device_id * /*out_devices*/,
    cl_uint * /*num_devices*/ ) CL_EXT_SUFFIX__VERSION_1_1;

  CL_API_ENTRY cl_int (CL_API_CALL*    clRetainDeviceEXT)(
    cl_device_id /*device*/ ) CL_EXT_SUFFIX__VERSION_1_1;

  CL_API_ENTRY cl_int (CL_API_CALL*    clReleaseDeviceEXT)(
    cl_device_id /*device*/ ) CL_EXT_SUFFIX__VERSION_1_1;

  CL_API_ENTRY cl_event (CL_API_CALL*clCreateEventFromGLsyncKHR)(
    cl_context           /* context */,
    cl_GLsync            /* cl_GLsync */,
    cl_int *             /* errcode_ret */) CL_EXT_SUFFIX__VERSION_1_1;

#ifdef CL_VERSION_1_2
  CL_API_ENTRY cl_int (CL_API_CALL*clCreateSubDevices)(
    cl_device_id                         /* in_device */,
    const cl_device_partition_property * /* properties */,
    cl_uint                              /* num_devices */,
    cl_device_id *                       /* out_devices */,
    cl_uint *                            /* num_devices_ret */
  ) CL_API_SUFFIX__VERSION_1_2;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown93)(void);
#endif

#ifdef CL_VERSION_1_2
  CL_API_ENTRY cl_int (CL_API_CALL*clRetainDevice)(
    cl_device_id /* device */
  ) CL_API_SUFFIX__VERSION_1_2;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown94)(void);
#endif

#ifdef CL_VERSION_1_2
  CL_API_ENTRY cl_int (CL_API_CALL*clReleaseDevice)(
    cl_device_id /* device */
  ) CL_API_SUFFIX__VERSION_1_2;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown95)(void);
#endif

#ifdef CL_VERSION_1_2
  CL_API_ENTRY cl_mem (CL_API_CALL*clCreateImage)(
    cl_context              /* context */,
    cl_mem_flags            /* flags */,
    const cl_image_format * /* image_format */,
    const cl_image_desc *   /* image_desc */,
    void *                  /* host_ptr */,
    cl_int *                /* errcode_ret */
  ) CL_API_SUFFIX__VERSION_1_2;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown96)(void);
#endif

#ifdef CL_VERSION_1_2
  CL_API_ENTRY cl_program (CL_API_CALL*clCreateProgramWithBuiltInKernels)(
    cl_context            /* context */,
    cl_uint               /* num_devices */,
    const cl_device_id *  /* device_list */,
    const char *          /* kernel_names */,
    cl_int *              /* errcode_ret */
  ) CL_API_SUFFIX__VERSION_1_2;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown97)(void);
#endif

#ifdef CL_VERSION_1_2
  CL_API_ENTRY cl_int (CL_API_CALL*clCompileProgram)(
    cl_program           /* program */,
    cl_uint              /* num_devices */,
    const cl_device_id * /* device_list */,
    const char *         /* options */,
    cl_uint              /* num_input_headers */,
    const cl_program *   /* input_headers */,
    const char **        /* header_include_names */,
    void (CL_CALLBACK *  /* pfn_notify */)(cl_program /* program */, void * /* user_data */),
    void *               /* user_data */
  ) CL_API_SUFFIX__VERSION_1_2;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown98)(void);
#endif

#ifdef CL_VERSION_1_2
  CL_API_ENTRY cl_program (CL_API_CALL*clLinkProgram)(
    cl_context           /* context */,
    cl_uint              /* num_devices */,
    const cl_device_id * /* device_list */,
    const char *         /* options */,
    cl_uint              /* num_input_programs */,
    const cl_program *   /* input_programs */,
    void (CL_CALLBACK *  /* pfn_notify */)(cl_program /* program */, void * /* user_data */),
    void *               /* user_data */,
    cl_int *             /* errcode_ret */
  ) CL_API_SUFFIX__VERSION_1_2;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown99)(void);
#endif

#ifdef CL_VERSION_1_2
  CL_API_ENTRY cl_int (CL_API_CALL*clUnloadPlatformCompiler)(
    cl_platform_id /* platform */
  ) CL_API_SUFFIX__VERSION_1_2;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown100)(void);
#endif

#ifdef CL_VERSION_1_2
  CL_API_ENTRY cl_int (CL_API_CALL*clGetKernelArgInfo)(
    cl_kernel       /* kernel */,
    cl_uint         /* arg_indx */,
    cl_kernel_arg_info  /* param_name */,
    size_t          /* param_value_size */,
    void *          /* param_value */,
    size_t *        /* param_value_size_ret */
  ) CL_API_SUFFIX__VERSION_1_2;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown101)(void);
#endif

#ifdef CL_VERSION_1_2
  CL_API_ENTRY cl_int (CL_API_CALL*clEnqueueFillBuffer)(
    cl_command_queue   /* command_queue */,
    cl_mem             /* buffer */,
    const void *       /* pattern */,
    size_t             /* pattern_size */,
    size_t             /* offset */,
    size_t             /* size */,
    cl_uint            /* num_events_in_wait_list */,
    const cl_event *   /* event_wait_list */,
    cl_event *         /* event */
  ) CL_API_SUFFIX__VERSION_1_2;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown102)(void);
#endif

#ifdef CL_VERSION_1_2
  CL_API_ENTRY cl_int (CL_API_CALL*clEnqueueFillImage)(
    cl_command_queue   /* command_queue */,
    cl_mem             /* image */,
    const void *       /* fill_color */,
    const size_t *     /* origin[3] */,
    const size_t *     /* region[3] */,
    cl_uint            /* num_events_in_wait_list */,
    const cl_event *   /* event_wait_list */,
    cl_event *         /* event */
  ) CL_API_SUFFIX__VERSION_1_2;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown103)(void);
#endif

#ifdef CL_VERSION_1_2
  CL_API_ENTRY cl_int (CL_API_CALL*clEnqueueMigrateMemObjects)(
    cl_command_queue       /* command_queue */,
    cl_uint                /* num_mem_objects */,
    const cl_mem *         /* mem_objects */,
    cl_mem_migration_flags /* flags */,
    cl_uint                /* num_events_in_wait_list */,
    const cl_event *       /* event_wait_list */,
    cl_event *             /* event */
  ) CL_API_SUFFIX__VERSION_1_2;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown104)(void);
#endif

#ifdef CL_VERSION_1_2
  CL_API_ENTRY cl_int (CL_API_CALL*clEnqueueMarkerWithWaitList)(
    cl_command_queue /* command_queue */,
    cl_uint           /* num_events_in_wait_list */,
    const cl_event *  /* event_wait_list */,
    cl_event *        /* event */
  ) CL_API_SUFFIX__VERSION_1_2;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown105)(void);
#endif

#ifdef CL_VERSION_1_2
  CL_API_ENTRY cl_int (CL_API_CALL*clEnqueueBarrierWithWaitList)(
    cl_command_queue /* command_queue */,
    cl_uint           /* num_events_in_wait_list */,
    const cl_event *  /* event_wait_list */,
    cl_event *        /* event */
  ) CL_API_SUFFIX__VERSION_1_2;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown106)(void);
#endif

#ifdef CL_VERSION_1_2
  CL_API_ENTRY void * (CL_API_CALL*
  clGetExtensionFunctionAddressForPlatform)(
    cl_platform_id /* platform */,
    const char *   /* func_name */
  ) CL_API_SUFFIX__VERSION_1_2;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown107)(void);
#endif

#ifdef CL_VERSION_1_2
  CL_API_ENTRY cl_mem (CL_API_CALL*clCreateFromGLTexture)(
    cl_context      /* context */,
    cl_mem_flags    /* flags */,
    cl_GLenum       /* target */,
    cl_GLint        /* miplevel */,
    cl_GLuint       /* texture */,
    cl_int *        /* errcode_ret */
  ) CL_API_SUFFIX__VERSION_1_2;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown108)(void);
#endif

  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown109)(
    void);

  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown110)(
    void);

  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown111)(
    void);

  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown112)(
    void);

  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown113)(
    void);

  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown114)(
    void);

  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown115)(
    void);

  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown116)(
    void);

  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown117)(
    void);

  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown118)(
    void);

  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown119)(
    void);

  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown120)(
    void);

  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown121)(
    void);

  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown122)(
    void);

#ifdef CL_VERSION_2_0
  CL_API_ENTRY cl_command_queue (CL_API_CALL*clCreateCommandQueueWithProperties)(
    cl_context               /* context */,
    cl_device_id             /* device */,
    const cl_queue_properties *    /* properties */,
    cl_int *                 /* errcode_ret */
  ) CL_API_SUFFIX__VERSION_2_0;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown123)(void);
#endif

#ifdef CL_VERSION_2_0
  CL_API_ENTRY cl_mem (CL_API_CALL*clCreatePipe)(
    cl_context                 /* context */,
    cl_mem_flags               /* flags */,
    cl_uint                    /* pipe_packet_size */,
    cl_uint                    /* pipe_max_packets */,
    const cl_pipe_properties * /* properties */,
    cl_int *                   /* errcode_ret */
  ) CL_API_SUFFIX__VERSION_2_0;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown124)(void);
#endif

#ifdef CL_VERSION_2_0
  CL_API_ENTRY cl_int (CL_API_CALL*clGetPipeInfo)(
    cl_mem           /* pipe */,
    cl_pipe_info     /* param_name */,
    size_t           /* param_value_size */,
    void *           /* param_value */,
    size_t *         /* param_value_size_ret */
  ) CL_API_SUFFIX__VERSION_2_0;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown125)(void);
#endif

#ifdef CL_VERSION_2_0
  CL_API_ENTRY void * (CL_API_CALL*clSVMAlloc)(
    cl_context       /* context */,
    cl_svm_mem_flags /* flags */,
    size_t           /* size */,
    cl_uint          /* alignment */
  ) CL_API_SUFFIX__VERSION_2_0;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown126)(void);
#endif

#ifdef CL_VERSION_2_0
  CL_API_ENTRY void (CL_API_CALL*clSVMFree)(
    cl_context        /* context */,
    void *            /* svm_pointer */
  ) CL_API_SUFFIX__VERSION_2_0;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown127)(void);
#endif

#ifdef CL_VERSION_2_0
  CL_API_ENTRY cl_int (CL_API_CALL*clEnqueueSVMFree)(
    cl_command_queue  /* command_queue */,
    cl_uint           /* num_svm_pointers */,
    void *[]          /* svm_pointers[] */,
    void (CL_CALLBACK * /*pfn_free_func*/)(cl_command_queue /* queue */,
    cl_uint          /* num_svm_pointers */,
    void *[]         /* svm_pointers[] */,
    void *           /* user_data */),
    void *            /* user_data */,
    cl_uint           /* num_events_in_wait_list */,
    const cl_event *  /* event_wait_list */,
    cl_event *        /* event */
  ) CL_API_SUFFIX__VERSION_2_0;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown128)(void);
#endif

#ifdef CL_VERSION_2_0
  CL_API_ENTRY cl_int (CL_API_CALL*clEnqueueSVMMemcpy)(
    cl_command_queue  /* command_queue */,
    cl_bool           /* blocking_copy */,
    void *            /* dst_ptr */,
    const void *      /* src_ptr */,
    size_t            /* size */,
    cl_uint           /* num_events_in_wait_list */,
    const cl_event *  /* event_wait_list */,
    cl_event *        /* event */
  ) CL_API_SUFFIX__VERSION_2_0;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown129)(void);
#endif

#ifdef CL_VERSION_2_0
  CL_API_ENTRY cl_int (CL_API_CALL*clEnqueueSVMMemFill)(
    cl_command_queue  /* command_queue */,
    void *            /* svm_ptr */,
    const void *      /* pattern */,
    size_t            /* pattern_size */,
    size_t            /* size */,
    cl_uint           /* num_events_in_wait_list */,
    const cl_event *  /* event_wait_list */,
    cl_event *        /* event */
  ) CL_API_SUFFIX__VERSION_2_0;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown130)(void);
#endif

#ifdef CL_VERSION_2_0
  CL_API_ENTRY cl_int (CL_API_CALL*clEnqueueSVMMap)(
    cl_command_queue  /* command_queue */,
    cl_bool           /* blocking_map */,
    cl_map_flags      /* flags */,
    void *            /* svm_ptr */,
    size_t            /* size */,
    cl_uint           /* num_events_in_wait_list */,
    const cl_event *  /* event_wait_list */,
    cl_event *        /* event */
  ) CL_API_SUFFIX__VERSION_2_0;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown131)(void);
#endif

#ifdef CL_VERSION_2_0
  CL_API_ENTRY cl_int (CL_API_CALL*clEnqueueSVMUnmap)(
    cl_command_queue  /* command_queue */,
    void *            /* svm_ptr */,
    cl_uint           /* num_events_in_wait_list */,
    const cl_event *  /* event_wait_list */,
    cl_event *        /* event */
  ) CL_API_SUFFIX__VERSION_2_0;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown132)(void);
#endif

#ifdef CL_VERSION_2_0
  CL_API_ENTRY cl_sampler (CL_API_CALL*clCreateSamplerWithProperties)(
    cl_context                     /* context */,
    const cl_sampler_properties *  /* normalized_coords */,
    cl_int *                       /* errcode_ret */
  ) CL_API_SUFFIX__VERSION_2_0;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown133)(void);
#endif

#ifdef CL_VERSION_2_0
  CL_API_ENTRY cl_int (CL_API_CALL*clSetKernelArgSVMPointer)(
    cl_kernel    /* kernel */,
    cl_uint      /* arg_index */,
    const void * /* arg_value */
  ) CL_API_SUFFIX__VERSION_2_0;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown134)(void);
#endif

#ifdef CL_VERSION_2_0
  CL_API_ENTRY cl_int (CL_API_CALL*clSetKernelExecInfo)(
    cl_kernel            /* kernel */,
    cl_kernel_exec_info  /* param_name */,
    size_t               /* param_value_size */,
    const void *         /* param_value */
  ) CL_API_SUFFIX__VERSION_2_0;
#else
  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown135)(void);
#endif

  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown136)(
    void);

  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown137)(
    void);

  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown138)(
    void);

  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown139)(
    void);

  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown140)(
    void);

  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown141)(
    void);

  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown142)(
    void);

  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown143)(
    void);

  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown144)(
    void);

  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown145)(
    void);

  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown146)(
    void);

  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown147)(
    void);

  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown148)(
    void);

  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown149)(
    void);

  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown150)(
    void);

  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown151)(
    void);

  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown152)(
    void);

  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown153)(
    void);

  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown154)(
    void);

  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown155)(
    void);

  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown156)(
    void);

  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown157)(
    void);

  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown158)(
    void);

  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown159)(
    void);

  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown160)(
    void);

  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown161)(
    void);

  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown162)(
    void);

  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown163)(
    void);

  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown164)(
    void);

  CL_API_ENTRY cl_int (CL_API_CALL* clUnknown165)(
    void);

};
#endif

