/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapespecial;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.M4;
import javajs.util.Measure;
import javajs.util.P3;
import javajs.util.P4;
import javajs.util.PT;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.api.AtomIndexIterator;
import org.jmol.api.SmilesMatcherInterface;
import org.jmol.api.SymmetryInterface;
import org.jmol.c.PAL;
import org.jmol.java.BS;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.script.SV;
import org.jmol.shape.AtomShape;
import org.jmol.shapespecial.Polyhedron;
import org.jmol.util.BSUtil;
import org.jmol.util.C;
import org.jmol.util.Logger;
import org.jmol.util.Normix;

public class Polyhedra
extends AtomShape {
    private static final float DEFAULT_FACECENTEROFFSET = 0.25f;
    private static final int EDGES_NONE = 0;
    public static final int EDGES_ALL = 1;
    public static final int EDGES_FRONT = 2;
    private static final int MAX_VERTICES = 250;
    private static final int FACE_COUNT_MAX = 247;
    private P3[] otherAtoms = new P3[498];
    private V3[] normalsT = new V3[251];
    private int[][] planesT = AU.newInt2((int)250);
    private static final P3 randomPoint = P3.new3((float)3141.0f, (float)2718.0f, (float)1414.0f);
    private static final int MODE_BONDING = 1;
    private static final int MODE_POINTS = 2;
    private static final int MODE_RADIUS = 3;
    private static final int MODE_BITSET = 4;
    private static final int MODE_UNITCELL = 5;
    private static final int MODE_INFO = 6;
    private static final float DEFAULT_PLANAR_PARAM = 0.98f;
    private static final float CONVEX_HULL_MAX = 0.02f;
    public int polyhedronCount;
    public Polyhedron[] polyhedrons = new Polyhedron[32];
    public int drawEdges;
    private float radius;
    private int nVertices;
    float faceCenterOffset;
    boolean isCollapsed;
    private boolean iHaveCenterBitSet;
    private boolean bondedOnly;
    private boolean haveBitSetVertices;
    private BS centers;
    private BS bsVertices;
    private BS bsVertexCount;
    private boolean useUnitCell;
    private int nPoints;
    private float planarParam;
    private Map<String, SV> info;
    private float distanceRef;
    private int buildMode;
    private final V3 vAB = new V3();
    private final V3 vAC = new V3();
    private final V3 vBC = new V3();
    private static float MAX_DISTANCE_TO_PLANE = 0.1f;

    public void setProperty(String string, Object object, BS bS) {
        int n;
        int n2;
        if ("init" == string) {
            this.faceCenterOffset = 0.25f;
            this.planarParam = Float.NaN;
            this.radius = 0.0f;
            this.nVertices = 0;
            this.nPoints = 0;
            this.bsVertices = null;
            this.useUnitCell = false;
            this.centers = null;
            this.info = null;
            this.bsVertexCount = new BS();
            this.iHaveCenterBitSet = false;
            this.isCollapsed = false;
            this.bondedOnly = false;
            this.haveBitSetVertices = false;
            if (Boolean.TRUE == object) {
                this.drawEdges = 0;
            }
            return;
        }
        if ("generate" == string) {
            if (!this.iHaveCenterBitSet) {
                this.centers = bS;
                this.iHaveCenterBitSet = true;
            }
            this.deletePolyhedra();
            this.buildPolyhedra();
            return;
        }
        if ("collapsed" == string) {
            this.isCollapsed = (Boolean)object;
            return;
        }
        if ("nVertices" == string) {
            int n3 = (Integer)object;
            if (n3 < 0) {
                if (-n3 >= this.nVertices) {
                    this.bsVertexCount.setBits(this.nVertices, 1 - n3);
                    this.nVertices = -n3;
                }
            } else {
                this.nVertices = n3;
                this.bsVertexCount.set(this.nVertices);
            }
            return;
        }
        if ("centers" == string) {
            this.centers = (BS)object;
            this.iHaveCenterBitSet = true;
            return;
        }
        if ("unitCell" == string) {
            this.useUnitCell = true;
            return;
        }
        if ("to" == string) {
            this.bsVertices = (BS)object;
            return;
        }
        if ("toBitSet" == string) {
            this.bsVertices = (BS)object;
            this.haveBitSetVertices = true;
            return;
        }
        if ("toVertices" == string) {
            P3[] p3Array = (P3[])object;
            int n4 = this.nPoints = Math.min(p3Array.length, 250);
            while (--n4 >= 0) {
                this.otherAtoms[n4] = p3Array[n4];
            }
            return;
        }
        if ("faceCenterOffset" == string) {
            this.faceCenterOffset = ((Float)object).floatValue();
            return;
        }
        if ("distanceFactor" == string) {
            return;
        }
        if ("planarParam" == string) {
            this.planarParam = ((Float)object).floatValue();
            return;
        }
        if ("bonds" == string) {
            this.bondedOnly = true;
            return;
        }
        if ("info" == string) {
            this.info = (Map)object;
            this.centers = BSUtil.newAndSetBit((int)this.info.get((Object)"atomIndex").intValue);
            this.iHaveCenterBitSet = true;
            return;
        }
        if ("delete" == string) {
            if (!this.iHaveCenterBitSet) {
                this.centers = bS;
            }
            this.deletePolyhedra();
            return;
        }
        if ("on" == string) {
            if (!this.iHaveCenterBitSet) {
                this.centers = bS;
            }
            this.setVisible(true);
            return;
        }
        if ("off" == string) {
            if (!this.iHaveCenterBitSet) {
                this.centers = bS;
            }
            this.setVisible(false);
            return;
        }
        if ("noedges" == string) {
            this.drawEdges = 0;
            return;
        }
        if ("edges" == string) {
            this.drawEdges = 1;
            return;
        }
        if ("frontedges" == string) {
            this.drawEdges = 2;
            return;
        }
        if (string.indexOf("color") == 0) {
            bS = "colorThis" == string && this.iHaveCenterBitSet ? this.centers : this.andBitSet(bS);
            n2 = "colorPhase" == string ? C.getColix((int)((Integer)((Object[])object)[0])) : 0;
            n = this.polyhedronCount;
            while (--n >= 0) {
                if (!bS.get(this.polyhedrons[n].centralAtom.i)) continue;
                this.polyhedrons[n].colixEdge = (short)n2;
            }
            if ("colorPhase" == string) {
                object = ((Object[])object)[1];
            }
            string = "color";
        }
        if (string.indexOf("translucency") == 0) {
            BS bS2 = bS = "translucentThis".equals(object) && this.iHaveCenterBitSet ? this.centers : this.andBitSet(bS);
            if (object.equals("translucentThis")) {
                object = "translucent";
            }
        }
        if ("radius" == string) {
            this.radius = ((Float)object).floatValue();
            return;
        }
        if (string == "deleteModelAtoms") {
            n2 = ((int[])((Object[])object)[2])[0];
            n = this.polyhedronCount;
            while (--n >= 0) {
                this.polyhedrons[n].info = null;
                short s = this.polyhedrons[n].centralAtom.mi;
                if (s != n2) continue;
                --this.polyhedronCount;
                this.polyhedrons = (Polyhedron[])AU.deleteElements((Object)this.polyhedrons, (int)n, (int)1);
            }
        }
        this.setPropAS(string, object, bS);
    }

    public Object getProperty(String string, int n) {
        if (string == "symmetry") {
            String string2 = "";
            int n2 = this.polyhedronCount;
            while (--n2 >= 0) {
                string2 = string2 + this.polyhedrons[n2].getSymmetry(this.vwr, true) + "\n";
            }
            return string2;
        }
        return null;
    }

    public boolean getPropertyData(String string, Object[] objectArray) {
        if (string == "points") {
            int n = (Integer)objectArray[0];
            int n2 = this.polyhedronCount;
            while (--n2 >= 0) {
                if (this.polyhedrons[n2].centralAtom.i != n) continue;
                if (this.polyhedrons[n2].collapsed) break;
                objectArray[1] = this.polyhedrons[n2].vertices;
                return true;
            }
            return false;
        }
        if (string == "move") {
            M4 m4 = (M4)objectArray[1];
            if (m4 == null) {
                return false;
            }
            BS bS = (BS)objectArray[0];
            int n = this.polyhedronCount;
            while (--n >= 0) {
                Polyhedron polyhedron = this.polyhedrons[n];
                if (!bS.get(polyhedron.centralAtom.i)) continue;
                polyhedron.move(m4);
            }
            return true;
        }
        if (string == "centers") {
            int n;
            BS bS = new BS();
            String string2 = (String)objectArray[1];
            SmilesMatcherInterface smilesMatcherInterface = string2 == null ? null : this.vwr.getSmilesMatcher();
            Integer n3 = (Integer)objectArray[0];
            if (smilesMatcherInterface != null) {
                string2 = smilesMatcherInterface.cleanSmiles(string2);
            }
            int n4 = string2 != null ? PT.countChar((String)string2, (char)'*') : (n = n3 == null ? Integer.MIN_VALUE : n3);
            if (string2 != null && n == 0) {
                n = Integer.MIN_VALUE;
            }
            int n5 = this.polyhedronCount;
            while (--n5 >= 0) {
                if (n > 0 && this.polyhedrons[n5].nVertices != n || n > Integer.MIN_VALUE && n < 0 && this.polyhedrons[n5].triangles.length != -n) continue;
                if (string2 == null) {
                    bS.set(this.polyhedrons[n5].centralAtom.i);
                    continue;
                }
                if (smilesMatcherInterface == null) continue;
                this.polyhedrons[n5].getSymmetry(this.vwr, false);
                String string3 = this.polyhedrons[n5].polySmiles;
                try {
                    if (smilesMatcherInterface.areEqual(string2, string3) <= 0) continue;
                    bS.set(this.polyhedrons[n5].centralAtom.i);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            objectArray[2] = bS;
            return true;
        }
        if (string == "allInfo") {
            Lst lst = new Lst();
            int n = this.polyhedronCount;
            while (--n >= 0) {
                lst.addLast(this.polyhedrons[n].getInfo(this.vwr, true));
            }
            objectArray[1] = lst;
            return false;
        }
        if (string == "info") {
            int n = (Integer)objectArray[0];
            int n6 = this.polyhedronCount;
            while (--n6 >= 0) {
                if (this.polyhedrons[n6].centralAtom.i != n) continue;
                objectArray[1] = this.polyhedrons[n6].getInfo(this.vwr, true);
                return true;
            }
            return false;
        }
        return false;
    }

    public Lst<Map<String, Object>> getShapeDetail() {
        Lst lst = new Lst();
        for (int i = 0; i < this.polyhedronCount; ++i) {
            lst.addLast(this.polyhedrons[i].getInfo(this.vwr, true));
        }
        return lst;
    }

    private BS andBitSet(BS bS) {
        BS bS2 = new BS();
        int n = this.polyhedronCount;
        while (--n >= 0) {
            bS2.set(this.polyhedrons[n].centralAtom.i);
        }
        bS2.and(bS);
        return bS2;
    }

    private void deletePolyhedra() {
        int n;
        int n2 = 0;
        byte by = PAL.pidOf(null);
        for (n = 0; n < this.polyhedronCount; ++n) {
            Polyhedron polyhedron = this.polyhedrons[n];
            int n3 = polyhedron.centralAtom.i;
            if (this.centers.get(n3)) {
                this.setColixAndPalette((short)0, by, n3);
                continue;
            }
            this.polyhedrons[n2++] = polyhedron;
        }
        for (n = n2; n < this.polyhedronCount; ++n) {
            this.polyhedrons[n] = null;
        }
        this.polyhedronCount = n2;
    }

    private void setVisible(boolean bl) {
        int n = this.polyhedronCount;
        while (--n >= 0) {
            Polyhedron polyhedron = this.polyhedrons[n];
            if (polyhedron == null || !this.centers.get(polyhedron.centralAtom.i)) continue;
            polyhedron.visible = bl;
        }
    }

    private void buildPolyhedra() {
        boolean bl;
        boolean bl2 = bl = this.radius == 0.0f || this.bondedOnly;
        this.buildMode = this.info != null ? 6 : (this.nPoints > 0 ? 2 : (this.haveBitSetVertices ? 4 : (this.useUnitCell ? 5 : (bl ? 1 : 3))));
        AtomIndexIterator atomIndexIterator = this.buildMode == 3 ? this.ms.getSelectedAtomIterator(null, false, false, false, false) : null;
        int n = this.centers.nextSetBit(0);
        while (n >= 0) {
            Atom atom = this.atoms[n];
            Polyhedron polyhedron = null;
            switch (this.buildMode) {
                case 4: {
                    polyhedron = this.constructBitSetPolyhedron(atom);
                    break;
                }
                case 5: {
                    polyhedron = this.constructUnitCellPolygon(atom, bl);
                    break;
                }
                case 1: {
                    polyhedron = this.constructBondsPolyhedron(atom, 0);
                    break;
                }
                case 3: {
                    this.vwr.setIteratorForAtom(atomIndexIterator, n, this.radius);
                    polyhedron = this.constructRadiusPolyhedron(atom, atomIndexIterator);
                    break;
                }
                case 6: {
                    polyhedron = new Polyhedron().setInfo(this.info, this.vwr.ms.at);
                    break;
                }
                case 2: {
                    polyhedron = this.validatePolyhedron(atom, this.nPoints);
                }
            }
            if (polyhedron != null) {
                if (this.polyhedronCount == this.polyhedrons.length) {
                    this.polyhedrons = (Polyhedron[])AU.doubleLength((Object)this.polyhedrons);
                }
                this.polyhedrons[this.polyhedronCount++] = polyhedron;
            }
            if (this.haveBitSetVertices) break;
            n = this.centers.nextSetBit(n + 1);
        }
        if (atomIndexIterator != null) {
            atomIndexIterator.release();
        }
    }

    private Polyhedron constructBondsPolyhedron(Atom atom, int n) {
        if (n == 0) {
            Bond[] bondArray = atom.bonds;
            if (bondArray == null) {
                return null;
            }
            float f = this.radius * this.radius;
            int n2 = bondArray.length;
            while (--n2 >= 0) {
                Bond bond = bondArray[n2];
                if (!bond.isCovalent()) continue;
                Atom atom2 = bond.getOtherAtom(atom);
                if (this.bsVertices != null && !this.bsVertices.get(atom2.i) || this.radius > 0.0f && atom2.distanceSquared((T3)atom) > f) continue;
                this.otherAtoms[n++] = atom2;
                if (n < 250) continue;
                break;
            }
        }
        this.distanceRef = 0.0f;
        return n < 3 || n >= 250 || this.nVertices > 0 && !this.bsVertexCount.get(n) ? null : this.validatePolyhedron(atom, n);
    }

    private Polyhedron constructUnitCellPolygon(Atom atom, boolean bl) {
        SymmetryInterface symmetryInterface = this.vwr.ms.getUnitCellForAtom(atom.i);
        if (symmetryInterface == null) {
            return null;
        }
        BS bS = BSUtil.copy((BS)this.vwr.getModelUndeletedAtomsBitSet((int)atom.mi));
        if (this.bsVertices != null) {
            bS.and(this.bsVertices);
        }
        if (bS.isEmpty()) {
            return null;
        }
        AtomIndexIterator atomIndexIterator = symmetryInterface.getIterator(this.vwr, atom, this.atoms, bS, bl ? 5.0f : this.radius);
        if (!bl) {
            return this.constructRadiusPolyhedron(atom, atomIndexIterator);
        }
        float f = atom.getBondingRadius();
        if (f == 0.0f) {
            return null;
        }
        float f2 = this.vwr.getFloat(0x22000004);
        float f3 = this.vwr.getFloat(570425364);
        float f4 = f3 * f3;
        int n = 0;
        block0: while (atomIndexIterator.hasNext()) {
            P3 p3;
            float f5;
            Atom atom2 = this.atoms[atomIndexIterator.next()];
            float f6 = atom2.getBondingRadius();
            if (!this.vwr.ms.isBondable(f, f6, f5 = atom.distanceSquared((T3)(p3 = atomIndexIterator.getPosition())), f4, f2)) continue;
            for (int i = 0; i < n; ++i) {
                if (this.otherAtoms[i].distanceSquared((T3)p3) < 0.01f) continue block0;
            }
            this.otherAtoms[n++] = p3;
            if (n < 250) continue;
            break;
        }
        return this.constructBondsPolyhedron(atom, n);
    }

    private Polyhedron constructBitSetPolyhedron(Atom atom) {
        this.bsVertices.clear(atom.i);
        int n = 0;
        this.distanceRef = 0.0f;
        int n2 = this.bsVertices.nextSetBit(0);
        while (n2 >= 0) {
            this.otherAtoms[n++] = this.atoms[n2];
            n2 = this.bsVertices.nextSetBit(n2 + 1);
        }
        return this.validatePolyhedron(atom, n);
    }

    private Polyhedron constructRadiusPolyhedron(Atom atom, AtomIndexIterator atomIndexIterator) {
        int n = 0;
        this.distanceRef = this.radius;
        float f = this.radius * this.radius;
        block0: while (atomIndexIterator.hasNext()) {
            Atom atom2 = this.atoms[atomIndexIterator.next()];
            P3 p3 = atomIndexIterator.getPosition();
            if (p3 == null) {
                p3 = atom2;
                if (this.bsVertices != null && !this.bsVertices.get(atom2.i) || atom.distanceSquared((T3)p3) > f) continue;
            }
            if (atom2.altloc != atom.altloc && atom2.altloc != '\u0000' && atom.altloc != '\u0000') continue;
            if (n == 250) break;
            for (int i = 0; i < n; ++i) {
                if (this.otherAtoms[i].distanceSquared((T3)p3) < 0.01f) continue block0;
            }
            this.otherAtoms[n++] = p3;
        }
        return n < 3 || this.nVertices > 0 && !this.bsVertexCount.get(n) ? null : this.validatePolyhedron(atom, n);
    }

    private Polyhedron validatePolyhedron(Atom atom, int n) {
        int n2;
        P3[] p3Array = this.otherAtoms;
        boolean bl = this.isCollapsed;
        int n3 = 0;
        int n4 = n + 1;
        int n5 = n - 2;
        int n6 = n - 1;
        float f = Float.isNaN(this.planarParam) ? 0.98f : this.planarParam;
        p3Array[n] = atom;
        P3 p3 = P3.newP((T3)atom);
        for (int i = 0; i < n; ++i) {
            p3.add((T3)p3Array[i]);
        }
        p3.scale(1.0f / (float)(n + 1));
        P3 p32 = P3.newP((T3)p3);
        BS bS = new BS();
        int n7 = 0;
        for (int i = 0; i < n5; ++i) {
            for (int j = i + 1; j < n6; ++j) {
                int n8 = j + 1;
                while (n8 < n) {
                    if (this.isPlanar(p3Array[i], p3Array[j], p3Array[n8], p32)) {
                        bS.set(n7);
                    }
                    ++n8;
                    ++n7;
                }
            }
        }
        int[][] nArray = this.planesT;
        P4 p4 = new P4();
        V3 v3 = new V3();
        float f2 = this.faceCenterOffset;
        int n9 = 247;
        int n10 = 250;
        BS bS2 = Normix.newVertexBitSet();
        V3[] v3Array = this.normalsT;
        Hashtable<Integer, Object[]> hashtable = new Hashtable<Integer, Object[]>();
        Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>();
        BS bS3 = new BS();
        V3 v32 = this.vAC;
        int n11 = 0;
        for (n2 = 0; n2 < n5; ++n2) {
            for (int i = n2 + 1; i < n6; ++i) {
                int n12 = i + 1;
                while (n12 < n) {
                    if (n3 >= n9) {
                        Logger.error((String)("Polyhedron error: maximum face(" + n9 + ") -- reduce RADIUS"));
                        return null;
                    }
                    if (n4 >= n10) {
                        Logger.error((String)("Polyhedron error: maximum vertex count(" + n10 + ") -- reduce RADIUS"));
                        return null;
                    }
                    boolean bl2 = bS.get(n11);
                    P3 p33 = bl2 ? randomPoint : p3;
                    V3 v33 = new V3();
                    boolean bl3 = Measure.getNormalFromCenter((P3)p33, (P3)p3Array[n2], (P3)p3Array[i], (P3)p3Array[n12], (!bl2 ? 1 : 0) != 0, (V3)v33, (V3)v32);
                    v3Array[n3] = v33;
                    nArray[n3] = new int[]{bl3 ? n2 : i, bl3 ? i : n2, n12, -7};
                    if (this.checkFace(p3Array, n, nArray, v3Array, n3, p4, v3, v32, hashtable, hashtable2, f, bS2)) {
                        if (bl2) {
                            bS3.set(n3++);
                        } else if (bl) {
                            p3Array[n4] = new P3();
                            p32.setT((T3)p3Array[n4]);
                            p3Array[n4].scaleAdd2(f2, (T3)v33, (T3)atom);
                            this.addFacet(n2, i, n12, p32, p3Array, v3Array, nArray, n3++, n4, bl3, v32);
                            this.addFacet(n12, n2, i, p32, p3Array, v3Array, nArray, n3++, n4, bl3, v32);
                            this.addFacet(i, n12, n2, p32, p3Array, v3Array, nArray, n3++, n4, bl3, v32);
                            ++n4;
                        } else {
                            ++n3;
                        }
                    }
                    ++n12;
                    ++n11;
                }
            }
        }
        --n4;
        if (Logger.debugging) {
            Logger.info((String)("Polyhedron planeCount=" + n3 + " nPoints=" + n4));
            for (n2 = 0; n2 < n3; ++n2) {
                Logger.info((String)("Polyhedron " + PT.toJSON((String)("face[" + n2 + "]"), (Object)nArray[n2])));
            }
        }
        return new Polyhedron().set(atom, p3Array, n4, n, nArray, n3, this.getFaces(nArray, n3, hashtable), v3Array, bS3, bl, this.distanceRef);
    }

    private void addFacet(int n, int n2, int n3, P3 p3, P3[] p3Array, V3[] v3Array, int[][] nArray, int n4, int n5, boolean bl, V3 v3) {
        V3 v32 = new V3();
        Measure.getNormalFromCenter((P3)p3Array[n3], (P3)p3, (P3)p3Array[n], (P3)p3Array[n2], (boolean)false, (V3)v32, (V3)v3);
        v3Array[n4] = v32;
        nArray[n4] = new int[]{n5, bl ? n : n2, bl ? n2 : n, -2};
    }

    /*
     * WARNING - void declaration
     */
    private boolean checkFace(P3[] p3Array, int n, int[][] nArray, V3[] v3Array, int n2, P4 p4, V3 v3, V3 v32, Map<Integer, Object[]> map, Map<String, Object> map2, float f, BS bS) {
        void var21_25;
        BS bS2;
        int[] nArray2 = nArray[n2];
        int n3 = nArray2[0];
        p4 = Measure.getPlaneThroughPoints((T3)p3Array[n3], (T3)p3Array[nArray2[1]], (T3)p3Array[nArray2[2]], (V3)v3, (V3)v32, (P4)p4);
        P3 p3 = p3Array[n3];
        for (int i = 0; i < n; ++i) {
            if (i == n3) continue;
            v32.sub2((T3)p3Array[i], (T3)p3);
            v32.normalize();
            float f2 = v32.dot((T3)v3);
            if (!(f2 > 0.02f)) continue;
            return false;
        }
        V3 v33 = v3Array[n2];
        Integer n4 = Normix.getNormixV((V3)v33, (BS)bS);
        Object[] objectArray = map.get(n4);
        if (objectArray == null) {
            bS2 = Normix.getVertexVectors();
            for (Map.Entry entry : map.entrySet()) {
                Integer n5 = (Integer)entry.getKey();
                if (!(bS2[n5].dot((T3)v33) > f)) continue;
                n4 = n5;
                objectArray = (Object[])entry.getValue();
                break;
            }
            if (objectArray == null) {
                objectArray = new Object[]{new BS(), new Lst()};
                map.put(n4, objectArray);
            }
        }
        bS2 = (BS)objectArray[0];
        Lst lst = (Lst)objectArray[1];
        boolean i = false;
        while (var21_25 < 3) {
            if (!this.addEdge((Lst<int[]>)lst, map2, n4, nArray2, (int)var21_25, p3Array, bS2)) {
                return false;
            }
            ++var21_25;
        }
        return true;
    }

    private boolean addEdge(Lst<int[]> lst, Map<String, Object> map, Integer n, int[] nArray, int n2, P3[] p3Array, BS bS) {
        int n3 = nArray[(n2 + 1) % 3];
        String string = "_" + n3;
        int n4 = nArray[n2];
        String string2 = "_" + n4;
        String string3 = n + string2 + string;
        if (map.containsKey(string3)) {
            return false;
        }
        String string4 = n + string + string2;
        Object object = map.get(string4);
        if (object == null) {
            P3 p3 = p3Array[n3];
            P3 p32 = p3Array[n4];
            this.vAB.sub2((T3)p3, (T3)p32);
            int n5 = bS.nextSetBit(0);
            while (n5 >= 0) {
                if (n5 != n3 && n5 != n4) {
                    this.vAC.sub2((T3)p3Array[n5], (T3)p32);
                    if (object == null) {
                        object = bS;
                        this.vBC.cross((T3)this.vAC, (T3)this.vAB);
                    } else {
                        this.vAC.cross((T3)this.vAC, (T3)this.vAB);
                        if (this.vBC.dot((T3)this.vAC) < 0.0f) {
                            return false;
                        }
                    }
                }
                n5 = bS.nextSetBit(n5 + 1);
            }
            bS.set(n4);
            bS.set(n3);
            int[] nArray2 = new int[]{n4, n3};
            lst.addLast((Object)nArray2);
            map.put(string3, new Object[]{nArray, n2, nArray2});
        } else {
            int[] nArray3 = (int[])((Object[])object)[0];
            int n6 = (Integer)((Object[])object)[1];
            nArray3[3] = -(-nArray3[3] ^ 1 << n6);
            nArray[3] = -(-nArray[3] ^ 1 << n2);
            int[] nArray4 = (int[])((Object[])object)[2];
            lst.removeObj((Object)nArray4);
        }
        return true;
    }

    private boolean isPlanar(P3 p3, P3 p32, P3 p33, P3 p34) {
        V3 v3 = new V3();
        float f = Measure.getNormalThroughPoints((T3)p3, (T3)p32, (T3)p33, (V3)v3, (V3)this.vAB);
        float f2 = Measure.distanceToPlaneV((V3)v3, (float)f, (P3)p34);
        return Math.abs(f2) < MAX_DISTANCE_TO_PLANE;
    }

    private int[][] getFaces(int[][] nArray, int n, Map<Integer, Object[]> map) {
        int n2 = map.size();
        int[][] nArray2 = AU.newInt2((int)n2);
        if (n == n2) {
            int n3 = n;
            while (--n3 >= 0) {
                nArray2[n3] = AU.arrayCopyI((int[])nArray[n3], (int)3);
            }
            return nArray2;
        }
        int n4 = 0;
        for (Map.Entry<Integer, Object[]> entry : map.entrySet()) {
            Lst lst = (Lst)entry.getValue()[1];
            n2 = lst.size();
            int n5 = n4++;
            int[] nArray3 = new int[n2];
            nArray2[n5] = nArray3;
            int[] nArray4 = nArray3;
            if (n2 < 2) continue;
            int[] nArray5 = (int[])lst.get(0);
            nArray4[0] = nArray5[0];
            nArray4[1] = nArray5[1];
            int n6 = 2;
            int n7 = 1;
            int n8 = -1;
            block2: while (n6 < n2 && n8 != n6) {
                n8 = n6;
                for (int i = n7; i < n2; ++i) {
                    nArray5 = (int[])lst.get(i);
                    if (nArray5[0] != nArray4[n6 - 1]) continue;
                    nArray4[n6++] = nArray5[1];
                    if (i != n7) continue block2;
                    ++n7;
                    continue block2;
                }
            }
        }
        return nArray2;
    }

    public void setModelVisibilityFlags(BS bS) {
        int n = this.polyhedronCount;
        while (--n >= 0) {
            Polyhedron polyhedron = this.polyhedrons[n];
            if (this.ms.at[polyhedron.centralAtom.i].isDeleted()) {
                polyhedron.isValid = false;
            }
            int n2 = polyhedron.visibilityFlags = polyhedron.visible && bS.get((int)polyhedron.centralAtom.mi) && !this.ms.isAtomHidden(polyhedron.centralAtom.i) && !this.ms.at[polyhedron.centralAtom.i].isDeleted() ? this.vf : 0;
            if (polyhedron.visibilityFlags == 0) continue;
            this.setShapeVisibility(this.atoms[polyhedron.centralAtom.i], true);
        }
    }

    public String getShapeState() {
        int n;
        if (this.polyhedronCount == 0) {
            return "";
        }
        SB sB = new SB();
        for (n = 0; n < this.polyhedronCount; ++n) {
            if (!this.polyhedrons[n].isValid) continue;
            sB.append(this.polyhedrons[n].getState(this.vwr));
        }
        if (this.drawEdges == 2) {
            Polyhedra.appendCmd((SB)sB, (String)"polyhedra frontedges");
        } else if (this.drawEdges == 1) {
            Polyhedra.appendCmd((SB)sB, (String)"polyhedra edges");
        }
        sB.append(this.vwr.getAtomShapeState((AtomShape)this));
        for (n = 0; n < this.polyhedronCount; ++n) {
            Polyhedron polyhedron = this.polyhedrons[n];
            if (!polyhedron.isValid || polyhedron.colixEdge == 0 || !this.bsColixSet.get(polyhedron.centralAtom.i)) continue;
            Polyhedra.appendCmd((SB)sB, (String)("select ({" + polyhedron.centralAtom.i + "}); color polyhedra " + (C.isColixTranslucent((short)this.colixes[polyhedron.centralAtom.i]) ? "translucent " : "") + C.getHexCode((short)this.colixes[polyhedron.centralAtom.i]) + " " + C.getHexCode((short)polyhedron.colixEdge)));
        }
        return sB.toString();
    }
}

