/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.io;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.util.Map;
import java.util.zip.ZipInputStream;
import javajs.api.GenericBinaryDocument;
import javajs.util.DataReader;
import javajs.util.PT;
import org.jmol.api.Interface;
import org.jmol.api.JmolFilesReaderInterface;
import org.jmol.util.Logger;
import org.jmol.viewer.FileManager;
import org.jmol.viewer.Viewer;

public class FilesReader
implements JmolFilesReaderInterface {
    private FileManager fm;
    private Viewer vwr;
    private String[] fullPathNamesIn;
    private String[] namesAsGivenIn;
    private String[] fileTypesIn;
    private Object atomSetCollection;
    private DataReader[] dataReaders;
    private Map<String, Object> htParams;
    private boolean isAppend;

    @Override
    public void set(FileManager fileManager, Viewer viewer, String[] stringArray, String[] stringArray2, String[] stringArray3, DataReader[] dataReaderArray, Map<String, Object> map, boolean bl) {
        this.fm = fileManager;
        this.vwr = viewer;
        this.fullPathNamesIn = stringArray;
        this.namesAsGivenIn = stringArray2;
        this.fileTypesIn = stringArray3;
        this.dataReaders = dataReaderArray;
        this.htParams = map;
        this.isAppend = bl;
    }

    @Override
    public void run() {
        if (!this.isAppend && this.vwr.displayLoadErrors) {
            this.vwr.zap(false, true, false);
        }
        boolean bl = !this.vwr.displayLoadErrors;
        this.atomSetCollection = this.vwr.getModelAdapter().getAtomSetCollectionReaders(this, this.fullPathNamesIn, this.fileTypesIn, this.htParams, bl);
        this.dataReaders = null;
        if (bl && !(this.atomSetCollection instanceof String)) {
            this.atomSetCollection = this.vwr.getModelAdapter().getAtomSetCollectionFromSet(this.atomSetCollection, null, this.htParams);
        }
        if (this.atomSetCollection instanceof String) {
            Logger.error("file ERROR: " + this.atomSetCollection);
            return;
        }
        if (!this.isAppend && !this.vwr.displayLoadErrors) {
            this.vwr.zap(false, true, false);
        }
        this.fm.setFileInfo(new String[]{this.dataReaders == null ? this.fullPathNamesIn[0] : "String[]"});
    }

    @Override
    public Object getBufferedReaderOrBinaryDocument(int n, boolean bl) {
        Object object;
        Object object2;
        if (this.dataReaders != null) {
            return bl ? null : this.dataReaders[n].getBufferedReader();
        }
        String string = this.fullPathNamesIn[n];
        String[] stringArray = null;
        this.htParams.remove("subFileList");
        if (string.indexOf("|") >= 0 && !this.htParams.containsKey("isStateScript")) {
            stringArray = PT.split(string, "|");
            string = stringArray[0];
        }
        if ((object2 = this.fm.getUnzippedReaderOrStreamFromName(string, null, true, bl, false, true, this.htParams)) instanceof ZipInputStream) {
            if (stringArray != null) {
                this.htParams.put("subFileList", stringArray);
            }
            object = this.fm.getZipDirectory(string, true, true);
            object2 = this.fm.getBufferedInputStreamOrErrorMessageFromName(string, this.fullPathNamesIn[n], false, false, null, false, true);
            object2 = this.fm.getJmb().getAtomSetCollectionOrBufferedReaderFromZip(this.vwr.getModelAdapter(), (BufferedInputStream)object2, string, (String[])object, this.htParams, true);
        }
        if (object2 instanceof BufferedInputStream) {
            object = (GenericBinaryDocument)Interface.getInterface("javajs.util.BinaryDocument", this.vwr, "file");
            object.setStream(this.vwr.getJzt(), (BufferedInputStream)object2, true);
            return object;
        }
        return object2 instanceof BufferedReader || object2 instanceof GenericBinaryDocument ? object2 : (object2 == null ? "error opening:" + this.namesAsGivenIn[n] : (String)object2);
    }

    @Override
    public Object getAtomSetCollection() {
        return this.atomSetCollection;
    }
}

